/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ExtrapointDataUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_NULL_CODE_DATA = "select fid,fdate from t_tk_extrapoints where fbillno = ' '";
    private static final String UPDATE_NUMBER = "update t_tk_extrapoints set fbillno = ? where fid = ?";
    private static final String EXTRA_COUNT = "select count(fid) from t_tk_extrapoints";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.ExtrapointDataUpgradeServiceImpl.queryCount", (DBRoute)DBRoute.of((String)"ssc"), (String)EXTRA_COUNT);){
            count = ((Row)ds.iterator().next()).getInteger(0).intValue();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMhh");
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        try (DataSet ds = DB.queryDataSet((String)"fi.ssc.ExtrapointDataUpgradeServiceImpl.queryNoBillNoData", (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_NULL_CODE_DATA);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long fid = row.getLong("fid");
                Date date = row.getDate("fdate");
                String dateString = simpleDateFormat.format(date);
                String countString = String.format("%08d", count);
                Object[] param = new Object[]{"EWJJF-" + dateString + "-" + countString, fid};
                params.add(param);
                ++count;
            }
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_NUMBER, params);
        }
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }
}

