/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang3.StringUtils;

public class TaskBillUpdateBillLongIDServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"TaskBillUpdateBillLongIDServiceImpl");
    String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.updatetask();
        this.updatetaskhistory();
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }

    private void updatetask() {
        String QUERY_SQL0 = "select tk.fid,tk.fbillid from t_tk_task tk where (tk.fbilllongid is null or tk.fbilllongid = 0) and tk.fbillid is not null and fbillid != ' '";
        String UPDATE_SQL_0 = "update t_tk_task set fbilllongid = ? where fid = ?";
        try (DataSet dSet0 = DB.queryDataSet((String)(this.algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)"select tk.fid,tk.fbillid from t_tk_task tk where (tk.fbilllongid is null or tk.fbilllongid = 0) and tk.fbillid is not null and fbillid != ' '");){
            ArrayList<Object[]> extraParams = new ArrayList<Object[]>(1000);
            for (Row row : dSet0) {
                Long fid = row.getLong("fid");
                String fbillid = row.getString("fbillid");
                if (StringUtils.isNumeric((CharSequence)fbillid)) {
                    try {
                        long fbilllongid = Long.parseLong(fbillid);
                        extraParams.add(new Object[]{fbilllongid, fid});
                    }
                    catch (NumberFormatException e) {
                        log.error(String.format("id=%1s,billid=%2s can not change to bigint type in t_tk_task", fid, fbillid));
                    }
                }
                if (extraParams.size() < 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_task set fbilllongid = ? where fid = ?", extraParams);
                extraParams.clear();
            }
            if (extraParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_task set fbilllongid = ? where fid = ?", extraParams);
            }
        }
    }

    private void updatetaskhistory() {
        String QUERY_SQL0 = "select tk.fid,tk.fbillid from t_tk_taskhistory tk where (tk.fbilllongid is null or tk.fbilllongid = 0) and tk.fbillid is not null and fbillid != ' '";
        String UPDATE_SQL_0 = "update t_tk_taskhistory set fbilllongid = ? where fid = ?";
        try (DataSet dSet0 = DB.queryDataSet((String)(this.algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)"select tk.fid,tk.fbillid from t_tk_taskhistory tk where (tk.fbilllongid is null or tk.fbilllongid = 0) and tk.fbillid is not null and fbillid != ' '");){
            ArrayList<Object[]> extraParams = new ArrayList<Object[]>(1000);
            for (Row row : dSet0) {
                Long fid = row.getLong("fid");
                String fbillid = row.getString("fbillid");
                if (StringUtils.isNumeric((CharSequence)fbillid)) {
                    try {
                        long fbilllongid = Long.parseLong(fbillid);
                        extraParams.add(new Object[]{fbilllongid, fid});
                    }
                    catch (NumberFormatException e) {
                        log.error(String.format("id=%1s,billid=%2s can not change to bigint type in t_tk_taskhistory", fid, fbillid));
                    }
                }
                if (extraParams.size() < 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_taskhistory set fbilllongid = ? where fid = ?", extraParams);
                extraParams.clear();
            }
            if (extraParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_taskhistory set fbilllongid = ? where fid = ?", extraParams);
            }
        }
    }
}

