/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class CommonUtil {
    private static final Log logger = LogFactory.getLog(CommonUtil.class);

    private CommonUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void saveLog(List<DynamicObject> logs) {
        if (logs != null && !logs.isEmpty()) {
            DynamicObject[] dys = new DynamicObject[logs.size()];
            logs.toArray(dys);
            SaveServiceHelper.saveOperate((String)"ricc_log", (DynamicObject[])dys, (OperateOption)OperateOption.create());
        }
    }

    public static List<Map<String, Object>> uploadFile(String formId, Object pkid, String attachKey, String fileExportPath, String uploadPath, String fileName) {
        String realUrl;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        File file = FileUtils.createFile(kd.bos.util.FileUtils.checkFileUrl((String)fileExportPath));
        if (!file.exists()) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"CommonUtil_17", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        uploadPath = uploadPath + File.separator + fileName;
        try (FileInputStream fileInputStream = new FileInputStream(fileExportPath);){
            FileItem fi = new FileItem(fileName, uploadPath, (InputStream)fileInputStream);
            realUrl = fs.upload(fi);
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25,%s", (String)"CommonUtil_30", (String)"sys-ricc-common", (Object[])new Object[]{e.getMessage()});
            throw new RiccBizException(msgTpl, e);
        }
        Map<String, Object> uploadFileMap = CommonUtil.createUploadFileMap(formId, pkid.toString(), attachKey, realUrl, fileName, file.length(), fileName.substring(fileName.lastIndexOf(46) + 1));
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        attachments.add(uploadFileMap);
        return attachments;
    }

    public static Map<String, Object> createUploadFileMap(String formId, Object pkid, String attachKey, String uploadPath, String fileName, long size, String type) {
        HashMap<String, Object> uploadFileMap = new HashMap<String, Object>(16);
        uploadFileMap.put("entityNum", formId);
        uploadFileMap.put("billPkId", String.valueOf(pkid));
        uploadFileMap.put("lastModified", System.currentTimeMillis());
        uploadFileMap.put("uid", "rc-upload-" + DB.genGlobalLongId());
        logger.info("\u4f20\u8f93\u5305\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668uid\uff1a" + uploadFileMap.get("uid"));
        uploadFileMap.put("attachKey", attachKey);
        uploadFileMap.put("client", "web");
        uploadFileMap.put("name", fileName);
        uploadFileMap.put("url", uploadPath);
        uploadFileMap.put("size", size);
        uploadFileMap.put("type", type);
        uploadFileMap.put("status", "success");
        return uploadFileMap;
    }

    public static List<DynamicObject> uploadFileToAttachmentField(String formId, Object pkid, String attachKey, String fileExportPath, String uploadPath, String fileName) {
        List<Map<String, Object>> attachments = CommonUtil.uploadFile(formId, pkid, attachKey, fileExportPath, uploadPath, fileName);
        return AttachmentFieldServiceHelper.saveAttachments((String)formId, (String)"", attachments);
    }

    public static List<DynamicObject> uploadDataPacket(Object pkid, String localTempPath, String fileFullPath, String uploadPath, String fileName) {
        String fileDir;
        List<DynamicObject> list = CommonUtil.uploadFileToAttachmentField("ricc_datapacket", pkid, "subdatapacketfile", fileFullPath, uploadPath, fileName);
        if (CollectionUtils.isNotEmpty(list)) {
            BillFileMappingWriter.syncWriteFileBillMapping((String)list.get(0).getString("url"));
        }
        if (!(fileDir = fileFullPath.substring(0, fileFullPath.lastIndexOf(File.separator))).equals(localTempPath)) {
            AppUtils.deleteKd((File)FileUtils.createFile(fileDir));
        }
        AppUtils.deleteKd((File)FileUtils.createFile(localTempPath));
        return list;
    }

    public static Map<String, Object> getStrArrByRowCollection(ListSelectedRowCollection selectRow, String entityname) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(2);
        String[] ids = new String[selectRow.size()];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(CommonConstant.getSelectedTitle(), entityname, entityname));
        for (int i = 0; i < selectRow.size(); ++i) {
            ids[i] = String.valueOf(selectRow.get(i).getPrimaryKeyValue());
            stringBuilder.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i + 1, selectRow.get(i).getNumber(), selectRow.get(i).getName()));
        }
        resMap.put("ids", ids);
        resMap.put("selectedInfo", stringBuilder.toString());
        return resMap;
    }

    public static Map<String, Object> getLongArrByRowCollection(ListSelectedRowCollection selectRow, String entityname) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(2);
        long[] ids = new long[selectRow.size()];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(CommonConstant.getSelectedTitle(), entityname, entityname));
        for (int i = 0; i < selectRow.size(); ++i) {
            ids[i] = Long.parseLong(selectRow.get(i).getPrimaryKeyValue().toString());
            stringBuilder.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i + 1, selectRow.get(i).getNumber(), selectRow.get(i).getName()));
        }
        resMap.put("ids", ids);
        resMap.put("selectedInfo", stringBuilder.toString());
        return resMap;
    }

    public static Map<String, DynamicObject> dynamicObjectCollectionToMap(String key, DynamicObjectCollection dynamicObjectCollection) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject dy : dynamicObjectCollection) {
            map.put(dy.getString(key), dy);
        }
        return map;
    }

    public static MulBasedataDynamicObjectCollection createAttachmentField(DynamicObjectType dynamicObjectType, long fbasedataId) {
        MulBasedataDynamicObjectCollection fileList = new MulBasedataDynamicObjectCollection();
        DynamicObject dyFile = new DynamicObject(dynamicObjectType);
        dyFile.set("FPKID", (Object)ID.genLongId());
        dyFile.set("fbasedataid", (Object)fbasedataId);
        dyFile.set("fbasedataid_id", (Object)fbasedataId);
        fileList.add(dyFile);
        return fileList;
    }

    public static String checkUrl(String url) {
        if (!StringUtils.isEmpty((CharSequence)url) && url.contains("path=")) {
            url = url.split("path=")[1];
        }
        return url;
    }

    public static String getExceptionDetailInfo(Throwable exception) {
        String retMsg;
        if (exception == null) {
            return "exception is null";
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            exception.printStackTrace(pw);
            pw.flush();
            sw.flush();
            retMsg = sw.toString();
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"exception \u89e3\u6790\u5931\u8d25\uff01%s", (String)"CommonUtil_21", (String)"sys-ricc-common", (Object[])new Object[0]);
            retMsg = String.format(msgTpl, e.getMessage());
        }
        return retMsg;
    }

    public static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if ("true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }

    public static ValidationErrorInfo buildOpErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = null;
        if (!Objects.isNull(obj)) {
            pkId = obj.getPkValue();
        }
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, exp.getErrorCode().getCode(), ResManager.loadKDString((String)"Ricc\u64cd\u4f5c\u9519\u8bef\u63d0\u793a", (String)"CommonUtil_28", (String)"sys-ricc-common", (Object[])new Object[0]), msg, errorLevel);
    }

    public static String getTenantProperty(String key) {
        String tenantId = RequestContext.get().getTenantId();
        return SystemPropertyUtils.getProptyByTenant((String)key, (String)tenantId);
    }

    public static boolean isProductionEnvironment() {
        String envRole = SysParaUtil.getenvRole();
        return StringUtils.equals((CharSequence)envRole, (CharSequence)EnvRoleEnum.PRD.getVal());
    }

    public static boolean whetherBatchPack() {
        boolean isAdmin;
        boolean result = true;
        if (CommonUtil.isProductionEnvironment() && !(isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId()))) {
            result = false;
        }
        return result;
    }

    public static MainEntityType getEntityTypeByFormId(String formId) {
        MainEntityType entityType = null;
        String realEntityId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)realEntityId);
        }
        catch (Exception e) {
            logger.error(String.format("\u67e5\u8be2\u4e0d\u5230\u8868\u5355%s\u5bf9\u5e94\u7684\u5b9e\u4f53", formId), (Throwable)e);
        }
        return entityType;
    }

    public static QFilter getDataCenterFilter() {
        long curUserId = UserServiceHelper.getCurrentUserId();
        List<Long> idList = CommonUtil.getAuthorizedUserIdList(curUserId);
        return new QFilter("id", "in", idList);
    }

    public static List<Long> getAuthorizedUserIdList(long userId) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] allCenterData = BusinessDataServiceHelper.load((String)"ricc_destaccount", (String)"id, number,name,controlled,authorizeduser,isdefault", (QFilter[])qFilter.toArray());
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject oneCenterData : allCenterData) {
            List userIds;
            boolean isControlled = oneCenterData.getBoolean("controlled");
            long pkId = oneCenterData.getLong("id");
            if (!isControlled) {
                idList.add(pkId);
                continue;
            }
            DynamicObjectCollection controlledUsers = oneCenterData.getDynamicObjectCollection("authorizeduser");
            if (!Objects.nonNull(controlledUsers) || !(userIds = controlledUsers.stream().map(l -> l.getLong("fbasedataid_id")).collect(Collectors.toList())).contains(userId)) continue;
            idList.add(pkId);
        }
        return idList;
    }

    public static JSONObject fail(String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("success", (Object)Boolean.FALSE);
        jsonObject.put("errMessage", (Object)msg);
        return jsonObject;
    }
}

