/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sys.ricc.common.util.StringUtils;

public class ShowParameterUtil {
    private ShowParameterUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ListShowParameter listShowParameter(String formId, String templateId, ShowType showType, Map<String, Object> customParams, List<QFilter> qFilterList, String caption, String custPlugin) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(showType);
        listShowParameter.setFormId(templateId);
        listShowParameter.setBillFormId(formId);
        if (!StringUtils.isEmpty(caption)) {
            listShowParameter.setCaption(caption);
        }
        if (qFilterList != null && !qFilterList.isEmpty()) {
            listShowParameter.getListFilterParameter().setQFilters(qFilterList);
        }
        if (!StringUtils.isEmpty(custPlugin)) {
            listShowParameter.addCustPlugin(custPlugin);
        }
        if (customParams != null && !customParams.isEmpty()) {
            listShowParameter.setCustomParams(customParams);
        }
        return listShowParameter;
    }

    public static ListShowParameter simpleListShowParameter(String formId, ShowType showType, QFilter qFilter) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        qFilterList.add(qFilter);
        return ShowParameterUtil.listShowParameter(formId, "bos_list", showType, null, qFilterList, null, null);
    }

    public static FormShowParameter formShowParameter(String formId, ShowType showType, Map<String, Object> customParams, String caption, String custPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        if (!StringUtils.isEmpty(caption)) {
            formShowParameter.setCaption(caption);
        }
        if (!StringUtils.isEmpty(custPlugin)) {
            formShowParameter.addCustPlugin(custPlugin);
        }
        if (customParams != null && !customParams.isEmpty()) {
            formShowParameter.setCustomParams(customParams);
        }
        return formShowParameter;
    }

    public static FormShowParameter formShowParameter(String formId, ShowType showType, Map<String, Object> customParams, String caption, String custPlugin, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        if (!StringUtils.isEmpty(caption)) {
            formShowParameter.setCaption(caption);
        }
        if (!StringUtils.isEmpty(custPlugin)) {
            formShowParameter.addCustPlugin(custPlugin);
        }
        if (customParams != null && !customParams.isEmpty()) {
            formShowParameter.setCustomParams(customParams);
        }
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        return formShowParameter;
    }

    public static FormShowParameter simpleFormShowParameter(String formId, Map<String, Object> customParams) {
        return ShowParameterUtil.formShowParameter(formId, ShowType.Modal, customParams, null, null);
    }

    public static void showLog(Object selectedId, IFormView view, ShowType showType, String opType) {
        boolean isLayout;
        BillShowParameter param = new BillShowParameter();
        param.setFormId("ricc_log");
        if (ShowType.Modal.equals((Object)showType)) {
            StyleCss style = new StyleCss();
            style.setWidth("1250");
            style.setHeight("600");
            param.getOpenStyle().setInlineStyleCss(style);
        }
        param.setPkId(selectedId);
        param.getOpenStyle().setShowType(showType);
        param.setStatus(OperationStatus.EDIT);
        boolean bl = isLayout = !StringUtils.equals(opType, "2") && !StringUtils.equals(opType, "3") && !StringUtils.equals(opType, "6") && !StringUtils.equals(opType, "7");
        if (isLayout) {
            param.setFormId("ricc_log_layout");
        }
        view.showForm((FormShowParameter)param);
    }

    public static void showLogs(IFormView view, QFilter qFilter, ShowType showType) {
        ListShowParameter param = ShowParameterUtil.simpleListShowParameter("ricc_log", showType, null);
        param.getListFilterParameter().setFilter(qFilter);
        param.setShowTitle(false);
        if (ShowType.Modal.equals((Object)showType)) {
            StyleCss style = new StyleCss();
            style.setWidth("1000");
            style.setHeight("600");
            param.getOpenStyle().setInlineStyleCss(style);
            param.setShowTitle(true);
            param.setCustomParam("showFilterContainer", (Object)Boolean.FALSE);
        }
        view.showForm((FormShowParameter)param);
    }

    public static String getParentPageId(IFormView view) {
        String parentPageId = view.getFormShowParameter().getRootPageId();
        String parentPgId = view.getFormShowParameter().getParentPageId();
        IFormView parentView = view.getViewNoPlugin(parentPgId);
        if (parentView != null) {
            parentPageId = parentPgId;
        }
        return parentPageId;
    }

    public static void setPageEnterParam(ListShowParameter listShowParameter, String pageParam) {
        if (StringUtils.isNotBlank(pageParam)) {
            JSONObject map = JSONObject.parseObject((String)pageParam).getJSONObject("params");
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Map tempMap = (Map)entry.getValue();
                for (Map.Entry anoentry : tempMap.entrySet()) {
                    String name = (String)anoentry.getKey();
                    String value = (String)anoentry.getValue();
                    switch (key) {
                        case "setCustomParam": {
                            listShowParameter.setCustomParam(name, (Object)value);
                            break;
                        }
                        case "setAppId": {
                            listShowParameter.setAppId(value);
                            break;
                        }
                        case "setCaption": {
                            listShowParameter.setCaption(value);
                            break;
                        }
                        case "addCustPlugin": {
                            listShowParameter.addCustPlugin(value);
                            break;
                        }
                    }
                }
            }
        }
    }
}

