/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.exception.RiccBizException;

public class SqlImportUtil {
    private static final Log log = LogFactory.getLog(SqlImportUtil.class);

    private SqlImportUtil() {
    }

    public static boolean excuteSqlFileByFilePath(String filePath, DBRoute dbRoute) {
        String sqlStr;
        try {
            sqlStr = SqlImportUtil.readAllFileLines(filePath);
        }
        catch (Exception e) {
            log.info("SqlImportUtil.excuteSqlFileByFilePath\u6267\u884c\u5f02\u5e38:" + CommonUtil.getExceptionDetailInfo(e));
            throw new RiccBizException(ResManager.loadKDString((String)"SqlImportUtil.excuteSqlFileByFilePath\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u65e5\u5fd7\u3002", (String)"SqlImportUtil_0", (String)"sys-ricc-common", (Object[])new Object[0]), e);
        }
        return SqlImportUtil.executeSql(dbRoute, sqlStr);
    }

    public static String readAllFileLines(String filePath) throws IOException {
        StringBuilder str = new StringBuilder();
        try (InputStream in = SqlImportUtil.class.getResourceAsStream(filePath);
             InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inReader);){
            String tempStr;
            while ((tempStr = reader.readLine()) != null) {
                str.append(tempStr);
            }
        }
        return str.toString();
    }

    public static boolean executeSql(DBRoute dbRoute, String sqlStr) {
        boolean success = false;
        try (TXHandle h1 = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)sqlStr);
                success = true;
            }
            catch (Exception e) {
                log.error("sql\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                h1.markRollback();
            }
        }
        return success;
    }
}

