/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util.setter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.sys.ricc.common.util.IscUtil;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.common.util.setter.Setter;

public class ComboPropSetter
implements Setter {
    private ComboProp comboProp;

    public ComboPropSetter(ComboProp comboProp) {
        this.comboProp = comboProp;
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        object.set(property, value);
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        Object val = obj.get(property);
        map.put(property, val);
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        List vItems = this.comboProp.getComboItems();
        HashMap<String, String> constantMap = new HashMap<String, String>();
        for (ValueMapItem item : vItems) {
            if (item == null || D.s(item.getName()) == null) continue;
            constantMap.put(D.s(item.getName()), item.getValue());
        }
        map.put("data_type", "ENUM");
        map.put("data_schema", IscUtil.mur32(parentEntityName + "." + this.comboProp.getName()));
        map.put("consts", constantMap);
        map.put("is_nullable", !this.comboProp.isMustInput());
        map.put("label", this.comboProp.getDisplayName().toString());
    }

    @Override
    public void setMapValByPropertyVal(Map<String, Object> targetMap, String propertyKey, Map<String, Object> propertyValueMap, Set<String> ignorePropertyKeySet) {
        targetMap.put(propertyKey, propertyValueMap.get(propertyKey));
    }
}

