/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.parameter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.formplugin.CheckParentFormIdPlugin;

public class BillParameterTransferFormPlugin
extends CheckParentFormIdPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String KEY_TREE_VIEW = "paratree";
    private static final String KEY_SEARCH = "searchap";
    private static final String TREE_CACHE = "treeCache";
    private static final String KEY_SEARCH_CACHE = "keyCache";
    private static final String SEARCH_RESULT_CACHE = "resultCache";
    private static final String INDEX_CACHE = "indexCache";
    private static final String FORM_NODE = "formNode";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BILL_FORM = "billForm";
    private static final String APP_ID = "appId";
    private static final String FAST_TRANSFER_KEY = "fasttransfer";
    private static final String ADD_PACKET_KEY = "addpacket";
    private static final String FAST_TRANSFER_ACTION_KEY = "fasttransfer_action";
    private static final String ADD_PACKET_ACTION_KEY = "addpacket_action";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.buildLeftTree();
        List<Map<String, String>> treeFormDataList = this.getTreeAllFormData();
        this.loadBillParamData(treeFormDataList);
        this.addPacketBtStatusProcess();
    }

    private void addPacketBtStatusProcess() {
        boolean canAddPacket = SysParaUtil.canAddPacket();
        if (canAddPacket) {
            FormViewUtil.cleanButtonTips((IFormView)this.getView(), (String[])new String[]{FAST_TRANSFER_KEY, ADD_PACKET_KEY});
        }
        this.getView().setEnable(Boolean.valueOf(canAddPacket), new String[]{FAST_TRANSFER_KEY, ADD_PACKET_KEY});
    }

    private void loadBillParamData(List<Map<String, String>> treeFormDataList) {
        String sql = "SELECT FFORMID FROM T_BAS_BILLPARAMETER;";
        List billParameterFormIdList = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, null, rs -> {
            ArrayList<String> list = new ArrayList<String>(16);
            while (rs.next()) {
                list.add(rs.getString("FFORMID"));
            }
            return list;
        });
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectType entryType = this.getModel().getEntryEntity(ENTRY_ENTITY).getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        List list = treeFormDataList.stream().filter(p -> billParameterFormIdList.contains(p.get("id"))).collect(Collectors.toList());
        for (Map parameter : list) {
            String id = (String)parameter.get("id");
            String appId = (String)parameter.get(APP_ID);
            String name = (String)parameter.get("name");
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("billname", (Object)name);
            entryObj.set("app_id", (Object)appId);
            entryObj.set("form_id", (Object)id);
            entryColl.add((Object)entryObj);
        }
        this.getModel().updateEntryCache(entryColl);
        this.getModel().updateCache();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private List<Map<String, String>> getTreeAllFormData() {
        String treeNodeFromCache = this.getPageCache().get(TREE_CACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (Object cloud : cloudNode) {
            if (cloud.getChildren() == null) continue;
            appNode.addAll(cloud.getChildren());
        }
        ArrayList formNode = new ArrayList();
        for (TreeNode app : appNode) {
            if (app.getChildren() == null) continue;
            formNode.addAll(app.getChildren());
        }
        ArrayList<Map<String, String>> treeFormIdList = new ArrayList<Map<String, String>>(16);
        for (TreeNode treeNode : formNode) {
            Map<String, String> formDataMap = this.buildFormDataMap(treeNode);
            treeFormIdList.add(formDataMap);
        }
        return treeFormIdList;
    }

    private Map<String, String> buildFormDataMap(TreeNode treeNode) {
        HashMap<String, String> formDataMap = new HashMap<String, String>(8);
        formDataMap.put("id", treeNode.getId());
        formDataMap.put("name", treeNode.getText());
        formDataMap.put(APP_ID, treeNode.getParentid());
        return formDataMap;
    }

    private void buildLeftTree() {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        if (treeRoot != null) {
            treeRoot.setId("rootNode");
            treeRoot.setText(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"BillParameterTransferFormPlugin_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            treeRoot.setParentid("");
            treeRoot.setIsOpened(true);
            List<Map<String, String>> formDataList = this.getFormData();
            List<TreeNode> formNodes = this.buildFormNodes(formDataList);
            this.buildNode(treeRoot, formNodes);
        }
        tree.addNode(treeRoot);
        tree.setRootVisible(true);
        tree.focusNode(treeRoot);
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)treeRoot));
    }

    private List<TreeNode> buildFormNodes(List<Map<String, String>> formDataList) {
        ArrayList<TreeNode> formNodes = new ArrayList<TreeNode>(formDataList.size());
        for (Map<String, String> formDataMap : formDataList) {
            String fid = formDataMap.get("id");
            String billForm = formDataMap.get(BILL_FORM);
            if (StringUtils.isBlank((CharSequence)billForm) || StringUtils.isBlank((CharSequence)fid)) continue;
            TreeNode node = new TreeNode();
            node.setText(formDataMap.get("name"));
            String appId = formDataMap.get(APP_ID);
            node.setParentid(appId);
            node.setId(fid);
            node.setData((Object)"form");
            node.setType(FORM_NODE);
            formNodes.add(node);
        }
        return formNodes;
    }

    public void search(SearchEnterEvent evt) {
        String cacheKey;
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        String cache = this.getPageCache().get(TREE_CACHE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        String key = evt.getText();
        if (key.equals(cacheKey = this.getPageCache().get(KEY_SEARCH_CACHE))) {
            String resultCache = this.getPageCache().get(SEARCH_RESULT_CACHE);
            List nodes = SerializationUtils.fromJsonStringToList((String)resultCache, TreeNode.class);
            int cachedIndex = Integer.parseInt(this.getPageCache().get(INDEX_CACHE));
            if (cachedIndex == nodes.size() - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22", (String)"BillParameterTransferFormPlugin_1", (String)"sys-ricc-business", (Object[])new Object[0]));
            }
            int currentIndex = this.getPageCache().get(INDEX_CACHE) == null ? 0 : cachedIndex % nodes.size();
            TreeNode tmpNode = (TreeNode)nodes.get(currentIndex);
            this.clickNode(tree, root, tmpNode);
            this.getPageCache().put(INDEX_CACHE, String.valueOf(++currentIndex));
        } else {
            List<TreeNode> nodes = new ArrayList();
            if ((nodes = root.getTreeNodeListById(nodes, key, 16)).isEmpty()) {
                nodes = root.getTreeNodeListByText(nodes, key, 16);
            }
            nodes.removeIf(node -> !FORM_NODE.equals(node.getType()));
            if (nodes.isEmpty()) {
                nodes = root.getTreeNodeListByText(nodes, key, 16);
            }
            nodes.removeIf(node -> !FORM_NODE.equals(node.getType()));
            if (nodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u76f8\u5173\u8868\u5355", (String)"BillParameterTransferFormPlugin_2", (String)"sys-ricc-business", (Object[])new Object[0]));
            } else {
                this.clickNode(tree, root, (TreeNode)nodes.get(0));
                this.getPageCache().put(SEARCH_RESULT_CACHE, SerializationUtils.toJsonString(nodes));
                this.getPageCache().put(INDEX_CACHE, String.valueOf(1));
                this.getPageCache().put(KEY_SEARCH_CACHE, key);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        EntryGrid entryGrid;
        int[] selectRows;
        String key = evt.getItemKey();
        if ((ADD_PACKET_KEY.equals(key) || FAST_TRANSFER_KEY.equals(key)) && (selectRows = (entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4f20\u8f93\u7684\u6570\u636e\u3002", (String)"BillParameterTransferFormPlugin_3", (String)"sys-ricc-business", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.buildLeftTree();
            List<Map<String, String>> treeFormDataList = this.getTreeAllFormData();
            this.loadBillParamData(treeFormDataList);
        } else if (ADD_PACKET_KEY.equalsIgnoreCase(itemKey) || FAST_TRANSFER_KEY.equals(itemKey)) {
            String actionId = ADD_PACKET_ACTION_KEY;
            if (FAST_TRANSFER_KEY.equals(itemKey)) {
                actionId = FAST_TRANSFER_ACTION_KEY;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(actionId, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u53c2\u6570\u662f\u63a7\u5236\u5355\u636e\u6d41\u7a0b\u7684\u6838\u5fc3\u914d\u7f6e\u6570\u636e\uff0c\u914d\u7f6e\u5f02\u5e38\u5c06\u4f1a\u9020\u6210\u7cfb\u7edf\u9519\u8bef\u3002\u5efa\u8bae\u4ec5\u521d\u59cb\u5316\u65f6\u5168\u91cf\u6253\u5305\uff0c\u614e\u91cd\u786e\u8ba4\u5185\u5bb9\u540e\u4f20\u8f93\u540c\u6b65\u3002\u8bf7\u518d\u6b21\u786e\u8ba4\u662f\u5426\u4f20\u8f93\u6240\u9009\u53c2\u6570\uff1f", (String)"BillParameterTransferFormPlugin_4", (String)"sys-ricc-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("addPacketClose".equalsIgnoreCase(actionId) && "success".equals(returnData = closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f", (String)"BillParameterTransferFormPlugin_5", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        ListSelectedRowCollection listSelectedRows = this.getListSelectedRows();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object guideId = formShowParameter.getCustomParam("guideId");
        if (guideId == null || kd.sys.ricc.common.util.StringUtils.isEmpty((String)guideId.toString())) {
            DynamicObject billParamTransfer = ConfigItemHelper.queryGuideByNumber((Object)"bos_billparamset", (String)"id,name");
            formShowParameter.setCustomParam("riccFormId", (Object)"bos_billparamset");
            formShowParameter.setCustomParam("packettype", (Object)DataPacketTypeEnum.CONFIG.getVal());
            formShowParameter.setCustomParam("guideId", billParamTransfer.get("id"));
            formShowParameter.setCustomParam("guideName", (Object)billParamTransfer.getString("name"));
            formShowParameter.setCustomParam("canAddPacket", (Object)Boolean.TRUE);
        }
        if (ADD_PACKET_ACTION_KEY.equalsIgnoreCase(callBackId)) {
            ConfigItemHelper.openAddPacketForm((ListSelectedRowCollection)listSelectedRows, (String)this.getView().getPageId(), null, (IFormView)this.getView(), (String)this.getPluginName());
        } else if (FAST_TRANSFER_ACTION_KEY.equals(callBackId)) {
            ConfigItemHelper.openAddTransferForm((ListSelectedRowCollection)listSelectedRows, (String)this.getView().getPageId(), null, (IFormView)this.getView(), (String)this.getPluginName());
        }
    }

    private ListSelectedRowCollection getListSelectedRows() {
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] rows = entry.getSelectRows();
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        for (int row : rows) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue(this.getModel().getValue("form_id", row));
            listSelectedRow.setName((String)this.getModel().getValue("billname", row));
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }

    public void clickNode(TreeView tree, TreeNode root, TreeNode node) {
        tree.focusNode(node);
        tree.treeNodeClick(node.getParentid(), node.getId());
        if (node.getChildren() == null) {
            String id = node.getParentid();
            while (StringUtils.isNotBlank((CharSequence)id)) {
                TreeNode tmp = root.getTreeNode(id, 16);
                tree.expand(tmp.getId());
                id = tmp.getParentid();
            }
        } else {
            tree.expand(node.getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_CACHE), TreeNode.class);
        if (!root.getId().equalsIgnoreCase(nodeId)) {
            ArrayList<Map<String, String>> formDataList = new ArrayList<Map<String, String>>(16);
            TreeNode checkedNode = root.getTreeNode(nodeId, 10);
            this.getFormDataFromTreeNode(checkedNode, formDataList);
            this.loadBillParamData(formDataList);
        } else {
            List<Map<String, String>> treeFormDataList = this.getTreeAllFormData();
            this.loadBillParamData(treeFormDataList);
        }
    }

    private void getFormDataFromTreeNode(TreeNode checkedNode, List<Map<String, String>> formDataList) {
        Object type = checkedNode.getData();
        if (type != null) {
            String typeStr = (String)type;
            if (typeStr.equalsIgnoreCase("cloud") || typeStr.equalsIgnoreCase("app")) {
                List childrenNodes = checkedNode.getChildren();
                if (childrenNodes != null && !childrenNodes.isEmpty()) {
                    for (TreeNode childrenNode : childrenNodes) {
                        this.getFormDataFromTreeNode(childrenNode, formDataList);
                    }
                }
            } else {
                formDataList.add(this.buildFormDataMap(checkedNode));
            }
        }
    }

    private void buildNode(TreeNode pNode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>(16);
        this.getLeafNodes(leafNodeMap, pNode);
        for (TreeNode cNode : childNode) {
            String parentId = cNode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentId);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cNode);
        }
        this.clearNoParamNode(pNode, null);
        this.clearNoParamNode(pNode, null);
    }

    private void clearNoParamNode(TreeNode curNode, TreeNode parentNode) {
        if (curNode.getChildren() != null && !curNode.getChildren().isEmpty()) {
            ArrayList lstNodes = new ArrayList(curNode.getChildren());
            for (TreeNode childNode : lstNodes) {
                this.clearNoParamNode(childNode, curNode);
            }
        } else {
            String typeStr;
            if (parentNode == null) {
                return;
            }
            Object type = curNode.getData();
            if (type != null && ((typeStr = (String)type).equalsIgnoreCase("cloud") || typeStr.equalsIgnoreCase("app"))) {
                parentNode.deleteChildNode(curNode.getId());
            }
        }
    }

    private void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                this.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
        }
    }

    private List<Map<String, String>> getFormData() {
        String sql = "select t.FID, t.FBIZAPPID, tl.FNAME, te.fdata, tp.fmasterid from T_META_MAINENTITYINFO as t left join T_META_MAINENTITYINFO_L as tl on t.FID=tl.FID left join t_meta_bizapp as tp on t.fbizappid = tp.fid left join t_meta_entity as te on t.fid = te.fnumber where t.FISTEMPLATE = '0' and tl.FLOCALEID=? and ((t.FMODELTYPE=? and t.FNUMBERFIELDKEY<>' ' and t.FNAMEFIELDKEY<>' ') or t.FMODELTYPE=?)";
        String sqlStrEntityId = RunModeServiceHelper.getEntityNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)sqlStrEntityId)) {
            sql = sql + " and t.FID not in (" + sqlStrEntityId + ")";
        }
        sql = sql + " and te.ftype = 20";
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>();
        sqlParams.add(new SqlParameter(12, (Object)RequestContext.get().getLang().name()));
        sqlParams.add(new SqlParameter(12, (Object)"BaseFormModel"));
        sqlParams.add(new SqlParameter(12, (Object)"BillFormModel"));
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParams.toArray(), rs -> {
            ArrayList formDataMapList = new ArrayList(10);
            while (rs.next()) {
                String fid = rs.getString(1);
                String fData = rs.getString(4);
                if (StringUtils.isBlank((CharSequence)fData) || StringUtils.isBlank((CharSequence)fid)) continue;
                String appIdStr = rs.getString(2);
                String name = rs.getString(3);
                String originalAppId = rs.getString(5);
                HashMap<String, String> formDataMap = new HashMap<String, String>(8);
                formDataMap.put("id", fid);
                formDataMap.put("name", name);
                if (StringUtils.isBlank((CharSequence)originalAppId)) {
                    formDataMap.put(APP_ID, appIdStr);
                } else {
                    formDataMap.put(APP_ID, originalAppId);
                }
                formDataMap.put(BILL_FORM, fData);
                formDataMapList.add(formDataMap);
            }
            return formDataMapList;
        });
    }
}

