/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.api.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sys.ricc.api.IDataPacketDemoService;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.impt.ExcelResolveHelper;
import kd.sys.ricc.common.enums.FileTransferType;
import kd.sys.ricc.common.helper.DataCompareHelper;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class DataPacketDemoServiceImpl
implements IDataPacketDemoService {
    private static final Log logger = LogFactory.getLog(DataPacketDemoServiceImpl.class);

    @Override
    public Map<String, Object> exportPacket(Map<String, Object> map) {
        Serializable selectedInfo;
        Serializable multdataList;
        String entityNumber = (String)map.get("entity_number");
        String fileTransferType = (String)map.get("file_transfer_type");
        map.put("entitynumber", entityNumber);
        List listSelectedRowList = (List)map.get("listSelectedRowList");
        JsonDataPacketImpl jsonDataPacketImpl = new JsonDataPacketImpl();
        SdpInputParams sdpInputParams = new SdpInputParams();
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        listSelectedRows.addAll((Collection)listSelectedRowList);
        String localPath = FileUtils.generateLocalPath();
        FileUtils.checkAndCreateDir((String)localPath);
        DynamicObject guide = ConfigItemHelper.queryGuideById(2148750605689118720L, "1");
        map.put("guideId", guide);
        sdpInputParams.setSelectRows(listSelectedRows);
        sdpInputParams.setLocalPath(localPath);
        sdpInputParams.setParam(map);
        SdpOutputParams sdpOutputParams = jsonDataPacketImpl.exportPacket(sdpInputParams);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (!sdpOutputParams.isSuccess()) {
            returnMap.put("msg", sdpOutputParams.getErrorStr());
            returnMap.put("dev_msg", sdpOutputParams.getDevErrorStr());
            return returnMap;
        }
        String filePath = sdpOutputParams.getExportFilePath();
        if (FileTransferType.TempFile.getValue().equals(fileTransferType)) {
            String tempUrl = FileUtils.getTempUrlFormLocalFile((String)filePath, (int)0);
            returnMap.put("code", 0);
            returnMap.put("msg", ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"DataPacketDemoServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            returnMap.put("export_url", tempUrl);
            multdataList = new ArrayList();
            HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
            dataMap.put("entity_number", entityNumber);
            dataMap.put("export_url", tempUrl);
            selectedInfo = new ArrayList();
            HashMap<String, Object> selectedMap = new HashMap<String, Object>(2);
            selectedMap.put("id", 1708617659693710336L);
            selectedMap.put("number", "ricc_unittest_byte_add");
            selectedMap.put("name", ResManager.loadKDString((String)"ricc\u5fae\u670d\u52a1\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6d4b\u8bd5\u6570\u636e\u3002", (String)"DataPacketDemoServiceImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
            HashMap<String, Object> selectedMap1 = new HashMap<String, Object>(2);
            selectedMap1.put("id", 1708618611507116032L);
            selectedMap1.put("number", "riccunittest_tempfile_add");
            selectedMap1.put("name", ResManager.loadKDString((String)"ricc\u5fae\u670d\u52a1\u4e34\u65f6\u6587\u4ef6\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6d4b\u8bd5\u6570\u636e\u3002", (String)"DataPacketDemoServiceImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
            selectedInfo.add(selectedMap);
            selectedInfo.add(selectedMap1);
            dataMap.put("selected_info", selectedInfo);
            multdataList.add(dataMap);
            returnMap.put("multidata_list", multdataList);
        } else {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                multdataList = null;
                try {
                    FileInputStream fileInputStream = new FileInputStream(filePath);
                    selectedInfo = null;
                    try {
                        FileUtils.inputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream);
                        returnMap.put("code", 0);
                        returnMap.put("msg", ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"DataPacketDemoServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                        returnMap.put("byte_arr", byteArrayOutputStream.toByteArray());
                    }
                    catch (Throwable throwable) {
                        selectedInfo = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fileInputStream != null) {
                            if (selectedInfo != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)selectedInfo).addSuppressed(throwable);
                                }
                            } else {
                                fileInputStream.close();
                            }
                        }
                    }
                }
                catch (Throwable fileInputStream) {
                    multdataList = fileInputStream;
                    throw fileInputStream;
                }
                finally {
                    if (byteArrayOutputStream != null) {
                        if (multdataList != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (Throwable fileInputStream) {
                                ((Throwable)multdataList).addSuppressed(fileInputStream);
                            }
                        } else {
                            byteArrayOutputStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                returnMap.put("code", 1);
                returnMap.put("msg", String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c%s", (String)"DataPacketDemoServiceImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()));
                returnMap.put("dev_msg", CommonUtil.getExceptionDetailInfo((Throwable)e));
            }
        }
        returnMap.put("file_name", System.currentTimeMillis() + "_micro.json");
        ArrayList relybdList = new ArrayList(2);
        HashMap<String, Object> relybdMap = new HashMap<String, Object>(2);
        relybdMap.put("entity_number", "bos_adminorg");
        ArrayList<Long> dataList = new ArrayList<Long>(8);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        dataList.add(rootOrgId);
        relybdMap.put("id_list", dataList);
        relybdList.add(relybdMap);
        returnMap.put("relybd_list", relybdList);
        return returnMap;
    }

    @Override
    public Map<String, Object> importPacket(Map<String, Object> map) {
        String fileTransferType = (String)map.get("file_transfer_type");
        SdpInputParams sdpInputParams = new SdpInputParams();
        HashMap<String, Object> resmap = new HashMap<String, Object>(1);
        String fileUrl = (String)map.get("import_url");
        String fileName = (String)map.get("file_name");
        sdpInputParams.setParam(resmap);
        JsonDataPacketImpl jsonDataPacketImpl = new JsonDataPacketImpl();
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        InputStream in = null;
        try {
            if (FileTransferType.TempFile.getValue().equals(fileTransferType)) {
                TempFileCacheDownloadable.Content cacheContentFromTempUrl = FileUtils.getCacheContentFromTempUrl((String)fileUrl);
                in = cacheContentFromTempUrl.getInputStream();
            } else {
                byte[] bytes = (byte[])map.get("byte_arr");
                in = new ByteArrayInputStream(bytes);
            }
            if (fileName.endsWith("zip")) {
                try (ZipInputStream zipInputStream = new ZipInputStream(in);){
                    ZipEntry entry;
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        this.importFile(zipInputStream, jsonDataPacketImpl, sdpOutputParams);
                    }
                }
            } else {
                this.importFile(in, jsonDataPacketImpl, sdpOutputParams);
            }
            boolean success = sdpOutputParams.getError().length() <= 0;
            sdpOutputParams.setSuccess(success);
            returnMap.put("msg", sdpOutputParams.getError());
            returnMap.put("dev_msg", sdpOutputParams.getDevError());
            returnMap.put("code", sdpOutputParams.getError().length() <= 0 ? 0 : 1);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            returnMap.put("msg", e.getMessage());
            returnMap.put("dev_msg", CommonUtil.getExceptionDetailInfo((Throwable)e));
            returnMap.put("code", 1);
            return returnMap;
        }
        if (!sdpOutputParams.isSuccess()) {
            returnMap.put("msg", sdpOutputParams.getErrorStr());
            returnMap.put("dev_msg", sdpOutputParams.getDevErrorStr());
            returnMap.put("code", 1);
            return returnMap;
        }
        return returnMap;
    }

    private void importFile(InputStream in, JsonDataPacketImpl jsonDataPacketImpl, SdpOutputParams sdpOutputParams) {
        JSONObject dataMap = null;
        try {
            String resStr = FileUtils.inputStreamToString((InputStream)in);
            dataMap = JSON.parseObject((String)resStr);
        }
        catch (JSONException e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5b50\u5305\u6570\u636e\u8f6c\u6362json\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataPacketDemoServiceImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()), CommonUtil.getExceptionDetailInfo((Throwable)e));
            return;
        }
        if (dataMap == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u6570\u636e\u5931\u8d25\u3002", (String)"DataPacketDemoServiceImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        Set idSet = dataMap.keySet();
        String entryentity = null;
        if (!dataMap.containsKey((Object)"entityType") || dataMap.get((Object)"entityType") == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b\u578bentityType\uff0c\u8bf7\u68c0\u67e5\u5305\u6587\u4ef6\u662f\u5426\u88ab\u7be1\u6539\u6216\u5185\u5bb9\u635f\u574f\u3002", (String)"DataPacketDemoServiceImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        entryentity = String.valueOf(dataMap.remove((Object)"entityType"));
        String keyFields = "id";
        jsonDataPacketImpl.synOnBatchResumeMode(sdpOutputParams, dataMap, entryentity, idSet, keyFields, JsonDataPacketImpl.BatchSaveType.SAVE_OPERATE);
    }

    @Override
    public Map<String, Object> parseStreamData(Map<String, Object> params) {
        logger.info("fileUrl:{}", params.get("fileUrl"));
        logger.info("itemId:{}", params.get("itemId"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        if (!params.containsKey("fileUrl") || StringUtils.isBlank((Object)params.get("fileUrl"))) {
            resultMap.put("success", false);
            resultMap.put("errMessage", ResManager.loadKDString((String)"fileUrl\u4e3a\u7a7a", (String)"ExcelDataPacketImpl_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return resultMap;
        }
        if (!params.containsKey("itemId") || StringUtils.isBlank((Object)params.get("itemId"))) {
            resultMap.put("success", false);
            resultMap.put("errMessage", ResManager.loadKDString((String)"itemId\u4e3a\u7a7a", (String)"ExcelDataPacketImpl_16", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return resultMap;
        }
        String filePath = (String)params.get("fileUrl");
        Long configItemId = (Long)params.get("itemId");
        try {
            List<Map<String, Object>> data = ExcelResolveHelper.resolveXlsxFile(filePath, configItemId);
            HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
            String keyFields = ConfigItemHelper.buildKeyFields(configItemId);
            dataMap.put("selectCount", data.size());
            dataMap.put("selectDatas", data);
            dataMap.put("keyFields", keyFields);
            resultMap.put("data", dataMap);
            resultMap.put("success", true);
        }
        catch (Exception e) {
            resultMap.put("success", false);
            resultMap.put("errMessage", e.getMessage());
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> compareData(Map<String, Object> params) {
        return DataCompareHelper.generalCompareDataImpl(params);
    }
}

