/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class AttachAndPictureTransHelper {
    public static Map<String, Object> getAllAttContentMap(DynamicObject[] dynamicObjects, List<String> attFieldKeys, List<String> attApKeys, String entityNumber, String localAttachPath) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (attFieldKeys.isEmpty() && attApKeys.isEmpty()) {
            return result;
        }
        HashMap<String, HashMap<String, Object>> allPictureMap = new HashMap<String, HashMap<String, Object>>(4);
        HashMap allAttContentMap = new HashMap(16);
        for (DynamicObject oneData : dynamicObjects) {
            HashMap attContentMap = new HashMap(16);
            HashMap<String, Object> pirctureMap = new HashMap<String, Object>(16);
            Object pkValue = oneData.getPkValue();
            if (!attFieldKeys.isEmpty()) {
                HashMap<String, Object> attFieldContentMap = new HashMap<String, Object>(16);
                DataEntityPropertyCollection properties = oneData.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String propertyName = property.getName();
                    if (attFieldKeys.contains(propertyName) && property instanceof AttachmentProp) {
                        List<Map<String, Object>> attachValues = AttachAndPictureTransHelper.getAttFieldContent(oneData, propertyName, localAttachPath);
                        attFieldContentMap.put(propertyName, attachValues);
                        continue;
                    }
                    if (attFieldKeys.contains(propertyName) && property instanceof PictureProp) {
                        AttachAndPictureTransHelper.setPictureMap(oneData, pirctureMap, propertyName);
                        continue;
                    }
                    if (!(property instanceof EntryProp)) continue;
                    AttachAndPictureTransHelper.getEntryAttFieldContent(oneData, propertyName, attFieldKeys, pirctureMap, attFieldContentMap, localAttachPath);
                }
                attContentMap.put("attfield", attFieldContentMap);
            }
            if (!pirctureMap.isEmpty()) {
                allPictureMap.put(String.valueOf(pkValue), pirctureMap);
            }
            if (!attApKeys.isEmpty()) {
                HashMap attApContentMap = new HashMap(16);
                for (String attachApKey : attApKeys) {
                    Map attachmentAps = AttachmentServiceHelper.getAttachments((String)entityNumber, (Object[])new Object[]{pkValue}, (String)attachApKey, (boolean)false);
                    if (attachmentAps.isEmpty()) continue;
                    List attachAps = (List)attachmentAps.get(String.valueOf(pkValue));
                    ArrayList newAttAps = new ArrayList(attachAps.size());
                    for (Map attachAp : attachAps) {
                        HashMap<String, String> newAttAp = new HashMap<String, String>(attachAp.size());
                        String name = (String)attachAp.get("name");
                        long id = (Long)attachAp.get("attPkId");
                        String fileName = id + "_" + name;
                        String url = (String)attachAp.get("url");
                        AttachAndPictureTransHelper.downAttachFile(fileName, url, localAttachPath);
                        newAttAp.put("name", name);
                        newAttAp.put("type", (String)attachAp.get("type"));
                        newAttAp.put("size", (String)attachAp.get("size"));
                        newAttAp.put("attachKey", attachApKey);
                        newAttAp.put("fileContent", fileName);
                        newAttAps.add(newAttAp);
                    }
                    attApContentMap.put(attachApKey, newAttAps);
                }
                attContentMap.put("attap", attApContentMap);
            }
            if (attContentMap.isEmpty()) continue;
            allAttContentMap.put(String.valueOf(pkValue), attContentMap);
        }
        if (!allPictureMap.isEmpty() || !allAttContentMap.isEmpty()) {
            result.put("entityType", entityNumber);
            result.put("allPictureMap", allPictureMap);
            result.put("attContent", allAttContentMap);
        }
        return result;
    }

    private static void getEntryAttFieldContent(DynamicObject oneData, String entryKey, List<String> attFieldKeys, Map<String, Object> pictureMap, Map<String, Object> attFieldContentMap, String localPath) {
        DynamicObjectCollection entrys = oneData.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entrys) {
            DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (attFieldKeys.contains(name) && property instanceof AttachmentProp) {
                    List<Map<String, Object>> attachValues = AttachAndPictureTransHelper.getAttFieldContent(entry, name, localPath);
                    attFieldContentMap.put(name, attachValues);
                    continue;
                }
                if (attFieldKeys.contains(name) && property instanceof PictureProp) {
                    AttachAndPictureTransHelper.setPictureMap(entry, pictureMap, name);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                AttachAndPictureTransHelper.getEntryAttFieldContent(entry, name, attFieldKeys, pictureMap, attFieldContentMap, localPath);
            }
        }
    }

    private static List<Map<String, Object>> getAttFieldContent(DynamicObject dynamicObject, String attFieldKey, String localAttachPath) {
        ArrayList<Map<String, Object>> attachValues = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection values = dynamicObject.getDynamicObjectCollection(attFieldKey);
        if (values.isEmpty()) {
            return attachValues;
        }
        List attachContents = values.stream().filter(value -> value.getDynamicObject("fbasedataid") != null).map(value -> value.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        if (attachContents.size() == 0) {
            return attachValues;
        }
        for (DynamicObject attachContent : attachContents) {
            HashMap<String, Object> attFieldValMap = new HashMap<String, Object>(5);
            String name = attachContent.getString("name");
            String url = attachContent.getString("url");
            String id = attachContent.getString("id");
            String fileName = id + "_" + name;
            AttachAndPictureTransHelper.downAttachFile(fileName, url, localAttachPath);
            attFieldValMap.put("name", name);
            attFieldValMap.put("type", attachContent.get("type"));
            attFieldValMap.put("size", attachContent.get("size"));
            attFieldValMap.put("attachKey", attFieldKey);
            attFieldValMap.put("fileContent", fileName);
            attachValues.add(attFieldValMap);
        }
        return attachValues;
    }

    private static void downAttachFile(String fileName, String url, String localAttachPath) {
        File attachFile = new File(localAttachPath + File.separator + fileName);
        try (FileOutputStream fos = new FileOutputStream(attachFile);){
            String realFileUrl = CommonUtil.checkUrl((String)url);
            FileServiceFactory.getAttachmentFileService().download(realFileUrl, (OutputStream)fos, "imsc-ricc");
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"AttachTransHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msg, fileName, e.getMessage()), (Throwable)e);
        }
    }

    private static void setPictureMap(DynamicObject oneData, Map<String, Object> pictureMap, String propertyName) {
        String imageUrl = (String)oneData.get(propertyName);
        if (StringUtils.isBlank((CharSequence)imageUrl)) {
            return;
        }
        FileService fs = FileServiceFactory.getImageFileService();
        String pictureStr = "";
        try (InputStream inputStream = fs.getInputStream(imageUrl);
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            pictureStr = Base64.getEncoder().encodeToString(output.toByteArray());
        }
        catch (Exception e) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u6587\u4ef6[%s]\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"AttachTransHelper_0", (String)"sys-ricc-platform", (Object[])new Object[]{propertyName}));
        }
        pictureMap.put(propertyName, pictureStr);
    }

    public static void importAttContent(InputStream fileInputStream, String name, SdpOutputParams sdpOutputParams) {
        DynamicObject[] datas;
        JSONObject dadaJson;
        try {
            String resStr = FileUtils.inputStreamToString((InputStream)fileInputStream);
            dadaJson = (JSONObject)JSON.parseObject((String)resStr, (TypeReference)new TypeReference<JSONObject>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6%s\u5931\u8d25\u3002", (String)"AttachTransHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]), name), e);
            return;
        }
        if (!dadaJson.containsKey((Object)"entityType") || dadaJson.get((Object)"entityType") == null) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b\u578bentityType\uff0c\u8bf7\u68c0\u67e5\u5305\u6587\u4ef6\u662f\u5426\u88ab\u7be1\u6539\u6216\u5185\u5bb9\u635f\u574f\u3002", (String)"AttachTransHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]), name));
            return;
        }
        String entityNum = String.valueOf(dadaJson.remove((Object)"entityType"));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        JSONObject allPictureMap = dadaJson.getJSONObject("allPictureMap");
        JSONObject attContentMap = dadaJson.getJSONObject("attContent");
        Set<Object> idList = new HashSet(2);
        if (attContentMap != null && !attContentMap.isEmpty()) {
            idList = attContentMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
        }
        if (allPictureMap != null && !allPictureMap.isEmpty()) {
            idList = allPictureMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
        }
        if ((datas = BusinessDataServiceHelper.load((Object[])idList.toArray(new Object[0]), (DynamicObjectType)entityType)).length == 0) {
            return;
        }
        DataEntityPropertyCollection properties = datas[0].getDataEntityType().getProperties();
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{entityNum});
        if (attContentMap != null && !attContentMap.isEmpty()) {
            AttachAndPictureTransHelper.uploadAttContent(datas, entityNum, appId, attContentMap, sdpOutputParams, properties);
        }
        if (allPictureMap != null && !allPictureMap.isEmpty()) {
            FileService imageFileService = FileServiceFactory.getImageFileService();
            for (DynamicObject oneData : datas) {
                Object pkValue = oneData.getPkValue();
                JSONObject pictureMap = (JSONObject)allPictureMap.get(pkValue);
                for (Map.Entry entry : pictureMap.entrySet()) {
                    String keyName = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    for (IDataEntityProperty property : properties) {
                        String propertyName = property.getName();
                        if (keyName.equals(propertyName)) {
                            AttachAndPictureTransHelper.setFieldPicture(imageFileService, oneData, value, propertyName);
                            continue;
                        }
                        if (!(property instanceof EntryProp)) continue;
                        AttachAndPictureTransHelper.setEntryPictures(imageFileService, oneData, keyName, value, propertyName);
                    }
                }
            }
        }
        try {
            SaveServiceHelper.save((DynamicObject[])datas);
        }
        catch (Exception e) {
            String error = String.format(ResManager.loadKDString((String)"\u901a\u8fc7SaveServiceHelper.save()\u65b9\u6cd5\u4fdd\u5b58\u5b9e\u4f53\u6807\u8bc6\u4e3a\u201c%1$s\u201d\u7684\u6570\u636e\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AttachTransHelper_4", (String)"sys-ricc-platform", (Object[])new Object[0]), entityNum);
            sdpOutputParams.append(error, e);
        }
    }

    private static void setFieldPicture(FileService imageFileService, DynamicObject oneData, String value, String propertyName) {
        String currentYearMonth;
        byte[] decodedBytes = Base64.getDecoder().decode(value);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
        String oldPath = (String)oneData.get(propertyName);
        CharSequence[] parts = oldPath.split("/");
        if (parts.length < 3) {
            return;
        }
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        parts[1] = tenantId;
        parts[2] = accountId;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        parts[3] = currentYearMonth = LocalDateTime.now().format(formatter);
        FileItem item = new FileItem(String.join((CharSequence)"/", parts), oldPath, (InputStream)inputStream);
        String newPath = imageFileService.upload(item);
        oneData.set(propertyName, (Object)newPath);
    }

    private static void setEntryPictures(FileService imageFileService, DynamicObject oneData, String keyName, String value, String propertyName) {
        DynamicObjectCollection entryData = oneData.getDynamicObjectCollection(propertyName);
        if (entryData.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)entryData.get(0)).getDataEntityType().getProperties();
        for (DynamicObject rowData : entryData) {
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (keyName.equals(name)) {
                    AttachAndPictureTransHelper.setFieldPicture(imageFileService, rowData, value, name);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                AttachAndPictureTransHelper.setEntryPictures(imageFileService, rowData, keyName, value, name);
            }
        }
    }

    private static void uploadAttContent(DynamicObject[] datas, String entityNum, String appId, JSONObject allAttContentMap, SdpOutputParams sdpOutputParams, DataEntityPropertyCollection properties) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        Map<String, Object> param = sdpOutputParams.getParam();
        Object attTemUrlObj = param.get("attTemUrl");
        HashMap<String, String> attTemUrlMap = new HashMap(16);
        if (attTemUrlObj != null) {
            attTemUrlMap = (Map)attTemUrlObj;
        }
        for (DynamicObject dynamicObject : datas) {
            Object pkValue = dynamicObject.getPkValue();
            String pdValueStr = String.valueOf(pkValue);
            AttachmentServiceHelper.remove((String)entityNum, (Object)pkValue);
            if (!allAttContentMap.containsKey((Object)pdValueStr) || allAttContentMap.get((Object)pdValueStr) == null) continue;
            Map attContentMap = (Map)allAttContentMap.get((Object)pdValueStr);
            if (attContentMap.containsKey("attap") && attContentMap.get("attap") != null) {
                Map attApContentMap = (Map)attContentMap.get("attap");
                for (Map.Entry attApEntry : attApContentMap.entrySet()) {
                    String attachApKey = (String)attApEntry.getKey();
                    List attachApValues = (List)attApEntry.getValue();
                    if (attachApValues.isEmpty()) continue;
                    for (Map attachApValue : attachApValues) {
                        String fileContent = (String)attachApValue.get("fileContent");
                        String fileName = (String)attachApValue.get("name");
                        String tUrl = (String)attTemUrlMap.get(fileContent);
                        if (StringUtils.isEmpty((String)tUrl)) continue;
                        try (InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(tUrl);){
                            String path = FileUtils.upload2FileService((String)fileName, (String)entityNum, (String)appId, (FileService)fileService, (InputStream)inputStream);
                            attachApValue.put("url", path);
                        }
                        catch (Exception e) {
                            sdpOutputParams.append(String.format(CommonConstant.getImportFileErrorTip(), fileName));
                        }
                        attachApValue.put("uid", "rc-upload-" + DB.genGlobalLongId());
                        attachApValue.remove("fileContent");
                    }
                    AttachmentServiceHelper.upload((String)entityNum, (Object)pkValue, (String)attachApKey, (List)attachApValues);
                }
            }
            if (!attContentMap.containsKey("attfield") || attContentMap.get("attfield") == null) continue;
            Map attFieldContentMap = (Map)attContentMap.get("attfield");
            Set attachFields = attFieldContentMap.keySet();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (attachFields.contains(propertyName)) {
                    DynamicObjectCollection attFieldDatas = AttachAndPictureTransHelper.uploadAttFieldContent(dynamicObject, entityNum, appId, propertyName, attFieldContentMap, fileService, sdpOutputParams, attTemUrlMap);
                    dynamicObject.set(property, (Object)attFieldDatas);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                AttachAndPictureTransHelper.uploadEntryAttField(dynamicObject, entityNum, appId, propertyName, attFieldContentMap, fileService, sdpOutputParams, attTemUrlMap);
            }
        }
        param.remove("attTemUrl");
    }

    private static void uploadEntryAttField(DynamicObject dynamicObject, String entityNum, String appId, String entryKey, Map<String, Object> attFieldContentMap, FileService fileService, SdpOutputParams sdpOutputParams, Map<String, String> attTemUrlMap) {
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection(entryKey);
        Set<String> attachFields = attFieldContentMap.keySet();
        for (DynamicObject entry : entrys) {
            DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (attachFields.contains(propertyName)) {
                    DynamicObjectCollection attFieldDatas = AttachAndPictureTransHelper.uploadAttFieldContent(entry, entityNum, appId, propertyName, attFieldContentMap, fileService, sdpOutputParams, attTemUrlMap);
                    entry.set(property, (Object)attFieldDatas);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                AttachAndPictureTransHelper.uploadEntryAttField(entry, entityNum, appId, propertyName, attFieldContentMap, fileService, sdpOutputParams, attTemUrlMap);
            }
        }
    }

    private static DynamicObjectCollection uploadAttFieldContent(DynamicObject dynamicObject, String entityNum, String appId, String attFieldKey, Map<String, Object> attFieldContentMap, FileService fileService, SdpOutputParams sdpOutputParams, Map<String, String> attTemUrlMap) {
        DynamicObjectCollection attFieldDatas = dynamicObject.getDynamicObjectCollection(attFieldKey);
        attFieldDatas.clear();
        List attachFieldValues = (List)attFieldContentMap.get(attFieldKey);
        if (attachFieldValues.isEmpty()) {
            return attFieldDatas;
        }
        for (Object attachFieldValue : attachFieldValues) {
            String fileName = (String)attachFieldValue.get("name");
            String fileContent = (String)attachFieldValue.get("fileContent");
            String tUrl = attTemUrlMap.get(fileContent);
            if (StringUtils.isEmpty((String)tUrl)) continue;
            try (InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(tUrl);){
                String path = FileUtils.upload2FileService((String)fileName, (String)entityNum, (String)appId, (FileService)fileService, (InputStream)inputStream);
                attachFieldValue.put("url", path);
            }
            catch (Exception e) {
                sdpOutputParams.append(String.format(CommonConstant.getImportFileErrorTip(), fileName));
            }
            attachFieldValue.remove("fileContent");
            attachFieldValue.put("status", "success");
            attachFieldValue.put("uid", "rc-upload-" + DB.genGlobalLongId());
        }
        List attList = AttachmentFieldServiceHelper.saveAttachments((String)entityNum, (String)"", (List)attachFieldValues);
        for (DynamicObject dyo : attList) {
            dyo.set("tempfile", (Object)1);
            long attId = dyo.getLong("id");
            DynamicObject newRow = new DynamicObject(attFieldDatas.getDynamicObjectType());
            newRow.set("fbasedataid_id", (Object)attId);
            attFieldDatas.add((Object)newRow);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])attList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            String error = ResManager.loadKDString((String)"\u901a\u8fc7SaveServiceHelper.save()\u65b9\u6cd5\u4fdd\u5b58\u9644\u4ef6\u5b57\u6bb5\u5b9e\u4f53\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AttachTransHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
            sdpOutputParams.append(error, e);
        }
        return attFieldDatas;
    }

    public static void uploadAttachTemp(String fileName, InputStream inputStream, SdpOutputParams sdpOutputParams) {
        fileName = fileName.split("/")[1];
        byte[] bytes = FileUtils.inputStreamToByte((InputStream)inputStream);
        String tUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, bytes, 900);
        sdpOutputParams.getParam().putIfAbsent("attTemUrl", new HashMap(16));
        Map attTemUrlMap = (Map)sdpOutputParams.getParam().get("attTemUrl");
        attTemUrlMap.put(fileName, tUrl);
    }

    public static List<String> getAttApKeys(List<String> attachKeys) {
        ArrayList<String> attachApKeys = new ArrayList<String>(16);
        ArrayList<String> oriAttachApKeys = new ArrayList<String>(16);
        for (String attachKey : attachKeys) {
            if (!attachKey.startsWith("#")) continue;
            String attachApKey = attachKey.substring(attachKey.indexOf("#") + 1);
            attachApKeys.add(attachApKey);
            oriAttachApKeys.add(attachKey);
        }
        attachKeys.removeAll(oriAttachApKeys);
        return attachApKeys;
    }
}

