/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.schedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.datapacket.schedule.BatchPackTaskHandler;
import kd.sys.ricc.business.log.ConfigLog;
import kd.sys.ricc.business.log.impl.ConfigLogImpl;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.exception.RiccBizException;

public class BatchPacketTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(BatchPacketTask.class);
    private AddPacketProgress addPacketProgress;
    ConfigLog configLog = new ConfigLogImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        JSONArray packSchemeEntry = (JSONArray)map.get("packschemeentry");
        this.getAddPacketProgress().feedbackProgress(packSchemeEntry.size(), 0);
        Object packetId = map.get("packetId");
        DynamicObject batchPacket = BusinessDataServiceHelper.loadSingle((Object)packetId, (String)"ricc_datapacket");
        JSONObject packet = new JSONObject();
        packet.put("pkv", batchPacket.get("id"));
        packet.put("na", (Object)batchPacket.getString("name"));
        packet.put("nu", (Object)batchPacket.getString("number"));
        BatchPackTaskHandler taskHandler = new BatchPackTaskHandler(packSchemeEntry, this.getAddPacketProgress(), packet);
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        Object packSchemeId = map.get("packSchemeId");
        this.configLog.preWriteBatchPackLog("2", this.taskId, (Long)packetId, packSchemeId);
        data.put("packetNumber", packet.getString("nu"));
        data.put("total", taskHandler.getTotal());
        if (packSchemeEntry.size() < 5) {
            taskHandler.call();
        } else {
            try (ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"OneKeyPackThreadPool", (int)2);){
                Future f1 = threadPool.submit((Callable)taskHandler);
                Future f2 = threadPool.submit((Callable)taskHandler);
                this.waitToEnd(f1, f2);
            }
        }
        taskHandler.getErrMsg().setEndTime(System.currentTimeMillis());
        if (taskHandler.getSuccessCount().get() < taskHandler.getTotal()) {
            data.put("successCount", taskHandler.getSuccessCount());
            data.put("failmsg", taskHandler.getErrMsg().toString());
        }
        Object logId = this.savePackingLog(taskHandler);
        data.put("logId", logId);
        this.getAddPacketProgress().feedbackCustData(data);
        this.getAddPacketProgress().complete();
    }

    private Object savePackingLog(BatchPackTaskHandler taskHandler) {
        this.configLog.afterWriteLog(taskHandler.getTotal(), taskHandler.getSuccessCount().get(), taskHandler.getErrMsg());
        return this.configLog.getLogId();
    }

    private void waitToEnd(Future f1, Future f2) {
        int sleepSecond = 500;
        int interruptedCount = 0;
        while (!f1.isDone() || !f2.isDone()) {
            block3: {
                try {
                    Thread.sleep(sleepSecond);
                }
                catch (InterruptedException e) {
                    int n = interruptedCount;
                    interruptedCount = (byte)(interruptedCount + 1);
                    if (n <= 3) break block3;
                    logger.error("BatchPacketTask.waitToEnd error: ", (Throwable)e);
                    throw new RiccBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u4efb\u52a1\u7b49\u5f85\u88ab\u591a\u6b21\u5f3a\u5236\u4e2d\u65ad,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"BatchPacketTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
                }
            }
            sleepSecond = ScheduleUtil.getDynamicSleepSecond(sleepSecond, 5000);
        }
    }

    public AddPacketProgress getAddPacketProgress() {
        if (this.addPacketProgress == null) {
            this.addPacketProgress = new AddPacketProgress(this.taskId);
        }
        return this.addPacketProgress;
    }
}

