/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import java.util.Collections;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public interface CommonMethod {
    public IFormView getView();

    public IPageCache getPageCache();

    default public <T> T getCustomFormParam(String paramName) {
        return (T)this.getView().getFormShowParameter().getCustomParam(paramName);
    }

    default public <T> void putCache(String cacheKey, T cacheValue) {
        String jsonStr = SerializationUtils.toJsonString(cacheValue);
        this.getPageCache().put(cacheKey, jsonStr);
    }

    default public <T> T getCache(String cacheKey, Class<?> valueType, Supplier<T> defaultValue) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return defaultValue.get();
        }
        String content = pageCache.get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)content)) {
            return defaultValue.get();
        }
        return (T)SerializationUtils.fromJsonString((String)content, valueType);
    }

    default public <T> T getCache(String cacheKey, Class<?> valueType) {
        return (T)this.getCache(cacheKey, valueType, () -> null);
    }

    default public void refreshList() {
        IFormView view = this.getView();
        if (view == null) {
            return;
        }
        BillList billList = (BillList)view.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    default public void checkPermission(String formId, String opKey) {
        IFormView view = this.getView();
        if (view == null) {
            return;
        }
        this.checkPermission(formId, opKey, view.getFormShowParameter().getAppId());
    }

    default public void checkPermission(String formId, String opKey, String appId) {
        FormOperate formOperate = (FormOperate)FormMetadataCache.getFormOperation((String)formId, (String)opKey);
        if (formOperate == null) {
            return;
        }
        String permissionItemId = formOperate.getPermissionItemId();
        if (StringUtils.isEmpty((CharSequence)permissionItemId)) {
            return;
        }
        int hasPerm = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)"DIM_NULL", Collections.singletonList(0L), (String)appId, (String)formId, (String)permissionItemId);
        if (hasPerm == 0) {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)formId);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonMethod_0", (String)"sys-ricc-platform", (Object[])new Object[]{met.getDisplayName(), this.getPermissionItemName(permissionItemId)}));
        }
    }

    default public String getPermissionItemName(String permissionItemId) {
        DynamicObject item = BusinessDataServiceHelper.loadSingleFromCache((Object)permissionItemId, (String)"perm_permitem");
        return item != null ? item.getString("name") : null;
    }
}

