/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.EncryptUtils;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;
import kd.sys.ricc.business.training.CloudProdConfig;
import kd.sys.ricc.business.training.CloudReleaseConfig;
import kd.sys.ricc.business.training.CloudTestConfig;
import kd.sys.ricc.business.training.CloudTrainConfig;

public class TrainConfigUtils {
    private static final Log log = LogFactory.getLog(TrainConfigUtils.class);
    private static final String CONFIG_KEY = "TRAIN_CONFIG";
    private static final Long CONFIG_ID = 2149986466523230208L;

    public static DynamicObject getTrainConfig() {
        return QueryServiceHelper.queryOne((String)"ricc_trainconfig", (String)"id,secret, environmentid, envtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)CONFIG_ID)});
    }

    public static Boolean configExists() {
        return QueryServiceHelper.exists((String)"ricc_trainconfig", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)CONFIG_ID)});
    }

    public static Pair<String, String> getEnvConfig() {
        if (!TrainConfigUtils.configExists().booleanValue()) {
            return new Pair((Object)"", (Object)"");
        }
        DynamicObject trainConfig = TrainConfigUtils.getTrainConfig();
        String secret = trainConfig.getString("secret");
        String environmentId = trainConfig.getString("environmentid");
        return new Pair((Object)(StringUtils.isEmpty((String)secret) ? "" : TrainConfigUtils.getDecryptString(secret)), (Object)(StringUtils.isEmpty((String)environmentId) ? "" : TrainConfigUtils.getDecryptString(environmentId)));
    }

    public static String getEncryptString(String text) {
        return EncryptUtils.encrypt((String)CONFIG_KEY, (String)text);
    }

    public static String getDecryptString(String encryptText) {
        try {
            return EncryptUtils.decrypt((String)CONFIG_KEY, (String)encryptText);
        }
        catch (Exception ex) {
            log.error("TrainConfigUtils_decryptError", (Throwable)ex);
            return "";
        }
    }

    public static String getEnvType() {
        DynamicObject trainConfig = TrainConfigUtils.getTrainConfig();
        if (trainConfig == null) {
            return "";
        }
        return trainConfig.getString("envtype");
    }

    public static CloudTrainConfig getCloudConfig() {
        String envType = TrainConfigUtils.getEnvType();
        if ("test".equals(envType)) {
            return new CloudTestConfig();
        }
        if ("release".equals(envType)) {
            return new CloudReleaseConfig();
        }
        return new CloudProdConfig();
    }

    public static String getApiServiceHttp(String method) {
        CloudTrainConfig cloudConfig = TrainConfigUtils.getCloudConfig();
        return cloudConfig.getApiServiceHttp() + "/openapi/school" + method;
    }

    public static String getAppId() {
        CloudTrainConfig cloudConfig = TrainConfigUtils.getCloudConfig();
        return cloudConfig.getAppId();
    }

    public static String getAppSecret() {
        CloudTrainConfig cloudConfig = TrainConfigUtils.getCloudConfig();
        String appSecret = cloudConfig.getAppSecret();
        return EncryptUtils.decrypt((String)CONFIG_KEY, (String)appSecret);
    }
}

