/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.common.enums.CompareDataResultEnum;
import kd.sys.ricc.common.enums.CompareStatusEnum;
import kd.sys.ricc.common.enums.DataSelectWayEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.exception.RiccBizException;

public class DataCompareHelper {
    private static final Log logger = LogFactory.getLog(DataCompareHelper.class);
    private static final HashMap<String, Integer> PRIORITIES = new HashMap(16);

    private DataCompareHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static QFilter getEntryRowFilters(String entityNumber, String selectWay, String dataStore) {
        QFilter filter;
        if (DataSelectWayEnum.FILTER_SELECT_WAY.getVal().equals(selectWay)) {
            if (StringUtils.isEmpty((String)dataStore)) {
                filter = new QFilter("1", "is not null", (Object)-1);
            } else {
                CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)dataStore, CRCondition.class);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), crCondition.getFilterCondition());
                fb.buildFilter();
                filter = fb.getQFilter();
            }
        } else if (StringUtils.isEmpty((String)dataStore)) {
            filter = new QFilter("id", "in", (Object)new Object[0]);
        } else {
            List<Object> ids = DataCompareHelper.getManualSelectedPks(dataStore, entityNumber);
            filter = new QFilter("id", "in", ids);
        }
        return filter;
    }

    public static boolean existCompareTask(Object dataComparePlanId) {
        QFilter numberFilter = new QFilter("datacompareplan.id", "=", dataComparePlanId);
        DynamicObject[] rptDyo = BusinessDataServiceHelper.load((String)"ricc_datacompare_rpt", (String)"comparestatus", (QFilter[])numberFilter.toArray(), (String)"createtime desc", (int)1);
        if (rptDyo != null && rptDyo.length > 0) {
            String compareStatus = rptDyo[0].getString("comparestatus");
            return !compareStatus.equals(CompareStatusEnum.BEGINNING.getVal());
        }
        return true;
    }

    private static List<Object> getManualSelectedPks(String dataStore, String entityNumber) {
        if (StringUtils.isEmpty((String)dataStore)) {
            return new ArrayList<Object>();
        }
        JSONObject selectDatas = JSON.parseObject((String)dataStore);
        if (selectDatas.isEmpty()) {
            return new ArrayList<Object>();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ISimpleProperty idProperty = dataEntityType.getPrimaryKey();
        if (idProperty instanceof LongProp) {
            return selectDatas.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        if (idProperty instanceof VarcharProp) {
            return new ArrayList<Object>(selectDatas.keySet());
        }
        String msgTpl = ResManager.loadKDString((String)"\u914d\u7f6e\u9879%s\u7684\u4e3b\u952e\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u82cd\u7a79\u7684\u89c4\u8303\uff0c\u8bf7\u4fee\u6539\u4e3b\u952e\u7684\u6570\u636e\u7c7b\u578b\u4e3along\u6216\u8005varchar", (String)"DataCompareHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
        throw new RiccBizException(String.format(msgTpl, entityNumber));
    }

    public static Map<String, Object> getCompareRequiresPropMap(DataEntityPropertyCollection properties) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(4);
        for (IDataEntityProperty property : properties) {
            String numberProp;
            String propertyKey = property.getName();
            if (property instanceof FlexProp) {
                propertyMap.put(propertyKey, "");
                continue;
            }
            if (property instanceof DynamicLocaleProperty || property instanceof AttachmentProp) continue;
            if (property instanceof BasedataProp) {
                HashMap<String, String> baseDataMap = new HashMap<String, String>(4);
                numberProp = ((BasedataProp)property).getNumberProp();
                baseDataMap.put(numberProp, "");
                baseDataMap.put("name", "");
                baseDataMap.put("id", "");
                propertyMap.put(propertyKey, baseDataMap);
                continue;
            }
            if (property instanceof MulBasedataProp) {
                HashMap<String, String> mulBaseDataMap = new HashMap<String, String>(4);
                numberProp = ((MulBasedataProp)property).getNumberProp();
                mulBaseDataMap.put(numberProp, "");
                mulBaseDataMap.put("name", "");
                propertyMap.put(propertyKey, mulBaseDataMap);
                continue;
            }
            if (property instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
                Map<String, Object> entryMap = DataCompareHelper.getCompareRequiresPropMap(entryProperties);
                propertyMap.put(propertyKey, entryMap);
                continue;
            }
            propertyMap.put(propertyKey, "");
        }
        return propertyMap;
    }

    public static Map<String, Object> generalCompareDataImpl(Map<String, Object> params) {
        boolean checkParam;
        String entityNumber = (String)params.get("entityNumber");
        String keyFields = (String)params.get("keyFields");
        List sourceDataList = (List)params.get("sourceData");
        List tarDataList = (List)params.get("tarData");
        Map ignoreInfoMap = (Map)params.get("isIgnore");
        boolean bl = checkParam = StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)keyFields) || sourceDataList == null || sourceDataList.isEmpty() || tarDataList == null || ignoreInfoMap == null;
        if (checkParam) {
            return CommonUtil.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u5bf9\u6bd4\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataCompareHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        Set<String> keyFieldsSet = Arrays.stream(keyFields.trim().replaceFirst(",", "").split(",")).collect(Collectors.toSet());
        Map<String, List<Map<String, Object>>> currentCompareDataMap = DataCompareHelper.getKeyFieldsValueToMap(sourceDataList, keyFieldsSet, entityNumber);
        Map<String, List<Map<String, Object>>> tarCompareDataMap = DataCompareHelper.getKeyFieldsValueToMap(tarDataList, keyFieldsSet, entityNumber);
        return DataCompareHelper.executeCompare(currentCompareDataMap, entityNumber, tarCompareDataMap, ignoreInfoMap);
    }

    private static Map<String, List<Map<String, Object>>> getKeyFieldsValueToMap(List<Map<String, Object>> compareData, Set<String> keyFieldsSet, String entityNumber) {
        HashMap<String, List<Map<String, Object>>> fieldKeyValueMap = new HashMap<String, List<Map<String, Object>>>(4);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (Map<String, Object> compareDataObject : compareData) {
            StringBuilder tarKey = new StringBuilder();
            for (String key : keyFieldsSet) {
                IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)key);
                if (property instanceof BasedataProp) {
                    tarKey.append(compareDataObject.get(key + "_id")).append("$$$");
                    continue;
                }
                tarKey.append(compareDataObject.get(key)).append("$$$");
            }
            tarKey.delete(tarKey.length() - 3, tarKey.length());
            List dyoList = (List)fieldKeyValueMap.get(tarKey.toString());
            if (dyoList != null) {
                dyoList.add(compareDataObject);
                continue;
            }
            ArrayList<Map<String, Object>> compareDataList = new ArrayList<Map<String, Object>>(2);
            compareDataList.add(compareDataObject);
            fieldKeyValueMap.put(tarKey.toString(), compareDataList);
        }
        return fieldKeyValueMap;
    }

    private static Map<String, Object> executeCompare(Map<String, List<Map<String, Object>>> curDataMap, String entityNumber, Map<String, List<Map<String, Object>>> tarDataMap, Map<String, Boolean> ignoreInfoMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("success", true);
        ArrayList<HashMap<String, Object>> dataComPareRowResultList = new ArrayList<HashMap<String, Object>>(curDataMap.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        HashSet<String> bdProps = new HashSet<String>(4);
        DataCompareHelper.getBaseDataPropName(bdProps, entityType.getProperties());
        HashMap<String, String> keyFieldsMap = DataCompareHelper.getIdKeyMapping(entityType);
        for (Map.Entry<String, List<Map<String, Object>>> oneKeyDataEntry : curDataMap.entrySet()) {
            String keyString = oneKeyDataEntry.getKey();
            List<Map<String, Object>> curDataList = oneKeyDataEntry.getValue();
            List<Map<String, Object>> tarDataList = tarDataMap.get(keyString);
            for (Map<String, Object> oneCurData : curDataList) {
                HashMap<String, Object> dataComPareRowResult = new HashMap<String, Object>(2);
                Object oneCurDataId = oneCurData.get(keyFieldsMap.get("id"));
                String oneCurDataNumber = (String)oneCurData.get(keyFieldsMap.get("number"));
                String oneCurDataName = DataCompareHelper.getDataName(entityType, keyFieldsMap, oneCurData, oneCurDataNumber);
                dataComPareRowResult.put("curDataMap", DataCompareHelper.getResultRowIdMapping(oneCurDataId, oneCurDataNumber, oneCurDataName));
                if (tarDataList == null || tarDataList.isEmpty()) {
                    dataComPareRowResult.put("compareResult", CompareDataResultEnum.DIFFERENCE.getVal());
                    dataComPareRowResult.put("diffExplain", ResManager.loadKDString((String)"\u6839\u636e\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u7684\u6570\u636e\uff0c\u5728\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u51c6\u786e\u6027\uff0c\u6216\u5230\u76ee\u6807\u73af\u5883\u67e5\u770b\u5177\u4f53\u60c5\u51b5\u3002", (String)"DataCompareHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                } else if (tarDataList.size() > 1) {
                    dataComPareRowResult.put("compareResult", CompareDataResultEnum.DIFFERENCE.getVal());
                    dataComPareRowResult.put("diffExplain", ResManager.loadKDString((String)"\u6839\u636e\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u7684\u6570\u636e\uff0c\u5728\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u552f\u4e00\u6027\uff0c\u6216\u5230\u76ee\u6807\u73af\u5883\u67e5\u770b\u5177\u4f53\u6570\u636e\u60c5\u51b5\u3002", (String)"DataCompareHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                } else {
                    Map<String, Object> oneTarData = tarDataList.get(0);
                    Object tarDataId = oneTarData.get(keyFieldsMap.get("id"));
                    String tarDataNumber = (String)oneTarData.getOrDefault(keyFieldsMap.get("number"), "");
                    String tarDataName = DataCompareHelper.getDataName(entityType, keyFieldsMap, oneTarData, tarDataNumber);
                    dataComPareRowResult.put("tarDataMap", DataCompareHelper.getResultRowIdMapping(tarDataId, tarDataNumber, tarDataName));
                    ArrayList<Map<String, Object>> dataDetailList = new ArrayList<Map<String, Object>>(10);
                    DataCompareHelper.mapValCompare("", "", (IDataEntityType)entityType, oneCurData, oneTarData, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
                    dataComPareRowResult.put("dataDetailList", dataDetailList);
                }
                dataComPareRowResultList.add(dataComPareRowResult);
            }
        }
        result.put("dataComPareResult", dataComPareRowResultList);
        return result;
    }

    private static void getBaseDataPropName(Set<String> bdProps, DataEntityPropertyCollection properties) {
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof BasedataProp) {
                bdProps.add(((BasedataProp)prop).getBaseEntityId());
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
            DataCompareHelper.getBaseDataPropName(bdProps, entryProperties);
        }
    }

    public static HashMap<String, String> getIdKeyMapping(MainEntityType entityType) {
        String id = entityType.getPrimaryKey().getName();
        String number = null;
        String name = null;
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)entityType;
            number = basedataEntityType.getNumberProperty();
            name = basedataEntityType.getNameProperty();
        } else if (entityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)entityType;
            name = number = billEntityType.getBillNo();
        }
        HashMap<String, String> keyFieldsMap = new HashMap<String, String>(4);
        keyFieldsMap.put("id", id);
        keyFieldsMap.put("number", number);
        keyFieldsMap.put("name", name);
        return keyFieldsMap;
    }

    private static String getDataName(MainEntityType entityType, HashMap<String, String> keyFieldsMap, Map<String, Object> oneCurData, String oneCurDataNumber) {
        String oneCurDataName = "";
        if (entityType instanceof BasedataEntityType) {
            Object nameMap = oneCurData.get(keyFieldsMap.get("name"));
            if (nameMap instanceof Map) {
                Object name = ((Map)nameMap).get("zh_CN");
                oneCurDataName = name == null ? " " : name.toString();
            }
        } else {
            oneCurDataName = oneCurDataNumber;
        }
        return oneCurDataName;
    }

    private static Map<String, Object> getResultRowIdMapping(Object id, String number, String name) {
        HashMap<String, Object> idMapping = new HashMap<String, Object>(2);
        idMapping.put("id", id);
        idMapping.put("number", number);
        idMapping.put("name", name);
        return idMapping;
    }

    private static void mapValCompare(String preEntityName, String preEntityKey, IDataEntityType entityType, Map<String, Object> currentCompareMap, Map<String, Object> tarCompareMap, Map<String, Boolean> ignoreInfoMap, Set<String> bdProps, Map<String, Object> dataComPareRowResult, List<Map<String, Object>> dataDetailList, DataEntityPropertyCollection properties) {
        String[] fields;
        for (String fieldKey : fields = DataCompareHelper.collectKeys(currentCompareMap, tarCompareMap)) {
            Object curFieldVal = currentCompareMap.get(fieldKey);
            Object tarFieldVal = tarCompareMap.get(fieldKey);
            String curEntityName = DataCompareHelper.getEntityDisplayName(entityType, fieldKey);
            String curEntityKey = fieldKey;
            if (!StringUtils.isEmpty((String)preEntityName)) {
                curEntityName = preEntityName + "." + curEntityName;
                curEntityKey = preEntityKey + "." + curEntityKey;
            }
            DataCompareHelper.fieldCompare(curEntityName, curEntityKey, fieldKey, entityType, curFieldVal, tarFieldVal, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
        }
    }

    private static String[] collectKeys(Map<String, Object> currentCompareMap, Map<String, Object> tarCompareMap) {
        HashSet<String> keys = new HashSet<String>(currentCompareMap.keySet());
        keys.addAll(tarCompareMap.keySet());
        return (String[])keys.stream().filter(key -> !key.startsWith("$")).filter(key -> {
            boolean endsWithId = key.endsWith("_id");
            return !endsWithId;
        }).distinct().sorted(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int p1 = this.getPriorities(s1);
                int p2 = this.getPriorities(s2);
                return Integer.compare(p1, p2);
            }

            private int getPriorities(String s1) {
                Integer p1 = (Integer)PRIORITIES.get(s1);
                return p1 == null ? PRIORITIES.size() : p1.intValue();
            }
        }).toArray(String[]::new);
    }

    private static String getEntityDisplayName(IDataEntityType entity, String key) {
        String s;
        if (entity == null) {
            return key;
        }
        IDataEntityProperty property = (IDataEntityProperty)entity.getProperties().get((Object)key);
        if (property == null) {
            return key;
        }
        LocaleString displayName = property.getDisplayName();
        if (displayName == null && key.endsWith("_id")) {
            property = (IDataEntityProperty)entity.getProperties().get((Object)key.substring(0, key.lastIndexOf("_id")));
            if (property == null) {
                return key;
            }
            displayName = new LocaleString(property.getDisplayName() + "_id");
        }
        if ((s = D.s((Object)displayName)) != null) {
            return s;
        }
        return key;
    }

    private static void fieldCompare(String curEntityName, String curEntityKey, String fieldKey, IDataEntityType entityType, Object curFieldVal, Object tarFieldVal, Map<String, Boolean> ignoreInfoMap, Set<String> bdProps, Map<String, Object> dataComPareRowResult, List<Map<String, Object>> dataDetailList, DataEntityPropertyCollection properties) {
        boolean isIgnore = DataCompareHelper.compareStrategy(curEntityKey, entityType, fieldKey, ignoreInfoMap, bdProps, properties);
        if (StringUtils.isBlank((Object)curFieldVal)) {
            DataCompareHelper.handleCurrentIsNull(curEntityName, curEntityKey, fieldKey, tarFieldVal, isIgnore, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
        } else if (StringUtils.isBlank((Object)tarFieldVal)) {
            DataCompareHelper.handleTargetIsNull(curEntityName, curEntityKey, fieldKey, curFieldVal, isIgnore, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
        } else if (curFieldVal instanceof Map && tarFieldVal instanceof Map) {
            DataCompareHelper.mapValCompare(curEntityName, curEntityKey, DataCompareHelper.getSubEntityType(properties, fieldKey), (Map)curFieldVal, (Map)tarFieldVal, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
        } else if (curFieldVal instanceof List && tarFieldVal instanceof List) {
            DataCompareHelper.handleEntryEntity(curEntityName, curEntityKey, DataCompareHelper.getSubEntityType(properties, fieldKey), (List)curFieldVal, (List)tarFieldVal, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList);
        } else {
            String result;
            boolean ignore;
            boolean isEquals;
            if (curFieldVal instanceof Date) {
                curFieldVal = JSON.toJSONStringWithDateFormat((Object)curFieldVal, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[0]).replace("\"", "");
                isEquals = curFieldVal.equals(tarFieldVal.toString());
            } else if (curFieldVal instanceof BigDecimal || curFieldVal instanceof Long) {
                isEquals = StringUtils.equals((String)curFieldVal.toString(), (String)tarFieldVal.toString());
            } else {
                DataEntityPropertyCollection subProperty;
                IDataEntityProperty property;
                isEquals = curFieldVal.toString().equals(tarFieldVal.toString());
                if (entityType != null && (property = (IDataEntityProperty)(subProperty = entityType.getProperties()).get((Object)fieldKey)) instanceof MulComboProp) {
                    isEquals = Arrays.stream(curFieldVal.toString().split(",")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toSet()).equals(Arrays.stream(tarFieldVal.toString().split(",")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toSet()));
                }
            }
            String compareResult = CompareDataResultEnum.valueOf((boolean)isEquals).getVal();
            if (isIgnore) {
                compareResult = CompareDataResultEnum.IGNORE.getVal();
            }
            boolean bl = ignore = StringUtils.equals((String)(result = (String)dataComPareRowResult.getOrDefault("compareResult", CompareDataResultEnum.NO_DIFFERENCE.getVal())), (String)CompareDataResultEnum.IGNORE.getVal()) && StringUtils.equals((String)compareResult, (String)CompareDataResultEnum.DIFFERENCE.getVal());
            if (StringUtils.equals((String)result, (String)CompareDataResultEnum.NO_DIFFERENCE.getVal()) || ignore) {
                dataComPareRowResult.put("compareResult", compareResult);
            }
            dataDetailList.add(DataCompareHelper.getDataDetailMap(curEntityName, curEntityKey, curFieldVal, tarFieldVal, compareResult));
        }
    }

    private static void handleCurrentIsNull(String fieldDisplayName, String fieldDisplayKey, String fieldKey, Object tarFieldVal, boolean isIgnore, Map<String, Boolean> ignoreInfoMap, Set<String> bdProps, Map<String, Object> dataComPareRowResult, List<Map<String, Object>> dataDetailList, DataEntityPropertyCollection properties) {
        if (StringUtils.isBlank((Object)tarFieldVal)) {
            dataComPareRowResult.computeIfAbsent("compareResult", k -> CompareDataResultEnum.NO_DIFFERENCE.getVal());
        } else if (tarFieldVal instanceof Map) {
            DataCompareHelper.mapValCompare(fieldDisplayName, fieldDisplayKey, DataCompareHelper.getSubEntityType(properties, fieldKey), Collections.emptyMap(), (Map)tarFieldVal, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
        } else if (tarFieldVal instanceof List) {
            DataCompareHelper.handleEntryEntity(fieldDisplayName, fieldDisplayKey, DataCompareHelper.getSubEntityType(properties, fieldKey), Collections.emptyList(), (List)tarFieldVal, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList);
        } else {
            boolean ignore;
            String compareResult = isIgnore ? CompareDataResultEnum.IGNORE.getVal() : CompareDataResultEnum.DIFFERENCE.getVal();
            String result = (String)dataComPareRowResult.getOrDefault("compareResult", CompareDataResultEnum.NO_DIFFERENCE.getVal());
            boolean bl = ignore = StringUtils.equals((String)result, (String)CompareDataResultEnum.IGNORE.getVal()) && StringUtils.equals((String)compareResult, (String)CompareDataResultEnum.DIFFERENCE.getVal());
            if (StringUtils.equals((String)result, (String)CompareDataResultEnum.NO_DIFFERENCE.getVal()) || ignore) {
                dataComPareRowResult.put("compareResult", compareResult);
            }
            dataDetailList.add(DataCompareHelper.getDataDetailMap(fieldDisplayName, fieldDisplayKey, "", tarFieldVal.toString(), compareResult));
        }
    }

    private static Map<String, Object> getDataDetailMap(String fieldName, String fieldKey, Object curValue, Object tarValue, String diffType) {
        HashMap<String, Object> dataDetailMap = new HashMap<String, Object>(8);
        dataDetailMap.put("fieldName", fieldName);
        dataDetailMap.put("fieldKey", fieldKey);
        dataDetailMap.put("curValue", curValue);
        dataDetailMap.put("tarValue", tarValue);
        dataDetailMap.put("diffType", diffType);
        return dataDetailMap;
    }

    private static void handleTargetIsNull(String curEntityName, String curEntityKey, String fieldKey, Object curFieldVal, boolean isIgnore, Map<String, Boolean> ignoreInfoMap, Set<String> bdProps, Map<String, Object> dataComPareRowResult, List<Map<String, Object>> dataDetailList, DataEntityPropertyCollection properties) {
        HashMap<String, Object> currentFieldMap = new HashMap<String, Object>(4);
        if (curFieldVal instanceof Map) {
            DataCompareHelper.mapValCompare(curEntityName, curEntityKey, DataCompareHelper.getSubEntityType(properties, curEntityKey), currentFieldMap, Collections.emptyMap(), ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, properties);
        } else if (curFieldVal instanceof List) {
            DataCompareHelper.handleEntryEntity(curEntityName, curEntityKey, DataCompareHelper.getSubEntityType(properties, curEntityKey), (List)curFieldVal, Collections.emptyList(), ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList);
        } else {
            boolean ignore;
            String compareResult = isIgnore ? CompareDataResultEnum.IGNORE.getVal() : CompareDataResultEnum.DIFFERENCE.getVal();
            String result = (String)dataComPareRowResult.getOrDefault("compareResult", CompareDataResultEnum.NO_DIFFERENCE.getVal());
            boolean bl = ignore = StringUtils.equals((String)result, (String)CompareDataResultEnum.IGNORE.getVal()) && StringUtils.equals((String)compareResult, (String)CompareDataResultEnum.DIFFERENCE.getVal());
            if (StringUtils.equals((String)result, (String)CompareDataResultEnum.NO_DIFFERENCE.getVal()) || ignore) {
                dataComPareRowResult.put("compareResult", compareResult);
            }
            dataDetailList.add(DataCompareHelper.getDataDetailMap(curEntityName, curEntityKey, curFieldVal.toString(), "", compareResult));
        }
    }

    private static void handleEntryEntity(String curEntityName, String curEntityKey, IDataEntityType entityType, List<Map<String, Object>> current, List<Map<String, Object>> target, Map<String, Boolean> ignoreInfoMap, Set<String> bdProps, Map<String, Object> dataComPareRowResult, List<Map<String, Object>> dataDetailList) {
        int srcSize = current.size();
        int targetSize = target.size();
        int index = 0;
        int maxSize = Math.max(srcSize, targetSize);
        if (srcSize > targetSize) {
            for (Map<String, Object> targetMap : target) {
                Map<String, Object> srcMap = current.get(++index - 1);
                DataCompareHelper.mapValCompare(DataCompareHelper.generatePrefix(curEntityName, index), curEntityKey, entityType, srcMap, targetMap, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, entityType.getProperties());
            }
            for (int i = index; i < maxSize; ++i) {
                DataCompareHelper.mapValCompare(DataCompareHelper.generatePrefix(curEntityName, ++index), curEntityKey, entityType, current.get(index - 1), Collections.emptyMap(), ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, entityType.getProperties());
            }
        } else {
            for (Map<String, Object> srcMap : current) {
                Map<String, Object> targetMap = target.get(++index - 1);
                DataCompareHelper.mapValCompare(DataCompareHelper.generatePrefix(curEntityName, index), curEntityKey, entityType, srcMap, targetMap, ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, entityType.getProperties());
            }
            for (int i = index; i < maxSize; ++i) {
                DataCompareHelper.mapValCompare(DataCompareHelper.generatePrefix(curEntityName, ++index), curEntityKey, entityType, Collections.emptyMap(), target.get(index - 1), ignoreInfoMap, bdProps, dataComPareRowResult, dataDetailList, entityType.getProperties());
            }
        }
    }

    private static String generatePrefix(String curEntityName, int index) {
        StringBuilder s = new StringBuilder();
        if (curEntityName.length() == 0) {
            s.append('[').append(index).append(']');
        } else {
            s.append(curEntityName, 0, curEntityName.length());
            s.append('[').append(index).append(']');
        }
        return s.toString();
    }

    private static boolean compareStrategy(String curEntityKey, IDataEntityType entityType, String fieldKey, Map<String, Boolean> ignoreInfoMap, Set<String> bdProps, DataEntityPropertyCollection properties) {
        boolean isBaseDataProp;
        boolean isIgnore;
        if (Boolean.TRUE.equals(ignoreInfoMap.get("isIgnoreCreateInfo"))) {
            boolean isModifierOrCreator = DataCompareHelper.isModifierOrCreator(curEntityKey, properties);
            if (isModifierOrCreator) {
                return true;
            }
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldKey);
            if (property instanceof ModifyDateProp || property instanceof CreateDateProp) {
                return true;
            }
        }
        if (Boolean.TRUE.equals(ignoreInfoMap.get("isIgnoreMultilingual")) && curEntityKey.contains(".")) {
            boolean bl = isIgnore = Arrays.toString(Lang.values()).replace("zh_CN", "").contains(fieldKey) && !StringUtils.equals((String)fieldKey, (String)"id");
            if (isIgnore) {
                return true;
            }
        }
        boolean bl = isBaseDataProp = entityType != null && bdProps.contains(entityType.getName()) && !StringUtils.equals((String)"id", (String)curEntityKey);
        if (isBaseDataProp) {
            if (Boolean.TRUE.equals(ignoreInfoMap.get("isIgnoreBdId"))) {
                return StringUtils.equals((String)fieldKey, (String)"id");
            }
        } else if (Boolean.TRUE.equals(ignoreInfoMap.get("isIgnoreKey"))) {
            isIgnore = StringUtils.equals((String)fieldKey, (String)"id") || StringUtils.equals((String)fieldKey, (String)"masterid") || curEntityKey.endsWith(".id");
            return isIgnore;
        }
        return false;
    }

    private static boolean isModifierOrCreator(String curEntityKey, DataEntityPropertyCollection properties) {
        if (curEntityKey.contains(".") && !curEntityKey.endsWith(".name")) {
            String[] entityKeys;
            for (String entityKey : entityKeys = curEntityKey.split("\\.")) {
                IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)entityKey);
                if (!(prop instanceof ModifierProp) && !(prop instanceof CreaterProp)) continue;
                return true;
            }
        }
        return false;
    }

    private static IDataEntityType getSubEntityType(DataEntityPropertyCollection properties, String fieldKey) {
        if (properties == null) {
            return null;
        }
        Object property = properties.get((Object)fieldKey);
        if (property == null) {
            return null;
        }
        if (property instanceof BasedataProp) {
            String entityId = ((BasedataProp)property).getBaseEntityId();
            return EntityMetadataCache.getDataEntityType((String)entityId);
        }
        if (property instanceof EntryProp) {
            return ((EntryProp)property).getItemType();
        }
        if (property instanceof MulBasedataProp) {
            return EntityMetadataCache.getDataEntityType((String)((MulBasedataProp)property).getBaseEntityId());
        }
        return null;
    }

    static {
        PRIORITIES.put("id", 0);
        PRIORITIES.put("entryid", PRIORITIES.size());
        PRIORITIES.put("detailid", PRIORITIES.size());
        PRIORITIES.put("number", PRIORITIES.size());
        PRIORITIES.put("name", PRIORITIES.size());
        PRIORITIES.put("title", PRIORITIES.size());
        PRIORITIES.put("full_name", PRIORITIES.size());
        PRIORITIES.put("type", PRIORITIES.size());
        PRIORITIES.put("version", PRIORITIES.size());
        PRIORITIES.put("modifytime", PRIORITIES.size());
        PRIORITIES.put("entryentity", PRIORITIES.size());
        PRIORITIES.put("coordinate", 2147483547);
    }
}

