/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bdcenter.item;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;
import kd.sys.ricc.formplugin.AbstractRiccTreeListPlugin;

public class BdCenterListPlugin
extends AbstractRiccTreeListPlugin {
    private static final Log log = LogFactory.getLog(BdCenterListPlugin.class);
    private static final String VIEW = "view";
    private static final String ISMIGRATION = "ismigration";
    private static final String PAGEENTERPARAM = "pageenterparam";
    private static final String DATAMIGRATION = "datamigration";
    private static final String ORDERFIELD = "orderfield";
    private static final String ISPRESET = "ispreset";
    private static final String FULLNAME = "fullname";
    private static final String PARENT = "parent";

    public void initialize() {
        ITreeModel treeModel = this.getTreeModel();
        if (treeModel instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            Map queryParas = treeListModel.getQueryParas();
            queryParas.put("order", "orderfield asc");
            treeListModel.setQueryParas(queryParas);
        }
        boolean iscConfigOk = SysParaUtil.isIscConfigOk();
        this.getView().setEnable(Boolean.valueOf(iscConfigOk), new String[]{"isc_sync"});
        if (iscConfigOk) {
            FormViewUtil.cleanButtonTips((String)"isc_sync", (IFormView)this.getView());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getPageCache().get("hasShowUpgradeMsg") == null) {
            String tip = "\u4e3a\u4fbf\u4e8e\u7528\u6237\u64cd\u4f5c\uff0c\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u548c\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u5c06\u8fdb\u884c\u5408\u5e76\uff0c\u5c06\u4e8e\u540e\u7eed\u7248\u672c\u5b8c\u5168\u9690\u85cf\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u3002\u9884\u7f6e\u57fa\u7840\u6570\u636e\u9879\u5df2\u5168\u90e8\u8fc1\u79fb\u5230\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\uff0c\u8bf7\u60a8\u53c2\u8003\u793e\u533a\u6587\u7ae0\uff08https://vip.kingdee.com/link/s/llW70\uff09\u8fdb\u884c\u624b\u5de5\u65b0\u589e\u57fa\u7840\u6570\u636e\u9879\u7684\u8fc1\u79fb";
            this.getView().showErrorNotification(ResManager.loadKDString((String)tip, (String)"BdCenterListPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]));
            this.getPageCache().put("hasShowUpgradeMsg", "0");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        filters.add(new QFilter("group.enable", "=", (Object)"1"));
        e.setOrderBy("orderfield asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        int size = selectedRows.size();
        if (StringUtils.equals((String)"isc_sync", (String)opKey)) {
            if (size > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BdCenterListPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            if (!this.isHasPermission(primaryKeyValue)) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u3010%s\u3011\u7684\u67e5\u770b\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u96c6\u6210\u540c\u6b65\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u540e\u64cd\u4f5c\u3002", (String)"BdCenterListPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), selectedRow.getName()));
                args.setCancel(true);
            }
        } else if (VIEW.equals(opKey)) {
            if (size > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BdCenterListPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)DATAMIGRATION, (String)opKey)) {
            this.baseDataMigration(args, selectedRows);
        }
    }

    private void baseDataMigration(BeforeDoOperationEventArgs e, ListSelectedRowCollection selectedRows) {
        MainEntityType baseDataEntityType;
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        DynamicObject[] baseDataItems = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)(baseDataEntityType = EntityMetadataCache.getDataEntityType((String)"ricc_basedata_item")));
        if (this.beforeMigrationCheck(e, baseDataItems)) {
            HashMap<String, Object> migrationResult = this.migration(baseDataItems);
            this.afterMigration(baseDataItems, migrationResult);
        }
    }

    private boolean beforeMigrationCheck(BeforeDoOperationEventArgs e, DynamicObject[] baseDataItems) {
        StringBuilder presettingStr = new StringBuilder();
        StringBuilder migratedStr = new StringBuilder();
        for (int i = 0; i < baseDataItems.length; ++i) {
            DynamicObject baseData = baseDataItems[i];
            boolean isPreset = baseData.getBoolean(ISPRESET);
            if (isPreset) {
                presettingStr.append(baseData.get("name")).append('\uff0c');
                continue;
            }
            boolean isMigration = baseData.getBoolean(ISMIGRATION);
            if (!isMigration) continue;
            migratedStr.append(baseData.get("name")).append('\uff0c');
        }
        if (presettingStr.length() > 0) {
            presettingStr.deleteCharAt(presettingStr.lastIndexOf("\uff0c"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u8fc1\u79fb", (String)"BdCenterListPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), presettingStr));
            e.setCancel(true);
            return false;
        }
        if (migratedStr.length() > 0) {
            migratedStr.deleteCharAt(migratedStr.lastIndexOf("\uff0c"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u9879\u3010%s\u3011\u5df2\u5347\u7ea7\u8fc1\u79fb\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5347\u7ea7\u8fc1\u79fb\u6570\u636e", (String)"BdCenterListPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]), migratedStr));
            return false;
        }
        return true;
    }

    private HashMap<String, Object> migration(DynamicObject[] baseDataItems) {
        HashMap<String, DynamicObject> allConfigTreeMap = this.getAllConfigTreeMap();
        HashMap<String, DynamicObject> allBaseDataTreeMap = this.getAllBaseDataTreeMap();
        HashMap<String, Object> migrationResult = new HashMap<String, Object>(3);
        ArrayList<DynamicObject> newConfigItemList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newConfigItemsTreeList = new ArrayList<DynamicObject>(10);
        LinkedHashSet<String> baseTreeSet = new LinkedHashSet<String>();
        ArrayList<Object> formMetasNumber = new ArrayList<Object>(10);
        for (DynamicObject baseDataItem : baseDataItems) {
            DynamicObject dataGroup = (DynamicObject)baseDataItem.get("group");
            String fullName = dataGroup.getLocaleString(FULLNAME).getLocaleValue();
            String[] longNameArr = fullName.split("\\.");
            StringBuilder treeName = new StringBuilder();
            for (int i = 0; i < longNameArr.length; ++i) {
                String tree = longNameArr[i];
                if (i != 0) {
                    treeName.append('.');
                }
                treeName.append(tree);
                baseTreeSet.add(treeName.toString());
            }
            DynamicObject page = (DynamicObject)baseDataItem.get("page");
            formMetasNumber.add(page.get("number"));
        }
        HashMap<Object, DynamicObject> baseDataFormMetaMap = this.getBaseDataFormMetaMap(formMetasNumber);
        for (String name : baseTreeSet) {
            if (allConfigTreeMap.containsKey(name)) continue;
            DynamicObject configTree = this.baseDataTreeConvertConfigTree(allBaseDataTreeMap.get(name), allConfigTreeMap);
            newConfigItemsTreeList.add(configTree);
            allConfigTreeMap.put(configTree.getLocaleString(FULLNAME).getLocaleValue(), configTree);
        }
        HashMap<Object, Object> itemGroupMappingMap = this.getItemGroupMappingMap();
        HashMap<Object, String> newConfigItemIdMap = new HashMap<Object, String>(16);
        for (DynamicObject baseDataItem : baseDataItems) {
            DynamicObject[] configItem = this.baseDataConvertConfigItem(itemGroupMappingMap, baseDataItem, allConfigTreeMap, newConfigItemList, baseDataFormMetaMap);
            newConfigItemList.add((DynamicObject)configItem);
            newConfigItemIdMap.put(configItem.getPkValue(), configItem.getString("number"));
            baseDataItem.set(ISMIGRATION, (Object)1);
        }
        StringBuilder errorMessage = new StringBuilder();
        QFilter qFilter = new QFilter("id", "in", newConfigItemIdMap.keySet());
        DynamicObject[] itemIds = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"id", (QFilter[])qFilter.toArray());
        if (itemIds.length > 0) {
            StringBuilder number = new StringBuilder();
            for (DynamicObject id : itemIds) {
                number.append((String)newConfigItemIdMap.get(id.getPkValue())).append(',');
            }
            number.deleteCharAt(number.lastIndexOf(","));
            String msg = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u6570\u636e\u9879\u5728\u914d\u7f6e\u4e2d\u5fc3\u5df2\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u5220\u9664\u5df2\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"BdCenterListPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
            errorMessage.append(String.format(msg, number));
        }
        if (errorMessage.length() == 0) {
            try (TXHandle h1 = TX.required();){
                try {
                    OperationResult saveTreeResult = SaveServiceHelper.saveOperate((String)"ricc_configtree", (DynamicObject[])newConfigItemsTreeList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    OperationResult saveItemResult = SaveServiceHelper.saveOperate((String)"ricc_configitems", (DynamicObject[])newConfigItemList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    SaveServiceHelper.save((DynamicObject[])baseDataItems);
                    if (!saveTreeResult.isSuccess() || !saveItemResult.isSuccess()) {
                        if (!saveTreeResult.isSuccess()) {
                            saveTreeResult.getAllErrorOrValidateInfo().forEach(l -> errorMessage.append(l.getMessage()));
                        } else {
                            saveItemResult.getAllErrorOrValidateInfo().forEach(l -> errorMessage.append(l.getMessage()));
                        }
                        throw new RiccBizException(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u5347\u7ea7\u4fdd\u5b58\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BdCenterListPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    errorMessage.append(CommonUtil.getExceptionDetailInfo((Throwable)e));
                    h1.markRollback();
                }
            }
        }
        migrationResult.put("errorMessage", errorMessage.toString());
        migrationResult.put("newconfigitem", newConfigItemList);
        return migrationResult;
    }

    private HashMap<String, DynamicObject> getAllConfigTreeMap() {
        HashMap<String, DynamicObject> configTreeMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection allConfigItemTree = QueryServiceHelper.query((String)"ricc_configtree", (String)"id,number,name,longnumber,fullname,orderfield", null);
        for (DynamicObject itemTree : allConfigItemTree) {
            configTreeMap.put((String)itemTree.get(FULLNAME), itemTree);
        }
        return configTreeMap;
    }

    private HashMap<Object, DynamicObject> getBaseDataFormMetaMap(List<Object> formMetaNumbers) {
        HashMap<Object, DynamicObject> formMetasMap = new HashMap<Object, DynamicObject>(16);
        DynamicObjectCollection formMetas = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,name,modeltype,bizappid,basedatafield.id,basedatafield.number,basedatafield.name", (QFilter[])new QFilter("number", "in", formMetaNumbers).toArray());
        for (DynamicObject formMeta : formMetas) {
            formMetasMap.put(formMeta.get("number"), formMeta);
        }
        return formMetasMap;
    }

    private HashMap<String, DynamicObject> getAllBaseDataTreeMap() {
        DynamicObject[] allBaseItemTree;
        HashMap<String, DynamicObject> baseDataTree = new HashMap<String, DynamicObject>(16);
        for (DynamicObject itemTree : allBaseItemTree = BusinessDataServiceHelper.load((String)"ricc_basedata_tree", (String)"id,status,level,isleaf,enable,number,name,longnumber,fullname,orderfield,parent,ispreset", null)) {
            baseDataTree.put(itemTree.getLocaleString(FULLNAME).getLocaleValue(), itemTree);
        }
        return baseDataTree;
    }

    private DynamicObject baseDataTreeConvertConfigTree(DynamicObject baseDataTree, HashMap<String, DynamicObject> allConfigTreeMap) {
        DynamicObject parent = (DynamicObject)baseDataTree.get(PARENT);
        DynamicObject configTree = BusinessDataServiceHelper.newDynamicObject((String)"ricc_configtree");
        configTree.set("number", baseDataTree.get("number"));
        configTree.set("name", baseDataTree.get("name"));
        configTree.set("status", baseDataTree.get("status"));
        configTree.set("creator_id", (Object)UserServiceHelper.getCurrentUserId());
        configTree.set("modifier_id", (Object)UserServiceHelper.getCurrentUserId());
        configTree.set("enable", baseDataTree.get("enable"));
        configTree.set("level", baseDataTree.get("level"));
        configTree.set(FULLNAME, baseDataTree.get(FULLNAME));
        configTree.set("isleaf", baseDataTree.get("isleaf"));
        if (parent == null) {
            configTree.set("parent_id", (Object)0);
            configTree.set(ORDERFIELD, (Object)this.getTreeOrder(null, baseDataTree.getLocaleString(FULLNAME).getLocaleValue(), allConfigTreeMap));
            configTree.set("longnumber", baseDataTree.get("longnumber"));
        } else {
            DynamicObject configParent = allConfigTreeMap.get(parent.getLocaleString(FULLNAME).getLocaleValue());
            configTree.set("parent_id", configParent.get("id"));
            configTree.set(ORDERFIELD, (Object)this.getTreeOrder(configParent, baseDataTree.getLocaleString(FULLNAME).getLocaleValue(), allConfigTreeMap));
            configTree.set("longnumber", (Object)(configParent.get("longnumber") + "." + baseDataTree.get("number")));
        }
        configTree.set(ISPRESET, baseDataTree.get(ISPRESET));
        configTree.set("id", baseDataTree.get("id"));
        return configTree;
    }

    private String getTreeOrder(DynamicObject configParent, String groupFullName, Map<String, DynamicObject> allConfigTreeMap) {
        String order;
        if (configParent == null) {
            List cloudList = allConfigTreeMap.keySet().stream().filter(l -> l.split("\\.").length == 1).collect(Collectors.toList());
            order = String.valueOf(cloudList.size() + 1);
        } else {
            String parentOrder = configParent.getString(ORDERFIELD);
            int newNum = 1;
            String parentFullName = configParent.getString(FULLNAME);
            List containGroupFullNameList = allConfigTreeMap.keySet().stream().filter(l -> l.contains(parentFullName)).collect(Collectors.toList());
            String[] fullNameArr = groupFullName.split("\\.");
            for (String fullName : containGroupFullNameList) {
                String[] containFullNameArr = fullName.split("\\.");
                if (containFullNameArr.length != fullNameArr.length) continue;
                ++newNum;
            }
            order = newNum > 9 ? parentOrder + "." + newNum : parentOrder + ".0" + newNum;
        }
        return order;
    }

    private DynamicObject baseDataConvertConfigItem(HashMap<Object, Object> itemGroupMappingMap, DynamicObject baseData, HashMap<String, DynamicObject> allConfigTreeMap, List<DynamicObject> newConfigItemList, HashMap<Object, DynamicObject> baseDataFormMetaMap) {
        DynamicObject configItem = BusinessDataServiceHelper.newDynamicObject((String)"ricc_configitems");
        configItem.set("number", baseData.get("number"));
        configItem.set("name", baseData.get("name"));
        configItem.set("id", baseData.get("id"));
        configItem.set("masterid", baseData.get("masterid"));
        DynamicObject baseDataGroup = (DynamicObject)baseData.get("group");
        DynamicObject group = allConfigTreeMap.get(baseDataGroup.getLocaleString(FULLNAME).getLocaleValue());
        configItem.set("group", (Object)group);
        configItem.set("group_id", group.get("id"));
        configItem.set("status", baseData.get("status"));
        configItem.set("enable", baseData.get("enable"));
        configItem.set(ISPRESET, (Object)0);
        DynamicObject page = (DynamicObject)baseData.get("page");
        DynamicObject pageItem = baseDataFormMetaMap.get(page.get("number"));
        configItem.set("page_id", pageItem.get("id"));
        configItem.set("pagetype", baseData.get("pagetype"));
        configItem.set("custompage", baseData.get("custompage"));
        configItem.set("importtemplate", baseData.get("importtemplate"));
        configItem.set("importtemplateid", baseData.get("importtemplateid"));
        configItem.set(PAGEENTERPARAM, baseData.get(PAGEENTERPARAM));
        configItem.set(ORDERFIELD, (Object)this.getConfigItemOrder(itemGroupMappingMap, group, newConfigItemList));
        configItem.set("controlled", baseData.get("controlled"));
        configItem.set("configtype", (Object)"B");
        boolean canExcel = baseData.getBoolean("canexcel");
        if (canExcel) {
            configItem.set("supportaddtopacket", (Object)1);
            configItem.set("importtype", (Object)"excel");
            configItem.set("canexportall", (Object)1);
        } else {
            configItem.set("supportaddtopacket", (Object)0);
            configItem.set("importtype", (Object)"");
            configItem.set("canexportall", (Object)0);
        }
        configItem.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        configItem.set("plugin", (Object)"");
        configItem.set("helptext", (Object)"");
        configItem.set("custparampage", (Object)"");
        configItem.set("explain", (Object)" ");
        configItem.set("relylevel", (Object)0);
        configItem.set("rightpage_id", pageItem.get("id"));
        configItem.set("exportfiltersdesc", (Object)"");
        configItem.set("exportfilters", (Object)"");
        configItem.set("dataimporttype", (Object)"");
        configItem.set("keyfields", (Object)"");
        configItem.set("isoverrideentry", (Object)1);
        DynamicObjectCollection entrySchemes = baseData.getDynamicObjectCollection("ricc_schemeentry");
        DynamicObjectCollection schemeEntry = configItem.getDynamicObjectCollection("ricc_schemeentry");
        if (entrySchemes != null && !entrySchemes.isEmpty()) {
            for (DynamicObject entryRow : entrySchemes) {
                String iscType = entryRow.getString("isctype");
                Integer seq = (Integer)entryRow.get("seq");
                DynamicObject scheme = (DynamicObject)entryRow.get("scheme");
                String schemeStatus = entryRow.getString("entrystatus");
                String explain = entryRow.getString("explain");
                schemeEntry.add((Object)BdCenterListPlugin.setSchemeEntry(seq, iscType, scheme, schemeStatus, explain));
            }
        }
        return configItem;
    }

    private String getConfigItemOrder(HashMap<Object, Object> itemGroupMappingMap, DynamicObject group, List<DynamicObject> newConfigItemList) {
        Object itemCount = itemGroupMappingMap.get(group.get("id"));
        int newOrder = 1;
        if (!ObjectUtils.isEmpty((Object)itemCount)) {
            newOrder = (Integer)itemCount;
            ++newOrder;
        }
        for (DynamicObject newConfigItem : newConfigItemList) {
            long groupId;
            long newConfigItemId = (Long)newConfigItem.get("group.id");
            if (newConfigItemId != (groupId = ((Long)group.get("id")).longValue())) continue;
            ++newOrder;
        }
        String groupOrder = group.getString(ORDERFIELD);
        return newOrder > 9 ? groupOrder + "." + newOrder : groupOrder + ".0" + newOrder;
    }

    private HashMap<Object, Object> getItemGroupMappingMap() {
        DynamicObjectCollection configItems = QueryServiceHelper.query((String)"ricc_configitems", (String)"orderfield,group.id", null);
        HashMap<Object, Object> itemGroupMappingMap = new HashMap<Object, Object>(16);
        for (DynamicObject items : configItems) {
            Object groupId = items.get("group.id");
            Object init = itemGroupMappingMap.get(groupId);
            if (ObjectUtils.isEmpty((Object)init)) {
                itemGroupMappingMap.put(groupId, 0);
                continue;
            }
            int count = (Integer)init;
            itemGroupMappingMap.put(groupId, ++count);
        }
        return itemGroupMappingMap;
    }

    private static DynamicObject setSchemeEntry(Integer seq, String iscType, DynamicObject scheme, String schemeStatus, String explain) {
        DynamicObject itemScheme = ORM.create().newDynamicObject("ricc_configitems.ricc_schemeentry");
        itemScheme.set("seq", (Object)seq);
        itemScheme.set("isctype", (Object)iscType);
        itemScheme.set("scheme", (Object)scheme);
        itemScheme.set("schemestatus", (Object)schemeStatus);
        itemScheme.set("entryexplain", (Object)explain);
        return itemScheme;
    }

    private void afterMigration(DynamicObject[] baseDataItems, HashMap<String, Object> migrationResult) {
        String errorMessage = (String)migrationResult.get("errorMessage");
        MainEntityType dtType = EntityMetadataCache.getDataEntityType((String)"ricc_basedata_migration");
        DynamicObject migratedResult = new DynamicObject((DynamicObjectType)dtType);
        DynamicObjectCollection entry = migratedResult.getDynamicObjectCollection("migrationresult");
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            List newConfigItemList = (List)migrationResult.get("newconfigitem");
            int i = 0;
            for (DynamicObject baseData : baseDataItems) {
                DynamicObject newConfig = (DynamicObject)newConfigItemList.get(i);
                DynamicObject entryRow = entry.addNew();
                entryRow.set("basedatagroup", (Object)baseData.getLocaleString("group.fullname").getLocaleValue());
                entryRow.set("datanumber", baseData.get("number"));
                entryRow.set("dataname", (Object)baseData.getLocaleString("name").getLocaleValue());
                entryRow.set("itemgroup", (Object)newConfig.get("group.fullname").toString());
                entryRow.set("itemnumber", newConfig.get("number"));
                entryRow.set("itemname", (Object)newConfig.getLocaleString("name").getLocaleValue());
                ++i;
            }
        }
        migratedResult.set("loginfo", (Object)errorMessage);
        migratedResult.set("migrationcount", (Object)baseDataItems.length);
        migratedResult.set("migrationresult", (Object)entry);
        String showCustom = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{migratedResult}, (DynamicObjectType)dtType);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("migrationResult", (Object)showCustom);
        showParameter.setFormId("ricc_basedata_migration");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("600");
        styleCss.setWidth("800");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm(showParameter);
    }

    private boolean isHasPermission(Object primaryKeyValue) {
        DynamicObject bdItem = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"ricc_basedata_item");
        String formId = bdItem.getString("page.id");
        return PermissionUtil.checkPagePermission((String)formId, (String)"47150e89000000ac");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("isc_sync".equals(opKey) && args.getOperationResult().isSuccess()) {
            this.showIscSchemeSelectForm();
        }
    }

    private void showIscSchemeSelectForm() {
        Object bdItemPk = this.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject schemeConfig = SysParaUtil.getSchemeConfig();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("ricc_basedata_itemlayout");
        billShowParameter.setPkId(bdItemPk);
        billShowParameter.setCustomParam("id", bdItemPk);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u65b9\u6848", (String)"BdCenterListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        billShowParameter.setCustomParam("isSynOpen", (Object)Boolean.TRUE);
        DynamicObject connectionEnv = (DynamicObject)schemeConfig.get("connectionenv");
        String dataCenterName = connectionEnv.getLocaleString("name").getLocaleValue();
        String dataCenterUrl = (String)connectionEnv.get("evnurl");
        String currentType = schemeConfig.getString("currenttype");
        String direction = null;
        direction = StringUtils.equals((String)currentType, (String)"tar") ? String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3--> %1$s[%2$s]", (String)"BdCenterListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), dataCenterUrl, dataCenterName) : String.format(ResManager.loadKDString((String)"%1$s[%2$s]-->\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"BdCenterListPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), dataCenterUrl, dataCenterName);
        billShowParameter.setCustomParam("direction", (Object)direction);
        StyleCss style = new StyleCss();
        style.setWidth("920");
        style.setHeight("430");
        billShowParameter.getOpenStyle().setInlineStyleCss(style);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        if ("number".equalsIgnoreCase(args.getFieldName())) {
            Object guideId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.openConfigForm(guideId);
        }
    }

    public void openConfigForm(Object guideId) {
        QFilter qFilter = new QFilter("id", "=", guideId);
        DynamicObject oneObject = QueryServiceHelper.queryOne((String)"ricc_basedata_item", (String)"id,page,number,page.modeltype modeltype,page.bizappid.number appid,page.bizappid.bizcloud.id cloudid,pagetype,name,custompage,canexcel,pageenterparam,importtemplateid", (QFilter[])qFilter.toArray());
        if (Objects.isNull(oneObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52fe\u9009\u6570\u636e\u5f02\u5e38\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"BdCenterListPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        String formId = oneObject.getString("page");
        String pageType = oneObject.getString("pagetype");
        String pageCode = oneObject.getString("number");
        String importTemplateId = oneObject.getString("importtemplateid");
        String guideName = oneObject.getString("name");
        if ("custom".equals(pageType)) {
            pageType = oneObject.getString("custompage");
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("riccFormId", formId);
        customParams.put("guideName", guideName);
        customParams.put("pageType", pageType);
        customParams.put("guideId", guideId);
        customParams.put("packettype", DataPacketTypeEnum.BASEDATA.getVal());
        customParams.put("canAddPacket", SysParaUtil.canAddPacket());
        customParams.put("importtemplateid", importTemplateId);
        String appId = oneObject.getString("appid");
        customParams.put("appId", appId);
        customParams.put(PAGEENTERPARAM, oneObject.get(PAGEENTERPARAM));
        Object formShowParameter = "bos_dynamicform".equals(pageType) ? ShowParameterUtil.formShowParameter((String)formId, (ShowType)ShowType.MainNewTabPage, customParams, null, null) : ShowParameterUtil.listShowParameter((String)formId, (String)pageType, (ShowType)ShowType.MainNewTabPage, customParams, null, null, null);
        String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
        formShowParameter.setParentPageId(parentPageId);
        boolean canExcel = oneObject.getBoolean("canexcel");
        if (canExcel) {
            formShowParameter.addCustPlugin("kd.bos.ext.imsc.ricc.form.listext.DynamicBdListPlugin");
        } else {
            formShowParameter.addCustPlugin("kd.bos.ext.imsc.ricc.form.listext.DynamicListPlugin");
        }
        ConfigItemHelper.setServiceAppId(appId, formShowParameter);
        formShowParameter.setPageId(pageCode + this.getView().getFormShowParameter().getRootPageId());
        this.getView().showForm(formShowParameter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        String key = e.getParameter().getBillStatus().name().toLowerCase();
        if (VIEW.equals(key)) {
            ListSelectedRow selectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            StringBuilder name = new StringBuilder(selectedRow.getName());
            billShowParameter.setCaption(name.append(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"BdCenterListPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0])).toString());
        }
    }
}

