/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.fasttransfer;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.log.ConfigLog;
import kd.sys.ricc.business.log.LogRecorder;
import kd.sys.ricc.business.log.impl.ConfigLogImpl;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.TransferUtil;
import kd.sys.ricc.exception.RiccBizException;

public class FastAddToPacketPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FastAddToPacketPlugin.class);
    private static final String DATA_PACKET_NAME = "packetname";
    private static final String DATA_PACKET = "datapacket";
    private static final String GUIDE_NAME = "guideName";
    private static final String OK = "ok";
    private static final String IS_NEW_DATA_PACKET = "isnewdatapacket";
    private static final String PACKET_VERSION = "packetversion";
    private static final String PROGRESSFORM_CLOSE = "progressClose";
    private static final String MANUALADD = "0";
    private static final String REMARKS = "remarks";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataPacket = (BasedataEdit)this.getView().getControl(DATA_PACKET);
        dataPacket.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"iconclick"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String guideName = "";
        String schemeName = (String)this.getView().getFormShowParameter().getCustomParam("schemeName");
        String openFrom = (String)this.getView().getFormShowParameter().getCustomParam("addDataPacketOpenFrom");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"transtippanelap"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        if (StringUtils.isNotEmpty((String)schemeName)) {
            this.hideRelyPanel();
            guideName = schemeName;
            String transTipMapStr = (String)this.getView().getFormShowParameter().getCustomParam("transtips");
            LinkedHashMap transTipMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)transTipMapStr, LinkedHashMap.class);
            if (transTipMap.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
            }
            TransferUtil.fillTransTipEntry((IFormView)this.getView(), (LinkedHashMap)transTipMap);
        } else if (StringUtils.equals((String)openFrom, (String)"openFromMetadata")) {
            this.hideRelyPanel();
            guideName = ResManager.loadKDString((String)"\u5143\u6570\u636e\u6253\u5305", (String)"FastAddToPacketPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
        } else {
            String relyItemName;
            String packetName = (String)this.getModel().getValue(DATA_PACKET_NAME);
            if (StringUtils.isEmpty((String)packetName)) {
                guideName = (String)this.getView().getFormShowParameter().getCustomParam(GUIDE_NAME);
            }
            String transTips = (String)this.getView().getFormShowParameter().getCustomParam("transtips");
            this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((String)transTips)), new String[]{"hint2"});
            if (StringUtils.isNotEmpty((String)transTips)) {
                Label tipLabel = (Label)this.getControl("labeltranstips");
                tipLabel.setText(transTips);
            }
            boolean showTips = StringUtils.isNotEmpty((String)(relyItemName = (String)this.getView().getFormShowParameter().getCustomParam("relyitemname"))) || StringUtils.isNotEmpty((String)transTips);
            this.getView().setVisible(Boolean.valueOf(showTips), new String[]{"transferhint"});
            if (StringUtils.isEmpty((String)relyItemName)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"hint"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"hint"});
                Label label = (Label)this.getView().getControl("relyitem");
                Object[] split = relyItemName.split(",");
                String text = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5df2\u9009\u6570\u636e\u4f9d\u8d56%s\u6570\u636e;", (String)"FastAddToPacketPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), Arrays.toString(split));
                label.setText(text);
            }
        }
        this.setDefaultPacket();
        String timestamp = new SimpleDateFormat("MMddHHmm").format(new Date());
        this.getModel().setValue(DATA_PACKET_NAME, (Object)String.format("%1$s-%2$s", guideName, timestamp));
    }

    private void hideRelyPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"transferhint"});
        this.getModel().setValue(IS_NEW_DATA_PACKET, (Object)Boolean.TRUE);
    }

    private void setDefaultPacket() {
        DynamicObject dataPacket;
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String openFrom = (String)this.getView().getFormShowParameter().getCustomParam("addDataPacketOpenFrom");
        QFilter packetFilter = new QFilter("status", "=", (Object)"A");
        packetFilter.and(new QFilter("creator.id", "=", (Object)currentUserId)).and(new QFilter("datasource", "=", (Object)MANUALADD));
        if (StringUtils.equals((String)openFrom, (String)"openFromMetadata")) {
            packetFilter.and(new QFilter("packettype", "=", (Object)"2"));
        } else {
            packetFilter.and(new QFilter("packettype", "=", (Object)"1"));
        }
        DynamicObject[] packets = BusinessDataServiceHelper.load((String)"ricc_datapacket", (String)"id", (QFilter[])packetFilter.toArray(), (String)"createtime desc", (int)1);
        if (!Objects.isNull(packets) && packets.length > 0) {
            String packetId = packets[0].getString("id");
            this.getModel().setValue(DATA_PACKET, (Object)packetId);
        }
        if ((dataPacket = (DynamicObject)this.getModel().getValue(DATA_PACKET)) != null) {
            String remarks = dataPacket.getString(REMARKS);
            long packetVersionId = dataPacket.getLong("packetversion.id");
            this.getModel().setValue(REMARKS, (Object)remarks);
            this.getModel().setValue(PACKET_VERSION, (Object)packetVersionId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("iconclick".equalsIgnoreCase(control.getKey())) {
            boolean whetherBatchPack = CommonUtil.whetherBatchPack();
            if (!whetherBatchPack) {
                this.getView().showTipNotification(CommonConstant.getBatchPackPerm());
                return;
            }
            boolean canExportAll = (Boolean)this.getView().getFormShowParameter().getCustomParam("canexportall");
            if (canExportAll) {
                String itemNumber = (String)this.getView().getFormShowParameter().getCustomParam("number");
                String noExportAllName = (String)this.getView().getFormShowParameter().getCustomParam("noexportallname");
                BaseShowParameter showParameter = new BaseShowParameter();
                String data = (String)this.getView().getFormShowParameter().getCustomParam("selectedData");
                showParameter.setAppId("ricc");
                showParameter.setFormId("ricc_packscheme");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("noExportAllName", (Object)noExportAllName);
                showParameter.setCustomParam("ServiceAppId", (Object)"ricc");
                showParameter.setCustomParam("selectData", (Object)data);
                showParameter.setCustomParam("itemNumber", (Object)itemNumber);
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                IFormView viewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
                viewNoPlugin.showForm((FormShowParameter)showParameter);
                this.getView().sendFormAction(viewNoPlugin);
                this.getView().close();
            } else {
                String itemName = (String)this.getView().getFormShowParameter().getCustomParam(GUIDE_NAME);
                String tip = String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u4f9d\u8d56\u6570\u636e\u5931\u8d25\uff0c[%s]\u4e0d\u652f\u6301\u6279\u91cf\u6253\u5305\uff0c\u8bf7\u624b\u5de5\u9009\u62e9\u6570\u636e\u4f20\u8f93", (String)"FastAddToPacketPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), itemName);
                this.getView().showTipNotification(tip);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (IS_NEW_DATA_PACKET.equals(key)) {
            boolean isNewDataPacket = (Boolean)this.getModel().getValue(IS_NEW_DATA_PACKET);
            if (isNewDataPacket) {
                long packetVersionId = DataPacketHelper.getLatestPacketVersion();
                this.getModel().setValue(PACKET_VERSION, (Object)packetVersionId);
            } else {
                this.getModel().setValue(DATA_PACKET, null);
                this.getModel().setValue(PACKET_VERSION, null);
            }
            this.getModel().setValue(REMARKS, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String opKey = op.getOperateKey();
        if (StringUtils.equals((String)OK, (String)opKey)) {
            boolean hasNewPacketPerm;
            boolean isNewPacket = (Boolean)this.getModel().getValue(IS_NEW_DATA_PACKET);
            if (isNewPacket && !(hasNewPacketPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"ricc", (String)"ricc_datapacket", (String)"47156aff000000ac"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f20\u8f93\u5305\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u5206\u914d\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"FastAddToPacketPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasSavePacketPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"ricc", (String)"ricc_datapacket", (String)"0=KX5+QVF5+R");
            if (!hasSavePacketPerm) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f20\u8f93\u5305\u7684\u4fdd\u5b58\u6743\u9650\uff0c\u8bf7\u5206\u914d\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"FastAddToPacketPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        boolean success = args.getOperationResult().isSuccess();
        if (success && OK.equals(key)) {
            String openFrom = (String)this.getView().getFormShowParameter().getCustomParam("addDataPacketOpenFrom");
            if (StringUtils.equals((String)openFrom, (String)"openFromMetadata")) {
                ListSelectedRow selectPacket = this.getOrCreatePacket(DataPacketTypeEnum.METADATA.getVal());
                HashMap<String, ListSelectedRow> returnParams = new HashMap<String, ListSelectedRow>(2);
                returnParams.put("selectedPacket", selectPacket);
                this.getView().returnDataToParent(returnParams);
                this.getView().close();
                return;
            }
            ListSelectedRow selectPacket = this.getOrCreatePacket(DataPacketTypeEnum.CONFIG.getVal());
            String schemeName = (String)this.getView().getFormShowParameter().getCustomParam("schemeName");
            if (!StringUtils.isEmpty((String)schemeName)) {
                Object primaryKeyValue = selectPacket.getPrimaryKeyValue();
                this.getView().returnDataToParent(primaryKeyValue);
                this.getView().close();
            } else {
                this.doPacket(selectPacket);
            }
        }
    }

    private ListSelectedRow getOrCreatePacket(String type) {
        boolean isNewPacket = (Boolean)this.getModel().getValue(IS_NEW_DATA_PACKET);
        ListSelectedRow selectPacket = new ListSelectedRow();
        if (isNewPacket) {
            String remarks = (String)this.getModel().getValue(REMARKS);
            String packetName = (String)this.getModel().getValue(DATA_PACKET_NAME);
            DynamicObject packetVersion = (DynamicObject)this.getModel().getValue(PACKET_VERSION);
            DynamicObject newPacket = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datapacket");
            long packetId = DB.genLongId((String)"ricc_datapacket");
            newPacket.set("id", (Object)packetId);
            newPacket.set(PACKET_VERSION, Optional.ofNullable(packetVersion).map(DataEntityBase::getPkValue).orElse(null));
            newPacket.set("status", (Object)"A");
            newPacket.set("creator", (Object)RequestContext.get().getCurrUserId());
            newPacket.set("createtime", (Object)System.currentTimeMillis());
            newPacket.set("dltrcount", (Object)0);
            newPacket.set("enable", (Object)"1");
            newPacket.set("packettype", (Object)type);
            newPacket.set("name", (Object)packetName);
            String readNumber = CodeRuleServiceHelper.getNumber((String)"ricc_datapacket", (DynamicObject)newPacket, null);
            newPacket.set("number", (Object)readNumber);
            newPacket.set(REMARKS, (Object)remarks);
            newPacket.set("datasource", (Object)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal());
            newPacket.set("lockedstatus", (Object)PacketLockEnum.NOT_LOCKED.getVal());
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPacket});
            }
            catch (Exception e) {
                throw new RiccBizException(ResManager.loadKDString((String)"\u521b\u5efa\u4f20\u8f93\u5305\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FastAddToPacketPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
            }
            selectPacket.setName(packetName);
            selectPacket.setNumber(readNumber);
            selectPacket.setPrimaryKeyValue((Object)packetId);
        } else {
            DynamicObject packet = (DynamicObject)this.getModel().getValue(DATA_PACKET);
            selectPacket.setName(packet.getString("name"));
            selectPacket.setNumber(packet.getString("number"));
            selectPacket.setPrimaryKeyValue(packet.getPkValue());
        }
        return selectPacket;
    }

    private void doPacket(ListSelectedRow selectedPacket) {
        Object selectGuideId = this.getView().getFormShowParameter().getCustomParam("guideId");
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("riccFormId");
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
        String packetType = (String)this.getView().getFormShowParameter().getCustomParam("packettype");
        Map custParam = (Map)this.getView().getFormShowParameter().getCustomParam("custParam");
        String selectedDataStr = (String)this.getView().getFormShowParameter().getCustomParam("selectedData");
        ListSelectedRowCollection dataRows = ListSelectedRowCollection.deSerialize((String)selectedDataStr);
        if (dataRows.size() <= 1000) {
            this.startAddToPacket(selectedPacket, selectGuideId, parentPageId, packetType, custParam, dataRows);
        } else {
            String taskKey = this.getTaskUniqueKey(selectedPacket, dataRows);
            if (TaskSerailHelper.taskExist(taskKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u6dfb\u52a0\u5230\u8fd9\u4e2a\u4f20\u8f93\u5305\u7684\u4efb\u52a1\u5df2\u7ecf\u5728\u6267\u884c\u4e86\uff0c\u8bf7\u68c0\u67e5\u4f20\u8f93\u5305\u65e5\u5fd7\u6216\u4f20\u8f93\u5305\u5217\u8868\u3002", (String)"FastAddToPacketPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            this.startAddToPacketTask(selectedPacket, formId, custParam, selectedDataStr, taskKey);
        }
    }

    private void startAddToPacketTask(ListSelectedRow selectedPacket, String formId, Map<String, Object> custParam, String selectedDataStr, String taskKey) {
        HashSet<String> taskKeySet = new HashSet<String>(2);
        taskKeySet.add(taskKey);
        HashMap<String, Object> allParam = new HashMap<String, Object>(this.getView().getFormShowParameter().getCustomParams());
        allParam.put("custParam", custParam);
        allParam.put("formId", formId);
        allParam.put("selectedPacket", selectedPacket);
        allParam.put("selectedData", selectedDataStr);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ricc_addpacketprogress");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(allParam);
        formShowParameter.setCustomParam("ricconcekey", taskKeySet);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PROGRESSFORM_CLOSE));
        this.getView().showForm(formShowParameter);
    }

    private void startAddToPacket(ListSelectedRow selectedPacket, Object selectGuideId, String parentPageId, String packetType, Map<String, Object> custParam, ListSelectedRowCollection dataRows) {
        ConfigLogImpl configLog = new ConfigLogImpl();
        ((ConfigLog)configLog).preWriteLog("3", MANUALADD, (Long)selectedPacket.getPrimaryKeyValue(), 0L, "", null);
        SdpOutputParams sdpOutputParams = SubDataPacketDispatch.exportPacket(packetType, selectGuideId, selectedPacket, dataRows, parentPageId, custParam, null);
        String errMsg = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", (String)"FastAddToPacketPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        if (!sdpOutputParams.isSuccess()) {
            ((ConfigLog)configLog).afterWriteLog(dataRows.size(), 0, sdpOutputParams.getLogRecordBuilder());
            this.getView().showErrorNotification(String.format(errMsg, sdpOutputParams.getErrorStr()));
            return;
        }
        try {
            DynamicObject subDataPacket = (DynamicObject)sdpOutputParams.getParam().get("subDataPacket");
            List<DynamicObject> relyPacketList = sdpOutputParams.getParam().getOrDefault("relyBdPacketList", Collections.emptyList());
            List multiPacketList = sdpOutputParams.getParam().getOrDefault("multiDataPacketList", Collections.emptyList());
            relyPacketList.addAll(multiPacketList);
            if (relyPacketList.isEmpty()) {
                SubDataPacketDispatch.saveSubDataPacket(selectedPacket.getPrimaryKeyValue(), subDataPacket);
            } else {
                relyPacketList.add(subDataPacket);
                SubDataPacketDispatch.saveBatchSubDataPacket(selectedPacket.getPrimaryKeyValue(), relyPacketList);
            }
        }
        catch (RiccBizException e) {
            logger.error("startAddToPacket\u5feb\u901f\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            String tips = String.format(errMsg, e.getMessage());
            this.getView().showErrorNotification(String.format(errMsg, e.getMessage()));
            LogRecorder logRecorder = new LogRecorder();
            logRecorder.append(tips, e);
            ((ConfigLog)configLog).afterWriteLog(dataRows.size(), 0, logRecorder);
            return;
        }
        ((ConfigLog)configLog).afterWriteLog(dataRows.size(), dataRows.size(), sdpOutputParams.getLogRecordBuilder());
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (PROGRESSFORM_CLOSE.equals(actionId)) {
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (DATA_PACKET.equals(key)) {
            String openFrom = (String)this.getView().getFormShowParameter().getCustomParam("addDataPacketOpenFrom");
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            showParam.setShowApproved(false);
            QFilter filter = new QFilter("status", "=", (Object)"A");
            filter.and(new QFilter("datasource", "=", (Object)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal()));
            if (StringUtils.equals((String)openFrom, (String)"openFromMetadata")) {
                filter.and(new QFilter("packettype", "=", (Object)"2"));
            } else {
                filter.and(new QFilter("packettype", "=", (Object)"1"));
            }
            evt.addCustomQFilter(filter);
        }
    }

    private String getTaskUniqueKey(ListSelectedRow selectedPacket, ListSelectedRowCollection dataRows) {
        StringBuilder result = new StringBuilder();
        return result.append(dataRows.get(0).getPrimaryKeyValue()).append(dataRows.size()).append(dataRows.get(dataRows.size() - 1).getPrimaryKeyValue()).append(selectedPacket.getPrimaryKeyValue()).toString();
    }
}

