/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.fasttransfer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.sync.SyncUtil;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.TransferUtil;

public class FastTransferFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(FastTransferFormPlugin.class);
    private static final String PROGRESS_CLOSE = "progressclose";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit targetDataCenter = (BasedataEdit)this.getControl("targetdatacenter");
        targetDataCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TransferUtil.setDefaultCenterAndUserMulti((IFormView)this.getView());
        TransferUtil.setEntryTransferType((IFormView)this.getView());
        String transTipMapStr = (String)this.getView().getFormShowParameter().getCustomParam("transtips");
        LinkedHashMap transTipMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)transTipMapStr, LinkedHashMap.class);
        TransferUtil.fillTransTipEntry((IFormView)this.getView(), (LinkedHashMap)transTipMap);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("targetdatacenter".equals(key)) {
            DynamicObject newCenter = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newCenter == null) {
                return;
            }
            long newCenterId = newCenter.getLong("id");
            this.getModel().setValue("targetdatacenteruser", (Object)CommonQuery.getTransferLatestUserPhone((long)newCenterId), rowIndex);
            TransferUtil.setEntryTransferType((IFormView)this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String opKey = operate.getOperateKey();
            if (StringUtils.equals((String)"ok", (String)opKey)) {
                DynamicObjectCollection targetDataEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
                String errMsg = this.transferValidate(targetDataEntry);
                if (StringUtils.isNotEmpty((String)errMsg)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                if (TransferUtil.isHasSyn((DynamicObjectCollection)targetDataEntry)) {
                    SyncUtil.showSyncMessageBox(this.getView(), args, this.getPluginName());
                }
            } else if (StringUtils.equals((String)"preview", (String)opKey)) {
                int focusRow = this.getFocusRow();
                Object destAccount = this.getModel().getValue("targetdatacenter", focusRow);
                Object targetCenterUser = this.getModel().getValue("targetdatacenteruser", focusRow);
                if (Objects.isNull(destAccount) || Objects.isNull(targetCenterUser)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u6216\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u3002", (String)"FastTransferFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    private String transferValidate(DynamicObjectCollection targetDataEntry) {
        String errMsg = TransferUtil.mustInputValidate((DynamicObjectCollection)targetDataEntry);
        if (StringUtils.isNotEmpty((String)errMsg)) {
            return errMsg;
        }
        DynamicObjectCollection packets = QueryServiceHelper.query((String)"ricc_datapacket", (String)"status,packettype,id,subdatapacket.custparam_tag", (QFilter[])new QFilter("id", "in", (Object)this.getSelectPacketIds()).toArray());
        DynamicObjectCollection metaConfirmCollection = QueryServiceHelper.query((String)"ricc_meta_confirm", (String)"id,headerconfirmstatus,targetdatacenter,package", (QFilter[])new QFilter("package", "in", (Object)this.getSelectPacketIds()).toArray());
        Map<Object, Object> confirmObjMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)metaConfirmCollection)) {
            confirmObjMap = metaConfirmCollection.stream().collect(Collectors.groupingBy(o -> o.getLong("package")));
        }
        for (DynamicObject targetData : targetDataEntry) {
            String tarEvnType;
            EnvRoleEnum tarEnvRole;
            DynamicObject targetDataCenter = targetData.getDynamicObject("targetdatacenter");
            if (targetDataCenter == null || (tarEnvRole = EnvRoleEnum.fromVal((String)(tarEvnType = targetDataCenter.getString("evnType")))) == null) continue;
            for (DynamicObject packet : packets) {
                boolean isControl;
                String status = packet.getString("status");
                boolean canUpload = SysParaUtil.canUploadPacketStatusInEnvType((String)tarEnvRole.getVal(), (String)status);
                if (!canUpload) {
                    return String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3[%s]\u53ea\u80fd\u4e0a\u4f20\u5ba1\u6838\u72b6\u6001\u7684\u4f20\u8f93\u5305\uff0c\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u540e\u518d\u64cd\u4f5c\u3002", (String)"FastTransferFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), targetDataCenter.getString("name"));
                }
                String packetType = packet.getString("packettype");
                if (!StringUtils.equals((String)packetType, (String)DataPacketTypeEnum.METADATA.getVal())) continue;
                String custerParam = (String)packet.get("subdatapacket.custparam_tag");
                JSONObject custerMap = JSON.parseObject((String)custerParam);
                Object isControlValue = custerMap.get((Object)"isControl");
                boolean bl = isControl = isControlValue == null || (Boolean)isControlValue != false;
                boolean isMetaControlled = targetDataCenter.getBoolean("ismetacontrolled");
                if (!isMetaControlled || !isControl) continue;
                List objs = (List)confirmObjMap.get(packet.getLong("id"));
                if (CollectionUtils.isEmpty((Collection)objs)) {
                    return String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3[%s]\u5143\u6570\u636e\u4f20\u8f93\u53d7\u63a7\uff0c\u8bf7\u5148\u901a\u8fc7\u3010\u5143\u6570\u636e\u5bf9\u6bd4\u3011\u751f\u6210\u53d8\u66f4\u786e\u8ba4\u5355\u4e14\u786e\u8ba4\u53d8\u66f4\u540e\u518d\u8fdb\u884c\u4f20\u8f93\u3002", (String)"FastTransferFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), targetDataCenter.getString("name"));
                }
                Optional<DynamicObject> isPresentOption = objs.stream().filter(o -> o.getLong("targetdatacenter") == targetDataCenter.getLong("id")).findFirst();
                if (!isPresentOption.isPresent()) {
                    return String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3[%s]\u5143\u6570\u636e\u4f20\u8f93\u53d7\u63a7\uff0c\u8bf7\u5148\u901a\u8fc7\u3010\u5143\u6570\u636e\u5bf9\u6bd4\u3011\u751f\u6210\u53d8\u66f4\u786e\u8ba4\u5355\u4e14\u786e\u8ba4\u53d8\u66f4\u540e\u518d\u8fdb\u884c\u4f20\u8f93\u3002", (String)"FastTransferFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), targetDataCenter.getString("name"));
                }
                Optional<DynamicObject> first = objs.stream().filter(o -> o.getLong("targetdatacenter") == targetDataCenter.getLong("id") && StringUtils.equals((String)o.getString("headerconfirmstatus"), (String)"0")).findFirst();
                if (!first.isPresent()) continue;
                return String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3[%s]\u5143\u6570\u636e\u4f20\u8f93\u53d7\u63a7\uff0c\u8bf7\u5148\u901a\u8fc7\u3010\u5143\u6570\u636e\u5bf9\u6bd4\u3011\u751f\u6210\u53d8\u66f4\u786e\u8ba4\u5355\u4e14\u786e\u8ba4\u53d8\u66f4\u540e\u518d\u8fdb\u884c\u4f20\u8f93\u3002", (String)"FastTransferFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), targetDataCenter.getString("name"));
            }
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        int focusRow = this.getFocusRow();
        if (StringUtils.equals((String)"ok", (String)opKey) && args.getOperationResult().isSuccess()) {
            this.showSyncProgress();
        }
        if (StringUtils.equals((String)"preview", (String)opKey)) {
            this.preview(focusRow);
        }
    }

    private int getFocusRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetdataentry");
        return entryGrid.getEntryState().getFocusRow();
    }

    private void preview(int focusRow) {
        String selectRowsStr = (String)this.getView().getFormShowParameter().getCustomParam("selectRows");
        ListSelectedRowCollection listSelectedRows = ListSelectedRowCollection.deSerialize((String)selectRowsStr);
        DynamicObject destAccount = (DynamicObject)this.getModel().getValue("targetdatacenter", focusRow);
        long destAccountPk = (Long)destAccount.getPkValue();
        String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser", focusRow);
        Map loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)targetCenterUser);
        HashMap<String, String> showParam = new HashMap<String, String>(2);
        showParam.put("previewType", "packetToTar");
        List selectIdList = Arrays.stream(listSelectedRows.getPrimaryKeyValues()).collect(Collectors.toList());
        showParam.put("selectIds", JSON.toJSONString(selectIdList));
        showParam.put("loginParams", JSON.toJSONString((Object)loginParams));
        FormShowParameter formShowParameter = ShowParameterUtil.simpleFormShowParameter((String)"ricc_dapacket_preview", showParam);
        this.getView().showForm(formShowParameter);
    }

    private void showSyncProgress() {
        String selectRowsStr = (String)this.getView().getFormShowParameter().getCustomParam("selectRows");
        DynamicObjectCollection targetDataEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
        HashMap<Long, String> targetDataMap = new HashMap<Long, String>(targetDataEntry.size());
        ArrayList<String> transferTypeList = new ArrayList<String>(10);
        for (DynamicObject target : targetDataEntry) {
            if (target.getDynamicObject("targetdatacenter") == null || !StringUtils.isNotEmpty((String)target.getString("targetdatacenteruser"))) continue;
            targetDataMap.put(target.getDynamicObject("targetdatacenter").getLong("id"), target.getString("targetdatacenteruser"));
            transferTypeList.add(target.getString("transfertype"));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("ricc_transferprogress");
        formShowParameter.setCustomParam("selectRows", (Object)selectRowsStr);
        formShowParameter.setCustomParam("targetdata", targetDataMap);
        formShowParameter.setCustomParam("transfertype", transferTypeList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PROGRESS_CLOSE));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (PROGRESS_CLOSE.equals(actionId)) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("transferandsyn".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.showSyncProgress();
        }
    }

    private Object[] getSelectPacketIds() {
        String selectRowsStr = (String)this.getView().getFormShowParameter().getCustomParam("selectRows");
        ListSelectedRowCollection listSelectedRows = ListSelectedRowCollection.deSerialize((String)selectRowsStr);
        return listSelectedRows.getPrimaryKeyValues();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("targetdatacenter".equals(propertyName)) {
            DynamicObjectCollection targetDataEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
            List selectDataCenterIds = targetDataEntrys.stream().filter(targetData -> targetData.getDynamicObject("targetdatacenter") != null).map(targetData -> targetData.getDynamicObject("targetdatacenter").getLong("id")).collect(Collectors.toList());
            if (!selectDataCenterIds.isEmpty()) {
                QFilter filter = new QFilter("id", "not in", selectDataCenterIds);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
            showParameter.setCustomParam("openStyle", (Object)"openStyle_f7");
            showParameter.getListFilterParameter().getQFilters().add(CommonUtil.getDataCenterFilter());
        }
    }
}

