/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.sys.ricc.business.training.TrainCommonMethod;
import kd.sys.ricc.business.training.TrainCourseUtils;

public class LearningRecordEntryPlugin
extends AbstractFormPlugin
implements CellClickListener,
TrainCommonMethod {
    private static final Log log = LogFactory.getLog(LearningRecordEntryPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshRecordData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "refreshdata": {
                this.refreshRecordData();
                break;
            }
            case "learndetail": {
                this.viewLearningDetails(this.getSelectUsers(), "all");
                break;
            }
            case "notify": {
                this.notifyTrainee();
                break;
            }
        }
    }

    private void refreshRecordData() {
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String entryQFilterJson = pageCache.get("EntryQFilter");
        List qFilterJsonList = (List)SerializationUtils.fromJsonString((String)entryQFilterJson, ArrayList.class);
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection learningDetails = QueryServiceHelper.query((String)"ricc_learningdetail", (String)"user, user.name, course, status", (QFilter[])((QFilter[])qFilterJsonList.stream().map(QFilter::fromSerializedString).toArray(QFilter[]::new)), (String)"user.name");
        Map<Long, List<DynamicObject>> learningMap = learningDetails.stream().collect(Collectors.groupingBy(e -> e.getLong("user")));
        if (learningMap.size() == 0) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", learningMap.size());
        int index = 0;
        for (Map.Entry<Long, List<DynamicObject>> entry : learningMap.entrySet()) {
            Long userId = entry.getKey();
            List<DynamicObject> records = entry.getValue();
            this.getModel().setValue("name", (Object)userId, rows[index]);
            this.getModel().setValue("total", (Object)records.size(), rows[index]);
            Map<String, List<DynamicObject>> recordStatusMap = records.stream().collect(Collectors.groupingBy(e -> e.getString("status")));
            this.getModel().setValue("complete", (Object)((List)recordStatusMap.getOrDefault("complete", new ArrayList())).size(), rows[index]);
            this.getModel().setValue("learning", (Object)((List)recordStatusMap.getOrDefault("learning", new ArrayList())).size(), rows[index]);
            this.getModel().setValue("unstart", (Object)((List)recordStatusMap.getOrDefault("unstart", new ArrayList())).size(), rows[index]);
            ++index;
        }
    }

    private List<Long> getSelectUsers() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            return new ArrayList<Long>(16);
        }
        return Arrays.stream(rows).mapToObj(e -> {
            DynamicObject user = (DynamicObject)this.getModel().getValue("name", e);
            if (user == null) {
                return 0L;
            }
            return user.getLong("id");
        }).collect(Collectors.toList());
    }

    private void notifyTrainee() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"LearningRecordEntryPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            return;
        }
        List selectRows = Arrays.stream(rows).mapToObj(e -> this.getModel().getEntryRowEntity("entryentity", e)).collect(Collectors.toList());
        try (TXHandle tx = TX.requiresNew((String)"notifyTrainee");){
            try {
                OperationResult result = new OperationResult();
                result.setBillCount(selectRows.size());
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(16);
                for (int i = 0; i < selectRows.size(); ++i) {
                    DynamicObject selectRow = (DynamicObject)selectRows.get(i);
                    int learning = selectRow.getInt("learning");
                    int unStart = selectRow.getInt("unstart");
                    ExtendedDataEntity dataEntity = new ExtendedDataEntity(selectRow, i, i);
                    dataEntity.setBillNo(selectRow.getDynamicObject("name").getString("name"));
                    if (learning == 0 && unStart == 0) {
                        TrainCourseUtils.addErrorInfo(result, dataEntity, ResManager.loadKDString((String)"\u6210\u5458\u6240\u6709\u8bfe\u7a0b\u5747\u4e3a\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u63d0\u9192\u3002", (String)"LearningRecordEntryPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b66\u4e60\u63d0\u9192", (String)"LearningRecordEntryPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), selectRows.size() == 1);
                        continue;
                    }
                    messageInfos.add(TrainCourseUtils.createNotifyMessageInfo(selectRow.getLong("name_id"), learning + unStart));
                    result.getSuccessPkIds().add(selectRow.getLong("name_id"));
                }
                if (messageInfos.size() != 0) {
                    MessageCenterServiceHelper.batchSendMessages(messageInfos);
                }
                if (result.isSuccess()) {
                    result.setMessage(ResManager.loadKDString((String)"\u63d0\u9192\u6210\u529f\u3002", (String)"LearningRecordEntryPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                this.getView().showOperationResult(result);
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("LearningRecordEntryPlugin_notifyTrainee", (Throwable)ex);
                this.getView().showErrorNotification(ex.getMessage());
            }
        }
    }

    public void cellClick(CellClickEvent event) {
        String fieldKey = event.getFieldKey();
        int row = event.getRow();
        this.clickToViewLearningDetails(fieldKey, row);
    }

    public void cellDoubleClick(CellClickEvent event) {
        String fieldKey = event.getFieldKey();
        int row = event.getRow();
        this.clickToViewLearningDetails(fieldKey, row);
    }

    private void clickToViewLearningDetails(String fieldKey, int row) {
        DynamicObject user = (DynamicObject)this.getModel().getValue("name", row);
        long userId = user == null ? 0L : user.getLong("id");
        String type = "";
        switch (fieldKey) {
            case "total": {
                type = "all";
                break;
            }
            case "complete": 
            case "learning": 
            case "unstart": {
                type = fieldKey;
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.viewLearningDetails(userId, type);
    }

    @Override
    public Map<String, Supplier<String>> getExecMap() {
        return new HashMap<String, Supplier<String>>(16);
    }
}

