/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.sys.ricc.business.training.TrainCommonMethod;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.business.training.TrainThreadUtils;
import kd.sys.ricc.business.training.task.LearnRecordUpdateTask;
import kd.sys.ricc.common.entity.MyCourse;
import kd.sys.ricc.common.entity.ViewCourse;

public class MyCoursePlugin
extends AbstractFormPlugin
implements TrainCommonMethod {
    private static final Log log = LogFactory.getLog(MyCoursePlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        TrainCourseUtils.updateRoleUserMap();
    }

    public void afterCreateNewData(EventObject e) {
        this.invokeCloudCheck((IFormPlugin)this, "loadPageData");
    }

    @Override
    public Map<String, Supplier<String>> getExecMap() {
        HashMap<String, Supplier<String>> execMap = new HashMap<String, Supplier<String>>(16);
        execMap.put("loadPageData", this::updateAndLoadPageData);
        return execMap;
    }

    private String updateAndLoadPageData() {
        List<Long> courseListIds = TrainCourseUtils.getOwnCourseLists();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        LearnRecordUpdateTask learnRecordUpdateTask = new LearnRecordUpdateTask(courseListIds, 0L, countDownLatch);
        TrainThreadUtils.submit(learnRecordUpdateTask);
        boolean isNotTimeOut = true;
        try {
            isNotTimeOut = countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            log.error("learnRecordUpdateTask_init_error", (Throwable)ex);
        }
        this.loadPageData(() -> courseListIds);
        if (!isNotTimeOut) {
            log.error("learnRecordUpdateTask_init_timeOut");
        }
        return null;
    }

    private void loadPageData() {
        this.loadPageData(TrainCourseUtils::getOwnCourseLists);
    }

    private void loadPageData(Supplier<List<Long>> courseListIds) {
        this.updateFrontData("course", this.getMyCourse(courseListIds));
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        String[] split = eventName.split("_");
        if ("viewCourse".equals(split[0])) {
            this.viewCourse(eventArgs);
        } else if ("updateCourseStatus".equals(split[0])) {
            JSONObject args = JSONObject.parseObject((String)eventArgs);
            Integer statusIndex = args.getInteger("status");
            String courseId = args.getString("courseId");
            if (statusIndex == null || statusIndex == 0 || StringUtils.isEmpty((String)courseId)) {
                return;
            }
            String status = statusIndex == 1 ? "complete" : "learning";
            QFilter qFilter = new QFilter("videoid", "=", (Object)courseId);
            String courseListId = args.getString("courseListId");
            QFilter listQFilter = new QFilter("courselistid", "=", (Object)courseListId);
            DynamicObject courseList = QueryServiceHelper.queryOne((String)"ricc_courselist", (String)"id", (QFilter[])listQFilter.toArray());
            if (courseList != null) {
                qFilter.and("courselist", "=", (Object)courseList.getLong("id"));
            }
            DynamicObjectCollection courses = QueryServiceHelper.query((String)"ricc_course", (String)"id", (QFilter[])qFilter.toArray());
            courses.forEach(k -> TrainCourseUtils.updateCourseStatus(k.getLong("id"), UserServiceHelper.getCurrentUserId(), status));
        }
    }

    private void viewCourse(String eventArgs) {
        JSONObject args = JSONObject.parseObject((String)eventArgs);
        String classId = args.getString("classId");
        QFilter qFilter = new QFilter("courseid", "=", (Object)classId);
        DynamicObject course = BusinessDataServiceHelper.loadSingle((String)"ricc_course", (QFilter[])qFilter.toArray());
        boolean customizationCourse = TrainCourseUtils.isCustomizationCourse(course);
        if (customizationCourse) {
            String url = course.getString("url");
            this.getView().openUrl(url);
            TrainCourseUtils.updateCustomCourseStatus(course.getLong("id"), UserServiceHelper.getCurrentUserId());
            this.loadPageData();
        } else {
            CustomApiResult<ViewCourse> result = TrainCourseUtils.getViewCourse(course);
            if (!result.isStatus()) {
                this.getView().showErrorNotification(result.getMessage());
                return;
            }
            MyCourse myCourse = this.getMyCourse(TrainCourseUtils::getOwnCourseLists);
            myCourse.setMethod("viewParam");
            myCourse.setSdkArgs((ViewCourse)result.getData());
            this.updateFrontData("course", myCourse);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.dealClosedCallBack(event);
    }

    @Override
    public void dealFailClosedBack(String actionId) {
        if (actionId.startsWith("CloudBinding")) {
            this.putCache("cloudBindingFail", Boolean.TRUE);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Boolean cloudBindingFail = (Boolean)this.getCache("cloudBindingFail", Boolean.class, () -> false);
        if (cloudBindingFail.booleanValue()) {
            return;
        }
        LearnRecordUpdateTask learnRecordUpdateTask = new LearnRecordUpdateTask();
        TrainThreadUtils.submit(learnRecordUpdateTask);
    }

    private MyCourse getMyCourse(Supplier<List<Long>> supplier) {
        MyCourse myCourse = TrainCourseUtils.getCourseFrontData(supplier.get());
        String status = (String)this.getCustomFormParam("status");
        if (StringUtils.isEmpty((String)status)) {
            status = "all";
        }
        myCourse.setRdgroup(status);
        return myCourse;
    }
}

