/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.training.KdCloudUtils;
import kd.sys.ricc.business.training.TrainCommonMethod;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.business.training.TrainRoleUserUtils;

public class TrainCourseAssignListPlugin
extends AbstractListPlugin
implements TrainCommonMethod {
    public void afterCreateNewData(EventObject e) {
        TrainCourseUtils.updateRoleUserMap();
        this.invokeCloudCheck((IFormPlugin)this, "empty");
        this.setGuideText();
    }

    private void setGuideText() {
        this.getModel().setValue("firststep", (Object)ResManager.loadKDString((String)"\u9879\u76ee\u7ecf\u7406\u4e3a\u9879\u76ee\u5b66\u5458\u7ef4\u62a4\u9700\u8981\u5b66\u4e60\u7684\u8bfe\u7a0b\u6e05\u5355\uff0c\u70b9\u51fb\u201c\u8bfe\u7a0b\u7ef4\u62a4\u201d\u524d\u5f80\u91d1\u8776\u4e91\u793e\u533a\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"TrainCourseAssignListPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.getModel().setValue("secondstep", (Object)ResManager.loadKDString((String)"\u8bfe\u7a0b\u6e05\u5355\u5728\u91d1\u8776\u4e91\u793e\u533a\u7ef4\u62a4\u5b8c\u6210\u540e\uff0c\u70b9\u51fb\u201c\u540c\u6b65\u8bfe\u7a0b\u201d\u5c06\u8bfe\u7a0b\u6e05\u5355\u540c\u6b65\u5230\u4ea7\u54c1\u7aef\u3002", (String)"TrainCourseAssignListPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.getModel().setValue("thirdstep", (Object)ResManager.loadKDString((String)"\u5c06\u8bfe\u7a0b\u6e05\u5355\u5206\u914d\u7ed9\u9700\u8981\u5b66\u4e60\u7684\u5b66\u5458\u3002", (String)"TrainCourseAssignListPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.getModel().setValue("fourthstep", (Object)ResManager.loadKDString((String)"\u60a8\u53ef\u4ee5\u5728\u201c\u5b66\u4e60\u8fdb\u5ea6\u201d\u5b9e\u65f6\u8ffd\u8e2a\u5b66\u5458\u72b6\u6001\uff0c\u4fdd\u969c\u9879\u76ee\u63a8\u8fdb\u3002", (String)"TrainCourseAssignListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                List<Object> toSaveRoles = new ArrayList(16);
                for (DynamicObject datum : data) {
                    DynamicObjectCollection trainees = datum.getDynamicObjectCollection("trainee");
                    Set userIds = trainees.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    DynamicObjectCollection roles = datum.getDynamicObjectCollection("role");
                    List roleIds = roles.stream().map(e -> e.getString("fbasedataid_id")).collect(Collectors.toList());
                    List<Long> roleUsers = TrainCourseUtils.getRoleUsers(roleIds, e -> e, toSaveRoles);
                    userIds.addAll(roleUsers);
                    datum.set("total", (Object)userIds.size());
                }
                if ((toSaveRoles = toSaveRoles.stream().distinct().collect(Collectors.toList())).size() != 0) {
                    TrainRoleUserUtils.saveRoleUserMap(toSaveRoles, TrainCourseUtils.getRoleUserMap());
                }
                return data;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newcourse": {
                this.invokeSaveCheck((IFormPlugin)this, "newCourse");
                break;
            }
            case "synccourse": {
                this.invokeSaveCheck((IFormPlugin)this, "syncCourse");
                break;
            }
            case "assigntrainee": {
                this.assignTrainee(false);
                break;
            }
            case "transfer": {
                this.invokeSaveCheck((IFormPlugin)this, "transfer");
                break;
            }
            case "assignrole": {
                this.assignRole(false);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "name": {
                args.setCancel(true);
                this.viewCourseDetail();
                break;
            }
            case "traineecount": {
                args.setCancel(true);
                this.checkPermission("ricc_courseassign", "assigntrainee");
                this.assignTrainee(true);
                break;
            }
            case "role_name": {
                args.setCancel(true);
                this.checkPermission("ricc_courseassign", "assigntrainee");
                this.assignRole(true);
                break;
            }
            case "total": {
                args.setCancel(true);
                this.viewUserList();
                break;
            }
        }
    }

    private void viewUserList() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_assigntraineedetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("assignId", this.getFocusRowPkId());
        this.getView().showForm(showParameter);
    }

    private void viewCourseDetail() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("ricc_course");
        showParameter.setFormId("ricc_courselistf7");
        showParameter.setF7Style(0);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        DynamicObject assign = BusinessDataServiceHelper.loadSingle((Object)this.getFocusRowPkId(), (String)"ricc_courseassign");
        DynamicObject list = assign.getDynamicObject("courselist");
        Long listId = list.getLong("id");
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("courselist", "=", (Object)listId));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void assignTrainee(boolean isSingle) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("bos_user");
        para.setFormId("bos_usertreelistf7");
        para.setF7Style(0);
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(styleCss);
        para.setLookUp(true);
        para.setMultiSelect(true);
        para.setShowTitle(false);
        para.setCustomParam("skipCheckSelectRows", (Object)true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assign_" + (isSingle ? "single" : "mul")));
        ListFilterParameter listFilterParameter = para.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("isforbidden", "=", (Object)"0"));
        qFilters.add(new QFilter("id", "not in", Arrays.asList(1L, 2L, 10L, 3L)));
        qFilters.add(new QFilter("usertypes.fbasedataid.category", "=", (Object)"1"));
        qFilters.add(new QFilter("entryentity.ispartjob", "=", (Object)"0").or(QFilter.emptyOrNotExists((String)"entryentity.dpt.number")));
        if (isSingle) {
            DynamicObject assign = BusinessDataServiceHelper.loadSingle((Object)this.getFocusRowPkId(), (String)"ricc_courseassign");
            DynamicObjectCollection trainees = assign.getDynamicObjectCollection("trainee");
            para.setSelectedRows(trainees.stream().map(e -> e.getLong("fbasedataid_id")).toArray());
        }
        this.getView().showForm((FormShowParameter)para);
    }

    private void assignRole(boolean isSingle) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("perm_role");
        para.setFormId("bos_templatetreelistf7");
        para.setF7Style(0);
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(styleCss);
        para.setLookUp(true);
        para.setMultiSelect(true);
        para.setShowTitle(false);
        ListFilterParameter listFilterParameter = para.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("enable", "=", (Object)"1"));
        para.setCustomParam("skipCheckSelectRows", (Object)true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assignRole_" + (isSingle ? "single" : "mul")));
        if (isSingle) {
            DynamicObject assign = BusinessDataServiceHelper.loadSingle((Object)this.getFocusRowPkId(), (String)"ricc_courseassign");
            DynamicObjectCollection roles = assign.getDynamicObjectCollection("role");
            para.setSelectedRows(roles.stream().map(e -> e.getString("fbasedataid_id")).toArray());
        }
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        String[] split = actionId.split("#");
        if ("CloudBinding".equals(split[0])) {
            this.dealClosedCallBack(event);
        }
        if ((returnData = event.getReturnData()) == null) {
            return;
        }
        switch (actionId) {
            case "assign_mul": {
                TrainCourseUtils.addTrainees(returnData, this.getSelectedRows());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TrainCourseAssignListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.refreshList();
                break;
            }
            case "assign_single": {
                TrainCourseUtils.updateTrainees(returnData, this.getFocusRowPkId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TrainCourseAssignListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.refreshList();
                break;
            }
            case "transferPerm": {
                this.dealTransferClose(returnData);
                break;
            }
            case "assignRole_mul": {
                TrainCourseUtils.addRoles(returnData, this.getSelectedRows());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TrainCourseAssignListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.refreshList();
                break;
            }
            case "assignRole_single": {
                TrainCourseUtils.updateRoles(returnData, this.getFocusRowPkId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TrainCourseAssignListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.refreshList();
                break;
            }
        }
    }

    private void dealTransferClose(Object retData) {
        if (retData == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)retData;
        if (rows.size() == 0) {
            return;
        }
        ListSelectedRow selectedRow = rows.get(0);
        Long userId = (Long)selectedRow.getPrimaryKeyValue();
        String kdCloudUId = KdCloudUtils.getKdCloudUId(userId);
        CustomApiResult<String> result = TrainCourseUtils.transferPerm(kdCloudUId);
        if (result.isStatus()) {
            this.getView().showSuccessNotification((String)result.getData());
        } else {
            this.dealTrainResultError(result);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Cancel == result) {
            return;
        }
        String callBackId = event.getCallBackId();
        if (!callBackId.startsWith("transfer")) {
            return;
        }
        List<Long> bindingCloudUserIds = KdCloudUtils.getBindingCloudUserIds();
        this.transferPerm(bindingCloudUserIds);
    }

    @Override
    public Map<String, Supplier<String>> getExecMap() {
        HashMap<String, Supplier<String>> execMap = new HashMap<String, Supplier<String>>(16);
        execMap.put("newCourse", this::newCourse);
        execMap.put("syncCourse", this::syncCourseList);
        execMap.put("transfer", this::transfer);
        return execMap;
    }

    private String newCourse() {
        this.getView().openUrl(TrainCourseUtils.skipLearnListPage());
        return null;
    }

    private String syncCourseList() {
        CustomApiResult<String> result = TrainCourseUtils.syncCourseList();
        this.refreshList();
        if (result.isStatus()) {
            this.getView().showSuccessNotification((String)result.getData());
        } else {
            this.dealTrainResultError(result);
        }
        return result.getMessage();
    }

    private void dealTrainResultError(CustomApiResult<String> result) {
        if (result.isStatus()) {
            return;
        }
        String errorCode = result.getErrorCode();
        if (!"409".equals(errorCode)) {
            this.getView().showErrorNotification(result.getMessage());
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u5bc6\u94a5\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5bc6\u94a5\u3002", (String)"TrainCourseAssignListPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.showSaveCheckPage((IFormPlugin)this, "empty");
    }

    private String transfer() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6743\u9650\u79fb\u4ea4\u540e\uff0c\u63a5\u6536\u65b9\u5c06\u83b7\u5f97\u5f53\u524d\u79df\u6237\u8bfe\u7a0b\u7684\u5b8c\u6574\u7ba1\u7406\u6743\u9650\uff0c\u4e14\u60a8\u5c06\u4e0d\u518d\u7528\u4e8e\u7ba1\u7406\u6743\u9650\uff0c\u786e\u5b9a\u79fb\u4ea4\u5417\uff1f", (String)"TrainCourseAssignListPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("transfer", (IFormPlugin)this));
        return null;
    }

    private void transferPerm(List<Long> bindingCloudUserIds) {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("bos_user");
        para.setFormId("bos_usertreelistf7");
        para.setF7Style(0);
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(styleCss);
        para.setLookUp(true);
        para.setMultiSelect(false);
        para.setShowTitle(false);
        para.setCustomParam("skipCheckSelectRows", (Object)true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "transferPerm"));
        ListFilterParameter listFilterParameter = para.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("id", "in", bindingCloudUserIds));
        this.getView().showForm((FormShowParameter)para);
    }

    @Override
    public void dealFailClosedBack(String actionId) {
        if (actionId.startsWith("CloudBinding#")) {
            this.getView().close();
        }
    }
}

