/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.common.entity.ViewCourse;

public class TrainCourseListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        int rowIndex = args.getRowIndex();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Optional<ListSelectedRow> optional = selectedRows.stream().filter(e -> e.getRowKey() == rowIndex).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        args.setCancel(true);
        ListSelectedRow selectedRow = optional.get();
        Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
        DynamicObject course = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"ricc_course");
        if (TrainCourseUtils.isCustomizationCourse(course)) {
            this.getView().openUrl(course.getString("url"));
            return;
        }
        CustomApiResult<ViewCourse> result = TrainCourseUtils.getViewCourse(course);
        if (!result.isStatus()) {
            this.getView().showErrorNotification(result.getMessage());
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_viewcourse");
        showParameter.setShowClose(false);
        showParameter.setCustomParam("courseId", primaryKeyValue);
        showParameter.setCustomParam("viewCourse", (Object)JSON.toJSONString((Object)result.getData()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                Map courseMap = BusinessDataServiceHelper.loadFromCache((Object[])data.stream().map(DataEntityBase::getPkValue).toArray(), (String)"ricc_course");
                for (DynamicObject datum : data) {
                    String type = datum.getString("type");
                    Object pkValue = datum.getPkValue();
                    DynamicObject course = (DynamicObject)courseMap.get(pkValue);
                    if (TrainCourseUtils.isCustomizationCourse(course)) {
                        type = "customization";
                        datum.set("type", (Object)type);
                    }
                    String time = datum.getString("time");
                    datum.set("time", (Object)TrainCourseUtils.getCourseTime(type, time));
                }
                return data;
            }
        });
    }
}

