/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.opplugin;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.common.enums.CompareStatusEnum;
import kd.sys.ricc.common.helper.DataCompareHelper;
import kd.sys.ricc.common.util.StringUtils;

public class DataCompareExecuteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String tip = null;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection entryData;
                    String enable;
                    Object billPkId = dataEntity.getBillPkId();
                    String number = dataEntity.getBillNo();
                    if (!DataCompareHelper.existCompareTask(billPkId)) {
                        tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%s\u3011\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u6b63\u5728\u6267\u884c\u6570\u636e\u5bf9\u6bd4\uff0c\u8bf7\u7b49\u5f85\uff0c\u6216\u65b0\u589e\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u518d\u6267\u884c\u5bf9\u6bd4\u3002", (String)"DataCompareExecuteOp_0", (String)"sys-ricc-platform", (Object[])new Object[]{number});
                        this.addErrorMessage(dataEntity, tip);
                    }
                    if ("0".equals(enable = (String)dataEntity.getValue("enable"))) {
                        tip = ResManager.loadKDString((String)"\u6267\u884c\u5bf9\u6bd4\u5931\u8d25\uff0c\u7981\u7528\u7684\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u4e0d\u5141\u8bb8\u6267\u884c\u5bf9\u6bd4\uff0c\u82e5\u8981\u5bf9\u6bd4\u8bf7\u5148\u542f\u7528\u8be5\u5bf9\u6bd4\u65b9\u6848\u3002", (String)"DataCompareExecuteOp_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, tip);
                    }
                    String compareType = (String)dataEntity.getValue("comparetype");
                    DynamicObject desAccountObj = (DynamicObject)dataEntity.getValue("targetdatacenter");
                    if (StringUtils.equals((String)compareType, (String)"item") && desAccountObj == null) {
                        tip = ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u3002", (String)"DataCompareExecuteOp_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, tip);
                    }
                    if ((entryData = (DynamicObjectCollection)dataEntity.getValue("ricc_compare_entry")).isEmpty()) {
                        tip = ResManager.loadKDString((String)"\u5bf9\u6bd4\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u5bf9\u8c61\u7684\u914d\u7f6e\u4fe1\u606f\u5728\u5bf9\u6bd4\u3002", (String)"DataCompareExecuteOp_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    } else if (StringUtils.equals((String)compareType, (String)"item") && !DataCompareExecuteOp.this.existDataCheck(entryData)) {
                        tip = ResManager.loadKDString((String)"\u9009\u62e9\u8fdb\u884c\u5bf9\u6bd4\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DataCompareExecuteOp_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)tip)) continue;
                    this.addErrorMessage(dataEntity, tip);
                }
            }
        });
    }

    private boolean existDataCheck(DynamicObjectCollection packEntity) {
        for (DynamicObject row : packEntity) {
            List pksList;
            String dataStore;
            String dataSelection;
            DynamicObject item = (DynamicObject)row.get("itemid");
            if (item == null) {
                return false;
            }
            String entityNumber = ConfigItemHelper.getEntityNumber(item.getPkValue());
            QFilter dataFilter = DataCompareHelper.getEntryRowFilters(entityNumber, dataSelection = row.getString("dataselection"), dataStore = row.getString("datastore_tag"));
            if (dataFilter == null || !(pksList = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])dataFilter.toArray(), null, (int)-1)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, String> customParam = new HashMap<String, String>(2);
        for (DynamicObject dataEntity : dataEntities) {
            int batchCount = (Integer)dataEntity.get("batchcount");
            String tarCenterType = (String)dataEntity.get("tarcentertype");
            DynamicObject desAccountObj = (DynamicObject)dataEntity.get("targetdatacenter");
            long destAccountPk = desAccountObj == null ? 0L : (Long)desAccountObj.getPkValue();
            String targetCenterUser = (String)dataEntity.get("targetdatacenteruser");
            Object isIgnoreCreateInfo = dataEntity.get("isignorecreateinfo");
            Object isIgnoreKey = dataEntity.get("isignorekey");
            Object isIgnoreBdId = dataEntity.get("isignorebdid");
            Object isIgnoreMultilingual = dataEntity.get("isignoremultilingual");
            String compareType = (String)dataEntity.get("comparetype");
            DynamicObject dataPacket = (DynamicObject)dataEntity.get("datapacket");
            String dataComparePlanNumber = (String)dataEntity.get("number");
            QFilter idFilter = new QFilter("number", "=", (Object)dataComparePlanNumber);
            DynamicObject dataComparePlan = BusinessDataServiceHelper.loadSingleFromCache((String)"ricc_datacompare_plan", (QFilter[])idFilter.toArray());
            DynamicObject dataCompareRpt = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datacompare_rpt");
            long dataCompareRptId = DB.genLongId((String)"t_ricc_datacompare_rpt");
            dataCompareRpt.set("id", (Object)dataCompareRptId);
            String readNumber = CodeRuleServiceHelper.getNumber((String)"ricc_datacompare_rpt", (DynamicObject)dataCompareRpt, null);
            dataCompareRpt.set("billno", (Object)readNumber);
            dataCompareRpt.set("comparetype", (Object)compareType);
            dataCompareRpt.set("datapacket_id", dataPacket == null ? Integer.valueOf(0) : dataPacket.getPkValue());
            dataCompareRpt.set("tarcentertype", (Object)tarCenterType);
            dataCompareRpt.set("targetdatacenter_id", (Object)destAccountPk);
            dataCompareRpt.set("targetdatacenteruser", (Object)targetCenterUser);
            dataCompareRpt.set("comparestatus", (Object)CompareStatusEnum.BEGINNING.getVal());
            dataCompareRpt.set("datacompareplan", dataComparePlan.getPkValue());
            dataCompareRpt.set("isignorecreateinfo", isIgnoreCreateInfo);
            dataCompareRpt.set("isignorekey", isIgnoreKey);
            dataCompareRpt.set("isignorebdid", isIgnoreBdId);
            dataCompareRpt.set("isignoremultilingual", isIgnoreMultilingual);
            dataCompareRpt.set("batchcount", (Object)batchCount);
            dataCompareRpt.set("creator_id", (Object)UserServiceHelper.getCurrentUserId());
            SaveServiceHelper.saveOperate((String)"ricc_datacompare_rpt", (DynamicObject[])new DynamicObject[]{dataCompareRpt}, (OperateOption)OperateOption.create());
            customParam.put("rptId", String.valueOf(dataCompareRptId));
            this.getOperationResult().setCustomData(customParam);
        }
    }
}

