/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.opplugin;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.util.StringUtils;

public class PacketManageOp
extends AbstractOperationServicePlugIn {
    private static final String DATASOURCE = "datasource";
    private static final String SYNC_STATE = "syncstate";
    private static final String DL_TR_COUNT = "dltrcount";
    private static final String LOCKED_STATUS = "lockedstatus";
    private static final String SUB_DATA_PACKET = "subdatapacket";
    private static final String ENTRY_STATUS = "entrystatus";
    private static final String OP_DELETE = "delete";
    private static final String OP_SAVE = "save";
    private static final String OP_AUDIT = "audit";
    private static final String UN_AUDIT = "unaudit";
    private static final String OP_SUBMIT = "submit";
    private static final String AUDITOR = "auditor";
    private static final String AUDITDATE = "auditdate";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(DATASOURCE);
        e.getFieldKeys().add(SYNC_STATE);
        e.getFieldKeys().add(DL_TR_COUNT);
        e.getFieldKeys().add(LOCKED_STATUS);
        e.getFieldKeys().add(SUB_DATA_PACKET);
        e.getFieldKeys().add(ENTRY_STATUS);
        e.getFieldKeys().add(AUDITOR);
        e.getFieldKeys().add(AUDITDATE);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operationKey = this.getOperateKey();
                ExtendedDataEntity[] entities = this.getDataEntities();
                if (StringUtils.equals((String)PacketManageOp.OP_SAVE, (String)operationKey)) {
                    this.saveValidate(entities);
                } else if (StringUtils.equals((String)PacketManageOp.OP_SUBMIT, (String)operationKey)) {
                    this.submitValidate(entities);
                }
            }

            private void saveValidate(ExtendedDataEntity[] entities) {
                Map variables = this.getOption().getVariables();
                boolean isDownload = variables.containsKey("downloadAndTransfer");
                boolean sync = variables.containsKey("sync");
                if (isDownload || sync) {
                    return;
                }
                for (ExtendedDataEntity entity : entities) {
                    String datasource = (String)entity.getValue(PacketManageOp.DATASOURCE);
                    boolean isNew = StringUtils.equals((String)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal(), (String)datasource);
                    if (isNew) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ec5\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u5141\u8bb8\u4fee\u6539\u3002", (String)"PacketManageOp_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
            }

            public void submitValidate(ExtendedDataEntity[] entities) {
                int invalidSonPacket = 0;
                for (ExtendedDataEntity dataEntity : entities) {
                    DynamicObjectCollection subDataPacket = (DynamicObjectCollection)dataEntity.getValue(PacketManageOp.SUB_DATA_PACKET);
                    int entrySize = subDataPacket.size();
                    for (DynamicObject entryRow : subDataPacket) {
                        String entryStatus = entryRow.getString(PacketManageOp.ENTRY_STATUS);
                        if (!StringUtils.equals((String)PacketEntryStatusEnum.INVALID.getVal(), (String)entryStatus) || ++invalidSonPacket != entrySize) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4f20\u8f93\u5305\u5185\u6240\u6709\u5b50\u4f20\u8f93\u5305\u5df2\u4f5c\u5e9f\uff0c\u8bf7\u6dfb\u52a0\u5b50\u4f20\u8f93\u5305\u3002", (String)"PacketManageOp_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((String)OP_DELETE, (String)operationKey)) {
            ArrayList<Object> objectsPkValue = new ArrayList<Object>(10);
            DynamicObject[] dynamicObjectArray = dataEntities;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dataEntity = dynamicObjectArray[i];
                objectsPkValue.add(dataEntity.getPkValue());
            }
            QFilter qFilter = new QFilter("packet", "in", objectsPkValue);
            DeleteServiceHelper.delete((String)"ricc_log", (QFilter[])qFilter.toArray());
        }
        if (StringUtils.equals((String)OP_AUDIT, (String)operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                long currentUserId = UserServiceHelper.getCurrentUserId();
                long auditTime = System.currentTimeMillis();
                dataEntity.set(AUDITOR, (Object)currentUserId);
                dataEntity.set(AUDITDATE, (Object)auditTime);
            }
        }
        if (StringUtils.equals((String)UN_AUDIT, (String)operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set(AUDITOR, null);
                dataEntity.set(AUDITDATE, null);
            }
        }
    }
}

