/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.sys.ricc.common.util.StringUtils;

public class SchemeConfigSaveOp
extends AbstractOperationServicePlugIn {
    private static final String SERVER_IP = "server_ip";
    private static final String SERVER_PORT = "server_port";
    private static final char PORT_SPLIT = ':';
    private static final String PROTOCAL_SPLIT = "://";
    private static final char WEB_APP_SPLIT = '/';
    private static final String EVNURL = "evnurl";
    private static final String OP_BEGININIT = "begininit";
    private static final String INIT_STATUS = "init_status";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(EVNURL);
        e.getFieldKeys().add(SERVER_IP);
        e.getFieldKeys().add(SERVER_PORT);
        e.getFieldKeys().add("webapp");
        e.getFieldKeys().add("httpprotocal");
        e.getFieldKeys().add(INIT_STATUS);
        e.getFieldKeys().add("entryentity");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        if (StringUtils.equals((String)OP_BEGININIT, (String)operationKey)) {
            for (DynamicObject dyo : entities) {
                dyo.set(INIT_STATUS, (Object)2);
                this.clearTaskData(dyo);
                this.setEvnUrlInfo(dyo);
            }
        }
    }

    private void clearTaskData(DynamicObject dyo) {
        DynamicObjectCollection subTasks = dyo.getDynamicObjectCollection("entryentity");
        for (DynamicObject subTask : subTasks) {
            subTask.set("taskStatus", (Object)1);
            subTask.set("impledetails_tag", (Object)"");
            subTask.set("starttime", null);
            subTask.set("endtime", null);
            subTask.set("usedtimes", null);
            subTask.set("progress", (Object)0);
        }
    }

    private void setEvnUrlInfo(DynamicObject dyo) {
        DynamicObject connectionEnv = dyo.getDynamicObject("connectionenv");
        String evnUrl = connectionEnv.getString(EVNURL);
        String appSecret = connectionEnv.getString("appsecuret");
        dyo.set("appsecret", (Object)appSecret);
        String url = evnUrl.trim();
        dyo.set(EVNURL, (Object)url);
        String httpDeal = url.split(PROTOCAL_SPLIT)[0];
        dyo.set("httpprotocal", (Object)httpDeal);
        String ip = "";
        String port = "";
        String webApp = "";
        url = url.split(PROTOCAL_SPLIT)[1];
        StringBuilder temp = new StringBuilder();
        block4: for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            switch (c) {
                case ':': {
                    ip = temp.toString();
                    temp.delete(0, temp.length());
                    continue block4;
                }
                case '/': {
                    if ("".equals(ip)) {
                        ip = temp.toString();
                    } else if (url.indexOf(58) >= 0 && "".equals(port)) {
                        port = temp.toString();
                    } else {
                        webApp = temp.toString();
                    }
                    temp.delete(0, temp.length());
                    continue block4;
                }
                default: {
                    temp.append(c);
                }
            }
        }
        if ("".equals(ip)) {
            ip = temp.toString();
        } else if (StringUtils.isNumeric((CharSequence)temp) && "".equals(port)) {
            port = temp.toString();
        } else if ("".equals(webApp) && temp.indexOf(".") < 0 && temp.indexOf("?") < 0 && temp.indexOf("&") < 0) {
            webApp = temp.toString();
        }
        dyo.set(SERVER_IP, (Object)ip);
        dyo.set(SERVER_PORT, (Object)(StringUtils.isEmpty((String)port) ? 0 : Integer.parseInt(port)));
        dyo.set("webapp", StringUtils.isEmpty((String)webApp) ? null : '/' + webApp);
    }
}

