/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.master.helper.MaterialServiceHelper;
import kd.bd.master.validator.MasterDataSaveValidator;
import kd.bd.master.vo.ErrorEntity;
import kd.bd.master.vo.MaterialReturnVo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialSaveValidator
extends MasterDataSaveValidator {
    public static final String NEW_NULL_FID = "0";
    private MaterialServiceHelper materialServiceHelper = new MaterialServiceHelper();

    public MaterialSaveValidator() {
        this.setEntityKey("bd_material");
    }

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("serviceattribute");
        propertys.add("serviceattribute.entity");
        return propertys;
    }

    public void validate() {
        Throwable throwable;
        TraceSpan span;
        DynamicObject param = BusinessDataServiceHelper.loadSingle((String)"bd_materialbgparam", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L)});
        if (param != null && !param.getBoolean("references")) {
            span = Tracer.create((String)"MaterialSaveValidator", (String)"checkUnitconvert");
            throwable = null;
            try {
                this.checkUnitconvert(this.dataEntities);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span != null) {
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        span = Tracer.create((String)"MaterialSaveValidator", (String)"checkGroupNew");
        throwable = null;
        try {
            Set groupIds = this.checkGroupEffective(this.dataEntities);
            this.checkGroupNew(this.dataEntities, groupIds);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (span != null) {
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    span.close();
                }
            }
        }
        span = Tracer.create((String)"MaterialSaveValidator", (String)"checkAuxptyUnit");
        throwable = null;
        try {
            block27: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkAuxptyUnit(dataEntity);
                this.checkAuxPtyEntry(dataEntity);
                DynamicObjectCollection serviceattributes = dataEntity.getDataEntity().getDynamicObjectCollection("serviceattribute");
                if (serviceattributes == null || serviceattributes.size() <= 0) continue;
                for (DynamicObject dyn : serviceattributes) {
                    DynamicObject basedata = dyn.getDynamicObject("fbasedataid");
                    if (basedata == null || basedata.getDynamicObject("entity") == null || "bd_material".equals(basedata.getDynamicObject("entity").getString("number"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u5bfc\u5165\u7684\u4e1a\u52a1\u5c5e\u6027\u5173\u8054\u5b9e\u4f53\u7c7b\u578b\u9700\u8981\u662f\u7269\u6599\u7c7b\u578b", (String)"MaterialSaveValidator_9", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    continue block27;
                }
            }
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (span != null) {
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private void checkAuxPtyEntry(ExtendedDataEntity dataEntity) {
        DynamicObject material = dataEntity.getDataEntity();
        boolean isUseAuxPty = material.getBoolean("isuseauxpty");
        DynamicObjectCollection auxPtyEntry = material.getDynamicObjectCollection("auxptyentry");
        if (isUseAuxPty && auxPtyEntry.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"MaterialSaveValidator_8", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkAuxptyUnit(ExtendedDataEntity dataEntity) {
        Object auxptyunit = dataEntity.getDataEntity().get("auxptyunit");
        Long auxptyunitId = 0L;
        if (auxptyunit instanceof DynamicObject) {
            auxptyunitId = Long.parseLong(((DynamicObject)auxptyunit).getPkValue().toString());
        } else if (auxptyunit instanceof Long) {
            auxptyunitId = (Long)auxptyunit;
        }
        if (auxptyunitId == 0L) {
            return;
        }
        Long baseunitId = 0L;
        Object baseunit = dataEntity.getDataEntity().get("baseunit");
        if (baseunit instanceof DynamicObject) {
            baseunitId = Long.parseLong(((DynamicObject)baseunit).getPkValue().toString());
        } else if (baseunit instanceof Long) {
            baseunitId = (Long)baseunit;
        }
        Set desmulist = this.materialServiceHelper.getFixedonversionList(dataEntity.getDataEntity());
        desmulist.add(baseunitId);
        if (desmulist.contains(auxptyunitId)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5355\u4f4d\u548c\u57fa\u672c\u5355\u4f4d\u4e0d\u80fd\u5b58\u5728\u56fa\u5b9a\u6362\u7b97\u5173\u7cfb\u3002", (String)"MaterialSaveValidator_6", (String)"bd-master-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkUnitconvert(ExtendedDataEntity[] dataEntitys) {
        ArrayList<String> ignoreRefEntityIds = new ArrayList<String>();
        ignoreRefEntityIds.add("bd_multimeasureunit");
        ignoreRefEntityIds.add("bd_materialgroupdetail");
        ArrayList<String> checkRefEntityIds = new ArrayList<String>();
        checkRefEntityIds.add("bd_configuredcode");
        boolean isOpenPrecision = MaterialServiceHelper.getPrecisionProperty();
        String entityNumber = "";
        HashSet<Object> materialIds = new HashSet<Object>();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            Object materialId;
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                entityNumber = dataEntity.getDataEntity().getDataEntityType().getName();
            }
            if (!dataEntity.getDataEntity().getDataEntityState().getFromDatabase() || StringUtils.isBlank((Object)(materialId = dataEntity.getDataEntity().getPkValue())) || NEW_NULL_FID.equals(materialId.toString())) continue;
            materialIds.add(materialId);
            if (!isOpenPrecision) continue;
            List errormsgs = this.materialServiceHelper.checkUnitconvertPrecision(dataEntity);
            for (String errormsg : errormsgs) {
                this.addMessage(dataEntity, errormsg);
            }
        }
        MaterialReturnVo materialReturnVo = this.materialServiceHelper.dataModifyVerification(materialIds, dataEntitys);
        List errors = this.materialServiceHelper.checkReferences(materialReturnVo.getMaterialIds(), dataEntitys, entityNumber, ignoreRefEntityIds);
        List configuredcodeErrors = this.materialServiceHelper.checkConfiguredcodeReferences(materialReturnVo.getConfiguredcodeMaterialIds(), dataEntitys, entityNumber, checkRefEntityIds);
        List suiteErrors = this.materialServiceHelper.checkSuiteReferences(materialReturnVo.getSuitChangeMaterialIds(), materialReturnVo.getMaterialTypeIds(), dataEntitys, entityNumber, ignoreRefEntityIds);
        List IsuseauxptyErrors = this.materialServiceHelper.checkIsuseauxptyReferences(materialReturnVo.getIsuseauxptyChangeMaterialIds(), dataEntitys, entityNumber, ignoreRefEntityIds);
        if (configuredcodeErrors.size() > 0) {
            errors.addAll(configuredcodeErrors);
        }
        if (suiteErrors.size() > 0) {
            errors.addAll(suiteErrors);
        }
        if (IsuseauxptyErrors.size() > 0) {
            errors.addAll(IsuseauxptyErrors);
        }
        for (ErrorEntity error : errors) {
            List errmsgs = error.getErrmsgs();
            for (String errmsg : errmsgs) {
                this.addMessage(error.getExtendedDataEntity(), errmsg);
            }
        }
    }
}

