/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.list.GroupStandardListPlugin;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class GroupTreePlugin
extends AbstractListPlugin
implements TreeNodeQueryListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(GroupTreePlugin.class);
    private static final String GROUP_TREE = "grouptree";
    private static final String ROOTNODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String ENTITY_GROUP = "group";
    public static final String ENTITY_GROUPDETAIL = "groupdetail";
    public static final String PROP_STANDARD = "standard";
    public static final String PROP_ID = "id";
    public static final String PROP_GROUP = "group";
    public static final String PROP_CUSTOMER = "customer";
    public static final String PROP_SUPPLIER = "supplier";
    public static final String PROP_MATERIAL = "material";
    public static final String ENTITY_GROUPSTANDARD = "groupstandard";
    public static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "1";
    public static final String PGCACHE_CREATEORG = "createOrg";
    public static final String PGCACHE_CREATEORGS = "createOrgs";
    public static final String PGCACHE_PARENTCREATEORG = "orgs";
    public static final String TEXTFORMAT_NAME = "{name}";
    public static final String TEXTFORMAT_CODE = "{code}";
    public static TreeNode rootNode;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void initialize() {
        TreeView tree = (TreeView)this.getControl(GROUP_TREE);
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void afterBindData(EventObject e) {
        this.initTree();
    }

    public void afterCreateNewData(EventObject e) {
        this.initStandardlst();
    }

    private void initStandardlst() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List<Map<String, Object>> orgList = this.getComData(customParams);
        this.setComboEdit(orgList);
        String standard = (String)customParams.get(PROP_STANDARD);
        this.getModel().setValue(PROP_STANDARDLST, (Object)standard);
    }

    private List<Map<String, Object>> getComData(Map<String, Object> customParams) {
        String createOrg = (String)customParams.get(PGCACHE_CREATEORG);
        String entity = (String)customParams.get("entity");
        Set<Long> groupStandard = new HashSet<Long>();
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            if (entity.startsWith("bd_supplier")) {
                groupStandard.add(716529547008326656L);
            } else if (entity.startsWith("bd_customer")) {
                groupStandard.add(712984405228187648L);
            } else if (entity.startsWith("bd_material")) {
                groupStandard.add(730148448254487552L);
            }
        } else {
            groupStandard = GroupStandardUtils.getGroupStandard((String)entity, (Long)Long.valueOf(createOrg), (boolean)true, null);
        }
        QFilter idFilter = new QFilter(PROP_ID, "in", groupStandard);
        QFilter[] filters = new QFilter[]{idFilter};
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)(entity + ENTITY_GROUPSTANDARD), (String)"id,number,name", (QFilter[])filters);
        if (bizMap == null || bizMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> listStandard = new ArrayList<Map<String, Object>>(bizMap.size());
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject dyStandard = (DynamicObject)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PROP_ID, dyStandard.get(PROP_ID).toString());
            map.put("name", dyStandard.get("name").toString());
            listStandard.add(map);
        }
        return listStandard;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView tree = (TreeView)this.getView().getControl(GROUP_TREE);
            tree.deleteAllNodes();
            this.initTree();
        }
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private void setComboEdit(List<Map<String, Object>> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    private Map<String, LocaleString> setComboItems(List<Map<String, Object>> orgModelList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>();
        if (orgModelList != null) {
            for (Map<String, Object> map : orgModelList) {
                String id = (String)map.get(PROP_ID);
                String fName = (String)map.get("name");
                comboItems.put(id, new LocaleString(fName));
            }
        }
        return comboItems;
    }

    public void click(EventObject evt) {
        boolean isParent;
        Control c = (Control)evt.getSource();
        TreeView tree = (TreeView)this.getControl(GROUP_TREE);
        Map map = tree.getTreeState().getFocusNode();
        if (map == null || map.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7ec4\u7c7b", (String)"GroupTreePlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ROOTNODE_ID.equals((String)map.get(PROP_ID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6839\u8282\u70b9", (String)"GroupTreePlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isGroupLastNew = new MasterDataHelper().getGroupNew();
        if (isGroupLastNew && (isParent = ((Boolean)map.get("isParent")).booleanValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"GroupTreePlugin_4", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (c.getKey().toLowerCase()) {
            case "btnsave": {
                this.save((String)map.get(PROP_ID));
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entity = (String)customParams.get("entity");
        HashSet<Long> creatorgs = new HashSet<Long>(1);
        String createOrg = (String)customParams.get(PGCACHE_CREATEORG);
        creatorgs.add(Long.valueOf(createOrg));
        Set groupOrgs = GroupStandardUtils.getGroupOrgId((String)entity, creatorgs);
        String parentId = event.getNodeId().toString();
        if (!ROOTNODE_ID.equals(parentId)) {
            List<Map<String, String>> childNodes = this.queryUserGroup(parentId, groupOrgs);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(childNodes.size());
            for (Map<String, String> map : childNodes) {
                TreeNode groupNode = new TreeNode();
                String id = map.get(PROP_ID);
                String name = map.get("name");
                groupNode.setParentid(parentId);
                groupNode.setId(id);
                groupNode.setText(name);
                List<Map<String, String>> newChildNodes = this.queryUserGroup(id, groupOrgs);
                if (null != newChildNodes && newChildNodes.size() > 0) {
                    groupNode.addChildren(new ArrayList());
                }
                nodes.add(groupNode);
            }
            TreeView tv = (TreeView)event.getSource();
            tv.addNodes(nodes);
        }
    }

    private void initTree() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entity = (String)customParams.get("entity");
        HashSet<Long> creatorgs = new HashSet<Long>(1);
        String createOrg = (String)customParams.get(PGCACHE_CREATEORG);
        creatorgs.add(Long.valueOf(createOrg));
        Set groupOrgs = GroupStandardUtils.getGroupOrgId((String)entity, creatorgs);
        List<Map<String, String>> initData = this.queryUserGroup(ROOTNODE_ID, groupOrgs);
        TreeView tree = (TreeView)this.getView().getControl(GROUP_TREE);
        rootNode = new TreeNode();
        rootNode.setParentid("");
        rootNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GroupTreePlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]));
        rootNode.setId(ROOTNODE_ID);
        rootNode.setIsOpened(true);
        for (Map<String, String> map : initData) {
            TreeNode groupNode = new TreeNode();
            groupNode.setParentid(ROOTNODE_ID);
            groupNode.setId(map.get(PROP_ID));
            groupNode.setText(map.get("name"));
            List<Map<String, String>> newChildNodes = this.queryUserGroup(map.get(PROP_ID), groupOrgs);
            if (null != newChildNodes && newChildNodes.size() > 0) {
                groupNode.addChildren(new ArrayList());
            }
            rootNode.addChild(groupNode);
        }
        tree.addNode(rootNode);
        tree.focusNode(rootNode);
    }

    private List<Map<String, String>> queryUserGroup(String parentId, Set<Long> groupOrgs) {
        if (ROOTNODE_ID.equals(parentId)) {
            parentId = "0";
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entity = (String)customParams.get("entity");
        Object standard = this.getModel().getValue(PROP_STANDARDLST);
        if (StringUtils.isBlank((Object)standard)) {
            standard = customParams.get(PROP_STANDARD);
        }
        QFilter[] qfArr = new QFilter[]{new QFilter("parent", "=", (Object)Long.parseLong(parentId)), new QFilter(PROP_STANDARD, "=", (Object)Long.valueOf(standard.toString())), new QFilter("createorg", "in", groupOrgs), new QFilter("enable", "in", (Object)NO_GROUP)};
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)(entity + "group"), (String)"id,name", (QFilter[])qfArr);
        List groups = loadFromCache.values().stream().sorted((a, b) -> a.getString("number").compareTo(b.getString("number"))).collect(Collectors.toList());
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(loadFromCache.size());
        HashSet<Long> ids = new HashSet<Long>(loadFromCache.size());
        for (DynamicObject group : groups) {
            ids.add(group.getLong(PROP_ID));
        }
        QFilter[] parentQfilter = new QFilter[]{new QFilter("parent", "in", ids), new QFilter(PROP_STANDARD, "in", groupOrgs)};
        Map parents = BusinessDataServiceHelper.loadFromCache((String)(entity + "group"), (String)"parent", (QFilter[])parentQfilter);
        HashSet<Long> parentIds = new HashSet<Long>(parents.size());
        for (DynamicObject group : parents.values()) {
            if (group.getDynamicObject("parent") == null) continue;
            parentIds.add(group.getDynamicObject("parent").getLong(PROP_ID));
        }
        for (DynamicObject group : groups) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PROP_ID, group.getString(PROP_ID));
            map.put("name", group.getString("name"));
            if (parentIds.contains(group.getLong(PROP_ID))) {
                map.put("isLeaf", "false");
            } else {
                map.put("isLeaf", "true");
            }
            list.add(map);
        }
        return list;
    }

    private void save(String nodeId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entity = (String)customParams.get("entity");
        String standard = (String)this.getModel().getValue(PROP_STANDARDLST);
        List dataIds = (List)customParams.get("dataIds");
        List dataStrIds = dataIds.stream().map(id -> id.toString()).collect(Collectors.toList());
        QFilter[] qFilters = null;
        QFilter f2 = null;
        QFilter f1 = new QFilter(PROP_STANDARD, "=", (Object)Long.parseLong(standard));
        String selectfield = "";
        String entityName = "";
        String groupStandardPK = "";
        if (entity.equals("bd_customer")) {
            f2 = new QFilter(PROP_CUSTOMER, "in", (Object)dataIds);
            selectfield = "id,standard,group,customer,createorg";
            entityName = PROP_CUSTOMER;
            groupStandardPK = "712984405228187648";
        } else if (entity.equals("bd_supplier")) {
            f2 = new QFilter(PROP_SUPPLIER, "in", (Object)dataIds);
            selectfield = "id,standard,group,supplier,createorg";
            entityName = PROP_SUPPLIER;
            groupStandardPK = "716529547008326656";
        } else if (entity.equals("bd_material")) {
            f2 = new QFilter(PROP_MATERIAL, "in", (Object)dataIds);
            selectfield = "id,standard,group,material,createorg";
            entityName = PROP_MATERIAL;
            groupStandardPK = "730148448254487552";
        }
        if (groupStandardPK.equals(standard)) {
            DynamicObject[] basedatas;
            for (DynamicObject entitydata : basedatas = BusinessDataServiceHelper.load((String)entity, (String)"id,group", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", (Object)dataIds)})) {
                entitydata.set("group", (Object)nodeId);
            }
            SaveServiceHelper.save((DynamicObject[])basedatas);
        }
        Long groupId = Long.valueOf(nodeId);
        DynamicObject defGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)(entity + "group"), (String)"createorg");
        Long defGroupOrgId = GroupStandardUtils.getDataByType((Object)defGroup.get("createorg"));
        qFilters = new QFilter[]{f1, f2};
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)(entity + ENTITY_GROUPDETAIL), (String)selectfield, (QFilter[])qFilters);
        ArrayList<DynamicObject> standards = new ArrayList<DynamicObject>(datas.length);
        int count = 0;
        for (DynamicObject data : datas) {
            data.set("group", (Object)groupId);
            data.set("createorg", (Object)defGroupOrgId);
            standards.add(data);
            String entityId = String.valueOf(GroupStandardUtils.getDataByType((Object)data.get(entityName)));
            if (dataStrIds.contains(entityId)) {
                dataStrIds.remove(entityId);
            }
            ++count;
        }
        for (String dataId : dataStrIds) {
            DynamicObject entityGroupDetail = BusinessDataServiceHelper.newDynamicObject((String)(entity + ENTITY_GROUPDETAIL));
            entityGroupDetail.set(PROP_STANDARD, (Object)standard);
            entityGroupDetail.set("group", (Object)nodeId);
            entityGroupDetail.set("createorg", (Object)defGroupOrgId);
            entityGroupDetail.set(entityName, (Object)Long.valueOf(dataId));
            standards.add(entityGroupDetail);
        }
        SaveServiceHelper.save((DynamicObject[])standards.toArray(new DynamicObject[0]));
        TreeView tree = (TreeView)this.getView().getParentView().getControl("treeview");
        BillList billList = (BillList)this.getView().getParentView().getControl("billlistap");
        if (tree != null && billList != null) {
            Map map;
            String nodeID;
            if (tree.getTreeState().getFocusNode() == null) {
                tree.focusNode(new TreeNode("", ROOTNODE_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"GroupTreePlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]), true));
            }
            if (!ROOTNODE_ID.equals(nodeID = (String)(map = tree.getTreeState().getFocusNode()).get(PROP_ID))) {
                ORM ormOV = ORM.create();
                QFilter filter1 = new QFilter(PROP_STANDARD, "=", (Object)Long.parseLong(standard));
                if (!NO_GROUP.equals(nodeId) && !ROOTNODE_ID.equals(nodeId)) {
                    List groupIds = GroupStandardUtils.queryGroupsByGroupId((String)entity, (Object)standard, (Object)nodeId);
                    QFilter filter2 = new QFilter("group", "in", (Object)groupIds);
                    qFilters = new QFilter[]{filter1, filter2};
                } else {
                    qFilters = new QFilter[]{filter1};
                }
                HashSet<String> customerSets = new HashSet<String>();
                try (DataSet ds = ormOV.queryDataSet(GroupStandardListPlugin.class.getName(), entity + ENTITY_GROUPDETAIL, selectfield, qFilters);){
                    for (Row row : ds) {
                        if (row.getString(entityName) == null) continue;
                        customerSets.add(row.getString(entityName));
                    }
                }
                QFilter qfilter = null;
                if (!groupStandardPK.equals(standard) || !ROOTNODE_ID.equals(nodeId)) {
                    qfilter = new QFilter(PROP_ID, "in", customerSets);
                }
                billList.getFilterParameter().getQFilters().add(qfilter);
                billList.clearSelection();
            }
        }
        try (TraceSpan span = Tracer.create((String)"GroupTreePlugin", (String)"saveOperLog");){
            this.saveOperLog(entity, count);
        }
        this.getView().getParentView().invokeOperation("refresh");
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"GroupTreePlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private void saveOperLog(String entityName, int count) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizObjID(entityName);
        appLogInfo.setBizAppID("basedata");
        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOpName("batchgroup");
        appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5171\u4fee\u6539\u4e86%s\u6761\u6570\u636e\u3002", (String)"BASEDATA-S-858681", (String)"bd-master-formplugin", (Object[])new Object[]{count}));
        ILogService logSrv = (ILogService)ServiceFactory.getService(ILogService.class);
        logSrv.addLog((AppLogInfo)appLogInfo);
    }

    public void search(SearchEnterEvent paramSearchEnterEvent) {
        List<Object> treeNodes;
        String searchText = paramSearchEnterEvent.getText();
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entity = (String)customParams.get("entity");
        TreeView treeView = (TreeView)this.getControl(GROUP_TREE);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = this.getSearchGroup(searchText, entity);
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"StandardTreeListPlugin_6", (String)"bos-form-core", (Object[])new Object[0]));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    if (indexCache == treeNodes.size()) {
                        indexCache = 0;
                    }
                    this.focusNode(treeView, rootNode, treeNodes.get(indexCache), entity);
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"StandardTreeListPlugin_7", (String)"bos-form-core", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                treeView.treeNodeClick(treeNodes.get(0).getParentid(), treeNodes.get(0).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode, String entity) {
        this.expandParents(treeView, rootNode, treeNode, entity);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node, String entity) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = this.getTreeNode(parentid, entity);
            if (p != null) {
                this.expandParents(treeView, rootNode, p, entity);
                treeView.expand(parentid);
                treeView.updateNode(node);
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    private TreeNode getTreeNode(String parentid, String entity) {
        String groupNumber = GroupStandardHelper.getGroupNumber((String)entity);
        TreeNode treeNode = new TreeNode();
        if (ROOTNODE_ID.equals(parentid)) {
            return rootNode;
        }
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(parentid), (String)groupNumber, (String)"longnumber,parent,name,number");
        List<TreeNode> nodes = this.getChildrenNodes(parentid, entity);
        treeNode.setId(parentid);
        treeNode.setParentid(group.getDynamicObject("parent") != null ? group.getDynamicObject("parent").getString(PROP_ID) : ROOTNODE_ID);
        treeNode.setLongNumber(group.getString("longnumber"));
        treeNode = this.getLocaleStringName(group, "", treeNode);
        treeNode.addChildren(nodes);
        return treeNode;
    }

    private List<TreeNode> getChildrenNodes(String parentid, String entity) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashSet<Long> creatorgs = new HashSet<Long>(1);
        String createOrg = (String)customParams.get(PGCACHE_CREATEORG);
        creatorgs.add(Long.valueOf(createOrg));
        Set groupOrgs = GroupStandardUtils.getGroupOrgId((String)entity, creatorgs);
        List<Map<String, String>> childNodes = this.queryUserGroup(parentid, groupOrgs);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(childNodes.size());
        for (Map<String, String> map : childNodes) {
            TreeNode groupNode = new TreeNode();
            String id = map.get(PROP_ID);
            String name = map.get("name");
            groupNode.setParentid(parentid);
            groupNode.setId(id);
            groupNode.setText(name);
            List<Map<String, String>> newChildNodes = this.queryUserGroup(id, groupOrgs);
            if (null != newChildNodes && newChildNodes.size() > 0) {
                groupNode.addChildren(new ArrayList());
            }
            nodes.add(groupNode);
        }
        return nodes;
    }

    private List<TreeNode> getSearchGroup(String searchText, String entity) {
        String value = (String)this.getModel().getValue(PROP_STANDARDLST);
        FormShowParameter param = this.getView().getFormShowParameter();
        String groupNumber = GroupStandardHelper.getGroupNumber((String)entity);
        QFilter qFilter = new QFilter(PROP_STANDARD, "=", (Object)Long.valueOf(value));
        QFilter qFilter2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter qFilter3 = new QFilter("enable", "=", (Object)NO_GROUP);
        Map customParams = param.getCustomParams();
        String createOrg = (String)customParams.get(PGCACHE_CREATEORG);
        HashSet<Long> useOrgs = new HashSet<Long>();
        useOrgs.add(Long.parseLong(createOrg));
        Set<Long> orgs = this.getorgAndParentOrg(entity, useOrgs);
        QFilter qFilter4 = new QFilter("createorg", "in", orgs);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)groupNumber, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4}, (String)"number");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(datas.size());
        for (DynamicObject group : datas) {
            if (group.getLong(PROP_ID) == 0L) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString(PROP_ID));
            Long parent = group.getLong("parent");
            treeNode.setParentid(parent == 0L ? ROOTNODE_ID : group.getString("parent"));
            treeNode.setLongNumber(group.getString("longnumber"));
            treeNode = this.getLocaleStringName(group, "", treeNode);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    protected Set<Long> getorgAndParentOrg(String entity, Set<Long> useOrgs) {
        Set orgs = null;
        String orgsStr = this.getPageCache().get(PGCACHE_PARENTCREATEORG);
        if (StringUtils.isNotBlank((CharSequence)orgsStr)) {
            orgs = (Set)SerializationUtils.fromJsonString((String)orgsStr, Set.class);
        }
        if (orgs == null) {
            orgs = GroupStandardUtils.getGroupOrgId((String)entity, useOrgs);
            this.getPageCache().put(PGCACHE_PARENTCREATEORG, SerializationUtils.toJsonString((Object)orgs));
        }
        return orgs;
    }

    protected TreeNode getLocaleStringName(DynamicObject group, String textFormat, TreeNode treeNode) {
        String name = group.getString("name");
        String number = group.getString("number");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = group.getString("name");
        }
        String text = textFormat;
        if (StringUtils.isNotBlank((CharSequence)textFormat)) {
            if (textFormat.contains(TEXTFORMAT_NAME) && StringUtils.isNotBlank((CharSequence)name)) {
                text = org.apache.commons.lang.StringUtils.replace((String)text, (String)TEXTFORMAT_NAME, (String)name);
            }
            if (textFormat.contains(TEXTFORMAT_CODE) && StringUtils.isNotBlank((CharSequence)number)) {
                text = org.apache.commons.lang.StringUtils.replace((String)text, (String)TEXTFORMAT_CODE, (String)number);
            }
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            treeNode.setText(name);
        } else {
            treeNode.setText(text);
        }
        return treeNode;
    }
}

