/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bd.master.util.MasterDataUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.lang.HZPinyin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MasterDataHelper {
    private static final Log log = LogFactory.getLog(MasterDataHelper.class);
    private static final int SIMPLE_PINYIN_LENGTH = 255;
    private Map<Long, Boolean> groupLastNews = new HashMap<Long, Boolean>();

    public static void setSimpleDefaultImediate(IDataModel model) {
        ILocaleString name = (ILocaleString)model.getValue("name");
        if (StringUtils.isBlank((Object)name) || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
            model.setValue("simplepinyin", (Object)"");
        } else {
            try {
                String simplePinyin = HZPinyin.getFirstSpell((String)name.toString());
                if (simplePinyin != null && simplePinyin.length() <= 255) {
                    model.setValue("simplepinyin", (Object)simplePinyin);
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        }
    }

    @Deprecated
    public static void setSimplepinyin(DynamicObject obj) {
        String simplepinyin = obj.getString("simplepinyin");
        ILocaleString name = obj.getLocaleString("name");
        if (StringUtils.isBlank((CharSequence)simplepinyin) && StringUtils.isNotBlank((Object)name)) {
            try {
                String simplePinyin = HZPinyin.getFirstSpell((String)name.toString());
                obj.set("simplepinyin", (Object)simplePinyin);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        }
    }

    public static boolean checkMasterDataExit(IDataModel model, String entityName) {
        Object pk = model.getDataEntity().getPkValue();
        if (pk == null || (Long)pk == 0L) {
            return false;
        }
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entityName);
        return dyn != null;
    }

    public static String checkGroupEnable(IDataModel model, IFormView view, String entityNumber) {
        DynamicObjectCollection standards = model.getDataEntity().getDynamicObjectCollection("entry_groupstandard");
        HashSet<Long> groupIds = new HashSet<Long>();
        if (standards == null || standards.isEmpty()) {
            return null;
        }
        for (DynamicObject dynamicObject : standards) {
            Long groupid = MasterDataUtil.getDataPkByType((Object)dynamicObject.get("groupid"));
            if (groupid == 0L) continue;
            groupIds.add(groupid);
        }
        QFilter[] qFilterGroupIds = new QFilter[]{new QFilter("id", "in", groupIds), new QFilter("enable", "=", (Object)Character.valueOf('0'))};
        Map groupCaches = BusinessDataServiceHelper.loadFromCache((String)(entityNumber + "group"), (String)"id,createorg,name,enable", (QFilter[])qFilterGroupIds);
        if (groupCaches != null && groupCaches.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry m : groupCaches.entrySet()) {
                sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MasterDataHelper_3", (String)"bd-master-business", (Object[])new Object[0]), ((DynamicObject)m.getValue()).getLocaleString("name").getLocaleValue()));
                sb.append(' ');
            }
            return sb.toString();
        }
        return null;
    }

    public static Long getUseOrg(IFormView view) {
        Long useOrg = 0L;
        FormShowParameter formShowParam = view.getFormShowParameter();
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(formShowParam.getParentPageId());
        if (pageCache.get("createOrg") != null) {
            useOrg = Long.valueOf(pageCache.get("createOrg"));
        }
        return useOrg;
    }

    public static void changeDefaultValue(IDataModel model, IFormView view, DynamicObject currentDyn, String property) {
        DynamicObjectCollection entryList = model.getEntryEntity(currentDyn.getDataEntityType().getName());
        int curSeq = (Integer)currentDyn.get("seq");
        DynamicObject entry = null;
        for (int i = 0; i < entryList.size(); ++i) {
            entry = (DynamicObject)entryList.get(i);
            if (curSeq == i + 1) {
                entry.set(property, (Object)currentDyn.getBoolean(property));
                continue;
            }
            entry.set(property, (Object)Boolean.FALSE);
        }
        MasterDataHelper.updateEntryView(view);
    }

    public static void changePhonecodeValue(IDataModel model, IFormView view, DynamicObject currentDyn) {
        DynamicObjectCollection entryList = model.getEntryEntity(currentDyn.getDataEntityType().getName());
        DynamicObject entry = null;
        for (int i = 0; i < entryList.size(); ++i) {
            entry = (DynamicObject)entryList.get(i);
            DynamicObject address = entry.getDynamicObject("associatedaddress");
            if (address == null || address.getDynamicObject("admindivisiondata") == null) continue;
            entry.set("phonecode", (Object)BusinessDataServiceHelper.loadSingle((Object)address.getDynamicObject("admindivisiondata").getPkValue(), (String)"bd_admindivision", (String)"citynumber").getString("citynumber"));
        }
        view.updateView("entry_linkman");
    }

    public static void updateEntryView(IFormView view) {
        view.updateView("entry_bank");
        view.updateView("entry_linkman");
    }

    public static void changeInformationByInternalCompany(IDataModel model) {
        Object internalCompanyObj = model.getValue("internal_company");
        if (internalCompanyObj instanceof DynamicObject) {
            DynamicObject internalCompany = (DynamicObject)internalCompanyObj;
            DynamicObject country = internalCompany.getDynamicObject("country");
            Object bizpartnerAddress = internalCompany.get("faddress");
            Object bizpartnerPhone = internalCompany.get("phone");
            Object societycreditcode = internalCompany.get("uniformsocialcreditcode");
            Object txregisterno = internalCompany.get("ftaxregnum");
            Object artificialperson = internalCompany.get("frepresentative");
            Object businessscope = internalCompany.get("fbizscope");
            String regcapital = internalCompany.getString("registeredcapital");
            Date businessterm = internalCompany.getDate("businessterm");
            Date establishdate = internalCompany.getDate("establishmentdate");
            model.setValue("country", (Object)country);
            model.setValue("bizpartner_address", bizpartnerAddress);
            model.setValue("bizpartner_phone", bizpartnerPhone);
            model.setValue("societycreditcode", societycreditcode);
            model.setValue("tx_register_no", txregisterno);
            model.setValue("artificialperson", artificialperson);
            model.setValue("businessscope", businessscope);
            model.setValue("regcapital", (Object)regcapital);
            if (null != businessterm) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String establishdateStr = formatter.format(businessterm);
                model.setValue("businessterm", (Object)establishdateStr);
            } else {
                model.setValue("businessterm", null);
            }
            model.setValue("establishdate", (Object)establishdate);
        }
    }

    public static boolean checkDatas(String entityType, List<Long> ids) {
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", ids)};
        return QueryServiceHelper.exists((String)entityType, (QFilter[])qfArr);
    }

    public static void setEnrtyPropertyEnable(IDataModel model, IFormView view, IPageCache pagecache, EntryGrid bankEntryGrid, EntryGrid linkmanEntryGrid) {
        Long createorgId = 0L;
        String status = (String)model.getValue("status");
        Object createorg = model.getValue("createorg");
        String useOrg = pagecache.get("createOrg");
        Boolean isPersonalizeData = (Boolean)view.getFormShowParameter().getCustomParam("isPersonalizeData");
        if (StringUtils.isNotBlank((CharSequence)useOrg)) {
            if (createorg instanceof DynamicObject) {
                createorgId = (Long)((DynamicObject)createorg).getPkValue();
            } else if (createorg instanceof Long) {
                createorgId = (Long)createorg;
            }
            if (!"A".equals(status) && createorgId.equals(Long.parseLong(useOrg)) || isPersonalizeData == null && !createorgId.equals(Long.parseLong(useOrg))) {
                MasterDataUtil.controlEnable((IDataModel)model, (IFormView)view, (EntryGrid)bankEntryGrid, (EntryGrid)linkmanEntryGrid, (Boolean)Boolean.FALSE);
            } else if (isPersonalizeData == null || isPersonalizeData != null && !isPersonalizeData.booleanValue()) {
                MasterDataUtil.controlEnable((IDataModel)model, (IFormView)view, (EntryGrid)bankEntryGrid, (EntryGrid)linkmanEntryGrid, (Boolean)Boolean.TRUE);
            }
        }
    }

    public static void setPublicRequiredFields(DynamicObject obj) {
        if (obj.getString("bizfunction") == null || ",,".equals(obj.getString("bizfunction"))) {
            obj.set("bizfunction", (Object)",1,2,3,4,");
        }
        if (obj.getString("type") == null || "".equals(obj.getString("type"))) {
            obj.set("type", (Object)"1");
        }
    }

    public static String getDataPk(DynamicObject obj) {
        Long pk = 0L;
        Object pkid = obj.getPkValue();
        if (pkid == null || pkid.equals(0L)) {
            pk = DB.genLongId((String)obj.getDataEntityType().getAlias());
            obj.set("id", (Object)pk);
        } else {
            pk = Long.parseLong(pkid.toString());
        }
        return pk.toString();
    }

    public static void setDataStatus(DynamicObject data, OperateOption operateOption) {
        String changeIndex = "false";
        if (operateOption.getVariables().containsKey("change")) {
            changeIndex = operateOption.getVariableValue("change");
        }
        if (StringUtils.isNotEmpty((CharSequence)changeIndex) && Boolean.parseBoolean(changeIndex)) {
            operateOption.removeVariable("change");
            data.set("status", (Object)"C");
        }
    }

    public static void restoreData(IDataModel model, IPageCache pageCache) {
        String[] arr;
        Long pk = 0L;
        String dynamicObjectType = "";
        String id = pageCache.get("id");
        if (StringUtils.isNotEmpty((CharSequence)id) && (arr = id.split("-")) != null && arr.length >= 1) {
            dynamicObjectType = arr[0];
            pk = Long.parseLong(arr[1]);
        }
        if (pk != 0L) {
            DynamicObject object = null;
            try {
                object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)dynamicObjectType);
                object.set("status", (Object)"C");
                SaveServiceHelper.update((DynamicObject)object);
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage());
            }
        }
        pageCache.remove("change");
    }

    public static void doChange(BeforeDoOperationEventArgs args, IDataModel model, IFormView view, IPageCache pageCache) {
        DynamicObject data = model.getDataEntity();
        boolean lock = MutexHelper.require((IFormView)view, (String)data.getDynamicObjectType().getName(), (Object)data.getPkValue(), (String)"change", (boolean)false, (StringBuilder)new StringBuilder());
        if (!lock) {
            return;
        }
        args.setCancel(true);
        Long useOrgId = MasterDataHelper.getUseOrg(view);
        DynamicObject createorg = data.getDynamicObject("createorg");
        String status = data.getString("status");
        String enable = data.getString("enable");
        if (!"C".equals(status) || !"1".equals(enable)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6570\u636e\u624d\u53ef\u4ee5\u5feb\u901f\u4fee\u6539\u3002", (String)"MasterDataHelper_0", (String)"bd-master-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (createorg != null && !useOrgId.equals(createorg.getLong("id"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u5feb\u901f\u4fee\u6539\u5931\u8d25\u3002", (String)"MasterDataHelper_1", (String)"bd-master-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        pageCache.put("change", "true");
        pageCache.put("id", data.getDataEntityType().getName() + "-" + data.getString("id"));
        data.set("status", (Object)"A");
        view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_delete", "bar_saveandnew", "bar_submit"});
        view.updateView();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)data.getDynamicObjectType().getName());
        object.set("status", (Object)"A");
        SaveServiceHelper.update((DynamicObject)object);
    }

    public static void recoverVisible(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"bar_new"});
        view.setVisible(Boolean.TRUE, new String[]{"bar_delete"});
        view.setVisible(Boolean.TRUE, new String[]{"bar_saveandnew"});
        view.setVisible(Boolean.TRUE, new String[]{"bar_submit"});
        view.updateView();
    }

    public boolean getGroupNew() {
        AppParam appParam = new AppParam();
        appParam.setAppId("0efa1992000000ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        boolean isOpenGroupNew = false;
        log.info("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5206\u7c7b\u672b\u7ea7\u65b0\u589e\u8bbe\u7f6e \uff1aparamMap" + paramMap);
        if (paramMap != null && paramMap.get("enablegroupnew") != null) {
            log.info("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u5206\u7c7b\u672b\u7ea7\u65b0\u589e\u8bbe\u7f6e \uff1aparamMap" + paramMap);
            Object isEnableGroupNew = paramMap.get("enablegroupnew");
            isOpenGroupNew = (Boolean)isEnableGroupNew;
        }
        return isOpenGroupNew;
    }

    public boolean checkGroupNew(DynamicObject data, String entityNumber, IFormView view) {
        boolean isGroupNew = true;
        boolean isGroupLastNew = new MasterDataHelper().getGroupNew();
        if (!isGroupLastNew) {
            return isGroupNew;
        }
        HashSet<Long> groupIds = new HashSet<Long>();
        DynamicObjectCollection standards = data.getDynamicObjectCollection("entry_groupstandard");
        if (standards == null || standards.isEmpty()) {
            return isGroupNew;
        }
        for (DynamicObject dynamicObject : standards) {
            Long groupid = MasterDataUtil.getDataPkByType((Object)dynamicObject.get("groupid"));
            if (groupid == 0L) continue;
            groupIds.add(groupid);
        }
        int count = 0;
        StringBuilder errMsgBuilder = new StringBuilder();
        QFilter[] qFilters = new QFilter[]{new QFilter("parent", "in", groupIds)};
        Map groups = BusinessDataServiceHelper.loadFromCache((String)(entityNumber + "group"), (String)"parent", (QFilter[])qFilters);
        for (DynamicObject group : groups.values()) {
            Long groupid = MasterDataUtil.getDataPkByType((Object)group.getDynamicObject("parent"));
            Boolean isnew = this.groupLastNews.get(groupid);
            if (isnew != null) continue;
            this.groupLastNews.put(groupid, Boolean.TRUE);
            ILocaleString groupName = group.getDynamicObject("parent").getLocaleString("name");
            if (count > 0) {
                errMsgBuilder.append("<br>");
            }
            errMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b[%s]\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b\uff0c\u7981\u6b62\u4fdd\u5b58\u3002", (String)"MasterDataHelper_2", (String)"bd-master-business", (Object[])new Object[0]), groupName.getLocaleValue()));
            ++count;
        }
        if (count == 1) {
            view.showTipNotification(errMsgBuilder.toString());
            return false;
        }
        if (count > 1) {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("errorMsg", errMsgBuilder.toString());
            view.showForm(FormShowParameterUtil.getOperResultForm((String)"bos_operationresult", params, null, (ShowType)ShowType.Modal));
            return false;
        }
        return true;
    }

    public static Map<String, Object> loadAppParameterFromCache(String viewType) {
        AppParam appParam = new AppParam();
        appParam.setAppId("0efa1992000000ac");
        appParam.setViewType(viewType);
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap == null ? new HashMap(16) : paramMap;
    }

    public static void checkMasterId(DynamicObject data, boolean flag) {
        Long masterid = data.getLong("masterid");
        if (0L == masterid) {
            log.info(data.getDynamicObjectType().getName() + "masterid value is 0.");
            data.set("masterid", data.getPkValue());
            flag = true;
        }
    }

    public static Boolean hasBizFuncPermission(Long bizOrgId, String bizInfoEntityId) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)bizInfoEntityId);
        if (ctrlview == null) {
            StringBuilder error = new StringBuilder(bizInfoEntityId);
            error.append(" BaseDataServiceHelper.getCtrlview result ctrlview is null");
            log.error(error.toString());
            return false;
        }
        QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
        QFilter f2 = new QFilter("org.id", "=", (Object)bizOrgId);
        QFilter[] qfilters = new QFilter[]{f1, f2};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])qfilters);
        return viewOrgs.length > 0;
    }

    public static Boolean hasOperPermission(Long bizOrgId, String appNumber, String bizInfoEntityId, String permItem) {
        int checkResult = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)bizOrgId, (String)appNumber, (String)bizInfoEntityId, (String)permItem);
        return checkResult == 1;
    }

    public static boolean hasOrgPermission(Long bizOrgId, String entityNumber) {
        List inventoryCtrlOrgs = BaseDataServiceHelper.getBdCtrlOrgs((String)entityNumber);
        if (inventoryCtrlOrgs.isEmpty()) {
            return true;
        }
        return inventoryCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrgId));
    }

    public static int[] sort(int[] arr) {
        for (int i = 0; i < arr.length - 1; ++i) {
            for (int j = 0; j < arr.length - i - 1; ++j) {
                if (arr[j] >= arr[j + 1]) continue;
                int temp = arr[j];
                arr[j] = arr[j + 1];
                arr[j + 1] = temp;
            }
        }
        return arr;
    }
}

