/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.task.MessageService;
import kd.fi.iep.util.LogORMHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageService {
    private static final Log logger = LogFactory.getLog((String)"MessageService");

    public static void sendIntellShemaExecMessage(Long intelschemaId, Long sumLogId) {
        QFilter fintelschemaidFilter = new QFilter("id", "=", (Object)intelschemaId);
        DynamicObject schemaSum = BusinessDataServiceHelper.loadSingle((String)"gl_intellexecschema", (String)StringUtils.join((Object[])new String[]{"id,number,name,executor", "notificationtypes", "notificationusers", "notificationconditions"}, (String)","), (QFilter[])new QFilter[]{fintelschemaidFilter});
        DynamicObjectCollection receivers = schemaSum.getDynamicObjectCollection("notificationusers");
        String name = schemaSum.getString("name");
        String msgSendTypes = schemaSum.getString("notificationtypes");
        if (receivers.isEmpty() || StringUtils.isEmpty((CharSequence)msgSendTypes)) {
            return;
        }
        long schemaId = schemaSum.getLong("id");
        List<OperSumLog> operSumLogs = MessageService.operSumLog(schemaId, sumLogId);
        List<Long> opersumlogids = operSumLogs.stream().map(OperSumLog::getId).collect(Collectors.toList());
        List<Intellexecdetaillog> intellexecdetaillogs = MessageService.intellexecdetaillogs(opersumlogids, sumLogId);
        long failLogCnt = intellexecdetaillogs.stream().filter(s -> Objects.equals(Intellexecdetaillog.access$100((Intellexecdetaillog)s), "3")).count();
        long finishedLogCnt = intellexecdetaillogs.stream().filter(s -> Objects.equals(Intellexecdetaillog.access$100((Intellexecdetaillog)s), "2")).count();
        String sendConditions = schemaSum.getString("notificationconditions");
        if (MessageService.isNeedSendNotification(sendConditions, failLogCnt, operSumLogs)) {
            String schemaName = schemaSum.getLocaleString("name").getLocaleValue();
            String[] channelStrs = msgSendTypes.split(",");
            ArrayList<MessageChannels> effectiveChannels = new ArrayList<MessageChannels>();
            for (String channleItem : channelStrs) {
                Optional<MessageChannels> validatedChannel = MessageService.channelNumberOf(channleItem);
                if (!validatedChannel.isPresent()) continue;
                effectiveChannels.add(validatedChannel.get());
            }
            if (effectiveChannels.isEmpty()) {
                logger.warn(String.format("for intell schema: %s[%s], No effective message channel available.", schemaName, schemaId));
            }
            List<Long> userIds = receivers.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
            MessageInfo waitingMessage = MessageService.buildMessage(schemaId, MessageService.buildMessageContent(operSumLogs, name, intellexecdetaillogs), userIds, effectiveChannels);
            waitingMessage.setSenderId(Long.valueOf(schemaSum.getLong("executor_id")));
            List<MessageInfo> waitingMessageList = Collections.singletonList(waitingMessage);
            try {
                Map sendMsgResult = MessageCenterServiceHelper.batchSendMessages(waitingMessageList);
                boolean success = (Boolean)sendMsgResult.get("success");
                String description = (String)sendMsgResult.get("description");
                logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask: waitingMessageList.size: %s, success: %s, description: %s", waitingMessageList.size(), success, description));
                Map data = sendMsgResult.getOrDefault("data", new HashMap());
                if (!data.isEmpty()) {
                    List successMsgIds = data.getOrDefault("successMsgIds", new ArrayList());
                    for (Long successMsgId : successMsgIds) {
                        logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask-success: %s, messageID: %s", null, successMsgId));
                    }
                    Map failMsgs = data.getOrDefault("failMsgs", new HashMap());
                    for (Map.Entry failMsg : failMsgs.entrySet()) {
                        MessageInfo failMessageInfo = (MessageInfo)failMsg.getKey();
                        String failDescription = (String)failMsg.getValue();
                        logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask-fail: %s, messageID: %s, description: %s", JSONUtils.toString((Object)failMessageInfo), failMessageInfo.getId(), failDescription));
                    }
                }
            }
            catch (Exception e) {
                try {
                    logger.error("FailedSendMessagePlanExecutionSummarySendTask: " + JSONUtils.toString(waitingMessageList));
                }
                catch (IOException ex) {
                    logger.error("Failed to parse message: " + waitingMessageList);
                }
            }
        }
    }

    private static List<Intellexecdetaillog> intellexecdetaillogs(List<Long> opersumlogids, Long sumLogId) {
        QFilter schemasumlogid = new QFilter("schemasumlogid", "=", (Object)sumLogId);
        QFilter opersumlogid = new QFilter("opersumlogid", "in", opersumlogids);
        DynamicObjectCollection intellexecdetaillog = LogORMHelper.query((String)"iep_intellexecdetaillog", (String)"id,srcbillnumber,execdetail,execstatus,oper,bussiness", (QFilter[])new QFilter[]{schemasumlogid, opersumlogid}, (int)1000, (int)0);
        HashMap cache = new HashMap(4);
        return intellexecdetaillog.stream().map(s -> {
            Intellexecdetaillog intellexecdetail = new Intellexecdetaillog(null);
            Intellexecdetaillog.access$602((Intellexecdetaillog)intellexecdetail, (Long)s.getLong("id"));
            Intellexecdetaillog.access$702((Intellexecdetaillog)intellexecdetail, (String)s.getString("srcbillnumber"));
            Intellexecdetaillog.access$802((Intellexecdetaillog)intellexecdetail, (String)MessageService.groupString(s.getString("execdetail")));
            Intellexecdetaillog.access$102((Intellexecdetaillog)intellexecdetail, (String)s.getString("execstatus"));
            Intellexecdetaillog.access$902((Intellexecdetaillog)intellexecdetail, (String)s.getString("oper"));
            Intellexecdetaillog.access$1002((Intellexecdetaillog)intellexecdetail, (String)s.getString("bussiness"));
            Intellexecdetaillog.access$002((Intellexecdetaillog)intellexecdetail, (String)cache.computeIfAbsent(Intellexecdetaillog.access$1000((Intellexecdetaillog)intellexecdetail), k -> FormDesignDao.getFormName(Intellexecdetaillog.access$1000((Intellexecdetaillog)intellexecdetail))));
            Intellexecdetaillog.access$1102((Intellexecdetaillog)intellexecdetail, (String)cache.computeIfAbsent(Intellexecdetaillog.access$1000((Intellexecdetaillog)intellexecdetail) + Intellexecdetaillog.access$900((Intellexecdetaillog)intellexecdetail), k -> FormDesignDao.getOperationNameWithVoucher(Intellexecdetaillog.access$1000((Intellexecdetaillog)intellexecdetail), Intellexecdetaillog.access$900((Intellexecdetaillog)intellexecdetail))));
            return intellexecdetail;
        }).collect(Collectors.toList());
    }

    public static String groupString(String details) {
        String safeExecDetail;
        String string = safeExecDetail = StringUtils.isEmpty((CharSequence)details) ? "unknow reason" : details;
        if (safeExecDetail.indexOf(":") == safeExecDetail.length() - 1) {
            return safeExecDetail;
        }
        return safeExecDetail.substring(safeExecDetail.indexOf(":") + 1);
    }

    private static List<OperSumLog> operSumLog(Long fintelschemaid, Long sumLogId) {
        QFilter intelschemaidEqual = new QFilter("intelschemaid", "=", (Object)fintelschemaid);
        QFilter schemasumlogidEqual = new QFilter("schemasumlogid", "=", (Object)sumLogId);
        DynamicObjectCollection opersumlog = QueryServiceHelper.query((String)"gl_intellopersumlog", (String)"id,execstatus,execdetail,oper,bussiness", (QFilter[])new QFilter[]{intelschemaidEqual, schemasumlogidEqual});
        HashMap cache = new HashMap(4);
        return opersumlog.stream().map(s -> {
            OperSumLog operSumLog = new OperSumLog(null);
            operSumLog.setId(Long.valueOf(s.getLong("id")));
            operSumLog.setExecdetail(s.getString("execdetail"));
            operSumLog.setExecstatus(s.getString("execstatus"));
            operSumLog.setBussiness(s.getString("bussiness"));
            operSumLog.setBussinessName(cache.computeIfAbsent(OperSumLog.access$300((OperSumLog)operSumLog), k -> FormDesignDao.getFormName(OperSumLog.access$300((OperSumLog)operSumLog))));
            operSumLog.setOper(s.getString("oper"));
            operSumLog.setOpername(cache.computeIfAbsent(OperSumLog.access$300((OperSumLog)operSumLog) + OperSumLog.access$400((OperSumLog)operSumLog), k -> FormDesignDao.getOperationNameWithVoucher(OperSumLog.access$300((OperSumLog)operSumLog), OperSumLog.access$400((OperSumLog)operSumLog))));
            return operSumLog;
        }).collect(Collectors.toList());
    }

    private static String buildMessageContent(List<OperSumLog> operSumLogs, String name, List<Intellexecdetaillog> intellexecdetaillogs) {
        boolean allSuccess = MessageService.isAllSuccess(operSumLogs);
        if (allSuccess) {
            return MessageService.buildSuccessMessageContent(name, operSumLogs);
        }
        return MessageService.buildFailMessageContent(name, intellexecdetaillogs);
    }

    private static String buildSuccessMessageContent(String planName, List<OperSumLog> operSumLogs) {
        StringBuilder successMsg = new StringBuilder();
        successMsg.append(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u3010%1$s\u3011\u7684", (String)"PlanExecutionSummarySendTask_4", (String)"bos-ext-fi", (Object[])new Object[0]), planName));
        String success = operSumLogs.stream().filter(s -> Objects.equals(s.getExecstatus(), "2")).map(s -> s.getOpername()).collect(Collectors.joining(","));
        successMsg.append(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4efb\u52a1\u6267\u884c\u6210\u529f\u3002", (String)"PlanExecutionSummarySendTask_6", (String)"bos-ext-fi", (Object[])new Object[0]), success));
        return successMsg.toString();
    }

    private static String buildFailMessageContent(String name, List<Intellexecdetaillog> intellexecdetaillogs) {
        StringBuilder msgContent = new StringBuilder();
        msgContent.append(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u3010%1$s\u3011\u7684", (String)"PlanExecutionSummarySendTask_4", (String)"bos-ext-fi", (Object[])new Object[0]), name));
        Map groupByOper = intellexecdetaillogs.stream().filter(s -> Objects.equals(Intellexecdetaillog.access$100((Intellexecdetaillog)s), "3")).collect(Collectors.groupingBy(Intellexecdetaillog::getOpername, Collectors.toList()));
        for (Map.Entry entry : groupByOper.entrySet()) {
            String opername = entry.getKey();
            List value = entry.getValue();
            msgContent.append(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c", (String)"PlanExecutionSummarySendTask_5", (String)"bos-ext-fi", (Object[])new Object[0]), opername));
            Map collect = value.stream().collect(Collectors.groupingBy(Intellexecdetaillog::getExecdetail, Collectors.toList()));
            for (Map.Entry e : collect.entrySet()) {
                String execdetail = e.getKey();
                List v = e.getValue();
                String operFailReason = String.format(ResManager.loadKDString((String)"%1$s%2$s\u56e0\u4e3a\u3010%3$s\u3011\u6267\u884c\u5931\u8d25\uff0c", (String)"PlanExecutionSummarySendTask_7", (String)"bos-ext-fi", (Object[])new Object[0]), Intellexecdetaillog.access$000((Intellexecdetaillog)((Intellexecdetaillog)v.get(0))), "\u3010" + v.stream().map(Intellexecdetaillog::getSrcbillnumber).collect(Collectors.joining("\uff0c")) + "\u3011", execdetail);
                msgContent.append(operFailReason);
            }
        }
        msgContent.append(ResManager.loadKDString((String)"\u8bf7\u5904\u7406\u3002", (String)"PlanExecutionSummarySendTask_8", (String)"bos-ext-fi", (Object[])new Object[0]));
        return msgContent.toString();
    }

    private static MessageInfo buildMessage(Long schemaId, String msgContent, List<Long> receiveUserIds, List<MessageChannels> sendChannels) {
        MessageInfo message = new MessageInfo();
        message.setTitle(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u6267\u884c\u63d0\u9192", (String)"PlanExecutionSummarySendTask_1", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        message.setContent(msgContent);
        LocaleString tag = new LocaleString();
        message.setMessageTag((ILocaleString)tag);
        message.setTag(ResManager.loadKDString((String)"\u7d27\u6025", (String)"PlanExecutionSummarySendTask_2", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        message.setUserIds(receiveUserIds);
        message.setType("alarm");
        message.setEntityNumber("gl_intellexecschema");
        message.setOperation("modify");
        message.setBizDataId(schemaId);
        message.setPubaccNumber("flowassist");
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%s&type=base&&pkId=%s&caption=%s", "gl_intellexecschema", schemaId, ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u65b9\u6848", (String)"PlanExecutionSummarySendTask_3", (String)"fi-iep-formplugin", (Object[])new Object[0]));
        message.setContentUrl(contentUrl);
        message.setNotifyType(StringUtils.join((Object[])sendChannels.stream().map(MessageChannels::getNumber).distinct().toArray(), (String)","));
        return message;
    }

    private static boolean isNeedSendNotification(String sendConditions, long failedCnt, long finishedCnt) {
        if (StringUtils.isEmpty((CharSequence)sendConditions)) {
            return false;
        }
        List<String> conditionList = Arrays.asList(sendConditions.split(","));
        if (failedCnt > 0L && conditionList.contains("fail")) {
            return true;
        }
        return conditionList.contains("success");
    }

    private static boolean isNeedSendNotification(String sendConditions, long failedCnt, List<OperSumLog> operSumLogs) {
        if (StringUtils.isEmpty((CharSequence)sendConditions)) {
            return false;
        }
        List<String> conditionList = Arrays.asList(sendConditions.split(","));
        if (failedCnt > 0L && conditionList.contains("fail")) {
            return true;
        }
        return conditionList.contains("success") && operSumLogs.stream().filter(s -> "2".equals(s.getExecstatus())).count() == (long)operSumLogs.size();
    }

    private static boolean isAllSuccess(List<OperSumLog> operSumLogs) {
        return operSumLogs.stream().filter(s -> "2".equals(s.getExecstatus())).count() == (long)operSumLogs.size();
    }

    private static Optional<MessageChannels> channelNumberOf(String number) {
        for (MessageChannels channel : MessageChannels.values()) {
            if (!channel.getNumber().equals(number)) continue;
            return Optional.of(channel);
        }
        return Optional.empty();
    }
}

