/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.enums.ExecuteType;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.task.AbstractExecute;
import kd.fi.iep.task.IntellExecuteContext;
import kd.fi.iep.util.IntellExecuteUtil;

public class GeneralExecute
extends AbstractExecute {
    private static final int THREAD_TOTAL = 20;
    private static final int THREAD_DATA_LIMIT = 1000;
    private static final int THREAD_DATA_LIMIT_TOTAL = 10000;
    private final Object syncObj = new Object();
    private int processThreadCount = 0;
    private static final ThreadPool threadPoolIntellPlan = ThreadPools.newFixedThreadPool((String)"fi/iep/intellAccountingExecPlan", (int)5);
    private AtomicBoolean isExistFailBill = new AtomicBoolean(false);

    public GeneralExecute(IntellExecuteContext ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        try {
            IntellExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
            Long intelschemaId = exceOperInfo.getSchemaId();
            Date execstartdate = this.ctx.getExecstartdate();
            long sumLogId = this.ctx.getSumLogId();
            logger.info(intelschemaId + "\u5f00\u59cb\u83b7\u53d6\u76ee\u6807\u6570\u636e...");
            List<QFilter> dataFilter = this.getExceDataCollectionFilter();
            logger.info("\u8fc7\u6ee4\u6761\u4ef6:" + dataFilter);
            String[] groupbys = this.getGroupbys();
            String selectFields = Stream.concat(Stream.of("id"), Arrays.stream(groupbys)).distinct().collect(Collectors.joining(","));
            DataSet endData = QueryServiceHelper.queryDataSet((String)"fi.iep.IntellAccountingExecPlan.getExceDataCollection", (String)exceOperInfo.getBussiness(), (String)selectFields, (QFilter[])dataFilter.toArray(new QFilter[0]), (String)"id").distinct();
            if (ExecuteType.AUTO == exceOperInfo.getExecuteType()) {
                DataSet removeFailBillId = AbstractExecute.removeFailBillId(exceOperInfo, this.isExistFailBill);
                final HashSet removeFailBillIds = new HashSet(16);
                removeFailBillId.forEach(x -> removeFailBillIds.add(x.getLong("srcbillid")));
                logger.info(" remove fail billid size {}", (Object)removeFailBillIds.size());
                endData = endData.filter(new FilterFunction(){
                    private static final long serialVersionUID = -1593549109335713680L;

                    public boolean test(Row row) {
                        return !removeFailBillIds.contains(row.getLong("id"));
                    }
                });
            }
            ArrayList idLists = new ArrayList(16);
            for (DataSet idData : endData.splitByGroup(groupbys)) {
                Iterator idList = new ArrayList();
                idData.forEach(x -> idList.add(x.getLong("id")));
                int n = idList.size();
                int batchCount = (int)Math.ceil((double)n * 1.0 / 1000.0);
                for (int batchIndex = 0; batchIndex < batchCount; ++batchIndex) {
                    List curBatch = 1000 * (batchIndex + 1) < n ? idList.subList(1000 * batchIndex, 1000 * (batchIndex + 1)) : idList.subList(1000 * batchIndex, n);
                    idLists.add(curBatch);
                }
            }
            int count = idLists.stream().mapToInt(List::size).sum();
            IntellSchemeExecInfo execInfo = this.ctx.getSchemeExecInfo();
            execInfo.appendRecordTC(count);
            try {
                Object bussinessName;
                logger.info(intelschemaId + "\u76ee\u6807\u6570\u636e" + count);
                if (count == 0) {
                    logger.info("\u667a\u80fd\u6838\u7b97\u4e3b\u7ebf\u7a0b\u9000\u51fa--\u6279\u5904\u7406\u6570\u636e:0");
                    if (this.isExistFailBill.get()) {
                        String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u6570\u636e\u5df2\u6709\u667a\u80fd\u65b9\u6848\u6267\u884c\u5931\u8d25\u8bb0\u5f55\uff0c\u8bf7\u5728\u5931\u8d25\u8be6\u60c5\u70b9\u51fb\u3010\u91cd\u65b0\u6267\u884c\u3011\u4ee5\u91cd\u65b0\u6267\u884c\u8fd9\u6279\u6570\u636e", (String)"IepResManage_1", (String)"bos-ext-fi", (Object[])new Object[0]);
                        execInfo.setExecDetails(msg);
                    } else {
                        bussinessName = FormDesignDao.getFormName(exceOperInfo.getBussiness());
                        String msg = String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u8be5\u65b9\u6848\u3010%1$s%2$s\u3011\u64cd\u4f5c\u7684\u524d\u7f6e\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"VoucherBatchBuildExecService_1", (String)"bos-ext-fi", (Object[])new Object[0]), bussinessName, exceOperInfo.getOperName());
                        execInfo.setExecDetails(msg);
                    }
                    return;
                }
                ArrayList<Future<ExecuteStatus>> reulstAll = new ArrayList<Future<ExecuteStatus>>();
                bussinessName = this.syncObj;
                synchronized (bussinessName) {
                    for (List list : idLists) {
                        if (this.processThreadCount >= 20) {
                            logger.info("\u667a\u80fd\u6838\u7b97\u4e3b\u7ebf\u7a0b\u7b49\u5f85");
                            this.syncObj.wait();
                        }
                        logger.info("1000\u4e00\u6279\u667a\u80fd\u6838\u7b97\u4e3b\u7ebf\u7a0b\u5f00\u59cb\u5206\u53d1\u5b50\u7ebf\u7a0b");
                        this.threadCountAdd();
                        Future<ExecuteStatus> future = this.mutiThreadExecOperation(intelschemaId, count, execstartdate, exceOperInfo, this, list, this.getBatchSize(exceOperInfo), this.syncObj);
                        reulstAll.add(future);
                        if (!IntellExecuteUtil.isStopExcute((IntellSchemeExecInfo)this.ctx.getSchemeExecInfo())) continue;
                        break;
                    }
                }
                HashSet operStatusSet = new HashSet(3);
                for (Future future : reulstAll) {
                    operStatusSet.add(future.get());
                }
                ExecuteStatus operstatus = ExecuteStatus.FINISH;
                if (operStatusSet.contains(ExecuteStatus.STOP)) {
                    operstatus = ExecuteStatus.STOP;
                } else if (operStatusSet.contains(ExecuteStatus.FAIL)) {
                    operstatus = ExecuteStatus.FAIL;
                }
                this.ctx.getSchemeExecInfo().getExceOperInfo().setExecuteStatus(operstatus);
                logger.info("\u667a\u80fd\u6838\u7b97\u4e3b\u7ebf\u7a0b\u8fd0\u884c\u5b8c\u6210");
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                endData.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Set<Long> batchRemoveFailBillId(IntellExceOperInfo exceOperInfo, DataSet endData) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        HashSet<Long> billIds = new HashSet<Long>(16);
        while (endData.hasNext()) {
            Row next = endData.next();
            Long id = next.getLong("id");
            idSet.add(id);
            if (ExecuteType.AUTO == this.ctx.getType()) {
                billIds.add(id);
                if (billIds.size() % 2000 == 0 || !endData.hasNext()) {
                    boolean isExist = GeneralExecute.removeFailBillId(idSet, billIds, exceOperInfo.getBussiness(), exceOperInfo);
                    if (!this.isExistFailBill.get()) {
                        this.isExistFailBill.compareAndSet(false, isExist);
                    }
                    logger.info(" remove fail billid size {}", (Object)billIds.size());
                    billIds.clear();
                    if (IntellExecuteUtil.isStopExcute((IntellSchemeExecInfo)this.ctx.getSchemeExecInfo())) break;
                }
            }
            if (endData.hasNext()) continue;
        }
        return idSet;
    }

    @Override
    protected OperationResult invokeOperation(Object[] ids, OperateOption option) {
        IntellExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        return OperationServiceHelper.executeOperate((String)exceOperInfo.getOper(), (String)exceOperInfo.getBussiness(), (Object[])ids, (OperateOption)option);
    }

    private Future<ExecuteStatus> mutiThreadExecOperation(Long intelschemaId, int count, Date execstartdate, IntellExceOperInfo exceOperInfo, GeneralExecute intellAccountingExecPlan, List<Long> newList, int pointsDataLimit, Object syncObj) {
        class OperationRunnable
        implements Callable {
            private Long intelschemaId;
            private int count;
            private Date execstartdate;
            private IntellExceOperInfo exceOperInfo;
            private List<Long> newList;
            private int pointsDataLimit;
            private GeneralExecute intellAccountingExecPlan;
            private final Object syncObj;

            public OperationRunnable(Long intelschemaId, int count, Date execstartdate, IntellExceOperInfo exceOperInfo, List<Long> newList, int pointsDataLimit, GeneralExecute intellAccountingExecPlan, Object syncObj) {
                this.intelschemaId = intelschemaId;
                this.count = count;
                this.execstartdate = execstartdate;
                this.exceOperInfo = exceOperInfo;
                this.newList = newList;
                this.pointsDataLimit = pointsDataLimit;
                this.intellAccountingExecPlan = intellAccountingExecPlan;
                this.syncObj = syncObj;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ExecuteStatus call() {
                ExecuteStatus executeStatus = ExecuteStatus.FINISH;
                try {
                    RequestContext.get().setTraceId(GeneralExecute.this.ctx.getTraceId());
                    logger.info("\u667a\u80fd\u6838\u7b97\u8fdb\u5165\u5355\u4e2a\u7ebf\u7a0b\u8c03\u5ea6:{};traceId:{}", (Object)this.intelschemaId, (Object)GeneralExecute.this.ctx.getTraceId());
                    long startTime = System.currentTimeMillis();
                    executeStatus = GeneralExecute.this.exeOperation(this.newList, this.intelschemaId, this.count, this.execstartdate, this.exceOperInfo, this.pointsDataLimit);
                    logger.info("\u667a\u80fd\u6838\u7b97\u8fdb\u884c\u7684\u7ebf\u7a0b\u6570:{}", (Object)this.intellAccountingExecPlan.processThreadCount);
                    logger.info("\u667a\u80fd\u6838\u7b97\u5b8c\u6210\u5355\u4e2a\u7ebf\u7a0b\u8c03\u5ea6: {};\u8017\u65f6:{}ms", (Object)this.intelschemaId, (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Exception e) {
                    logger.error("\u667a\u80fd\u6838\u7b97\u5355\u4e2a\u7ebf\u7a0b\u53d1\u751f\u62a5\u9519:" + e);
                }
                finally {
                    this.intellAccountingExecPlan.threadCountSub();
                    int halfThreads = 10;
                    if (this.intellAccountingExecPlan.processThreadCount == halfThreads) {
                        Object object = this.syncObj;
                        synchronized (object) {
                            logger.info("\u667a\u80fd\u6838\u7b97\u4e3b\u7ebf\u7a0b\u5524\u9192");
                            this.syncObj.notifyAll();
                        }
                    }
                }
                return executeStatus;
            }
        }
        OperationRunnable runnable = new OperationRunnable(intelschemaId, count, execstartdate, exceOperInfo, newList, pointsDataLimit, intellAccountingExecPlan, syncObj);
        return threadPoolIntellPlan.submit((Callable)runnable);
    }

    public synchronized void threadCountAdd() {
        ++this.processThreadCount;
    }

    public synchronized void threadCountSub() {
        --this.processThreadCount;
    }

    protected ExecuteStatus exeOperation(List<Long> operAllData, long intelschemaId, int count, Date execstartdate, IntellExceOperInfo exceOperInfo, int batchSize) {
        ExecuteStatus operstatus = ExecuteStatus.FINISH;
        StringBuffer errorMessage = new StringBuffer();
        List processObj = null;
        HashSet<ExecuteStatus> operStatusSet = new HashSet<ExecuteStatus>(3);
        for (int i = 0; i < operAllData.size(); ++i) {
            processObj = Optional.ofNullable(processObj).orElseGet(ArrayList::new);
            processObj.add(operAllData.get(i));
            if (processObj.size() != batchSize && i != operAllData.size() - 1) continue;
            operstatus = this.startExecOperation(intelschemaId, count, execstartdate, exceOperInfo, errorMessage, processObj);
            processObj = null;
            operStatusSet.add(operstatus);
        }
        if (operStatusSet.contains(ExecuteStatus.STOP)) {
            operstatus = ExecuteStatus.STOP;
        } else if (operStatusSet.contains(ExecuteStatus.FAIL)) {
            operstatus = ExecuteStatus.FAIL;
        }
        return operstatus;
    }

    private int getBatchSize(IntellExceOperInfo exceOperInfo) {
        if (exceOperInfo.isSingle()) {
            return 1;
        }
        return exceOperInfo.getEachbatchsize();
    }
}

