/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.BillFlowResult;
import kd.data.idi.data.Company;
import kd.data.idi.data.Courier;
import kd.data.idi.data.CourierDataResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.FasindexConfig;
import kd.data.idi.data.FasindexResult;
import kd.data.idi.data.GradeItem;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.InvoiceCloudCodeType;
import kd.data.idi.data.InvoiceFailureEntity;
import kd.data.idi.data.InvoiceImageResult;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.data.LineCard;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.News;
import kd.data.idi.data.NewsConfig;
import kd.data.idi.data.NewsResult;
import kd.data.idi.data.NodeLineStatusEnum;
import kd.data.idi.data.NodeStatusEnum;
import kd.data.idi.data.NumericalUnitEnum;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.data.StatisticsResult;
import kd.data.idi.data.TableDataResult;
import kd.data.idi.data.TableLineNode;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.show.BillFlowModel;
import kd.data.idi.data.show.BusinessCatalogs;
import kd.data.idi.data.show.CardModel;
import kd.data.idi.data.show.CardRowModel;
import kd.data.idi.data.show.Carousel;
import kd.data.idi.data.show.DimensionModel;
import kd.data.idi.data.show.FasindexModel;
import kd.data.idi.data.show.FasindexTableDataModel;
import kd.data.idi.data.show.HrefItemModel;
import kd.data.idi.data.show.IconItemModel;
import kd.data.idi.data.show.ItemModel;
import kd.data.idi.data.show.LineCardModel;
import kd.data.idi.data.show.LineCardRowModel;
import kd.data.idi.data.show.PopoverModel;
import kd.data.idi.data.show.PopoverRowModel;
import kd.data.idi.data.show.StatisticModel;
import kd.data.idi.data.show.TableLineNodeModel;
import kd.data.idi.data.show.TextItemModel;
import kd.data.idi.data.show.TimeLineFlag;
import kd.data.idi.data.show.TimeLineItemModel;
import kd.data.idi.data.show.URLItemModel;
import kd.data.idi.dataconverter.IDISchemaResultDataConvert;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.decision.service.DecisionTypeExtInfoService;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class IDISchemaResultPCDataConvert
extends IDISchemaResultDataConvert {
    protected static final String HEADER_LIST = "headerList";
    protected static final String CARD_MODEL_LIST = "cardModelList";
    protected static final String STATUS = "status";
    protected static final String IS_PC = "isPC";
    protected static final String GRADE_MORETHAN = "morethan";
    protected static final String GRADE_OTHER = "other";
    protected static final String ICON_AGREE = "agree";
    protected static final String ICON_EXCEPTION = "exception";
    protected static final String ISEXPEND = "isExpend";
    protected static final String ISHIGHLIGHT = "isHighLight";
    private boolean isHighLight = false;

    public Map<String, Object> convertObject(SchemaResult result, Schema schema) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (schema == null) {
            return resultMap;
        }
        resultMap.put(ISHIGHLIGHT, Boolean.FALSE);
        SchemaExecutorLogger.info((String)(" schema is " + schema.getNumber() + " highLight flag is" + schema.isHighLight()), (Object[])new Object[0]);
        try {
            if ("success".equalsIgnoreCase(result.getStatus())) {
                List<CardRowModel> cardRowModelList = this.createHeader(schema, result);
                resultMap.put(HEADER_LIST, cardRowModelList);
                this.isHighLight = schema.isHighLight();
                if (result.getAreaResults() != null && !result.getAreaResults().isEmpty()) {
                    ArrayList<CardModel> cardModelList = new ArrayList<CardModel>(result.getAreaResults().size());
                    resultMap.put(CARD_MODEL_LIST, cardModelList);
                    int index = 1;
                    for (AreaResult areaResult : result.getAreaResults()) {
                        CardModel cm;
                        if ((cm = this.createCard(index++, areaResult)) == null) continue;
                        cardModelList.add(cm);
                    }
                }
                resultMap.put(ISHIGHLIGHT, this.isHighLight);
            } else {
                String text = this.getErrorSchemaText(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDISchemaResultPCDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]), result.getStatus());
                List<CardRowModel> cardRowModelList = this.createErrorHead(text);
                resultMap.put(HEADER_LIST, cardRowModelList);
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error((Throwable)ex);
            resultMap.put(HEADER_LIST, this.createErrorHead(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDISchemaResultPCDataConvert_0", (String)"data-idi-core", (Object[])new Object[0])));
            resultMap.put(CARD_MODEL_LIST, this.createErrorCard());
        }
        resultMap.put(STATUS, result.getStatus());
        resultMap.put(IS_PC, Boolean.TRUE);
        resultMap.put(ISEXPEND, ParamFactory.getBoolean((String)ISEXPEND, (boolean)true));
        return resultMap;
    }

    private List<CardRowModel> createErrorHead(String warnText) {
        ArrayList<CardRowModel> list = new ArrayList<CardRowModel>();
        CardRowModel row = new CardRowModel();
        ArrayList<TextItemModel> mainDesc = new ArrayList<TextItemModel>();
        TextItemModel rowItemModel1 = new TextItemModel(warnText);
        rowItemModel1.addItemStyle("font-size", "14px");
        rowItemModel1.addItemStyle("color", "#666666");
        mainDesc.add(rowItemModel1);
        row.setMainDesc(mainDesc);
        row.addRowStyle("padding", "0px");
        list.add(row);
        return list;
    }

    private List<CardModel> createErrorCard() {
        CardModel cardModel = new CardModel();
        ArrayList<CardModel> list = new ArrayList<CardModel>();
        list.add(cardModel);
        ArrayList<CardRowModel> rowList = new ArrayList<CardRowModel>();
        CardRowModel firstRow = new CardRowModel();
        ArrayList<IconItemModel> items = new ArrayList<IconItemModel>();
        IconItemModel icon = new IconItemModel("nodata.png");
        icon.addItemStyle("width", "120px");
        icon.addImageStyle("width", "120px");
        icon.addImageStyle("height", "120px");
        items.add(icon);
        firstRow.setMainDesc(items);
        firstRow.addMainStyle("justify-content", "center");
        rowList.add(firstRow);
        cardModel.setEntity(rowList);
        cardModel.addCardStyle("height", "300px");
        cardModel.addCardStyle("border", "none");
        return list;
    }

    protected List<CardRowModel> createHeader(Schema schema, SchemaResult result) {
        List gradeList = schema.getGrade();
        GradeItem matchItem = null;
        GradeItem defaultMatchItem = null;
        if (gradeList != null) {
            for (GradeItem item : gradeList) {
                if (GRADE_MORETHAN.equalsIgnoreCase(item.getCondition())) {
                    if (!((float)result.getScore() >= item.getGrade())) continue;
                    matchItem = item;
                    break;
                }
                if (!GRADE_OTHER.equalsIgnoreCase(item.getCondition()) || defaultMatchItem != null) continue;
                defaultMatchItem = item;
            }
        }
        if (matchItem == null) {
            matchItem = defaultMatchItem;
        }
        if (matchItem == null) {
            matchItem = new GradeItem();
            matchItem.setShowColor("#333333");
            matchItem.setShowScript(this.defaultHeadertxt());
        }
        ArrayList<CardRowModel> list = new ArrayList<CardRowModel>();
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<TextItemModel> mainList = new ArrayList<TextItemModel>();
        String showText = ResManager.loadKDString((String)"\u8bf7\u67e5\u9605\u4ee5\u4e0b\u6d1e\u5bdf\u5185\u5bb9", (String)"IDISchemaResultPCDataConvert_9", (String)"data-idi-core", (Object[])new Object[0]);
        if (result.getScore() >= 0) {
            TextItemModel rowItemModel1 = new TextItemModel(String.format(ResManager.loadKDString((String)"%d\u5206", (String)"IDISchemaResultPCDataConvert_16", (String)"data-idi-core", (Object[])new Object[0]), result.getScore()));
            mainList.add(rowItemModel1);
            rowItemModel1.addItemStyle("color", this.getColor(matchItem.getShowColor()));
            rowItemModel1.addItemStyle("font-size", "14px");
            rowItemModel1.addItemStyle("margin-right", "6px");
            if (result.getScore() == 100) {
                rowItemModel1.addItemStyle("min-width", "39px");
            } else if (result.getScore() > 9) {
                rowItemModel1.addItemStyle("min-width", "31px");
            } else {
                rowItemModel1.addItemStyle("min-width", "23px");
            }
            showText = matchItem.getShowScript();
        } else if (result.getScore() < -1) {
            showText = ResManager.loadKDString((String)"\u6d1e\u5bdf\u7ed3\u679c\u52a0\u8f7d\u4e2d\u2026\u2026", (String)"IDISchemaResultPCDataConvert_18", (String)"data-idi-core", (Object[])new Object[0]);
        }
        TextItemModel rowItemModel2 = new TextItemModel(showText);
        rowItemModel2.addItemStyle("color", "#333333");
        rowItemModel2.addItemStyle("font-size", "14px");
        cardRowModel.addMainStyle("white-space", "normal");
        rowItemModel2.addItemStyle("white-space", "normal");
        mainList.add(rowItemModel2);
        cardRowModel.setMainDesc(mainList);
        cardRowModel.addMainStyle("max-width", "192px");
        cardRowModel.addRowStyle("padding", "0px");
        list.add(cardRowModel);
        return list;
    }

    protected String defaultHeadertxt() {
        return ResManager.loadKDString((String)"\u8bf7\u67e5\u9605\u4ee5\u4e0b\u6d1e\u5bdf\u5185\u5bb9", (String)"IDISchemaResultPCDataConvert_9", (String)"data-idi-core", (Object[])new Object[0]);
    }

    protected CardModel createCard(int i, AreaResult areaResult) {
        Area area = areaResult.getArea();
        List decisionResults = areaResult.getDecisionResults();
        if (CollectionUtils.isEmpty((Collection)decisionResults)) {
            return null;
        }
        CardModel cardModel = new CardModel();
        cardModel.setId(area.getPk());
        cardModel.setTitle(area.getTitle());
        String borderTopColor = i % 2 == 0 ? "#A9BEFF" : "#32AA70";
        cardModel.addCardStyle("border-top-color", borderTopColor);
        cardModel.addCardStyle("border-top-width", "2px");
        SchemaExecutorLogger.info((String)String.format("createCard areaResult : %s", IDIJSONUtils.toJsonString((Object)decisionResults)), (Object[])new Object[0]);
        ArrayList<CardRowModel> statisticsList = new ArrayList<CardRowModel>();
        ArrayList<CardRowModel> cardRowModelList = new ArrayList<CardRowModel>();
        for (DecisionResult result : decisionResults) {
            if (result == null) continue;
            if (result.getNewsResult() != null) {
                cardModel.setName("news");
                List<CardRowModel> resultRowList = this.createNewsData(result.getNewsResult(), result.getDecision().getNews());
                cardRowModelList.addAll(resultRowList);
                continue;
            }
            if (result.getTableDataResult() != null) {
                cardModel.setName("timeline");
                cardRowModelList.addAll(this.createTableData(result.getTableDataResult()));
                continue;
            }
            if (result.getInvoiceImageRuleResults() != null && !result.getInvoiceImageRuleResults().isEmpty()) {
                cardModel.setButtonTitle(ResManager.loadKDString((String)"\u67e5\u770b\u7968\u636e\u5f71\u50cf", (String)"IDISchemaResultPCDataConvert_17", (String)"data-idi-core", (Object[])new Object[0]));
                cardModel.setButtonData(IDIJSONUtils.toJsonString((Object)result.getInvoiceImageResults()));
                List<CardRowModel> rowModelList = this.createInvoiceCard(result, area.getPk());
                cardRowModelList.addAll(rowModelList);
                statisticsList.addAll(rowModelList);
                continue;
            }
            if (result.getLinkUpBillResults() != null && !result.getLinkUpBillResults().isEmpty()) {
                this.createCardRowByLinkupBillResult(result.getLinkUpBillResults(), cardRowModelList, statisticsList, null, area.getPk(), result.getDecision().getPk());
                continue;
            }
            if (result.getCourierDataResult() != null) {
                Carousel carousel = this.createCarousel(result.getCourierDataResult());
                cardModel.setCarousel(carousel);
                continue;
            }
            if (result.getBillFlowResult() != null) {
                BillFlowModel billFlow = this.createBillFlow(result.getBillFlowResult(), result);
                cardModel.setBillFlowModel(billFlow);
                continue;
            }
            if (result.getStatisticsResult() != null) {
                StatisticModel statisticModel = this.createStatistic(result.getStatisticsResult(), result);
                cardModel.addStatisticModel(statisticModel);
                continue;
            }
            if (result.getFasindexResult() != null) {
                FasindexModel fasindexModel = this.createFasindex(result.getFasindexResult(), result);
                cardModel.addFasindexModel(fasindexModel);
                continue;
            }
            if (result.getAttachmentResults() != null && !result.getAttachmentResults().isEmpty()) {
                HashSet<LinkUpBillResult> notShow = new HashSet<LinkUpBillResult>(3);
                this.createCardRowByLinkupBillResult(result.getAttachmentResults(), cardRowModelList, statisticsList, notShow, area.getPk(), result.getDecision().getPk());
                continue;
            }
            if (result.getDecision() != null && !MatchType.containsType((String)result.getDecision().getMatchType())) {
                List<CardRowModel> list = this.createCardRowsOfMServiceApiResult(result.getApiDecisionResultItems(), result.getDecision());
                if (CollectionUtils.isNotEmpty(list)) {
                    cardRowModelList.addAll(list);
                    statisticsList.addAll(list);
                    continue;
                }
                CardRowModel resultRow = this.createCardRow(result, null);
                cardRowModelList.add(resultRow);
                statisticsList.add(resultRow);
                continue;
            }
            CardRowModel resultRow = this.createCardRow(result, area.getPk());
            cardRowModelList.add(resultRow);
            statisticsList.add(resultRow);
        }
        this.createTotalRow(cardRowModelList, statisticsList);
        cardModel.setEntity(cardRowModelList);
        return cardModel;
    }

    private List<CardRowModel> createCardRowsOfMServiceApiResult(List<ApiDecisionResultItem> results, Decision decision) {
        ArrayList<CardRowModel> cardRowModelList = new ArrayList<CardRowModel>(10);
        if (CollectionUtils.isEmpty(results)) {
            return cardRowModelList;
        }
        DecisionTypeExtInfoService decisionTypeExtInfoService = new DecisionTypeExtInfoService();
        ExtDecisionInfo extDecisionInfo = decisionTypeExtInfoService.queryByMatchType(decision.getMatchType());
        for (ApiDecisionResultItem item : results) {
            DecisionResult tmpResult = new DecisionResult();
            tmpResult.setDecision(decision);
            tmpResult.setStatus(item.getStatus());
            tmpResult.setShowText(item.getShowText());
            if (CollectionUtils.isNotEmpty((Collection)item.getHoverContents())) {
                DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
                decisionFrontEndResult.setHoverContent(item.getHoverContents());
                tmpResult.setFrontEndResult(decisionFrontEndResult);
            }
            CardRowModel resultRow = this.createCardRow(tmpResult, null);
            if (extDecisionInfo != null) {
                resultRow.setDetailDisplayType(Integer.valueOf(extDecisionInfo.getDetailDisplayType()));
            }
            if ("ANCHOR".equals(item.getType())) {
                resultRow.setEventName(item.getEventName());
                resultRow.setEventArgs(item.getEventArgs());
            }
            cardRowModelList.add(resultRow);
        }
        return cardRowModelList;
    }

    private void createCardRowByLinkupBillResult(List<LinkUpBillResult> linkUpBillResultList, List<CardRowModel> cardRowModelList, List<CardRowModel> statisticsList, Set<LinkUpBillResult> notShow, String areaPk, String decisionPk) {
        for (LinkUpBillResult billResult : linkUpBillResultList) {
            if (notShow != null && notShow.contains(billResult)) continue;
            CardRowModel resultRow = this.createCardRow(billResult, areaPk, decisionPk);
            cardRowModelList.add(resultRow);
            statisticsList.add(resultRow);
        }
    }

    private FasindexModel createFasindex(FasindexResult fasindexResult, DecisionResult result) {
        FasindexModel fasindexModel = new FasindexModel();
        fasindexModel.setTitle(fasindexResult.getTitle());
        List fasindexCardDataResultList = fasindexResult.getCardData();
        ArrayList<Object> fasindexTableDataModelList = new ArrayList<Object>(fasindexCardDataResultList.size());
        FasindexConfig fc = result.getDecision().getFasindexConfig();
        int precision = fc.getPrecision();
        precision = precision >= 10 ? 10 : precision;
        NumericalUnitEnum numericalUnitEnum = fc.getNumericalUnit();
        ArrayList<FasindexTableDataModel> nullFasindexTableDataModelList = new ArrayList<FasindexTableDataModel>(fasindexCardDataResultList.size());
        for (FasindexResult.FasindexCardDataResult cardDataResult : fasindexCardDataResultList) {
            FasindexTableDataModel fasindexTableDataModel = new FasindexTableDataModel();
            String valueTypeAlias = cardDataResult.getValueType().getAlias();
            NumericalUnitEnum processEnum = cardDataResult.getValueType() == FasindexConfig.ValueTypeEnum.C_03 || cardDataResult.getValueType() == FasindexConfig.ValueTypeEnum.C_01 ? NumericalUnitEnum.PERCENTAGE : (numericalUnitEnum == null ? NumericalUnitEnum.NULL : numericalUnitEnum);
            Object value = cardDataResult.getValue();
            String valueTxt = null;
            if (value != null) {
                BigDecimal castValue = new BigDecimal(String.valueOf(value));
                BigDecimal processValue = BigDecimal.ZERO.compareTo(castValue) == 0 ? BigDecimal.ZERO : processEnum.calUnitScale(castValue, precision);
                valueTxt = processValue + processEnum.getName();
                fasindexTableDataModelList.add(fasindexTableDataModel);
            } else {
                nullFasindexTableDataModelList.add(fasindexTableDataModel);
            }
            fasindexTableDataModel.setValue(valueTxt);
            fasindexTableDataModel.setValueType(valueTypeAlias);
            List pairList = cardDataResult.getDimension();
            ArrayList<DimensionModel> dimensionModelList = new ArrayList<DimensionModel>(pairList.size());
            for (FasindexResult.FasindexRow row : pairList) {
                DimensionModel dm = new DimensionModel();
                dm.setKey(String.valueOf(row.displayDimension));
                dm.setValue(String.valueOf(row.value));
                dimensionModelList.add(dm);
            }
            fasindexTableDataModel.setDimension(dimensionModelList);
        }
        fasindexTableDataModelList.addAll(nullFasindexTableDataModelList);
        fasindexModel.setTableData(fasindexTableDataModelList);
        return fasindexModel;
    }

    private StatisticModel createStatistic(StatisticsResult statisticsResult, DecisionResult result) {
        StatisticModel sm = new StatisticModel();
        sm.setTitle(result.getDecision().getName());
        if (!statisticsResult.isHeadMode()) {
            List table = statisticsResult.getDataTable();
            if (table != null && !table.isEmpty()) {
                sm.setTable(!statisticsResult.isNotTable());
                sm.setHeadList(statisticsResult.getTitleList());
                sm.setTableData(statisticsResult.getDataTable());
            }
        } else {
            List table = statisticsResult.getDataTable();
            if (table != null && !table.isEmpty()) {
                if (table.size() > 1) {
                    sm.setTable(true);
                    List oldTitleList = statisticsResult.getTitleList();
                    List titleList = oldTitleList.subList(1, oldTitleList.size());
                    ArrayList tableDataList = new ArrayList(table.size());
                    for (int i = 0; i < table.size(); ++i) {
                        List rowDataList = (List)table.get(i);
                        tableDataList.add(rowDataList.subList(1, rowDataList.size()));
                    }
                    sm.setHeadList(titleList);
                    sm.setTableData(tableDataList);
                } else {
                    List rowDataList = (List)table.get(0);
                    List oldTitleList = statisticsResult.getTitleList();
                    ArrayList tableDataList = new ArrayList(rowDataList.size());
                    sm.setTable(false);
                    sm.setTableData(tableDataList);
                    boolean notLast = oldTitleList.size() > rowDataList.size();
                    for (int i = 0; i < rowDataList.size(); ++i) {
                        ArrayList newRowDataList = new ArrayList(2);
                        newRowDataList.add(notLast ? oldTitleList.get(i + 1) : oldTitleList.get(i));
                        newRowDataList.add(rowDataList.get(i));
                        tableDataList.add(newRowDataList);
                    }
                }
            }
        }
        return sm;
    }

    private BillFlowModel createBillFlow(BillFlowResult billFlowResult, DecisionResult result) {
        List list;
        BillFlowModel billFlowModel = new BillFlowModel();
        String title = result.getDecision().getName();
        if (!StringUtils.isEmpty((String)title)) {
            CardRowModel titleRow = new CardRowModel();
            ArrayList<TextItemModel> itemList = new ArrayList<TextItemModel>();
            TextItemModel titleModel = new TextItemModel(result.getDecision().getName());
            titleModel.addItemStyle("color", "#333333");
            titleModel.addItemStyle("font-size", "12px");
            itemList.add(titleModel);
            titleRow.setMainDesc(itemList);
            titleRow.addMainStyle("width", "80%");
            titleRow.addMainStyle("margin-bottom", "4px");
            billFlowModel.setTitle(titleRow);
        }
        if ((list = billFlowResult.getNodeList()) != null && !list.isEmpty()) {
            List<TableLineNodeModel> modelList = this.createTableLine(list, false);
            billFlowModel.setTableLineNodeList(modelList);
        }
        return billFlowModel;
    }

    protected void createTotalRow(List<CardRowModel> cardRowModelList, List<CardRowModel> statisticCardRowModelList) {
        ItemModel item;
        List itemList;
        int successCount = 0;
        int errorCount = 0;
        for (CardRowModel cardRowModel : statisticCardRowModelList) {
            itemList = cardRowModel.getMainDesc();
            item = (ItemModel)itemList.get(0);
            String iconName = ((IconItemModel)item).getIconName();
            if (iconName.contains(ICON_AGREE)) {
                ++successCount;
                continue;
            }
            if (!iconName.contains(ICON_EXCEPTION)) continue;
            IconItemModel iconItemModel = (IconItemModel)item;
            iconItemModel.addImageStyle("width", "16px");
            iconItemModel.addImageStyle("height", "16px");
            ++errorCount;
        }
        if (errorCount > 1) {
            DecisionResult errorResult = new DecisionResult();
            errorResult.setShowText(String.format(ResManager.loadKDString((String)"%d\u9879\u68c0\u67e5\u9879\u672a\u6b63\u5e38\u68c0\u6d4b\u51fa", (String)"IDISchemaResultPCDataConvert_5", (String)"data-idi-core", (Object[])new Object[0]), errorCount));
            errorResult.setStatus("none");
            CardRowModel errorCardRow = this.createCardRow(errorResult, null);
            errorCardRow.addRowStyle("background", " #fff");
            itemList = errorCardRow.getMainDesc();
            item = (ItemModel)itemList.get(0);
            IconItemModel iconItemModel = (IconItemModel)item;
            iconItemModel.addImageStyle("width", "16px");
            iconItemModel.addImageStyle("height", "16px");
            cardRowModelList.add(0, errorCardRow);
        }
        if (successCount > 1) {
            DecisionResult successResult = new DecisionResult();
            successResult.setShowText(String.format(ResManager.loadKDString((String)"%d\u9879\u68c0\u67e5\u9879\u5408\u89c4", (String)"IDISchemaResultPCDataConvert_4", (String)"data-idi-core", (Object[])new Object[0]), successCount));
            successResult.setStatus("green");
            CardRowModel successCardRow = this.createCardRow(successResult, null);
            successCardRow.addRowStyle("background", " #fff");
            cardRowModelList.add(0, successCardRow);
        }
    }

    private List<CardRowModel> createNewsData(NewsResult newsResult, NewsConfig newsConfig) {
        ArrayList<Object> secondList;
        List newsList;
        CardRowModel cardRowModel;
        Company company;
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>();
        List companyList = newsResult.getCompanyList();
        if (companyList != null && !companyList.isEmpty() && (company = (Company)companyList.get(0)) != null) {
            cardRowModel = new CardRowModel();
            ArrayList itemList = new ArrayList();
            TextItemModel textItemModel = new TextItemModel(company.getCompanyName());
            textItemModel.addItemStyle("color", "#4570D3");
            itemList.add(textItemModel);
            DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
            List newsCatalogs = newsConfig.getBusinessCatalogs();
            if (newsCatalogs != null && !newsCatalogs.isEmpty()) {
                for (String catalogs : newsCatalogs) {
                    BusinessCatalogs businessCatalogs = BusinessCatalogs.convertFromKeyWord((String)catalogs);
                    String value = null;
                    try {
                        Object val = FieldUtils.readDeclaredField((Object)company, (String)BusinessCatalogs.newsCatalogChange((String)catalogs), (boolean)true);
                        if (val != null) {
                            value = (String)val;
                        }
                    }
                    catch (IllegalAccessException ex) {
                        SchemaExecutorLogger.error((String)catalogs, (Throwable)ex);
                    }
                    frontEndResult.addHoverContent(new HoverContent[]{HoverContent.createText((String)businessCatalogs.getCaption()), HoverContent.createText((String)value)});
                }
            }
            PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
            textItemModel.addItemStyle("cursor", "pointer");
            textItemModel.addItemStyle("color", "#5582F3");
            textItemModel.setPopover(popover);
            cardRowModel.setMainDesc((List)itemList);
            cardRowModel.addMainStyle("width", "80%");
            rtn.add(cardRowModel);
        }
        if ((newsList = newsResult.getNewsList()) != null && !newsList.isEmpty()) {
            for (News news : newsList) {
                cardRowModel = new CardRowModel();
                URLItemModel main = new URLItemModel(news.getTitle(), news.getNewsUrl());
                main.addItemStyle("color", "#666");
                main.addItemStyle("font-size", "12px");
                ArrayList<URLItemModel> mainList = new ArrayList<URLItemModel>();
                mainList.add(main);
                secondList = new ArrayList(3);
                for (String s : new String[]{news.getNewsSource(), " \u00b7 ", news.getPublishTime()}) {
                    TextItemModel rowItemModel = new TextItemModel(s);
                    secondList.add((ItemModel)rowItemModel);
                }
                cardRowModel.addRowStyle("flex-direction", "column");
                cardRowModel.addRowStyle("align-items", "flex-start");
                cardRowModel.setMainDesc(mainList);
                cardRowModel.setSecondDesc(secondList);
                cardRowModel.addSecondStyle("color", "#A4A8AB");
                cardRowModel.addSecondStyle("font-size", "10px");
                cardRowModel.addSecondStyle("line-height", "16px");
                cardRowModel.addSecondStyle("margin-top", "4px");
                rtn.add(cardRowModel);
            }
        } else {
            String noNewsMesg = ResManager.loadKDString((String)"\u672a\u68c0\u7d22\u5230\u65b0\u95fb", (String)"IDISchemaResultPCDataConvert_22", (String)"data-idi-core", (Object[])new Object[0]);
            CardRowModel noNewCardRowModel = new CardRowModel();
            ArrayList<Object> mainList = new ArrayList<Object>();
            IconItemModel iconItemModel = new IconItemModel("none.png");
            mainList.add(iconItemModel);
            mainList.add(new TextItemModel(noNewsMesg));
            noNewCardRowModel.setMainDesc(mainList);
            secondList = new ArrayList<ItemModel>();
            this.cardRowStyle(noNewCardRowModel, null, secondList);
            rtn.add(noNewCardRowModel);
        }
        return rtn;
    }

    private List<CardRowModel> createTableData(TableDataResult tableDataResult) {
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>(10);
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<TextItemModel> itemList = new ArrayList<TextItemModel>();
        itemList.add(new TextItemModel(tableDataResult.getTitle()));
        cardRowModel.setMainDesc(itemList);
        cardRowModel.addMainStyle("width", "50%");
        rtn.add(cardRowModel);
        List tableList = tableDataResult.getData();
        if (tableList != null && !tableList.isEmpty()) {
            int len = tableList.size();
            for (int i = 0; i < len; ++i) {
                List row = (List)tableDataResult.getData().get(i);
                HoverContent popover = (HoverContent)tableDataResult.getPopover().get(i);
                cardRowModel = new CardRowModel();
                ArrayList<Object> itemList2 = new ArrayList<Object>();
                TimeLineItemModel timeLineModel = new TimeLineItemModel(((HoverContent)row.get(0)).getContent());
                timeLineModel.setId((long)i);
                if (i == 0) {
                    timeLineModel.setFlag(TimeLineFlag.First);
                } else if (i == len - 1) {
                    timeLineModel.setFlag(TimeLineFlag.Lastest);
                }
                itemList2.add(timeLineModel);
                IconItemModel iconModel = new IconItemModel("remark_hover.png");
                iconModel.setItemStyle((Map)new HashMap<String, String>(){
                    {
                        this.put("visibility", "hidden");
                        this.put("margin-left", "20px");
                    }
                });
                itemList2.add(iconModel);
                if (popover != null && StringUtils.isNotEmpty((String)popover.getContent())) {
                    iconModel.addItemStyle("cursor", "pointer");
                    iconModel.setPopover(this.createCardPopover(popover));
                }
                this.tableDataIconStyleChange(iconModel);
                cardRowModel.setMainDesc(itemList2);
                cardRowModel.addMainStyle("width", "60%");
                itemList2 = new ArrayList();
                HoverContent rightHoverContent = (HoverContent)row.get(1);
                HrefItemModel textItemModel = HoverContent.ContentType.HREF == rightHoverContent.getType() || HoverContent.ContentType.CHAT == rightHoverContent.getType() ? new HrefItemModel(rightHoverContent.getContent(), rightHoverContent.getData()) : new TextItemModel(rightHoverContent.getContent());
                itemList2.add(textItemModel);
                cardRowModel.setSecondDesc(itemList2);
                cardRowModel.addSecondStyle("width", "36%");
                cardRowModel.addSecondStyle("justify-content", "flex-end");
                rtn.add(cardRowModel);
            }
        }
        return rtn;
    }

    protected void tableDataIconStyleChange(IconItemModel iconModel) {
    }

    private List<CardRowModel> createInvoiceCard(DecisionResult decisionResult, String areaPk) {
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>(decisionResult.getInvoiceImageRuleResults().size());
        List invoiceResultList = decisionResult.getInvoiceImageResults();
        HashMap<String, List> invoiceResultMap = new HashMap<String, List>();
        for (InvoiceImageResult invoiceResult : invoiceResultList) {
            List ruleResults = invoiceResult.getRuleResults();
            for (InvoiceImageRuleResult ruleResult : ruleResults) {
                if (ruleResult.isPass()) continue;
                String ruleNo = ruleResult.getRuleNo();
                List list = invoiceResultMap.computeIfAbsent(ruleNo, k -> new ArrayList());
                list.add(invoiceResult);
            }
        }
        boolean notShowImagePage = QueryServiceHelper.exists((String)"bas_imageconfig", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"FPY"), new QFilter("enable", "=", (Object)"A")});
        for (InvoiceImageRuleResult ruleResult : decisionResult.getInvoiceImageRuleResults()) {
            Map invoiceFailureMap;
            if (ruleResult == null) continue;
            CardRowModel cardRowModel = new CardRowModel();
            DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
            ArrayList<Object> mainList = new ArrayList<Object>();
            IconItemModel iconItemModel = new IconItemModel("block.png");
            mainList.add(iconItemModel);
            String showText = ruleResult.getText();
            String status = ruleResult.getStatus();
            if (!StringUtils.isEmpty((String)status)) {
                iconItemModel.setIconName(this.getIcon(status));
            }
            mainList.add(new TextItemModel(showText));
            cardRowModel.setMainDesc(mainList);
            cardRowModel.addMainStyle("width", "91%");
            List<List<HoverContent>> hoverContent = new ArrayList<List<HoverContent>>();
            if (!"A009".equalsIgnoreCase(ruleResult.getRuleNo())) {
                ArrayList<HoverContent> title = new ArrayList<HoverContent>();
                if ("A003".equalsIgnoreCase(ruleResult.getRuleNo())) {
                    if (!notShowImagePage) {
                        title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u672c\u5355\u9875\u7801", (String)"IDISchemaResultPCDataConvert_14", (String)"data-idi-core", (Object[])new Object[0])));
                        title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u91cd\u590d\u53d1\u7968\u7684\u5f71\u50cf\u9875\u7801", (String)"IDISchemaResultPCDataConvert_12", (String)"data-idi-core", (Object[])new Object[0])));
                    }
                    title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u91cd\u590d\u53d1\u7968\u7684\u5f71\u50cf\u7f16\u53f7", (String)"IDISchemaResultPCDataConvert_13", (String)"data-idi-core", (Object[])new Object[0])));
                } else {
                    if (!notShowImagePage) {
                        title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u5f71\u50cf\u9875\u7801", (String)"IDISchemaResultPCDataConvert_6", (String)"data-idi-core", (Object[])new Object[0])));
                    }
                    title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u53f7", (String)"IDISchemaResultPCDataConvert_8", (String)"data-idi-core", (Object[])new Object[0])));
                }
                title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"IDISchemaResultPCDataConvert_7", (String)"data-idi-core", (Object[])new Object[0])));
                hoverContent.add(title);
                List list = (List)invoiceResultMap.get(ruleResult.getRuleNo());
                if (list != null && !list.isEmpty()) {
                    HashMap continuousListMap = new HashMap(8);
                    for (Object invoiceResult : list) {
                        if ("A003".equalsIgnoreCase(ruleResult.getRuleNo())) {
                            List duplicatedList = invoiceResult.getDuplicatedList();
                            if (duplicatedList == null) continue;
                            for (List rowList : duplicatedList) {
                                int index;
                                if (rowList == null) continue;
                                ArrayList<HoverContent> rowHoverContentList = new ArrayList<HoverContent>(rowList.size());
                                if (!notShowImagePage) {
                                    rowHoverContentList.add(HoverContent.createText((String)invoiceResult.getImagePage()));
                                }
                                boolean lastNoProcess = rowList.size() >= 4;
                                int n = index = notShowImagePage ? 1 : 0;
                                while (index < rowList.size()) {
                                    String s = (String)rowList.get(index);
                                    if (lastNoProcess && index == rowList.size() - 2) {
                                        rowHoverContentList.add(HoverContent.createViewInvoice((String)s, (String)((String)rowList.get(index + 1))));
                                        ++index;
                                    } else {
                                        rowHoverContentList.add(HoverContent.createText((String)s));
                                    }
                                    ++index;
                                }
                                hoverContent.add(rowHoverContentList);
                            }
                            continue;
                        }
                        if ("A011".equalsIgnoreCase(ruleResult.getRuleNo())) {
                            continuousListMap.putAll(invoiceResult.getContinuousListMap());
                            continue;
                        }
                        ArrayList<HoverContent> row = new ArrayList<HoverContent>();
                        if (!notShowImagePage) {
                            row.add(HoverContent.createText((String)invoiceResult.getImagePage()));
                        }
                        row.add(HoverContent.createText((String)invoiceResult.getImageNo()));
                        row.add(HoverContent.createText((String)invoiceResult.getInvoiceNo()));
                        hoverContent.add(row);
                    }
                    if (!continuousListMap.isEmpty()) {
                        Object invoiceResult;
                        ArrayList continuousList = new ArrayList(continuousListMap.values());
                        continuousList.sort((v1, v2) -> Math.toIntExact(new BigDecimal((String)v1.get(2)).compareTo(new BigDecimal((String)v2.get(2)))));
                        invoiceResult = continuousList.iterator();
                        while (invoiceResult.hasNext()) {
                            int index;
                            List rowList = (List)invoiceResult.next();
                            if (rowList == null) continue;
                            ArrayList<HoverContent> rowHoverContentList = new ArrayList<HoverContent>(rowList.size());
                            int n = index = notShowImagePage ? 1 : 0;
                            while (index < rowList.size()) {
                                String s = (String)rowList.get(index);
                                rowHoverContentList.add(HoverContent.createText((String)s));
                                ++index;
                            }
                            hoverContent.add(rowHoverContentList);
                        }
                    }
                }
                frontEndResult.setTableStyle(true);
            }
            if ("none".equalsIgnoreCase(status) && "A010".equalsIgnoreCase(ruleResult.getRuleNo()) && (invoiceFailureMap = decisionResult.getFailureInvoiceMap()) != null && !invoiceFailureMap.isEmpty()) {
                hoverContent = this.addFailureInvoiceHoverContent(hoverContent, invoiceFailureMap);
                frontEndResult.setTableStyle(true);
            }
            if (ruleResult.getFullAmounts() != null) {
                String[] amounts = ruleResult.getFullAmounts();
                int invoiceAmount = 0;
                int billAmount = 1;
                ArrayList<HoverContent> invoiceRow = new ArrayList<HoverContent>();
                invoiceRow.add(HoverContent.createText((String)ResManager.loadKDString((String)"\u53d1\u7968\u603b\u91d1\u989d", (String)"IDISchemaResultPCDataConvert_10", (String)"data-idi-core", (Object[])new Object[0])));
                invoiceRow.add(HoverContent.createText((String)amounts[invoiceAmount]));
                hoverContent.add(invoiceRow);
                ArrayList<HoverContent> billRow = new ArrayList<HoverContent>();
                billRow.add(HoverContent.createText((String)ResManager.loadKDString((String)"\u6e90\u5355\u91d1\u989d", (String)"IDISchemaResultPCDataConvert_11", (String)"data-idi-core", (Object[])new Object[0])));
                billRow.add(HoverContent.createText((String)amounts[billAmount]));
                hoverContent.add(billRow);
                frontEndResult.setTableStyle(false);
            }
            if (hoverContent.size() > 1) {
                List rowList;
                frontEndResult.setHoverContent(hoverContent);
                PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
                if (("A003".equalsIgnoreCase(ruleResult.getRuleNo()) || "A011".equalsIgnoreCase(ruleResult.getRuleNo())) && !notShowImagePage && (rowList = popover.getPopoverItemList()) != null && !rowList.isEmpty()) {
                    for (PopoverRowModel row : rowList) {
                        List itemList = row.getPopoverRow();
                        if (itemList == null || itemList.isEmpty()) continue;
                        ((ItemModel)itemList.get(0)).addItemStyle("width", "60px");
                        if (!"A011".equalsIgnoreCase(ruleResult.getRuleNo())) continue;
                        ((ItemModel)itemList.get(1)).addItemStyle("width", "200px");
                        ((ItemModel)itemList.get(2)).addItemStyle("width", "100px");
                    }
                }
                ArrayList<IconItemModel> secondList = new ArrayList<IconItemModel>();
                IconItemModel iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add(iconModel);
                cardRowModel.setSecondDesc(secondList);
                this.invoiceRowStyle(iconModel, cardRowModel);
            }
            if (ruleResult.getRuleNo().startsWith("C00")) {
                cardRowModel.setHighLightAttr(areaPk + "_" + decisionResult.getDecision().getPk() + "_" + ruleResult.getRuleNo());
            }
            rtn.add(cardRowModel);
        }
        return rtn;
    }

    protected void invoiceRowStyle(IconItemModel iconModel, CardRowModel cardRowModel) {
        iconModel.setItemStyle((Map)new HashMap<String, String>(){
            {
                this.put("margin-left", "20px");
            }
        });
        iconModel.addItemStyle("cursor", "pointer");
        cardRowModel.addSecondStyle("width", "22%");
        cardRowModel.addSecondStyle("justify-content", "flex-end");
        cardRowModel.addMainStyle("width", "78%");
    }

    protected CardRowModel createCardRow(DecisionResult decisionResult, String areaPk) {
        String showText;
        Decision decision = decisionResult.getDecision();
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<Object> mainList = new ArrayList<Object>();
        IconItemModel iconItemModel = this.createCardRowIcon(decisionResult);
        if (iconItemModel != null) {
            mainList.add(iconItemModel);
        }
        if (StringUtils.isEmpty((String)(showText = decisionResult.getShowText()))) {
            showText = decision.getName();
        }
        mainList.add(new TextItemModel(showText));
        cardRowModel.setMainDesc(mainList);
        if (decision != null) {
            if (MatchType.KEYWORD.getType().equals(decision.getMatchType())) {
                cardRowModel.setHighLightAttr(areaPk + "_" + decision.getPk());
            } else if (MatchType.ATTACHMENT.getType().equals(decision.getMatchType()) && decision.getAttachmentConfig().getCheckType() == CheckAttachmentTypeEnum.CHECKEXISTS && decisionResult.getStatus().equals("green")) {
                cardRowModel.setHighLightAttr(areaPk + "_" + decision.getPk() + "_" + Integer.MAX_VALUE);
            }
        }
        ArrayList<ItemModel> secondList = new ArrayList<ItemModel>();
        IconItemModel iconModel = null;
        DecisionFrontEndResult frontEndResult = decisionResult.getFrontEndResult();
        if (frontEndResult != null) {
            if (this.isHighLight) {
                this.increaseHighLightMesg(cardRowModel, frontEndResult);
            }
            PopoverModel popover = this.createCardPopover(frontEndResult, new String[]{decision != null ? decision.getMatchType() : null});
            if (!StringUtils.isEmpty((String)frontEndResult.getHoverText())) {
                String content = frontEndResult.getHoverText();
                TextItemModel dataContent = new TextItemModel(content);
                if (popover != null) {
                    dataContent.addItemStyle("cursor", "pointer");
                    dataContent.addItemStyle("color", "#5582F3");
                    dataContent.setPopover(popover);
                }
                secondList.add((ItemModel)dataContent);
            } else {
                iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add((ItemModel)iconModel);
            }
        }
        this.cardRowStyle(cardRowModel, iconModel, secondList);
        if (decision != null && MatchType.GENERALLEDGER.getType().equals(decision.getMatchType())) {
            cardRowModel.addMainStyle("width", "50%");
            cardRowModel.addSecondStyle("width", "50%");
        }
        return cardRowModel;
    }

    private void increaseHighLightMesg(CardRowModel cardRowModel, DecisionFrontEndResult frontEndResult) {
        String highLightAttr = cardRowModel.getHighLightAttr();
        if (StringUtils.isEmpty((String)highLightAttr)) {
            return;
        }
        List contentList = frontEndResult.getHoverContent();
        if (CollectionUtils.isNotEmpty((Collection)contentList)) {
            for (List hoverContents : contentList) {
                if (CollectionUtils.isEmpty((Collection)hoverContents)) continue;
                for (HoverContent hoverContent : hoverContents) {
                    if (hoverContent == null || !hoverContent.showBillFormAction()) continue;
                    hoverContent.getData().put("highLightKey", highLightAttr);
                }
            }
        }
    }

    protected IconItemModel createCardRowIcon(DecisionResult decisionResult) {
        IconItemModel iconItemModel = new IconItemModel("block.png");
        String status = decisionResult.getStatus();
        if (!StringUtils.isEmpty((String)status)) {
            iconItemModel.setIconName(this.getIcon(status));
        }
        return iconItemModel;
    }

    protected void cardRowStyle(CardRowModel cardRowModel, IconItemModel iconModel, List<ItemModel> secondList) {
        if (iconModel != null) {
            iconModel.addItemStyle("margin-left", "20px");
            iconModel.addItemStyle("cursor", "pointer");
        }
        if (CollectionUtils.isEmpty(secondList)) {
            cardRowModel.addMainStyle("width", "91%");
        } else {
            cardRowModel.addMainStyle("width", "78%");
            cardRowModel.setSecondDesc(secondList);
            cardRowModel.addSecondStyle("width", "22%");
            cardRowModel.addSecondStyle("justify-content", "flex-end");
        }
    }

    private CardRowModel createCardRow(LinkUpBillResult linkUpBillResult, String areaPk, String decisionPk) {
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<Object> mainList = new ArrayList<Object>();
        IconItemModel iconItemModel = this.createCardRowIcon(linkUpBillResult);
        if (iconItemModel != null) {
            mainList.add(iconItemModel);
        }
        String showText = linkUpBillResult.getShowText();
        mainList.add(new TextItemModel(showText));
        cardRowModel.setMainDesc(mainList);
        if (linkUpBillResult.getMatchRule() > -1) {
            cardRowModel.setHighLightAttr(areaPk + "_" + decisionPk + "_" + linkUpBillResult.getMatchRule());
        }
        ArrayList<ItemModel> secondList = new ArrayList<ItemModel>();
        IconItemModel iconModel = null;
        DecisionFrontEndResult frontEndResult = linkUpBillResult.getFrontEndResult();
        if (frontEndResult != null) {
            if (this.isHighLight) {
                this.increaseHighLightMesg(cardRowModel, frontEndResult);
            }
            PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
            if (!StringUtils.isEmpty((String)frontEndResult.getHoverText())) {
                String content = frontEndResult.getHoverText();
                TextItemModel dataContent = new TextItemModel(content);
                if (popover != null) {
                    dataContent.addItemStyle("cursor", "pointer");
                    dataContent.addItemStyle("color", "#5582F3");
                    dataContent.setPopover(popover);
                }
                secondList.add((ItemModel)dataContent);
            } else {
                iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add((ItemModel)iconModel);
            }
        }
        this.cardRowStyle(cardRowModel, iconModel, secondList);
        return cardRowModel;
    }

    protected IconItemModel createCardRowIcon(LinkUpBillResult linkUpBillResult) {
        IconItemModel iconItemModel = new IconItemModel("block.png");
        String status = linkUpBillResult.getStatus();
        if (!StringUtils.isEmpty((String)status)) {
            iconItemModel.setIconName(this.getIcon(status));
        }
        return iconItemModel;
    }

    private Carousel createCarousel(CourierDataResult courierDataResult) {
        List courierList = courierDataResult.getCourierList();
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>(2);
        Carousel carousel = new Carousel();
        carousel.setItems(rtn);
        int size = 5;
        carousel.setSize(size);
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<TextItemModel> itemList = new ArrayList<TextItemModel>();
        TextItemModel titleModel = new TextItemModel(courierDataResult.getTitle());
        titleModel.addItemStyle("color", "#333333");
        itemList.add(titleModel);
        if (!StringUtils.isEmpty((String)courierDataResult.getTotalDesc())) {
            TextItemModel descModel = new TextItemModel();
            descModel.addItemStyle("font-size", "10px");
            descModel.addItemStyle("color", "#98A1A8");
            descModel.addItemStyle("margin-left", "4px");
            descModel.setContent(courierDataResult.getTotalDesc());
            itemList.add(descModel);
        }
        cardRowModel.setMainDesc(itemList);
        cardRowModel.addMainStyle("width", "80%");
        rtn.add(cardRowModel);
        if (courierList != null && !courierList.isEmpty()) {
            int total = courierList.size();
            for (Courier courier : courierList) {
                cardRowModel = new CardRowModel();
                ArrayList<TextItemModel> mainList = new ArrayList<TextItemModel>(2);
                TextItemModel company = new TextItemModel(courier.getCompany());
                company.addItemStyle("color", "#333333");
                company.addItemStyle("font-size", "12px");
                mainList.add(company);
                TextItemModel order = new TextItemModel(courier.getOrder());
                if (courier.isSuccess()) {
                    order.addItemStyle("color", "#5582F3");
                } else {
                    order.addItemStyle("color", "#666666");
                }
                order.addItemStyle("cursor", "default");
                order.addItemStyle("font-size", "12px");
                order.addItemStyle("margin-left", "6px");
                List<TableLineNodeModel> orderTableLine = this.createTableLine(courier.getTableLine(), true);
                if (orderTableLine != null) {
                    PopoverModel pm = new PopoverModel();
                    pm.setTableLineNodeList(orderTableLine);
                    order.setPopover(pm);
                }
                mainList.add(order);
                cardRowModel.setMainDesc(mainList);
                cardRowModel.addMainStyle("flex-direction", "row");
                cardRowModel.addMainStyle("align-items", "flex-start");
                ArrayList<TextItemModel> secondList = new ArrayList<TextItemModel>(1);
                TextItemModel time = new TextItemModel(courier.getTimeDesc());
                time.addItemStyle("color", "#98A1A8");
                time.addItemStyle("font-size", "12px");
                secondList.add(time);
                cardRowModel.setSecondDesc(secondList);
                cardRowModel.addSecondStyle("margin-top", "4px");
                cardRowModel.addRowStyle("flex-direction", "column");
                cardRowModel.addRowStyle("align-items", "flex-start");
                cardRowModel.addRowStyle("padding-bottom", "8px");
                rtn.add(cardRowModel);
            }
            int pageCount = total % size != 0 ? total / size + 1 : total / size;
            boolean isMore = pageCount > 0;
            carousel.setPage(pageCount);
            carousel.setHasNext(isMore);
            carousel.addNextStyle("width", (Object)"18px");
            carousel.addNextStyle("height", (Object)"40px");
            carousel.addNextStyle("background-color", (Object)"#F6F7F9");
            carousel.addNextStyle("cursor", (Object)"pointer");
            carousel.setHasPage(isMore);
            carousel.setHasPrevious(isMore);
            carousel.addPreviousStyle("width", (Object)"18px");
            carousel.addPreviousStyle("height", (Object)"40px");
            carousel.addPreviousStyle("background-color", (Object)"#F6F7F9");
            carousel.addPreviousStyle("cursor", (Object)"pointer");
            carousel.addPageWrapperStyle("height", (Object)"280px");
            carousel.addPageWrapperStyle("width", (Object)"100%");
            carousel.addPageWrapperStyle("background-color", (Object)"#ffffff");
            carousel.addPageWrapperStyle("overflow", (Object)"hidden");
            carousel.addPageNumberStyle("text-align", (Object)"center");
        }
        return carousel;
    }

    private List<TableLineNodeModel> createTableLine(List<TableLineNode> tableLineNodes, boolean isPopover) {
        if (tableLineNodes != null && !tableLineNodes.isEmpty()) {
            ArrayList<TableLineNodeModel> list = new ArrayList<TableLineNodeModel>(tableLineNodes.size());
            for (TableLineNode node : tableLineNodes) {
                TableLineNodeModel nodeModel = new TableLineNodeModel();
                NodeStatusEnum nodeStatus = node.getStatus();
                IconItemModel imgModel = new IconItemModel(this.getTableNodeIcon(nodeStatus));
                nodeModel.setImgModel(imgModel);
                imgModel.addItemStyle("width", "18px");
                TextItemModel titleModel = new TextItemModel(node.getTitle());
                titleModel.addItemStyle("color", "#333333");
                titleModel.addItemStyle("font-size", "12px");
                nodeModel.setTitleModel(titleModel);
                List titleDescriptList = node.getTitleDescrpt();
                if (titleDescriptList != null && !titleDescriptList.isEmpty()) {
                    ArrayList<TextItemModel> titleDescrptModels = new ArrayList<TextItemModel>(titleDescriptList.size());
                    nodeModel.setTitleDescrptModels(titleDescrptModels);
                    for (HoverContent hc : titleDescriptList) {
                        Object color;
                        TextItemModel titleDescModel = new TextItemModel(hc.getContent());
                        titleDescModel.addItemStyle("color", "#98A1A8");
                        Map colorMap = hc.getData();
                        Object v0 = color = colorMap == null || colorMap.isEmpty() ? null : colorMap.get("color");
                        if (color != null) {
                            titleDescModel.addItemStyle("color", String.valueOf(color));
                        }
                        titleDescrptModels.add(titleDescModel);
                    }
                    nodeModel.addTitleDescrptWrapperStyle("display", (Object)"flex");
                    nodeModel.addTitleDescrptWrapperStyle("flex-grow", (Object)"1");
                    nodeModel.addTitleDescrptWrapperStyle("justify-content", (Object)"flex-end");
                }
                nodeModel.addHeaderWrapperStyle("display", (Object)"flex");
                if (node.getLineStatus() != null) {
                    nodeModel.addLineStatusStyle("background", (Object)this.getTableLineColor(node.getLineStatus()));
                }
                nodeModel.addLineStatusStyle("width", (Object)"1px");
                nodeModel.addLineStatusStyle("height", (Object)"100%");
                nodeModel.addLineStatusStyle("margin-left", (Object)"7px");
                nodeModel.addLineStatusStyle("min-height", (Object)"12px");
                nodeModel.addLineCardWrapperStyle("background", (Object)"#F8F9FB");
                nodeModel.addLineCardWrapperStyle("margin-left", (Object)"6px");
                nodeModel.addLineCardWrapperStyle("margin-top", (Object)"4px");
                nodeModel.addLineCardWrapperStyle("margin-bottom", (Object)"12px");
                nodeModel.addLineCardWrapperStyle("width", (Object)"100%");
                List lineCards = node.getCardList();
                if (lineCards != null && !lineCards.isEmpty()) {
                    for (int i = 0; i < lineCards.size(); ++i) {
                        LineCard lc = (LineCard)lineCards.get(i);
                        List titles = lc.getLeftText();
                        List valueOrDescList = lc.getRightText();
                        if (titles == null || titles.isEmpty()) continue;
                        LineCardModel lcm = new LineCardModel();
                        lcm.addLineCardStyle("backeground", (Object)"#F8F9FB");
                        lcm.addLineCardStyle("padding-top", (Object)"4px");
                        lcm.addLineCardStyle("padding-bottom", (Object)"4px");
                        lcm.addLineCardStyle("padding-left", (Object)"6px");
                        if (i > 1) {
                            lcm.addLineCardStyle("border-top-color", (Object)"#E6E8EE");
                            lcm.addLineCardStyle("border-top-width", (Object)"1px");
                            lcm.addLineCardStyle("border-top-style", (Object)"solid");
                        }
                        for (int j = 0; j < titles.size(); ++j) {
                            HoverContent rowHoverContent = (HoverContent)titles.get(j);
                            List valueOrDescs = valueOrDescList != null && valueOrDescList.size() > j ? (List)valueOrDescList.get(j) : null;
                            LineCardRowModel rowModel = new LineCardRowModel();
                            TextItemModel rowTitleModel = new TextItemModel(rowHoverContent.getContent());
                            rowTitleModel.addItemStyle("color", "#666666");
                            rowTitleModel.addItemStyle("font-size", "12px");
                            rowTitleModel.addItemStyle("text-overflow", "inherit");
                            rowTitleModel.addItemStyle("white-space", "inherit");
                            rowModel.addRowStyle("padding-bottom", (Object)"4px");
                            rowModel.addLeftStyle("width", (Object)(isPopover ? "90%" : "40%"));
                            rowModel.addLeftStyle("text-align", (Object)"left");
                            rowModel.setLeftModel(rowTitleModel);
                            if (valueOrDescs != null && !valueOrDescs.isEmpty()) {
                                for (HoverContent hc : valueOrDescs) {
                                    Object color;
                                    if (HoverContent.ContentType.HREF == hc.getType() || HoverContent.ContentType.CHAT == hc.getType()) {
                                        rowModel.addRightModels((ItemModel)new HrefItemModel(hc.getContent(), hc.getData()));
                                        continue;
                                    }
                                    TextItemModel rowValueOrDescModel = new TextItemModel(hc.getContent());
                                    rowValueOrDescModel.addItemStyle("color", "#333333");
                                    rowValueOrDescModel.addItemStyle("font-size", "12px");
                                    Map colorMap = hc.getData();
                                    Object v1 = color = colorMap == null || colorMap.isEmpty() ? null : colorMap.get("color");
                                    if (color != null) {
                                        rowValueOrDescModel.addItemStyle("color", String.valueOf(color));
                                    }
                                    rowModel.addRightModels((ItemModel)rowValueOrDescModel);
                                }
                            }
                            rowModel.addRightStyle("width", (Object)"60%");
                            rowModel.addRightStyle("text-align", (Object)"right");
                            rowModel.addRightStyle("display", (Object)"flex");
                            rowModel.addRightStyle("justify-content", (Object)"flex-end");
                            rowModel.addRightStyle("flex-grow", (Object)"1");
                            rowModel.addRowStyle("display", (Object)"flex");
                            rowModel.addRowStyle("flex-direction", (Object)"row");
                            lcm.addlineRows(rowModel);
                        }
                        nodeModel.addLineCard(lcm);
                    }
                }
                list.add(nodeModel);
            }
            return list;
        }
        return null;
    }

    public List<List<HoverContent>> addFailureInvoiceHoverContent(List<List<HoverContent>> hoverContent, Map<String, List<InvoiceFailureEntity>> invoiceFailureMap) {
        ArrayList<HoverContent> title = new ArrayList<HoverContent>();
        ArrayList<List<HoverContent>> newHoverContent = new ArrayList<List<HoverContent>>();
        title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"IDISchemaResultPCDataConvert_15", (String)"data-idi-core", (Object[])new Object[0])));
        title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u53f7", (String)"IDISchemaResultPCDataConvert_8", (String)"data-idi-core", (Object[])new Object[0])));
        title.add(HoverContent.createTitle((String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"IDISchemaResultPCDataConvert_7", (String)"data-idi-core", (Object[])new Object[0])));
        newHoverContent.add(title);
        for (Map.Entry<String, List<InvoiceFailureEntity>> invoiceFailureEntry : invoiceFailureMap.entrySet()) {
            String errorCode = invoiceFailureEntry.getKey();
            List<InvoiceFailureEntity> invoiceFailureEntityList = invoiceFailureEntry.getValue();
            String errorMessage = InvoiceCloudCodeType.typeToCloudCodeType((String)errorCode).getErrorMessage();
            for (int i = 0; i < invoiceFailureEntityList.size(); ++i) {
                ArrayList<HoverContent> rowHoverContentList = new ArrayList<HoverContent>(invoiceFailureEntityList.size());
                rowHoverContentList.add(HoverContent.createText((String)errorMessage));
                rowHoverContentList.add(HoverContent.createText((String)invoiceFailureEntityList.get(i).getImageNumber()));
                rowHoverContentList.add(HoverContent.createText((String)invoiceFailureEntityList.get(i).getInvoiceNo()));
                newHoverContent.add(rowHoverContentList);
            }
        }
        return newHoverContent;
    }

    private String getTableNodeIcon(NodeStatusEnum nodeStatus) {
        switch (nodeStatus) {
            case PAST: {
                return "agree_13_13.png";
            }
            case NOW: {
                return "running.png";
            }
            case FUTURE: {
                return "end.png";
            }
        }
        return null;
    }

    private String getTableLineColor(NodeLineStatusEnum nodeLineStatus) {
        switch (nodeLineStatus) {
            case COMPLETE: {
                return "#26B175";
            }
            case PLAN: {
                return "#CCCCCC";
            }
        }
        return null;
    }
}

