/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.salary;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.QueryPayProxyDownload;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QuerySalaryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QuerySalaryPayImpl.class);

    public int getBatchSize() {
        return 2000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Packer.createHead((String)"200201", (String)Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        String bankParameterValue = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)(StringUtils.isEmpty((String)bankParameterValue) ? ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : bankParameterValue));
        String serialNo = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"serial_no");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialNo);
        String encoding = RequestContextUtils.getCharset();
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return Packer.buildCommonMsg((String)xmlMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = Parser.parserHead((Element)root);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u72b6\u6001\u7801\u4e3a\uff1a%1$s,\u94f6\u884c\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\uff1a%2$s", (String)"QuerySalaryPayImpl_1", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        this.logger.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"QuerySalaryPayImpl_2", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
            return new EBBankPayResponse(paymentInfos);
        }
        String data = "";
        if ("1".equals(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            QueryPayProxyDownload proxyDownload = new QueryPayProxyDownload();
            data = proxyDownload.doBiz(file_name);
        } else if ("0".equals(file_flag)) {
            data = body.getChildTextTrim("serial_record");
        } else {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u7684\u6587\u4ef6\u6807\u8bc6\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ed8\u6b3e\u72b6\u6001");
            return new EBBankPayResponse(paymentInfos);
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = StringUtils.split((String)data, (String)"|");
        HashMap<String, PaymentInfo> payInfoMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            payInfoMap.put(paymentInfo.getBankRefID(), paymentInfo);
        }
        List paymentInfoAll = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID());
        bankPayRequest.setPaymentInfos(paymentInfoAll);
        List handPaymentInfos = bankPayRequest.getPaymentInfos();
        for (int i = 1; i <= recordNum; ++i) {
            String AMT;
            String accountName;
            String CARD_NO;
            String STAT;
            String ERR_MSG = splits[fieldNum * i + 10];
            if ("0".equals(file_flag) && "BOD_CMP".equalsIgnoreCase(bankPayRequest.getHeader().getBankVersionID())) {
                STAT = splits[fieldNum * i + 9];
                CARD_NO = splits[fieldNum * i + 1];
                accountName = splits[fieldNum * i + 3];
                AMT = splits[fieldNum * i + 5];
            } else {
                STAT = splits[fieldNum * i];
                CARD_NO = splits[fieldNum * i + 5];
                accountName = splits[fieldNum * i + 6];
                AMT = splits[fieldNum * i + 8];
            }
            PaymentInfo info = QuerySalaryPayImpl.findPaymentInfo(handPaymentInfos, CARD_NO, accountName, AMT);
            if (null == info) continue;
            this.handlePayStatus(info, STAT, ERR_MSG);
            PayStatusMatchUtil.preBatchSameItemCheck((List)handPaymentInfos, (boolean)false, (boolean)false);
            this.processingBankItemDataHandler(splits, recordNum, fieldNum, bankPayRequest.getHeader().getBankVersionID(), file_flag, handPaymentInfos);
            PayStatusMatchUtil.backBatchSameItemHandler((List)handPaymentInfos, (boolean)false, (boolean)false);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private void processingBankItemDataHandler(String[] splits, int recordNum, int fieldNum, String version, String file_flag, List<PaymentInfo> paymentInfos) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 1; i <= recordNum; ++i) {
                    String bankDataKey;
                    String AMT;
                    String accountName;
                    String CARD_NO;
                    String STAT;
                    String ERR_MSG = splits[fieldNum * i + 10];
                    if ("0".equals(file_flag) && "BOD_CMP".equalsIgnoreCase(version)) {
                        STAT = splits[fieldNum * i + 9];
                        CARD_NO = splits[fieldNum * i + 1];
                        accountName = splits[fieldNum * i + 3];
                        AMT = splits[fieldNum * i + 5];
                    } else {
                        STAT = splits[fieldNum * i];
                        CARD_NO = splits[fieldNum * i + 5];
                        accountName = splits[fieldNum * i + 6];
                        AMT = splits[fieldNum * i + 8];
                    }
                    PaymentInfo paymentInfo = QuerySalaryPayImpl.findPaymentInfo(paymentInfos, CARD_NO, accountName, AMT);
                    if (null == paymentInfo || !HashSetKeys.contains(bankDataKey = PayStatusMatchUtil.getKeyByPaymentInfo((PaymentInfo)paymentInfo, (boolean)false, (boolean)false))) continue;
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, STAT, ERR_MSG);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private void handlePayStatus(PaymentInfo tempInfo, String stat, String msg) {
        if ("6".equals(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)stat, (String)msg);
        } else if ("9".equals(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)stat, (String)"");
        } else if ("3".equals(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)stat, (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)stat, (String)msg);
        }
    }

    public static PaymentInfo findPaymentInfo(List<PaymentInfo> payInfos, String incomeAccNo, String incomeName, String amount) {
        if (null == payInfos || payInfos.isEmpty()) {
            return null;
        }
        BigDecimal formattedAmount = BigDecimalHelper.str2BigDecimal((String)amount);
        String amountStr = BigDecimalHelper.plain2((BigDecimal)formattedAmount);
        formattedAmount = BigDecimalHelper.str2BigDecimal((String)amountStr);
        for (PaymentInfo payInfo : payInfos) {
            if (!payInfo.getIncomeAccNo().equalsIgnoreCase(incomeAccNo) || !payInfo.getAmount().equals(formattedAmount) || !payInfo.getIncomeAccName().equals(incomeName)) continue;
            return payInfo;
        }
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u67e5\u8be2", (String)"QuerySalaryPayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg((String)super.recv(inputStream));
    }
}

