/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayParser {
    private String[] SUCCESS = new String[]{"000000"};

    public Map<String, String> parsePay6W1301(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        HashMap<String, String> rspMap = new HashMap<String, String>(16);
        Element rspRoot = CCB_DC_Parser.parseString2Root((String)rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse((Element)rspRoot);
        if (!this.isMatched(response.getResponseCode(), this.SUCCESS)) {
            throw EBExceiptionUtil.serviceException((String)response.getResponseMessage());
        }
        Element rspBody = JDomUtils.getChildElementNotNull((Element)rspRoot, (String)"TX_INFO");
        Element rspProjectList = JDomUtils.getChildElementNotNull((Element)rspBody, (String)"ProjectList");
        String billCode = JDomUtils.getChildTextNotNull((Element)rspProjectList, (String)"BILL_CODE");
        String billDesc = JDomUtils.getChildTextNotNull((Element)rspProjectList, (String)"BILL_DESC");
        String tranType = JDomUtils.getChildTextNotNull((Element)rspProjectList, (String)"TRAN_TYPE");
        String useofCode = JDomUtils.getChildTextNotNull((Element)rspProjectList, (String)"USEOF_CODE");
        String useofDesc = JDomUtils.getChildTextNotNull((Element)rspProjectList, (String)"USEOF_DESC");
        rspMap.put("billCode", billCode);
        rspMap.put("billDesc", billDesc);
        rspMap.put("tranType", tranType);
        rspMap.put("useofCode", useofCode);
        rspMap.put("useofDesc", useofDesc);
        return rspMap;
    }

    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root((String)rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse((Element)root);
        if (!this.isMatched(response.getResponseCode(), this.SUCCESS)) {
            throw EBExceiptionUtil.serviceException((String)response.getResponseMessage());
        }
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITTING, (String)ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1\u4ee3\u6263\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\u3002", (String)"PayParser_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
    }

    public void parsePay6W2100(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root((String)rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse((Element)root);
        if (this.isMatched(response.getResponseCode(), this.SUCCESS)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613\u5904\u7406\u4e2d\u3002", (String)"PayParser_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    public boolean isMatched(String responseCode, String[] fields) {
        for (String field : fields) {
            if (!field.equalsIgnoreCase(responseCode)) continue;
            return true;
        }
        return false;
    }
}

