/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.accno;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.util.CertTypeUtil;
import kd.ebg.aqap.formplugin.plugin.util.ControlUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.repository.EbcBankLoginRepository;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.FieldUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class BankAcntFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final String ENTITY_KEY_BANK_ACNT = "aqap_bank_acnt";
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private static final String ENTITY_KEY_LOGIN = "aqap_bank_login";
    private static final String ENTITY_KEY_CER = "aqap_bd_cert";
    private static final String FIELD_KEY_BANK_LOGIN = "bank_login";
    private static final String FIELD_KEY_BANK_VERSION = "group";
    private static final String FIELD_KEY_CURRENCY = "currency";
    private static final String CONTAINER_KEY_CONTAINER_FJSX = "container_fjsx";
    private static final String NOTE_BANKS_LOGING_ID = "note_banks_login_id";
    private static final String CONTAINER_KEY_CONTAINER = "conentpanel";
    private PropertyConfigInfo myPropertyConfigInfo;
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
    private EbcBankLoginRepository ebcBankLoginRepository = (EbcBankLoginRepository)SpringContextUtil.getBean(EbcBankLoginRepository.class);
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BankAcntFormPlugin.class);
    private static String BTN_PREFIX = "btn_";
    private static final String ATTACHMENTPANELKEY = "attachmentPanelKey";
    private static final String UPLOAD_FILED_NAME_MAP_KEY = "upload_filed_name_map_key";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)FIELD_KEY_BANK_VERSION, (CharSequence)fieldKey)) {
            IDataModel model = this.getModel();
            model.setValue(FIELD_KEY_BANK_LOGIN, null);
            model.setValue(FIELD_KEY_CURRENCY, null);
        }
        this.setFieldShowOrHide();
    }

    public void registerListener(EventObject e) {
        Toolbar toolbar;
        super.registerListener(e);
        BasedataEdit bankLoginFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_KEY_BANK_LOGIN);
        BasedataEdit currencyFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_KEY_CURRENCY);
        if (bankLoginFieldEdit != null) {
            bankLoginFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            bankLoginFieldEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        }
        if (currencyFieldEdit != null) {
            currencyFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmain")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        attachmentPanelKeys.stream().forEach(key -> {
            Button button = (Button)this.getView().getControl(key);
            if (button != null) {
                button.addClickListener((ClickListener)this);
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_KEY_BANK_LOGIN)) {
            this.bankLoginFilter(e);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_KEY_CURRENCY)) {
            this.currencyFilter(e);
        }
    }

    void bankLoginFilter(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String bankVersion = (String)model.getDataEntity().get("group.number");
        if (StringUtils.isNotBlank((CharSequence)bankVersion)) {
            model.getDataEntityType().getName();
            QFilter qFilter = QFilter.of((String)"group.number=? and config_type=?", (Object[])new Object[]{bankVersion, "0"});
            qFilter.and("custom_id", "=", (Object)RequestContext.get().getTenantId());
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            QFilter qFilter = QFilter.of((String)"config_type=?", (Object[])new Object[]{"0"});
            qFilter.and("custom_id", "=", (Object)RequestContext.get().getTenantId());
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    void currencyFilter(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String bankVersion = (String)model.getDataEntity().get("group.number");
        if (StringUtils.isNotBlank((CharSequence)bankVersion)) {
            QFilter qFilter = new QFilter("bank_version.number", "=", (Object)bankVersion);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        this.createDynamicPanel();
        this.getPageCache().put("hasAddToContainer", "true");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BankAcntFormPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        String bankVersion = this.getBankVersion();
        PropertyConfigInfo propertyConfigInfo = this.getBankAcntConfig(bankVersion);
        List propertyConfigItemInfos = propertyConfigInfo.getConfigItems();
        propertyConfigItemInfos.stream().forEach(propertyConfigItemInfo -> {
            if (propertyConfigItemInfo.isHide()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
            }
            if (CollectionUtil.isNotEmpty((Collection)propertyConfigItemInfo.getDefaultValues())) {
                this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), propertyConfigItemInfo.getDefaultValues().get(0));
            }
        });
        this.getModel().setValue("custom_id", (Object)RequestContext.get().getTenantId());
        this.setFieldShowOrHide();
    }

    public void afterLoadData(EventObject e) {
        String acnt = (String)this.getModel().getValue("number");
        if (StringUtils.isNotEmpty((CharSequence)acnt)) {
            PropertyConfigInfo propertyConfigInfo = this.getBankAcntConfig(this.getBankVersion());
            QFilter[] filters = new QFilter[]{new QFilter("object_id", "=", (Object)acnt), new QFilter("object_name", "=", (Object)propertyConfigInfo.getPropertyName())};
            DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_key, attr_value", (QFilter[])filters);
            if (datas.size() > 0) {
                HashSet dbDataSet = new HashSet(1);
                datas.stream().forEach(data -> {
                    String configid = data.getString("attr_key");
                    String value = data.getString("attr_value");
                    try {
                        this.getModel().setValue(configid, (Object)value);
                        dbDataSet.add(configid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                propertyConfigInfo.getConfigItems().stream().forEach(propertyConfigItemInfo -> {
                    if (!dbDataSet.contains(propertyConfigItemInfo.getKey()) && CollectionUtil.isNotEmpty((Collection)propertyConfigItemInfo.getDefaultValues())) {
                        this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), propertyConfigItemInfo.getDefaultValues().get(0));
                    }
                    if (propertyConfigItemInfo.isHide()) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
                    }
                });
            }
        }
        this.setFieldShowOrHide();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<FlexPanelAp> flexPanelApList = this.createDynamicPanel();
        Container myFldPanel = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        flexPanelApList.stream().forEach(fieldsetPanelAp -> {
            myFldPanel.getItems().addAll(((Container)fieldsetPanelAp.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(myFldPanel.getItems());
        });
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        if (CollectionUtil.isEmpty(propertyConfigItemInfos)) {
            return;
        }
        propertyConfigItemInfos.stream().forEach(propertyConfigItemInfo -> {
            if (StringUtils.equals((CharSequence)propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH), (CharSequence)e.getKey()) || StringUtils.equals((CharSequence)(BTN_PREFIX + propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)), (CharSequence)e.getKey())) {
                if (BankPropertyConfigType.UPLOAD_PARAM.getName().equals(propertyConfigItemInfo.getType()) && e.getKey().startsWith(BTN_PREFIX)) {
                    Button button = new Button();
                    button.setKey(BTN_PREFIX + propertyConfigItemInfo.getKey());
                    button.setOperationKey("upload");
                    button.setView(this.getView());
                    e.setControl((Control)button);
                } else if (ConfigInputType.MUL_SELECT.getInputType().equals(propertyConfigItemInfo.getInputType())) {
                    MulComboEdit edit = new MulComboEdit();
                    edit.setKey(propertyConfigItemInfo.getKey());
                    edit.setView(this.getView());
                    e.setControl((Control)edit);
                } else {
                    TextEdit textEdit = new TextEdit();
                    textEdit.setKey(propertyConfigItemInfo.getKey());
                    textEdit.setView(this.getView());
                    e.setControl((Control)textEdit);
                }
                return;
            }
        });
    }

    public String getBankVersion() {
        if (this.getView() == null) {
            return "";
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("tree_parent_id");
        if (jsonObject == null) {
            Long bankAcntid = (Long)baseShowParameter.getPkId();
            if (bankAcntid != null) {
                return this.ebcBankAcntRepository.getBankVersionByAcntID(bankAcntid);
            }
            return (String)baseShowParameter.getCustomParam("bankVersion");
        }
        return this.getBankVersion(jsonObject);
    }

    public String getBankVersion(JSONObject jsonObject) {
        String groupKey = jsonObject.getString("value");
        return this.getBankVersion(groupKey);
    }

    public String getBankVersion(String id) {
        QFilter filter = QFilter.of((String)"id = ?", (Object[])new Object[]{Long.parseLong(id)});
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"number", (QFilter[])filter.toArray());
        String bankVersion = (String)((DynamicObject)datas.get(0)).get("number");
        return bankVersion;
    }

    private List<FlexPanelAp> createDynamicPanel() {
        ArrayList<FlexPanelAp> result = new ArrayList<FlexPanelAp>(1);
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        if (CollectionUtil.isEmpty(propertyConfigItemInfos)) {
            return result;
        }
        String hasAddToContainer = this.getPageCache().get("hasAddToContainer");
        Container container = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        if (CollectionUtil.isNotEmpty(propertyConfigItemInfos)) {
            FlexPanelAp flex = ControlUtil.createFlexPanelAp((String)CONTAINER_KEY_CONTAINER_FJSX);
            propertyConfigItemInfos.forEach(propertyConfigItemInfo -> {
                String key = propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH);
                if (key.equals(NOTE_BANKS_LOGING_ID)) {
                    List all = BankLoginRepository.getInstance().findNoteLoginByCustomerIDAndEnable(RequestContext.get().getTenantId(), "1");
                    ArrayList<String> bankLoginName = new ArrayList<String>(all.size());
                    ArrayList<String> bankLoginID = new ArrayList<String>(all.size());
                    if (CollectionUtil.isNotEmpty((Collection)all)) {
                        for (BankLogin info : all) {
                            bankLoginName.add(info.getBankName() + info.getKey().getBankLoginId());
                            bankLoginID.add(info.getKey().getBankLoginId());
                        }
                    }
                    propertyConfigItemInfo.setSourceNames(bankLoginName);
                    propertyConfigItemInfo.setSourceValues(bankLoginID);
                }
            });
            ControlUtil.addFieldsetPanelApItems((FlexPanelAp)flex, propertyConfigItemInfos);
            if (hasAddToContainer == null) {
                container.addControls(Collections.singletonList(flex.createControl()));
            }
            result.add(flex);
        }
        return result;
    }

    public List<PropertyConfigItemInfo> getPropertyConfigItemInfoList(String bankVersion) {
        PropertyConfigInfo propertyConfigInfo = this.getBankAcntConfig(bankVersion);
        if (propertyConfigInfo != null) {
            return propertyConfigInfo.getConfigItems();
        }
        return null;
    }

    public PropertyConfigInfo getBankAcntConfig(String bankVersion) {
        if (this.myPropertyConfigInfo != null) {
            return this.myPropertyConfigInfo;
        }
        this.myPropertyConfigInfo = this.infoService.getBankAcntConfig(bankVersion);
        return this.myPropertyConfigInfo;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        if (CollectionUtil.isEmpty(propertyConfigItemInfos)) {
            return;
        }
        propertyConfigItemInfos.stream().forEach(propertyConfigItemInfo -> {
            TextProp textProp = ControlUtil.buildTextPorp((String)propertyConfigItemInfo.getKey(), (String)propertyConfigItemInfo.getName());
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            String errorMessage = this.getValidErrorMessage(this.getModel().getDataEntity().getString("bank_login.number"));
            if (StringUtil.isNotNil((String)errorMessage)) {
                this.getView().showTipNotification(errorMessage);
                args.setCancel(true);
                return;
            }
            String number = (String)this.getModel().getValue("number");
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number)};
            if (StringUtil.isNil((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"BankAcntFormPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_BANK_ACNT, (String)"id, enable, name, group, bank_login, addr, currency,has_receipt", (QFilter[])qFilters);
            if (dynamicObject != null) {
                Long myId;
                String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getBillStatus().name();
                if ("ADDNEW".equalsIgnoreCase(statusName)) {
                    if ("1".equalsIgnoreCase(dynamicObject.getString("enable"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u5b58\u5728\u6b64\u8d26\u53f7\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u3002", (String)"BankAcntFormPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    } else {
                        this.updateToEnable(dynamicObject, number);
                        this.getView().showSuccessNotification(MultiLang.getSaveSuccessTip());
                    }
                    args.setCancel(true);
                } else if ("EDIT".equalsIgnoreCase(statusName) && (myId = (Long)this.getModel().getValue("id")).longValue() != dynamicObject.getLong("id")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u5b58\u5728\u6b64\u8d26\u53f7\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", (String)"BankAcntFormPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    private void updateToEnable(DynamicObject dynamicObject, String number) {
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("name", this.getModel().getValue("name"));
        dynamicObject.set(FIELD_KEY_BANK_VERSION, this.getModel().getValue(FIELD_KEY_BANK_VERSION));
        dynamicObject.set(FIELD_KEY_BANK_LOGIN, this.getModel().getValue(FIELD_KEY_BANK_LOGIN));
        dynamicObject.set("addr", this.getModel().getValue("addr"));
        dynamicObject.set(FIELD_KEY_CURRENCY, this.getModel().getValue(FIELD_KEY_CURRENCY));
        dynamicObject.set("number", (Object)number.trim());
        boolean isReceipt = false;
        String bankIsReceiptValue = "false";
        try {
            bankIsReceiptValue = (String)this.getModel().getValue("bank_isReceipt");
            isReceipt = Boolean.parseBoolean(bankIsReceiptValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dynamicObject.set("has_receipt", (Object)(isReceipt ? 1 : 0));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        PropertyConfigItemInfo configItemInfo = new PropertyConfigItemInfo();
        configItemInfo.setKey("bank_isReceipt");
        DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])new QFilter[]{QFilter.of((String)"object_id=? and attr_key=?", (Object[])new Object[]{number, "bank_isReceipt"})});
        this.save(configItemInfo, number, "BANK_BUSINESS", bankIsReceiptValue, RequestContext.get().getTenantId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            if (!args.getOperationResult().isSuccess()) {
                this.getView().showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u8d26\u53f7\u4fdd\u5b58\u5931\u8d25", (String)"BankAcntFormPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).getLocaleValue());
                return;
            }
            IDataModel model = this.getModel();
            String acnt = (String)model.getValue("number");
            String hasReceipt = "";
            String hasNote = "";
            try {
                hasReceipt = (String)model.getValue("bank_isReceipt");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hasNote = (String)model.getValue("bank_isNote");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String uAcnt = acnt.trim();
            DynamicObject dynamicObject = this.ebcBankAcntRepository.getAcntByAccno(acnt);
            if (dynamicObject == null) {
                this.getView().showTipNotification(new LocaleString(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u5f53\u524d\u8d26\u53f7\u3002", (String)"BankAcntFormPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).getLocaleValue());
                return;
            }
            if (StringUtil.isNotNil((String)hasReceipt)) {
                dynamicObject.set("has_receipt", (Object)("true".equalsIgnoreCase(hasReceipt) ? 1 : 0));
            } else {
                dynamicObject.set("has_receipt", (Object)0);
            }
            if (StringUtil.isNotNil((String)hasNote)) {
                dynamicObject.set("has_note", (Object)("true".equalsIgnoreCase(hasNote) ? 1 : 0));
            } else {
                dynamicObject.set("has_note", (Object)0);
            }
            dynamicObject.set("number", (Object)uAcnt);
            this.updateCountryByAddr(dynamicObject);
            try (TXHandle h = TX.requiresNew();){
                this.save(dynamicObject, acnt, uAcnt);
            }
        }
    }

    void save(DynamicObject dynamicObject, String acnt, String uAcnt) {
        IDataModel model = this.getModel();
        String customId = RequestContext.get().getTenantId();
        String bankVersion = (String)model.getDataEntity().get("group.number");
        String bankLogin = (String)model.getDataEntity().get("bank_login.number");
        PropertyConfigInfo propertyConfigInfo = this.getBankAcntConfig(bankVersion);
        List configItems = propertyConfigInfo.getConfigItems();
        Map<String, DynamicObject> cerMap = this.getCerDataMap();
        ArrayList dynamicObjectSaveList = new ArrayList(16);
        ArrayList operateLogList = new ArrayList(16);
        configItems.stream().forEach(propertyConfigItemInfo -> {
            String value = (String)model.getValue(propertyConfigItemInfo.getKey());
            value = value != null ? value.trim() : value;
            dynamicObjectSaveList.add(this.getSaveDataEntity((PropertyConfigItemInfo)propertyConfigItemInfo, uAcnt, propertyConfigInfo.getPropertyName(), value, customId));
            String name = propertyConfigItemInfo.getMlName().loadKDString();
            if (kd.ebg.aqap.formplugin.util.StringUtils.isEmpty((String)name)) {
                name = propertyConfigItemInfo.getName();
            }
            operateLogList.add(this.operateLog(name, propertyConfigItemInfo.getKey(), value, bankVersion, acnt));
            if (BankPropertyConfigType.UPLOAD_PARAM.getName().equalsIgnoreCase(propertyConfigItemInfo.getType())) {
                String key = propertyConfigItemInfo.getKey();
                if (cerMap.get(key) != null) {
                    if (this.getPageCache().get(key + "content") != null) {
                        this.updateCer((DynamicObject)cerMap.get(key), (PropertyConfigItemInfo)propertyConfigItemInfo, bankVersion, bankLogin, acnt, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(key + "content"), CertInfo.class));
                    }
                } else if (this.getPageCache().get(key + "content") != null) {
                    this.addCer((PropertyConfigItemInfo)propertyConfigItemInfo, bankVersion, bankLogin, uAcnt, customId, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(key + "content"), CertInfo.class));
                }
            }
        });
        DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])new QFilter[]{QFilter.of((String)"object_id=? and object_name=?", (Object[])new Object[]{acnt, propertyConfigInfo.getPropertyName()})});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        boolean result = this.save(dynamicObjectSaveList.toArray(new DynamicObject[dynamicObjectSaveList.size()]));
        if (result) {
            for (OpLogAppInfo opLogAppInfo : operateLogList) {
                if (!StringUtil.isNotNil((String)opLogAppInfo.getBizAppID())) continue;
                OperationLogUtil.recordInvoke((OpLogAppInfo)opLogAppInfo);
            }
        }
    }

    private OpLogAppInfo operateLog(String name, String key, String newValue, String bankVersionId, String accNo) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge opNameBridge = new kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
        QFilter filter = QFilter.of((String)"object_id=?", (Object[])new Object[]{accNo});
        filter.and(new QFilter("attr_key", "=", (Object)key));
        DynamicObject object = QueryCacheUtil.getSingleDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_value", (QFilter[])filter.toArray());
        newValue = this.infoService.getBankAcntConfigSourceName(bankVersionId, key, newValue);
        if (object != null) {
            String value = object.getString("attr_value");
            if (!kd.ebg.aqap.formplugin.util.StringUtils.equalsIgnoreCase((String)newValue, (String)(value = this.infoService.getBankAcntConfigSourceName(bankVersionId, key, value)))) {
                kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge descBridge = new kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge("\u8d26\u53f7%1$s\uff0c\u66f4\u65b0\u9644\u52a0\u5c5e\u6027\uff0c%2$s\uff1a[%3$s] -> [%4$s]\u3002", "BankAcntFormPlugin_22", "ebg-aqap-formplugin");
                opLogAppInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge)opNameBridge, (kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge)descBridge, (String[])new String[]{accNo, name, value, newValue});
            }
        } else {
            kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge descBridge = new kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge("\u8d26\u53f7%1$s\uff0c\u65b0\u589e\u9644\u52a0\u5c5e\u6027\uff0c%2$s\uff1a[%3$s]\u3002", "BankAcntFormPlugin_21", "ebg-aqap-formplugin");
            opLogAppInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge)opNameBridge, (kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge)descBridge, (String[])new String[]{accNo, name, newValue});
        }
        return opLogAppInfo;
    }

    private void updateCountryByAddr(DynamicObject dynamicObject) {
        String addr = (String)this.getModel().getDataEntity().get("addr");
        if (StringUtil.isNotNil((String)addr)) {
            Long fid = Long.parseLong(addr);
            QFilter filter = QFilter.of((String)"id = ?", (Object[])new Object[]{fid});
            DynamicObject admindivision = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"id,country.id", (QFilter[])filter.toArray());
            if (admindivision != null) {
                String fcountryid = admindivision.getString("country.id");
                QFilter filter1 = QFilter.of((String)"id = ?", (Object[])new Object[]{Long.parseLong(fcountryid)});
                DynamicObject countryObject = BusinessDataServiceHelper.loadSingle((String)"bd_country", (String)"id,name", (QFilter[])filter1.toArray());
                dynamicObject.set("country", (Object)countryObject.getString("name"));
            } else {
                DynamicObject countryObject1 = BusinessDataServiceHelper.loadSingle((String)"bd_country", (String)"id,name", (QFilter[])filter.toArray());
                dynamicObject.set("country", (Object)(countryObject1 != null ? countryObject1.getString("name") : " "));
            }
        }
    }

    public String getValidErrorMessage(String bankLoginID) {
        if (StringUtil.isNullOrEmpty((String)bankLoginID)) {
            return ResManager.loadKDString((String)"\u672a\u9009\u62e9\u524d\u7f6e\u673a\u7f16\u53f7\u3002", (String)"BankAcntFormPlugin_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        DynamicObject bankLogin = this.ebcBankLoginRepository.getBankLoginByBankLoginID(bankLoginID);
        if (bankLogin == null) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u4e3b\u524d\u7f6e\u673a\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"BankAcntFormPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        if ("1".equals(bankLogin.getString("config_type"))) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u524d\u7f6e\u673a\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u524d\u7f6e\u673a\u3002", (String)"BankAcntFormPlugin_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    DynamicObject[] getCerDatas() {
        String acnt = (String)this.getModel().getValue("number");
        return this.certRepository.loadCertByAcnt(acnt);
    }

    Map<String, DynamicObject> getCerDataMap() {
        DynamicObject[] cerDatas = this.getCerDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (cerDatas != null && cerDatas.length > 0) {
            for (DynamicObject cerData : cerDatas) {
                map.put((String)cerData.get("bank_config_id"), cerData);
            }
        }
        return map;
    }

    void addCer(PropertyConfigItemInfo configItemInfo, String bankVersion, String bankLogin, String acnt, String customID, CertInfo certInfo) {
        certInfo.setCertType(CertTypeUtil.getCertType((String)bankVersion) + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        this.certRepository.addCert(configItemInfo.getKey(), configItemInfo.getName(), bankVersion, bankLogin, acnt, certInfo, CertType.ACNT_CER.getType());
    }

    void updateCer(DynamicObject cerData, PropertyConfigItemInfo configItemInfo, String bankVersion, String bankLogin, String acnt, CertInfo certInfo) {
        certInfo.setCertType(CertTypeUtil.getCertType((String)bankVersion) + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        certInfo.setAlert(cerData.getBoolean("is_alert"));
        certInfo.setAlertDay(cerData.getString("alert_day"));
        this.certRepository.saveCert(cerData, configItemInfo.getKey(), configItemInfo.getName(), bankVersion, bankLogin, acnt, certInfo, CertType.ACNT_CER.getType());
    }

    OperationResult save(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value, String customID) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_KEY_OBJECT_PROPERTIES, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }

    public DynamicObject getSaveDataEntity(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value, String customID) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        return dataEntity;
    }

    public boolean save(DynamicObject[] dataEntities) {
        try {
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent beforeQuickAddNewEvent) {
        String bankVersion = (String)this.getModel().getDataEntity().get("group.number");
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(ENTITY_KEY_LOGIN);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("100%");
        styleCss.setHeight("100%");
        baseShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCustomParam("bankVersion", (Object)bankVersion);
        this.getView().showForm((FormShowParameter)baseShowParameter);
        beforeQuickAddNewEvent.setCancel(true);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        String bankVersion = (String)this.getModel().getDataEntity().get("group.number");
        if (CollectionUtil.isNotEmpty(attachmentPanelKeys)) {
            for (String uploadKey : attachmentPanelKeys) {
                if (!StringUtils.equals((CharSequence)source.getKey(), (CharSequence)uploadKey)) continue;
                ControlUtil.showUploadPage((String)this.getUploadNameMap(uploadKey), (String)uploadKey, (boolean)true, (IFormPlugin)this, (IFormView)this.getView(), (String)bankVersion);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            CertInfo certInfo = (CertInfo)JSONObject.parseObject((String)((String)closedCallBackEvent.getReturnData()), CertInfo.class);
            String fieldKey = closedCallBackEvent.getActionId();
            fieldKey = fieldKey.replaceFirst(BTN_PREFIX, "");
            this.getPageCache().put(fieldKey + "content", JSONObject.toJSONString((Object)certInfo));
            this.getModel().setValue(fieldKey, (Object)certInfo.getFileName());
        }
    }

    List<String> getAttachmentPanelKey() {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(ATTACHMENTPANELKEY) != null) {
            String keys = this.getPageCache().get(ATTACHMENTPANELKEY);
            return StringUtil.isNil((String)keys) ? new ArrayList(1) : Arrays.asList(keys.split(","));
        }
        ArrayList<String> result = new ArrayList<String>(1);
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        String str = "";
        if (CollectionUtil.isNotEmpty(propertyConfigItemInfos) && CollectionUtil.isNotEmpty(fileUploadConfigItemInfoList = propertyConfigItemInfos.stream().filter(p -> BankPropertyConfigType.UPLOAD_PARAM.getName().equals(p.getType())).collect(Collectors.toList()))) {
            for (PropertyConfigItemInfo p2 : fileUploadConfigItemInfoList) {
                str = str + BTN_PREFIX + p2.getKey() + ",";
                result.add(BTN_PREFIX + p2.getKey());
            }
            str = str.substring(0, str.length() - 1);
        }
        this.getPageCache().put(ATTACHMENTPANELKEY, str);
        return result;
    }

    String getUploadNameMap(String key) {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY) != null) {
            String keys = this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY);
            return ControlUtil.getUploadName((String)keys, (String)key);
        }
        List<PropertyConfigItemInfo> propertyConfigItemInfos = this.getPropertyConfigItemInfoList(this.getBankVersion());
        String str = "";
        if (CollectionUtil.isNotEmpty(propertyConfigItemInfos) && CollectionUtil.isNotEmpty(fileUploadConfigItemInfoList = propertyConfigItemInfos.stream().filter(p -> BankPropertyConfigType.UPLOAD_PARAM.getName().equals(p.getType())).collect(Collectors.toList()))) {
            StringBuilder sb = new StringBuilder();
            for (PropertyConfigItemInfo p2 : fileUploadConfigItemInfoList) {
                String name = FieldUtil.getName((MultiLangEnumBridge)p2.getMlName(), (String)p2.getName());
                sb.append(BTN_PREFIX).append(p2.getKey()).append('-').append(name).append(',');
            }
            str = sb.toString();
            str = str.substring(0, str.length() - 1);
        }
        this.getPageCache().put(UPLOAD_FILED_NAME_MAP_KEY, str);
        return ControlUtil.getUploadName((String)str, (String)key);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    private void setFieldShowOrHide() {
        List<PropertyConfigItemInfo> propertyConfigItemInfoList = this.getPropertyConfigItemInfoList(this.getBankVersion());
        List newPropertyConfigItemInfos = propertyConfigItemInfoList.stream().filter(b -> b.getShowByFieldAndVal() != null).collect(Collectors.toList());
        for (PropertyConfigItemInfo propertyConfigItemInfo : newPropertyConfigItemInfos) {
            String val = "";
            try {
                String[] filters;
                boolean showResult;
                ShowByFieldAndVal showByFieldAndVal = propertyConfigItemInfo.getShowByFieldAndVal();
                val = (String)this.getModel().getValue(showByFieldAndVal.getFieldName());
                String showVal = showByFieldAndVal.getFieldVal();
                if (showVal.startsWith("!")) {
                    showResult = !val.equals(showVal = showVal.replaceFirst("!", ""));
                } else if (showVal.contains("'||'")) {
                    filters = showVal.split("'\\|\\|'");
                    showResult = this.getOrValue(filters, val);
                } else if (showVal.contains("'&&'")) {
                    filters = showVal.split("'&&'");
                    showResult = this.getAndValue(filters, val);
                } else {
                    showResult = val.equals(showVal);
                }
                this.getView().setVisible(Boolean.valueOf(showResult), new String[]{propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
                if (!propertyConfigItemInfo.getType().contains("upload")) continue;
                this.getView().setVisible(Boolean.valueOf(showResult), new String[]{"btn_" + propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH)});
            }
            catch (Exception exception) {}
        }
    }

    boolean getOrValue(String[] filters, String val) {
        for (int i = 0; i < filters.length; ++i) {
            boolean result = val.equals(filters[i]);
            if (!result) continue;
            return true;
        }
        return false;
    }

    boolean getAndValue(String[] filters, String val) {
        for (int i = 0; i < filters.length; ++i) {
            boolean result = val.equals(filters[i]);
            if (result) continue;
            return false;
        }
        return true;
    }
}

