/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.EBGBasePlugin;
import kd.ebg.aqap.formplugin.plugin.log.PayRouteLogPlugin;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class QueryPayPlugin
extends EBGBasePlugin {
    private EbcBankAcntRepository bankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private static final String ENTITY_KEY_PAYMENTINFO = "aqap_bd_paymentinfo";
    private int totalNum = 0;
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private LinkedList<QFilter> rowQFilter = new LinkedList();

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                if ("bank_version.name".equalsIgnoreCase(qFilter.getProperty()) || "bank_version.id".equalsIgnoreCase(qFilter.getProperty()) || "bank_acnt.id".equalsIgnoreCase(qFilter.getProperty()) || "bank_acnt.number".equalsIgnoreCase(qFilter.getProperty()) || "status_msg".equalsIgnoreCase(qFilter.getProperty()) || "trans_date".equalsIgnoreCase(qFilter.getProperty())) continue;
                this.rowQFilter.add(qFilter);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (fieldName.equalsIgnoreCase("trans_date") && paramMap.get("trans_date_start") != null) {
                    ArrayList l = new ArrayList(1);
                    l.add(paramMap.get("trans_date_start"));
                    l.add(paramMap.get("trans_date_end"));
                    commonFilterColumn.setDefaultValues(l);
                    continue;
                }
                if (!fieldName.equalsIgnoreCase("status_msg") || paramMap.get("status_msg") == null) continue;
                commonFilterColumn.setDefaultValue((String)paramMap.get("status_msg"));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String SearchCondition = "";
        List fastFilters = args.getFastFilterValues();
        ArrayList<String> batchSeqIDList = new ArrayList<String>(16);
        if (fastFilters.size() > 0) {
            for (int i = 0; i < fastFilters.size(); ++i) {
                List batchSeqIDs = (List)((Map)fastFilters.get(i)).get("Value");
                for (int j = 0; j < batchSeqIDs.size(); ++j) {
                    batchSeqIDList.add(String.valueOf(batchSeqIDs.get(j)));
                }
            }
        }
        SearchCondition = JSON.toJSONString(batchSeqIDList);
        this.getPageCache().put("SearchCondition", SearchCondition);
        String payStatus = String.valueOf(args.getFilterValue("status_msg"));
        if ("null".equalsIgnoreCase(payStatus)) {
            payStatus = "";
        }
        this.getPageCache().put("status_msg", payStatus);
    }

    public void packageData(PackageDataEvent evt) {
        Object obj = evt.getSource();
        DynamicObject rowData = evt.getRowData();
        int status = rowData.getInt("status_id");
        String back_status = rowData.getString("back_status");
        int seq = rowData.getInt("id");
        if (obj instanceof ComboColumnDesc) {
            if ("status_msg".equalsIgnoreCase(((ComboColumnDesc)obj).getKey())) {
                if (PaymentState.SUCCESS == PaymentState.getEnumById((int)status)) {
                    this.setListUnitStyle(seq, "status_msg", "#1BA854");
                } else if (PaymentState.UNKNOWN == PaymentState.getEnumById((int)status)) {
                    this.setListUnitStyle(seq, "status_msg", "#FF991C");
                } else if (PaymentState.FAIL == PaymentState.getEnumById((int)status)) {
                    this.setListUnitStyle(seq, "status_msg", "#FB2323");
                }
            }
        } else if (obj instanceof TextColumnDesc && "back_status".equalsIgnoreCase(((TextColumnDesc)obj).getKey())) {
            if (PaymentState.SUCCESS == PaymentState.getEnumByCnName((String)back_status)) {
                this.setListUnitStyle(seq, "back_status", "#1BA854");
            } else if (PaymentState.UNKNOWN == PaymentState.getEnumByCnName((String)back_status)) {
                this.setListUnitStyle(seq, "back_status", "#FF991C");
            } else if (PaymentState.FAIL == PaymentState.getEnumByCnName((String)back_status)) {
                this.setListUnitStyle(seq, "back_status", "#FB2323");
            }
        }
    }

    private void setListUnitStyle(int row, String key, String color) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(row);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setCellStyle(cellStyles);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String SearchCondition = this.getPageCache().get("SearchCondition");
        String acntNo = "";
        String payStatus = "";
        String bankVersion = "";
        LocalDate startDate = LocalDate.now();
        LocalDate endDate = LocalDate.now();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (StringUtil.isNil((String)SearchCondition) || "[]".equalsIgnoreCase(SearchCondition)) {
            if (this.getPageCache().get("isFirstInit") == null && !CollectionUtils.isEmpty((Map)paramMap) && paramMap.get("trans_date_start") != null) {
                this.getPageCache().put("startDateTime", (String)paramMap.get("trans_date_start"));
                this.getPageCache().put("endDateTime", (String)paramMap.get("trans_date_end"));
                this.getPageCache().put("status_msg", (String)paramMap.get("status_msg"));
                this.getPageCache().put("isFirstInit", "false");
            } else if (StringUtil.isNil((String)this.getPageCache().get("startDateTime"))) {
                this.getPageCache().put("startDateTime", DateUtil.formatDate((Date)new Date(), (String)dateFormat));
                this.getPageCache().put("endDateTime", DateUtil.formatDate((Date)new Date(), (String)dateFormat));
            }
            if (StringUtil.isNotNil((String)this.getPageCache().get("selectedAcntId"))) {
                DynamicObject acnt = this.bankAcntRepository.getAcntByID(Long.valueOf(this.getPageCache().get("selectedAcntId")));
                acntNo = acnt.getString("number");
            }
            if (StringUtil.isNotNil((String)this.getPageCache().get("bank_version"))) {
                bankVersion = this.getPageCache().get("bank_version");
            }
            startDate = LocalDate.parse(this.getPageCache().get("startDateTime"), DateTimeFormatter.ofPattern(dateFormat));
            endDate = LocalDate.parse(this.getPageCache().get("endDateTime"), DateTimeFormatter.ofPattern(dateFormat));
        }
        if (StringUtil.isNotNil((String)this.getPageCache().get("status_msg"))) {
            payStatus = this.getPageCache().get("status_msg");
        }
        final HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("accNo", acntNo);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("SearchCondition", SearchCondition);
        params.put("status_msg", payStatus);
        params.put("bank_version", bankVersion);
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "page_data_data_count";
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dataCollection = QueryPayPlugin.this.getCollection(currentPage, pageSize, params);
                if (dataCollection != null) {
                    this.getQueryResult().setCollection(dataCollection);
                    this.getQueryResult().setDataCount(QueryPayPlugin.this.totalNum);
                    iPageCache.put(dataCountCacheKey, QueryPayPlugin.this.totalNum + "");
                } else {
                    iPageCache.put(dataCountCacheKey, "0");
                }
                return dataCollection;
            }
        });
    }

    private DynamicObjectCollection getCollection(int page, int pageSize, Map<String, Object> params) {
        boolean flag;
        String customID = RequestContext.get().getTenantId();
        String accNo = (String)params.get("accNo");
        LocalDate startDate = (LocalDate)params.get("startDate");
        LocalDate endDate = (LocalDate)params.get("endDate");
        String SearchCondition = (String)params.get("SearchCondition");
        String payStatus = (String)params.get("status_msg");
        String bankVersion = (String)params.get("bank_version");
        if (endDate.isBefore(startDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u8d85\u524d\u4e8e\u8d77\u59cb\u65e5\u671f\u3002", (String)"QueryPayPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return null;
        }
        endDate = endDate.plusDays(1L);
        String selectFields = "id,custom_id,bank_version_id,amount,iso_currency_code,acc_no,acc_name,income_acc_no,income_acc_name,status_id,status_msg,batch_seq_id,insert_time,update_operation,reason,operator,back_status,last_submit_time,update_time,detail_seq_id,bank_batch_seq_id,bank_detail_seq_id,detail_biz_no,version,back_bank_status,sync_count,reversed1,reversed_biz_field";
        QFilter[] qFilters = new QFilter[1];
        if (StringUtil.isNotNil((String)SearchCondition)) {
            List batchSeqIDList = JSONArray.parseArray((String)SearchCondition, String.class);
            flag = batchSeqIDList.size() == 0;
            QFilter filter = new QFilter("batch_seq_id", "in", (Object)batchSeqIDList);
            if (StringUtil.isNotNil((String)payStatus) && !"[]".equalsIgnoreCase(payStatus)) {
                filter.and(this.getStatusFilter(payStatus));
            }
            qFilters = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID}).and(filter).toArray();
        } else {
            flag = true;
        }
        if (flag) {
            QFilter filter = QFilter.of((String)"custom_id = ? and insert_time >= ? and insert_time <= ?", (Object[])new Object[]{customID, startDate, endDate});
            if (StringUtil.isNotNil((String)accNo)) {
                filter.and(QFilter.of((String)"acc_no = ?", (Object[])new Object[]{accNo}));
            }
            if (StringUtil.isNotNil((String)payStatus) && !"[]".equalsIgnoreCase(payStatus)) {
                filter.and(this.getStatusFilter(payStatus));
            }
            if (StringUtil.isNotNil((String)bankVersion)) {
                filter.and(QFilter.of((String)"bank_version_id = ?", (Object[])new Object[]{bankVersion}));
            }
            this.rowQFilter.addFirst(filter);
            qFilters = this.rowQFilter.toArray(new QFilter[16]);
        }
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY_PAYMENTINFO, (String)"count(1) as count_num", (QFilter[])qFilters);
        this.totalNum = ((DynamicObject)dCollection.get(0)).getInt("count_num");
        QFilter nFilter = QFilter.of((String)"id = 0", (Object[])new Object[0]);
        dCollection = QueryServiceHelper.query((String)ENTITY_KEY_PAYMENTINFO, (String)selectFields, (QFilter[])nFilter.toArray());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_PAYMENTINFO, (String)selectFields, (QFilter[])qFilters, (String)"batch_seq_id desc", (int)page, (int)pageSize);
        if (dynamicObjects.length > 0) {
            dCollection = new DynamicObjectCollection();
            for (int i = 0; i < dynamicObjects.length; ++i) {
                dynamicObjects[i].set("number", dynamicObjects[i].get("id"));
                dynamicObjects[i].set("id", (Object)(page * pageSize + i));
                dynamicObjects[i].set("status_msg", (Object)this.getStatusName(dynamicObjects[i].getString("status_id")));
                dynamicObjects[i].set("back_status", (Object)this.getStatusName(dynamicObjects[i].getString("back_status")));
                String bookPayFlagStr = this.getBiz("bookPayFlag", dynamicObjects[i].getString("reversed_biz_field"));
                boolean bookPayFlag = Boolean.parseBoolean(bookPayFlagStr);
                dynamicObjects[i].set("reversed1", (Object)String.valueOf(bookPayFlag));
                dCollection.add(i, dynamicObjects[i]);
            }
        }
        return dCollection;
    }

    private String getBiz(String key, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return " ";
        }
        JSONObject obj = JSONObject.parseObject((String)content);
        return obj.getString(key);
    }

    private String getStatusName(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                int status = Integer.parseInt(value);
                return PaymentState.getEnumById((int)status).getCnName();
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((String)"donothing", (String)formOperate.getOperateKey())) {
            if (this.getPageCache().get("selectedAcntId") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u53f7\u3002", (String)"QueryPayPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getPageCache().get("startDateTime") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u6613\u65e5\u671f\u8303\u56f4\u3002", (String)"QueryPayPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((String)"searchlog", (String)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedData2 = args.getListSelectedData();
            if (listSelectedData2 != null && !listSelectedData2.isEmpty()) {
                args.setCancel(true);
                if (listSelectedData2.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ea4\u6613\u8bb0\u5f55\u65e5\u5fd7\u67e5\u8be2,\u8bf7\u9009\u62e9\u4e00\u7b14\u4ea4\u6613\u8bb0\u5f55\u8fdb\u884c\u67e5\u8be2\u3002", (String)"QueryPayPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    return;
                }
                String selField = "id,custom_id,bank_version_id,bank_batch_seq_id,insert_time";
                String selNumber = listSelectedData2.get(0).getNumber();
                QFilter qFilter = QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(selNumber)});
                DynamicObject payment = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_PAYMENTINFO, (String)selField, (QFilter[])qFilter.toArray());
                String bank_batch_seq_id = payment.getString("bank_batch_seq_id");
                Date insertTime = payment.getDate("insert_time");
                String startDate = DateUtil.transTimeZoneSystemToUser((Date)insertTime);
                String endDate = DateUtil.transTimeZoneSystemToUser((Date)new Date());
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("aqap_new_log");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap params = Maps.newHashMapWithExpectedSize((int)1);
                params.put("bank_batch_seq_id", bank_batch_seq_id);
                params.put("trans_date_start", startDate);
                params.put("trans_date_end", endDate);
                if (StringUtil.isNotNil((String)this.getPageCache().get("selectedBankId"))) {
                    params.put("bank_id", this.getPageCache().get("selectedBankId"));
                }
                showParameter.setCustomParams((Map)params);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (StringUtils.equals((String)"routelog", (String)formOperate.getOperateKey()) && (listSelectedData = args.getListSelectedData()) != null && listSelectedData.size() > 0) {
            String selNumber = String.valueOf(listSelectedData.get(0).getNumber());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId(PayRouteLogPlugin.ENTITY_NAME);
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("id", selNumber);
            params.put("entityName", ENTITY_KEY_PAYMENTINFO);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
            args.setCancel(true);
        }
    }

    private QFilter getStatusFilter(String payStatus) {
        QFilter filter = null;
        if (payStatus.startsWith("[") && payStatus.endsWith("]")) {
            List statusList = JSONArray.parseArray((String)payStatus, String.class);
            ArrayList<Long> payStatusList = new ArrayList<Long>(16);
            for (String status : statusList) {
                payStatusList.add(Long.valueOf(status));
            }
            if (payStatusList.size() > 0) {
                filter = new QFilter("status_id", "in", payStatusList);
            }
        } else {
            filter = new QFilter("status_id", "=", (Object)Long.valueOf(payStatus));
        }
        return filter;
    }
}

