/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.service.info;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.info.FrameworkInfoContributor;
import kd.ebg.aqap.common.utils.BeanFactory;
import kd.ebg.aqap.formplugin.exception.EBBizException;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankLoginInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.EBJobBean;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.ServiceInfo;
import kd.ebg.aqap.formplugin.pojo.received.DtoConfigInfo;
import kd.ebg.aqap.formplugin.service.info.CommonToFormPluginAdapter;
import kd.ebg.aqap.mservice.boot.configuration.FrameworkInfoConfiguration;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;

@Service
public class InfoService {
    private static AtomicReference<ServiceInfo> serviceInfoAtomicReference = new AtomicReference();
    private ConcurrentMap<String, PropertyConfigItemInfo> PropertyConfigItemMap = new ConcurrentHashMap<String, PropertyConfigItemInfo>(16);

    private synchronized void init() {
        FrameworkInfoConfiguration infoConfiguration = (FrameworkInfoConfiguration)BeanFactory.getBean(FrameworkInfoConfiguration.class);
        if (!infoConfiguration.isFinished()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e94\u7528\u542f\u52a8\u8fd8\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InfoService_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        FrameworkInfoContributor frameworkInfoContributor = (FrameworkInfoContributor)BeanFactory.getBean(FrameworkInfoContributor.class);
        ServiceInfo serviceInfo = new ServiceInfo();
        List bizMetas = frameworkInfoContributor.getInfoBizs();
        List banks = frameworkInfoContributor.getInfoBanks();
        List bankVersions = frameworkInfoContributor.getInfoBankVersions();
        List propertyConfigs = frameworkInfoContributor.getInfoPropertyConfigs();
        Map bankLogins = frameworkInfoContributor.getInfoBankLogins();
        serviceInfo.setBanks(CommonToFormPluginAdapter.convertBankInfos(banks));
        serviceInfo.setBizMetas(CommonToFormPluginAdapter.convertBizInfos(bizMetas));
        serviceInfo.setBankVersions(CommonToFormPluginAdapter.convertBankVersionInfos(bankVersions));
        serviceInfo.setPropertyConfigs(CommonToFormPluginAdapter.convertPropertyConfigInfos(propertyConfigs));
        serviceInfo.setBankLogins(CommonToFormPluginAdapter.convertBankLoginInfos(bankLogins));
        serviceInfoAtomicReference.set(serviceInfo);
    }

    private void ensureInit() {
        if (Objects.isNull(serviceInfoAtomicReference.get())) {
            this.init();
        }
    }

    public JSONObject getBankVersionInfo() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        result.put("bankVersions", (Object)array);
        if (serviceInfo != null) {
            serviceInfo.getBankVersions().forEach(version -> {
                JSONObject bankVersion = new JSONObject();
                bankVersion.put("bankVersionID", (Object)version.getBankVersionID());
                bankVersion.put("bankVersionName", (Object)version.getBankVersionName());
                bankVersion.put("bankVersionDescription", (Object)version.getBankVersionDescription());
                bankVersion.put("version", (Object)version.getVersion());
                array.add((Object)bankVersion);
            });
        }
        return result;
    }

    public List<BankInfo> getBankAll() {
        this.ensureInit();
        return serviceInfoAtomicReference.get().getBanks();
    }

    public List<EBJobBean> getAllJobBeans() {
        this.ensureInit();
        return serviceInfoAtomicReference.get().getJobBeans();
    }

    public JSONObject getBanksInfo() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        result.put("banks", (Object)array);
        serviceInfo.getBanks().forEach(bankInfo -> {
            JSONObject bank = new JSONObject();
            bank.put("bankShortName", (Object)bankInfo.getBankShortName());
            bank.put("bankName", (Object)bankInfo.getBankName());
            bank.put("bankDescription", (Object)bankInfo.getBankDescription());
            JSONArray keyWords = new JSONArray();
            bankInfo.getBankNameKeyWords().forEach(arg_0 -> ((JSONArray)keyWords).add(arg_0));
            array.add((Object)bank);
        });
        return result;
    }

    public Map<String, String> getBankNamePairs() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        HashMap<String, String> bankNamePairs = new HashMap<String, String>(16);
        serviceInfo.getBanks().forEach(bankInfo -> bankNamePairs.put(bankInfo.getBankShortName(), bankInfo.getBankName()));
        return bankNamePairs;
    }

    public JSONObject getLoginConfig(String bankVersionID) {
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        result.put("loginConfigs", (Object)array);
        BankVersionInfo versionInfo = this.getBankVersionInfo(bankVersionID);
        versionInfo.getLogins().forEach(arg_0 -> ((JSONArray)array).add(arg_0));
        return result;
    }

    public PropertyConfigInfo getBankConfig(String bankVersionID) {
        BankVersionInfo versionInfo = this.getBankVersionInfo(bankVersionID);
        if (versionInfo == null) {
            return null;
        }
        return versionInfo.getPropertyConfigInfo();
    }

    public String getBusinessName(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        if (propertyConfigInfo != null) {
            return propertyConfigInfo.getPropertyName();
        }
        return "";
    }

    public String getBusinessName() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        return ((BankVersionInfo)serviceInfo.getBankVersions().get(0)).getPropertyConfigInfo().getPropertyName();
    }

    public List<BankVersionInfo> getBankVersionInfoList() {
        this.ensureInit();
        return serviceInfoAtomicReference.get().getBankVersions();
    }

    public PropertyConfigInfo getBankBusinessConfig(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        if (propertyConfigInfo == null) {
            return null;
        }
        PropertyConfigInfo propertyConfigInfoCopy = new PropertyConfigInfo();
        FieldUtils.fieldsCopy((Object)propertyConfigInfo, (Object)propertyConfigInfoCopy);
        propertyConfigInfoCopy.setConfigItems(propertyConfigInfo.getConfigItems());
        List configItemInfos = propertyConfigInfoCopy.getConfigItems().stream().filter(configItemInfo -> !configItemInfo.isAccNo()).collect(Collectors.toList());
        propertyConfigInfoCopy.setConfigItems(configItemInfos);
        return propertyConfigInfoCopy;
    }

    public PropertyConfigInfo getBankAcntConfig(String bankVersionID) {
        PropertyConfigInfo propertyConfigInfo = this.getBankConfig(bankVersionID);
        if (propertyConfigInfo == null) {
            return null;
        }
        PropertyConfigInfo propertyConfigInfoCopy = new PropertyConfigInfo();
        FieldUtils.fieldsCopy((Object)propertyConfigInfo, (Object)propertyConfigInfoCopy);
        propertyConfigInfoCopy.setConfigItems(propertyConfigInfo.getConfigItems());
        List configItemInfos = propertyConfigInfoCopy.getConfigItems().stream().filter(configItemInfo -> configItemInfo.isAccNo()).collect(Collectors.toList());
        propertyConfigInfoCopy.setConfigItems(configItemInfos);
        return propertyConfigInfoCopy;
    }

    public PropertyConfigInfo getSystemConfig() {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        List propertyConfigs = serviceInfo.getPropertyConfigs();
        for (PropertyConfigInfo info : propertyConfigs) {
            if (!"access".equalsIgnoreCase(info.getPropertyConfigID())) continue;
            return info;
        }
        return null;
    }

    public List<PropertyConfigItemInfo> getBankAcntAddtionOpts(String bankVersionID) {
        this.ensureInit();
        ArrayList<PropertyConfigItemInfo> bankAcntAddtionOpts = new ArrayList<PropertyConfigItemInfo>(1);
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        List propertyConfigs = serviceInfo.getPropertyConfigs();
        for (PropertyConfigInfo propertyConfig : propertyConfigs) {
            if (!propertyConfig.getPropertyConfigID().equalsIgnoreCase(bankVersionID)) continue;
            List configItems = propertyConfig.getConfigItems();
            for (PropertyConfigItemInfo configItem : configItems) {
                if (!configItem.isAccNo()) continue;
                bankAcntAddtionOpts.add(configItem);
            }
        }
        return bankAcntAddtionOpts;
    }

    public List<PropertyConfigInfo> getCommonBusinessConfig() {
        ArrayList<PropertyConfigInfo> PropertyConfigInfos = new ArrayList<PropertyConfigInfo>(2);
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        List propertyConfigs = serviceInfo.getPropertyConfigs();
        for (PropertyConfigInfo info : propertyConfigs) {
            if (!"common_business".equalsIgnoreCase(info.getPropertyConfigID())) continue;
            PropertyConfigInfos.add(info);
        }
        return PropertyConfigInfos;
    }

    public void checkConfig(DtoConfigInfo info) {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        String value = info.getValue();
        List propertyConfigs = serviceInfo.getPropertyConfigs();
        PropertyConfigItemInfo config = null;
        block0: for (PropertyConfigInfo configInfo : propertyConfigs) {
            if (!configInfo.getPropertyConfigID().equalsIgnoreCase(info.getPropertyConfigID()) || !configInfo.getPropertyName().equalsIgnoreCase(info.getPropertyName())) continue;
            for (PropertyConfigItemInfo itemInfo : configInfo.getConfigItems()) {
                if (!itemInfo.getKey().equalsIgnoreCase(info.getAttrKey())) continue;
                config = itemInfo;
                continue block0;
            }
        }
        if (config == null) {
            throw new EBBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u65e0\u6548", (String)"InfoService_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        if (config.isReadonly()) {
            throw new EBBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u65e0\u6548", (String)"InfoService_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        if (config.getSourceValues() != null && config.getSourceValues().size() > 0 && !config.getSourceValues().contains(value)) {
            throw new EBBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u65e0\u6548", (String)"InfoService_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        if (config.getMaxValueNum() > 1) {
            Object[] split = value.split(";");
            if (split.length == 1) {
                split = value.split("\n");
            }
            if (split.length > config.getMaxValueNum() || split.length < config.getMinValueNum()) {
                throw new EBBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u65e0\u6548", (String)"InfoService_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            }
            info.setValue(Joiner.on((String)";").join(split));
        }
    }

    public boolean containsBankVersion(String bankVersionID) {
        for (BankVersionInfo v : serviceInfoAtomicReference.get().getBankVersions()) {
            if (!v.getBankVersionID().equalsIgnoreCase(bankVersionID)) continue;
            return true;
        }
        return false;
    }

    private BankVersionInfo getBankVersionInfo(String bankVersionID) {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        return serviceInfo.getBankVersions().stream().filter(v -> v.getBankVersionID().equalsIgnoreCase(bankVersionID)).findFirst().orElse(null);
    }

    private BankVersionInfo getBankVersionInfoWithException(String bankVersionID) {
        this.ensureInit();
        ServiceInfo serviceInfo = serviceInfoAtomicReference.get();
        return serviceInfo.getBankVersions().stream().filter(v -> v.getBankVersionID().equalsIgnoreCase(bankVersionID)).findFirst().orElseThrow(() -> new EBBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684 bankVersionID\uff1a%s\u3002", (String)"InfoService_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankVersionID)));
    }

    public List<BankLoginInfo> getBankLoginInfoList(String bankVersionID) {
        BankVersionInfo bankVersionInfo = this.getBankVersionInfo(bankVersionID);
        if (bankVersionInfo != null) {
            return bankVersionInfo.getLogins();
        }
        return null;
    }

    public PropertyConfigItemInfo getCommonBusinessConfig(String key) {
        PropertyConfigItemInfo propertyConfigItemInfo = null;
        if (this.PropertyConfigItemMap.containsKey(key)) {
            return (PropertyConfigItemInfo)this.PropertyConfigItemMap.get(key);
        }
        List<PropertyConfigInfo> propertyConfigInfos = this.getCommonBusinessConfig();
        for (PropertyConfigInfo propertyConfigInfo : propertyConfigInfos) {
            List propertyConfigItemInfoList = propertyConfigInfo.getConfigItems();
            Optional<PropertyConfigItemInfo> optional = propertyConfigItemInfoList.stream().filter(bankConfig -> bankConfig.getKey().equalsIgnoreCase(key)).findFirst();
            if (!optional.isPresent()) continue;
            propertyConfigItemInfo = optional.get();
            this.PropertyConfigItemMap.put(key, propertyConfigItemInfo);
        }
        return propertyConfigItemInfo;
    }

    public String getCommonBusinessConfigSourceName(String key, String value) {
        List sourceValues;
        String sourceName = value;
        PropertyConfigItemInfo commonBusinessConfig = this.getCommonBusinessConfig(key);
        if (commonBusinessConfig != null && CollectionUtil.isNotEmpty((Collection)(sourceValues = commonBusinessConfig.getSourceValues()))) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                if (!((String)sourceValues.get(i)).equalsIgnoreCase(value)) continue;
                sourceName = CollectionUtil.isEmpty((Collection)commonBusinessConfig.getSourceNames()) ? ((MultiLangEnumBridge)commonBusinessConfig.getMlSourceNames().get(i)).loadKDString() : (String)commonBusinessConfig.getSourceNames().get(i);
            }
        }
        return sourceName;
    }

    public PropertyConfigItemInfo getBankBusinessConfig(String bankVersionID, String key) {
        PropertyConfigItemInfo propertyConfigItemInfo = null;
        String mKey = bankVersionID + key;
        if (this.PropertyConfigItemMap.containsKey(mKey)) {
            return (PropertyConfigItemInfo)this.PropertyConfigItemMap.get(mKey);
        }
        PropertyConfigInfo propertyConfigInfo = this.getBankBusinessConfig(bankVersionID);
        List propertyConfigItemInfoList = propertyConfigInfo.getConfigItems();
        Optional<PropertyConfigItemInfo> optional = propertyConfigItemInfoList.stream().filter(bankConfig -> bankConfig.getKey().equalsIgnoreCase(key)).findFirst();
        if (optional.isPresent()) {
            propertyConfigItemInfo = optional.get();
            this.PropertyConfigItemMap.put(mKey, propertyConfigItemInfo);
        }
        return propertyConfigItemInfo;
    }

    public String getBankBusinessConfigSourceName(String bankVersionID, String key, String value) {
        List sourceValues;
        String sourceName = value;
        PropertyConfigItemInfo commonBusinessConfig = this.getBankBusinessConfig(bankVersionID, key);
        if (commonBusinessConfig != null && CollectionUtil.isNotEmpty((Collection)(sourceValues = commonBusinessConfig.getSourceValues()))) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                if (!((String)sourceValues.get(i)).equalsIgnoreCase(value)) continue;
                sourceName = CollectionUtil.isEmpty((Collection)commonBusinessConfig.getSourceNames()) ? ((MultiLangEnumBridge)commonBusinessConfig.getMlSourceNames().get(i)).loadKDString() : (String)commonBusinessConfig.getSourceNames().get(i);
            }
        }
        return sourceName;
    }

    private BankLoginInfo getBankLoginConfig(String bankVersionID, String key) {
        List<BankLoginInfo> bankLoginConfigList = this.getBankLoginInfoList(bankVersionID);
        for (BankLoginInfo bankLoginConfig : bankLoginConfigList) {
            if (!bankLoginConfig.getBankConfigId().equalsIgnoreCase(key)) continue;
            return bankLoginConfig;
        }
        return null;
    }

    public List<BankLoginInfo> getBankLoginUploadConfig(String bankVersionID) {
        List<BankLoginInfo> bankLoginConfigList = this.getBankLoginInfoList(bankVersionID);
        List<BankLoginInfo> bankLoginUploadConfigs = bankLoginConfigList.stream().filter(c -> c.getInputType().equalsIgnoreCase("upload")).collect(Collectors.toList());
        return bankLoginUploadConfigs;
    }

    public String getBankLoginConfigSourceName(String bankVersionID, String key, String value) {
        List<String> sourceValues;
        String sourceName = value;
        BankLoginInfo bankLoginConfig = this.getBankLoginConfig(bankVersionID, key);
        if (bankLoginConfig != null && CollectionUtil.isNotEmpty(sourceValues = bankLoginConfig.getSourceValues())) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                if (!sourceValues.get(i).equalsIgnoreCase(value)) continue;
                sourceName = CollectionUtil.isEmpty(bankLoginConfig.getSourceNames()) ? bankLoginConfig.getMlSourceNames().get(i).loadKDString() : bankLoginConfig.getSourceNames().get(i);
            }
        }
        return sourceName;
    }

    public PropertyConfigItemInfo getBankAcntConfig(String bankVersionID, String key) {
        PropertyConfigInfo propertyConfigInfo = this.getBankAcntConfig(bankVersionID);
        List propertyConfigItemInfoList = propertyConfigInfo.getConfigItems();
        Optional<PropertyConfigItemInfo> optional = propertyConfigItemInfoList.stream().filter(bankConfig -> bankConfig.getKey().equalsIgnoreCase(key)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public String getBankAcntConfigSourceName(String bankVersionID, String key, String value) {
        List sourceValues;
        String sourceName = value;
        PropertyConfigItemInfo PropertyConfigItemInfo2 = this.getBankAcntConfig(bankVersionID, key);
        if (PropertyConfigItemInfo2 != null && CollectionUtil.isNotEmpty((Collection)(sourceValues = PropertyConfigItemInfo2.getSourceValues()))) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                if (!((String)sourceValues.get(i)).equalsIgnoreCase(value)) continue;
                sourceName = CollectionUtil.isEmpty((Collection)PropertyConfigItemInfo2.getSourceNames()) ? ((MultiLangEnumBridge)PropertyConfigItemInfo2.getMlSourceNames().get(i)).loadKDString() : (String)PropertyConfigItemInfo2.getSourceNames().get(i);
            }
        }
        return sourceName;
    }
}

