/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.acctype.AccTypeEnum;
import kd.ebg.aqap.banks.abc.dc.service.balance.CQRA07;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        String accType = BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo());
        return "tzck".equalsIgnoreCase(accType.trim()) ? CQRA07.pack((BankBalanceRequest)request) : this.packNormalTodayBalance(request);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String accType = BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo());
        return "tzck".equalsIgnoreCase(accType.trim()) ? CQRA07.parse((BankBalanceRequest)request, (String)responseStr) : this.parseNormalTodayBalance(request, responseStr);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CQRA06";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public String packNormalTodayBalance(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CQRA06", (String)Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        String accTypeName = AccTypeEnum.getAccNoType((String)acnt.getAccNo());
        if (StringUtils.isNotEmpty((String)accTypeName)) {
            JDomUtils.addChild((Element)cmp, (String)"DbAccType", (String)accTypeName);
            JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo().substring(accTypeName.length())));
        } else {
            JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        }
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)rqst.getBankCurrency());
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    private String parseAccNo(boolean isContainsAccType, String[] respPrvData) {
        if (respPrvData == null || respPrvData.length < 3) {
            return "";
        }
        if (isContainsAccType) {
            return respPrvData[2];
        }
        return respPrvData[1];
    }

    private String parseCurrency(boolean isContainsAccType, String[] respPrvData) {
        if (respPrvData == null || respPrvData.length < 4) {
            return "";
        }
        if (isContainsAccType) {
            return respPrvData[3];
        }
        return respPrvData[2];
    }

    public EBBankBalanceResponse parseNormalTodayBalance(BankBalanceRequest rqst, String rspStr) {
        String requestAccNo = rqst.getAcnt().getAccNo();
        String accTypeName = AccTypeEnum.getAccNoType((String)requestAccNo);
        boolean isContainsAccType = StringUtils.isNotEmpty((String)accTypeName);
        if (isContainsAccType) {
            requestAccNo = requestAccNo.substring(accTypeName.length());
        }
        String inputBankCurr = rqst.getBankCurrency();
        Element root = ABC_DC_Parser.parseString2Root((String)rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader((Element)root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element cmp = root.getChild("Cmp");
        String RespPrvData1 = cmp.getChildTextTrim("RespPrvData1");
        String[] temp = StringUtils.split((String)RespPrvData1, (String)"|");
        String accNo = this.parseAccNo(isContainsAccType, temp);
        String currency = this.parseCurrency(isContainsAccType, temp);
        if (StringUtils.isEmpty((String)currency) && (currency = cmp.getChildTextTrim("DbCur")) == null) {
            currency = "";
        }
        Element acc = root.getChild("Acc");
        BalanceInfo balance = new BalanceInfo();
        this.setCurrentBalance(balance, acc.getChildTextTrim("Bal"));
        this.setAvailableBalance(balance, acc.getChildTextTrim("AvailBal"));
        this.setLastDayAvlBalance(balance, acc.getChildTextTrim("LastBal"));
        this.setFreezeBalance(balance, acc.getChildTextTrim("FrzAmt"));
        logger.info("\u89e3\u6790\u5230\u519c\u884c\u8fd4\u56de\u7684'\u5e01\u79cd'\u4e3a{}", (Object)currency);
        BankAcnt bankAcnt = new BankAcnt();
        balance.setBankAcnt(bankAcnt);
        this.setBankCurrency(balance, rqst.getBankCurrency(), currency);
        balance.setBalanceDateTime(LocalDateTime.now());
        if (!StrUtil.isEmpty((String)accNo) && accNo.equalsIgnoreCase(AcntNumberHelper.fixAccNoTo15Or19((String)requestAccNo))) {
            bankAcnt.setAccNo(rqst.getAcnt().getAccNo());
        } else {
            balance.setError(BalanceUtils.inconsistentAcc());
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public boolean match(BankBalanceRequest request) {
        return !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo()) && !BankBusinessConfig.isAggregatorsAcnt((String)request.getAcnt().getAccNo());
    }
}

