/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayPacker {
    static EBGLogger log = EBGLogger.getInstance().getLogger(BatchPayPacker.class);

    public static String packBatchPayString(PaymentInfo[] infos, String transCode, String fileName) {
        Element root = ABC_DC_Packer.createABCRoot4New((String)transCode, (String)infos[0].getBankBatchSeqId());
        String accNo = infos[0].getAccNo();
        JDomUtils.addChild((Element)root, (String)"Amt", (String)BatchPayPacker.getTotalAmount(infos));
        JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"SumNum", (String)(infos.length + ""));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)accNo));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo((PaymentInfo)infos[0], (boolean)false));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)infos[0].getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)fileName);
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"NVoucherType", (String)BankBusinessConfig.getNVoucherType((String)accNo));
        JDomUtils.addChild((Element)corp, (String)"NFAccNo", (String)BankBusinessConfig.getNFAccNo((String)accNo));
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public static String packUploadFile(PaymentInfo[] infos, String type) {
        if ("IBBF02".equalsIgnoreCase(type)) {
            return BatchPayPacker.packIBBF02UploadFile(infos);
        }
        if ("IBBF01".equalsIgnoreCase(type)) {
            return BatchPayPacker.packIBBF01UploadFile(infos);
        }
        if ("CFRT03".equalsIgnoreCase(type)) {
            return BatchPayPacker.packCFRT03UploadFile(infos);
        }
        if ("IBBF23".equalsIgnoreCase(type)) {
            return BatchPayPacker.packIBBF23UploadFile(infos);
        }
        if ("IBAF04".equalsIgnoreCase(type)) {
            return BatchPayPacker.packIBAF04UploadFile(infos);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u4ea7\u5bf9\u5e94\u7c7b\u578b%1$s\u7684\u6587\u4ef6\u683c\u5f0f\u3002", (String)"BatchPayPacker_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), type));
    }

    private static String packIBAF04UploadFile(PaymentInfo[] infos) {
        StringBuilder sb = new StringBuilder();
        for (PaymentInfo info : infos) {
            sb.append(info.getBankDetailSeqId()).append("|_|");
            sb.append(info.getIncomeAccName()).append("|_|");
            String incomeAccNo = info.getIncomeAccNo();
            if (info.is2SameBank() && incomeAccNo != null && incomeAccNo.length() == 15) {
                try {
                    String areaCode = AcntNumberHelper.getAreaCodeByPaymentInfo((PaymentInfo)info, (boolean)true);
                    incomeAccNo = areaCode + incomeAccNo;
                }
                catch (Exception e) {
                    log.info("\u83b7\u53d6\u5730\u533a\u7801\u5931\u8d25:{}", (Object)info.getIncomeAccNo());
                }
            }
            sb.append(incomeAccNo).append("|_|");
            sb.append(info.getCurrency()).append("|_|");
            sb.append("").append("|_|");
            sb.append(info.getAmount().toString()).append("|_|");
            String explan = info.getExplanation();
            if (!StringUtils.isEmpty((String)explan)) {
                explan = explan.replaceAll("\r|\n", "");
            }
            sb.append(explan).append("|_|");
            sb.append("02").append("|_|");
            sb.append("0").append("|_|");
            sb.append("0").append("|_|");
            sb.append("").append("|_|");
            sb.append("").append("|_|");
            sb.append("").append("|_|");
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String packIBBF23UploadFile(PaymentInfo[] infos) {
        StringBuilder sb = new StringBuilder();
        for (PaymentInfo info : infos) {
            sb.append(info.getBankDetailSeqId()).append("|_|");
            String incomeAccNo = info.getIncomeAccNo();
            if (info.is2SameBank() && incomeAccNo != null && incomeAccNo.length() == 15) {
                try {
                    String areaCode = AcntNumberHelper.getAreaCodeByPaymentInfo((PaymentInfo)info, (boolean)true);
                    incomeAccNo = areaCode + incomeAccNo;
                }
                catch (Exception e) {
                    log.info("\u83b7\u53d6\u5730\u533a\u7801\u5931\u8d25:{}", (Object)info.getIncomeAccNo());
                }
            }
            sb.append(incomeAccNo).append("|_|");
            sb.append(info.getIncomeAccName()).append("|_|");
            sb.append(info.getCurrency()).append("|_|");
            sb.append(info.getAmount().toString()).append("|_|");
            String explan = info.getExplanation();
            if (!StringUtils.isEmpty((String)explan)) {
                explan = explan.replaceAll("\r|\n", "");
            }
            sb.append(explan).append("|_|");
            sb.append(info.is2Urgent() ? "1" : "0").append("|_|");
            sb.append(info.getIncomeBankName()).append("|_|");
            sb.append(info.getIncomeCnaps()).append("|_|");
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String packCFRT03UploadFile(PaymentInfo[] infos) {
        StringBuilder StringBuilder2 = new StringBuilder();
        String charSet = RequestContextUtils.getCharset();
        for (int i = 0; i < infos.length; ++i) {
            StringBuilder2.append(BatchPayPacker.getFixedString(60, infos[i].getIncomeAccName(), charSet));
            StringBuilder2.append(BatchPayPacker.getFixedString(30, infos[i].getIncomeAccNo(), charSet));
            StringBuilder2.append(BatchPayPacker.getFixedString(18, infos[i].getAmount().setScale(2, 4).toString(), charSet));
            StringBuilder2.append(BatchPayPacker.getFixedString(30, infos[i].getBankDetailSeqId(), charSet));
            StringBuilder2.append('\n');
        }
        return StringBuilder2.toString();
    }

    public static String getFixedString(int length, String str, String charSet) {
        byte[] result = new byte[length];
        String content = "";
        int byteLength = 0;
        try {
            byteLength = str.getBytes(charSet).length;
            if (byteLength >= length) {
                result = str.getBytes(charSet);
            } else {
                int index = 0;
                byte[] strBytes = str.getBytes(charSet);
                for (int i = 0; i < byteLength; ++i) {
                    System.arraycopy(strBytes, i, result, i, 1);
                    ++index;
                }
                for (int j = index; j < length; ++j) {
                    result[j] = 32;
                }
            }
            content = new String(result, charSet);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return content;
    }

    public static String packIBBF02UploadFile(PaymentInfo[] infos) {
        StringBuilder sb = new StringBuilder();
        for (PaymentInfo info : infos) {
            sb.append(info.getBankDetailSeqId()).append("|_|");
            sb.append(info.getAccNo()).append("|_|");
            sb.append("|_|");
            sb.append(info.getAccName()).append("|_|");
            String incomeAccNo = info.getIncomeAccNo();
            if (info.getSameBank().booleanValue() && incomeAccNo != null && incomeAccNo.length() == 15) {
                try {
                    String areaCode = AcntNumberHelper.getAreaCodeByPaymentInfo((PaymentInfo)info, (boolean)true);
                    incomeAccNo = areaCode + incomeAccNo;
                }
                catch (EBServiceException e) {
                    log.info("\u83b7\u53d6\u5730\u533a\u7801\u5931\u8d25:{}", (Object)info.getIncomeAccNo());
                }
            }
            sb.append(incomeAccNo).append("|_|");
            sb.append("|_|");
            sb.append(info.getIncomeAccName()).append("|_|");
            sb.append(info.getCurrency()).append("|_|");
            sb.append(info.getAmount()).append("|_|");
            sb.append(info.getExplanation()).append("|_|");
            sb.append('1').append("|_|");
            sb.append('\n');
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)info.getBankDetailSeqId());
        }
        return sb.toString();
    }

    public static String packIBBF01UploadFile(PaymentInfo[] infos) {
        StringBuilder sb = new StringBuilder();
        for (PaymentInfo info : infos) {
            sb.append(info.getBankDetailSeqId()).append("|_|");
            sb.append(info.getAccNo()).append("|_|");
            sb.append("|_|");
            sb.append(info.getAccName()).append("|_|");
            String incomeAccNo = info.getIncomeAccNo();
            if (info.getSameBank().booleanValue() && incomeAccNo != null && incomeAccNo.length() == 15) {
                try {
                    String areaCode = AcntNumberHelper.getAreaCodeByPaymentInfo((PaymentInfo)info, (boolean)true);
                    incomeAccNo = areaCode + incomeAccNo;
                }
                catch (EBServiceException e) {
                    log.info("\u83b7\u53d6\u5730\u533a\u7801\u5931\u8d25:{}", (Object)info.getIncomeAccNo());
                }
            }
            sb.append(incomeAccNo).append("|_|");
            sb.append(info.getIncomeAccName()).append("|_|");
            sb.append(info.getCurrency()).append("|_|");
            sb.append(info.getAmount()).append("|_|");
            sb.append(info.getExplanation()).append("|_|");
            sb.append(info.getUrgent() != false ? "1" : "0").append("|_|");
            sb.append(info.getIncomeBankName()).append("|_|");
            sb.append(info.getIncomeCnaps()).append("|_|");
            sb.append('\n');
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)info.getBankDetailSeqId());
        }
        return sb.toString();
    }

    public static String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }
}

