/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.PaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.MatchTypeEnum;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        String subBizType = paymentInfo.getSubBizType();
        if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setSubBizType4Allocation(paymentInfo);
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo);
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.company.PaymentImpl.class.getName());
        } else if (this.isPay(paymentInfo)) {
            this.setSubBizType4Pay(paymentInfo);
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), subBizType));
        }
        return busiImplInfo;
    }

    private void setSubBizType4Allocation(PaymentInfo paymentInfo) {
        AcntHelp.checkAccCity((PaymentInfo)paymentInfo);
        paymentInfo.setIndividual(Boolean.valueOf(false));
        if (this.isTransferUpUseCN(paymentInfo)) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.allocation.transup.PaymentImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.company.PaymentImpl.class.getName());
        }
    }

    private void setSubBizType4Pay(PaymentInfo paymentInfo) {
        if (this.isSalaryUseCN(paymentInfo) || this.isReimUseCN(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo);
        } else if (this.isTransferUseCN(paymentInfo)) {
            this.setSubBizType4Allocation(paymentInfo);
        } else if (this.isVirtualAccount(paymentInfo)) {
            if (this.isMerge(paymentInfo)) {
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.virtual.batch.PaymentImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.virtual.PaymentImpl.class.getName());
            }
        } else if (this.isUseOnlinePay()) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.online.PaymentImpl.class.getName());
        } else if (this.isIndividual(paymentInfo)) {
            if (this.isSameBank(paymentInfo)) {
                if (this.isCompanySubAc(paymentInfo)) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub.PaymentImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner.PaymentImpl.class.getName());
                }
            } else if (this.isDiffBankIndividual2Batch()) {
                this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.PaymentImpl.class.getName());
            }
        } else {
            AcntHelp.checkAccCity((PaymentInfo)paymentInfo);
            paymentInfo.setIndividual(Boolean.valueOf(false));
            if (this.isCompany2Batch()) {
                this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.company.PaymentImpl.class.getName());
            }
        }
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo) throws EBServiceException {
        paymentInfo.setIndividual(Boolean.valueOf(true));
        if (this.isSameBank(paymentInfo)) {
            if (this.isSalaryUseCN(paymentInfo)) {
                if (this.isCompanySubAc(paymentInfo)) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub.PaymentImpl.class.getName());
                } else if (this.isSalary2NewInterface()) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew.PaymentImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PaymentImpl.class.getName());
                }
            } else if (this.isReimUseCN(paymentInfo)) {
                if (this.isCompanySubAc(paymentInfo)) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.sub.PaymentImpl.class.getName());
                } else if (this.isSalary2NewInterface()) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew.PaymentImpl.class.getName());
                } else if (this.isMerge(paymentInfo)) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PaymentImpl.class.getName());
                } else if (this.isCostReimbToSingleAgencyPay()) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner.PaymentImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.PaymentImpl.class.getName());
                }
            }
        } else if (this.isSalaryUseCN(paymentInfo) || this.isReimUseCN(paymentInfo)) {
            if (this.isMerge(paymentInfo)) {
                if (this.isSalary2NewInterface()) {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew.PaymentImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PaymentImpl.class.getName());
                }
            } else {
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.PaymentImpl.class.getName());
            }
        }
    }

    private boolean isUseOnlinePay() {
        return this.assertBusinessConfig("cmbc_dc_useOnline", "true");
    }

    private boolean isDiffBankIndividual2Batch() {
        return this.assertBusinessConfig("cmbc_dc_isDiffBankIndividual2BatchPay", "true");
    }

    private boolean isCompany2Batch() {
        return this.assertBusinessConfig("cmbc_dc_is2BatchPay", "true");
    }

    private boolean isCostReimbToSingleAgencyPay() {
        return this.assertBusinessConfig("CMBC_SINGLE_AGENCY_PAY_SELECT", "CostReimb");
    }

    private boolean isSalary2NewInterface() {
        return this.assertBusinessConfig("cmbc_dc_isSalary2NewInterface", "true");
    }

    private boolean isVirtualAccount(PaymentInfo paymentInfo) {
        return this.assertAccountConfig("bank_accType", "virtual", paymentInfo.getAccNo());
    }

    private boolean isCompanySubAc(PaymentInfo paymentInfo) {
        boolean result = BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo());
        if (result) {
            this.addRoute(true, "inner_bank_subac_list", MatchTypeEnum.EXIST.getDesc(), paymentInfo.getAccNo());
            return true;
        }
        result = this.isSubAccount(paymentInfo);
        return result;
    }

    private boolean isSubAccount(PaymentInfo paymentInfo) {
        return this.assertAccountConfig("is_sub_account", "true", paymentInfo.getAccNo());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

