/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.payment;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbnxs.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_Parser;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_headPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26 (1001)\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = HBNXS_headPacker.buildHead((String)paymentInfo.getBankDetailSeqId(), (String)"1001");
        Element body = root.getChild("body");
        JDomUtils.addChild((Element)body, (String)"DeAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"DeAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"SubAcctNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"SubAcctName", (String)"");
        JDomUtils.addChild((Element)body, (String)"CrAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"CrAcctName", (String)paymentInfo.getIncomeAccName());
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"BusType", (String)"1");
            JDomUtils.addChild((Element)body, (String)"CrBankName", (String)"");
        } else {
            JDomUtils.addChild((Element)body, (String)"BusType", (String)"2");
            JDomUtils.addChild((Element)body, (String)"CrBankName", (String)paymentInfo.getIncomeBankName());
        }
        JDomUtils.addChild((Element)body, (String)"CrChgNo", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"Amt", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        if (paymentInfo.getExplanation().length() > 40) {
            JDomUtils.addChild((Element)body, (String)"Summary", (String)paymentInfo.getExplanation().substring(40));
        } else {
            JDomUtils.addChild((Element)body, (String)"Summary", (String)paymentInfo.getExplanation());
        }
        JDomUtils.addChild((Element)body, (String)"Remark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"Bk1", (String)"");
        JDomUtils.addChild((Element)body, (String)"Bk2", (String)"");
        JDomUtils.addChild((Element)body, (String)"Bk3", (String)"");
        return HBNXS_headPacker.getMsg((Element)root, (String)"001001");
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)HBNXS_Parser.getMsg((String)s), (String)encoding);
        BankResponse bankRsp = new BankResponse();
        bankRsp = HBNXS_Parser.parserHead((Element)root);
        if (!"00000".equals(bankRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        } else {
            Element body = root.getChild("body");
            String TxStatus = body.getChildText("TxStatus");
            if ("0".equals(TxStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)TxStatus, (String)bankRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)TxStatus, (String)bankRsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "1001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26 (1001)", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

