/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.otherbank;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.otherbank.QueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayImpl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BigDecimal totalAmt = new BigDecimal("0.00");
        StringBuilder sendList = new StringBuilder();
        boolean addKDFlagToPay = BankBusinessConfig.isAddKDFlagToPay();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(i);
            totalAmt = totalAmt.add(paymentInfo.getAmount());
            sendList.append(paymentInfo.getBankSerialNo());
            sendList.append('|');
            sendList.append(paymentInfo.getIncomeCnaps());
            sendList.append('|');
            sendList.append(paymentInfo.getIncomeAccNo());
            sendList.append('|');
            sendList.append(paymentInfo.getIncomeAccName());
            sendList.append('|');
            sendList.append(paymentInfo.getAmount());
            sendList.append('|');
            sendList.append(paymentInfo.getExplanation());
            sendList.append('|');
            if (paymentInfo.is2Individual()) {
                sendList.append("1");
            } else {
                sendList.append("0");
            }
            sendList.append('|');
            sendList.append('|');
            sendList.append('|');
            sendList.append('|');
            sendList.append('|');
            sendList.append('#');
        }
        StringBuilder sb = new StringBuilder();
        sb.append("xhj8044");
        sb.append('#');
        sb.append(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        sb.append('#');
        sb.append(((PaymentInfo)paymentInfos.get(0)).getAccNo());
        sb.append('#');
        sb.append(totalAmt);
        sb.append('#');
        sb.append(paymentInfos.size());
        sb.append('#');
        if (addKDFlagToPay) {
            sb.append(Packer.getBatchKDExp((List)paymentInfos));
        } else {
            sb.append(((PaymentInfo)paymentInfos.get(0)).getExplanation());
        }
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append('#');
        sb.append((CharSequence)sendList);
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        try {
            String responseCode = elements[0];
            String responseMsg = "";
            responseMsg = elements.length > 2 ? String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7:%1$s;\u5907\u7528\u57df1:%2$s\u3002", (String)"IndividualPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[1], elements[2]) : String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%s\u3002", (String)"IndividualPayImpl_12", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[0]);
            if ("000000".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"IndividualPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"IndividualPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else if ("EL4114".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u8d26\u53f7\u6216\u5361\u53f7\u65e0\u6548\u3002", (String)"IndividualPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualPayImpl_8", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMsg);
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%s\u3002", (String)"IndividualPayImpl_13", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "xhj8044";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

