/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.payment.company.sameBank;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.banks.crcb.dc.helper.RequestPacker;
import kd.ebg.aqap.banks.crcb.dc.helper.SvsSign;
import kd.ebg.aqap.banks.crcb.dc.payment.company.PayParser;
import kd.ebg.aqap.banks.crcb.dc.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        HashMap<String, String> requestMap = new HashMap<String, String>(16);
        String header = RequestPacker.getHeader((String)"CL0005");
        requestMap.put("I1QYLS", paymentInfo.getBankDetailSeqId());
        requestMap.put("I1SMID", "");
        requestMap.put("I1ATID", "");
        requestMap.put("I1FKAC", paymentInfo.getAccNo());
        requestMap.put("I1FKNM", paymentInfo.getAccName());
        requestMap.put("I1CUNM", paymentInfo.getIncomeAccName());
        requestMap.put("I1SKAC", paymentInfo.getIncomeAccNo());
        requestMap.put("I1TRAM", String.format("%.2f", paymentInfo.getAmount()));
        requestMap.put("I1TRCY", paymentInfo.getCurrency());
        requestMap.put("I1PUPS", paymentInfo.getUseCn());
        requestMap.put("I1REM", paymentInfo.getExplanation());
        requestMap.put("IJYLX", BankBusinessConfig.getTransType((String)paymentInfo.getAccNo()));
        requestMap.put("I1NBBH", paymentInfo.getBankDetailSeqId());
        requestMap.put("I1JYBZ", "");
        requestMap.put("I1MXXH", "");
        requestMap.put("I1AC1", "");
        requestMap.put("I1NM1", "");
        requestMap.put("I1YWZL", "");
        requestMap.put("I1JLXX", "");
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, (String)"CL0005");
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage((String)header, (String)signData, (String)reqMessage);
                this.logger.info("\u4ed8\u6b3e\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u62a5\u6587\u8fd4\u56de\u4e3a\u7a7a", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.logger.info("\u6253\u5305\u4ed8\u6b3e\u62a5\u6587\u5931\u8d25 ", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6253\u5305\u4ed8\u6b3e\u62a5\u6587\u5931\u8d25", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        new PayParser().parsePay(bankPayRequest.getPaymentInfoAsArray(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CL0005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u8f6c\u8d26", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }
}

