/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.util;

import java.time.LocalDateTime;
import kd.ebg.aqap.banks.cexim.dc.util.FileInfoNode;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class CommonPacker {
    public static Element createSystemHead(String transCode) {
        return CommonPacker.createSystemHead(transCode, Sequence.gen18Sequence(), "", "", "");
    }

    public static Element createSystemHead(String transCode, String size, String pageNo, String stsTraceId) {
        return CommonPacker.createSystemHead(transCode, Sequence.gen18Sequence(), size, pageNo, stsTraceId);
    }

    public static Element packCommonHeader(String sysTXCode, String sequence, String traceID, String nextPage) {
        Element root = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_TX_CODE", (String)sysTXCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_MSG_LEN", (String)"0123456789");
        LocalDateTime now = LocalDateTime.now();
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_REQ_TIME", (String)LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMddhhmmssSSS"));
        JDomExtUtils.addChildCDData((Element)root, (String)"SYS_TX_VRSN", (String)"01");
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_DT", (String)LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_TM", (String)LocalDateUtil.formatDate((LocalDateTime)now, (String)"hhmmss"));
        JDomExtUtils.addChildCDData((Element)root, (String)"TXN_STFF_ID", (String)EBContext.getContext().getParameter().getBankParameter("cust_no"));
        JDomExtUtils.addChildCDData((Element)root, (String)"MULTI_TENANCY_ID", (String)"CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"LNG_ID", (String)"zh-cn");
        JDomExtUtils.addChildCDData((Element)root, (String)"REC_IN_PAGE", (String)"100");
        JDomExtUtils.addChildCDData((Element)root, (String)"PAGE_JUMP", (String)nextPage);
        JDomExtUtils.addChildCDData((Element)root, (String)"STS_TRACE_ID", (String)traceID);
        JDomExtUtils.addChildCDData((Element)root, (String)"CHNL_CUST_NO", (String)EBContext.getContext().getParameter().getBankParameter("cust_id"));
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Jrnl_No", (String)sequence);
        String ip = EBContext.getContext().getParameter().getBankParameter("ip");
        JDomExtUtils.addChildCDData((Element)root, (String)"Txn_Itt_IP_Adr", (String)ip);
        return root;
    }

    public static Element packCommonHeader(String sysTXCode, String sequence) {
        return CommonPacker.packCommonHeader(sysTXCode, sequence, "", "1");
    }

    public static Element createSystemHead(String transCode, String sequence, String size, String pageNo, String stsTraceId) {
        Element systemHead = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"SYS_TX_CODE", (String)transCode);
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"SYS_MSG_LEN", (String)"0123456789");
        LocalDateTime now = LocalDateTime.now();
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"SYS_REQ_TIME", (String)LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMddhhmmssSSS"));
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"SYS_TX_VRSN", (String)"01");
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"TXN_DT", (String)LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"TXN_TM", (String)LocalDateUtil.formatDate((LocalDateTime)now, (String)"hhmmss"));
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"TXN_STFF_ID", (String)EBContext.getContext().getParameter().getBankParameter("cust_no"));
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"MULTI_TENANCY_ID", (String)"CN000");
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"LNG_ID", (String)"zh-cn");
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"STS_TRACE_ID", (String)stsTraceId);
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"CHNL_CUST_NO", (String)EBContext.getContext().getParameter().getBankParameter("cust_id"));
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"IttParty_Jrnl_No", (String)sequence);
        String ip = EBContext.getContext().getParameter().getBankParameter("ip");
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"Txn_Itt_IP_Adr", (String)ip);
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"REC_IN_PAGE", (String)size);
        JDomExtUtils.addChildCDData((Element)systemHead, (String)"PAGE_JUMP", (String)pageNo);
        return systemHead;
    }

    public static Element packFileEntity(Element request, FileInfoNode fileInfoNode, String fileName) {
        Element FILE_LIST_PACK = JDomExtUtils.addChild((Element)request, (String)"FILE_LIST_PACK");
        JDomExtUtils.addChildCDData((Element)FILE_LIST_PACK, (String)"FILE_NUM", (String)"1");
        Element FILE_INFO = JDomExtUtils.addChild((Element)FILE_LIST_PACK, (String)"FILE_INFO");
        JDomExtUtils.addChildCDData((Element)FILE_INFO, (String)"FILE_NAME", (String)fileName);
        JDomExtUtils.addChildCDData((Element)FILE_INFO, (String)"Msg_Smy", (String)fileInfoNode.getMd5());
        return request;
    }

    public static Element packInfoComEntity() {
        return CommonPacker.packComEntity("00000058");
    }

    public static Element packPayComEntity() {
        return CommonPacker.packComEntity("00000057");
    }

    public static Element packPayComEntity(String sequence) {
        return CommonPacker.packComEntity("00000057", sequence);
    }

    public static Element packComEntity(String proCode) {
        return CommonPacker.packComEntity(proCode, Sequence.gen18Sequence());
    }

    public static Element packComEntity(String proCode, String sequence) {
        return CommonPacker.packComEntity(proCode, "000000000000000", "000000000000000", "", sequence, "01");
    }

    public static Element packComEntity(String proCode, String schlNo, String fwctlNodeID, String fileName, String sequence, String functionCode) {
        IParameter parameter = EBContext.getContext().getParameter();
        Element root = new Element("request");
        JDomExtUtils.addChildCDData((Element)root, (String)"ASPD_ECD", (String)proCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"SChl_No", (String)schlNo);
        JDomExtUtils.addChildCDData((Element)root, (String)"FwCtl_Node_ID", (String)fwctlNodeID);
        JDomExtUtils.addChildCDData((Element)root, (String)"IttParty_Bsn_Dt", (String)LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMdd"));
        String grpid = parameter.getBankParameter("grp_id");
        JDomExtUtils.addChildCDData((Element)root, (String)"Grp_ID", (String)(StringUtils.isEmpty((String)grpid) ? "" : grpid));
        JDomExtUtils.addChildCDData((Element)root, (String)"Cst_ID", (String)parameter.getBankParameter("cst_id"));
        JDomExtUtils.addChildCDData((Element)root, (String)"Prim_AR_No", (String)parameter.getBankParameter("primar_no"));
        JDomExtUtils.addChildCDData((Element)root, (String)"Root_Node_PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"PdAr_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"SvM24Hr_Ind", (String)"0");
        JDomExtUtils.addChildCDData((Element)root, (String)"Tmzon_ECD", (String)"08");
        JDomExtUtils.addChildCDData((Element)root, (String)"Rqs_Upload_File_Nm", (String)fileName);
        JDomExtUtils.addChildCDData((Element)root, (String)"Cmpt_Ent_ID", (String)"0000CN000");
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_BIZ_ID", (String)sequence);
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_MNPLT_TP", (String)functionCode);
        JDomExtUtils.addChildCDData((Element)root, (String)"WF_FCN_ID", (String)"");
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTr_ID", (String)parameter.getBankParameter("ccsttr_id"));
        JDomExtUtils.addChildCDData((Element)root, (String)"CCstTrNdID", (String)parameter.getBankParameter("ccsttrndd_id"));
        return root;
    }
}

