/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.opa.service.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonPacker;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject requestJson = CommonPacker.createData(paymentInfo.getBatchSeqID(), this.getBizCode());
        if (StringUtils.isEmpty((String)paymentInfo.getBankRefID())) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u94f6\u884c\u67e5\u8be2\u6d41\u6c34\u8fd4\u56de\u4e3a\u7a7a", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-bjb-opa", (Object[])new Object[0]));
        }
        requestJson.put("orderSerialNo", (Object)paymentInfo.getBankRefID());
        String xmlRequest = CommonPacker.createRequest("queryPay", requestJson.toJSONString());
        return xmlRequest;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        res = CommonParser.parseResponse(res);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject response = JSONObject.parseObject((String)res);
        JSONArray ret = response.getJSONArray("ret");
        JSONObject jsonObject = ret.getJSONObject(0);
        String retCode = jsonObject.getString("retCode");
        String errMsg = response.getString("errMsg");
        String result = response.getString("result");
        if ("0000".equals(retCode)) {
            if ("4".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)retCode, (String)errMsg);
            } else if ("3".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)retCode, (String)errMsg);
            } else if ("1".equals(result) || "2".equals(result) || "11".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)retCode, (String)errMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)retCode, (String)errMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)retCode, (String)errMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "CebankQryOrderOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26\u67e5\u8be2", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-bjb-opa", (Object[])new Object[0]);
    }
}

