/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.salary.batch;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.salary.batch.SalaryBatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.TimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryBatchPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryBatchQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return "NTAGCSAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5927\u6279\u91cf\u4ee3\u53d1\u5de5\u8d44", (String)"SalaryBatchPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        TimeUtils timeUtils = new TimeUtils();
        String encoding = RequestContextUtils.getCharset();
        Element root = CMB_DC_Packer.packRoot((String)"NTAGCSAL");
        String count = String.valueOf(paymentInfos.size());
        String busmod = RequestContextUtils.getBankParameterValue((String)"BUSMOD4Salary");
        if (StringUtils.isEmpty((String)busmod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4ee3\u53d1\u4e1a\u52a1\uff08\u5de5\u8d44\u9664\u5916\uff09\u7684'\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7'", (String)"SalaryBatchPayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        Element ntbusmody = JDomUtils.addChild((Element)root, (String)"NTBUSMODY");
        JDomUtils.addChild((Element)ntbusmody, (String)"BUSMOD", (String)busmod);
        Element ntagcagcx1 = JDomUtils.addChild((Element)root, (String)"NTAGCAGCX1");
        JDomUtils.addChild((Element)ntagcagcx1, (String)"BEGTAG", (String)"Y");
        JDomUtils.addChild((Element)ntagcagcx1, (String)"ENDTAG", (String)"Y");
        Element ttlamt = JDomUtils.addChild((Element)ntagcagcx1, (String)"TTLAMT");
        JDomUtils.addChild((Element)ntagcagcx1, (String)"TTLCNT", (String)count);
        JDomUtils.addChild((Element)ntagcagcx1, (String)"TTLNUM", (String)"1");
        Element curamt = JDomUtils.addChild((Element)ntagcagcx1, (String)"CURAMT");
        JDomUtils.addChild((Element)ntagcagcx1, (String)"CURCNT", (String)count);
        JDomUtils.addChild((Element)ntagcagcx1, (String)"CCYNBR", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)ntagcagcx1, (String)"BBKNBR", (String)((PaymentInfo)paymentInfos.get(0)).getAreaCode());
        JDomUtils.addChild((Element)ntagcagcx1, (String)"ACCNBR", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)ntagcagcx1, (String)"CCYMKT", (String)"0");
        JDomUtils.addChild((Element)ntagcagcx1, (String)"TRSTYP", (String)"BYSA");
        String explain = ((PaymentInfo)paymentInfos.get(0)).getExplanation();
        if (explain.indexOf("|") != -1) {
            JDomUtils.addChild((Element)ntagcagcx1, (String)"NUSAGE", (String)StringUtils.substringChinese((String)explain.substring(0, explain.lastIndexOf("|")), (String)encoding, (int)42));
        } else {
            JDomUtils.addChild((Element)ntagcagcx1, (String)"NUSAGE", (String)StringUtils.substringChinese((String)explain, (String)encoding, (int)42));
        }
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime bookDateTime = ((PaymentInfo)paymentInfos.get(0)).getBookingTime();
        ZonedDateTime zdt = bookDateTime.atZone(zoneId);
        Date bookDate = Date.from(zdt.toInstant());
        if (null != ((PaymentInfo)paymentInfos.get(0)).getBookingTime() && DateTimeUtils.dayAfter((Date)bookDate, (Date)new Date())) {
            JDomUtils.addChild((Element)ntagcagcx1, (String)"EPTDAT", (String)DateTimeUtils.format((Date)bookDate, (String)"yyyyMMdd"));
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setBookPayFlag((List)paymentInfos);
        } else {
            JDomUtils.addChild((Element)ntagcagcx1, (String)"EPTDAT", (String)"");
        }
        if (null != ((PaymentInfo)paymentInfos.get(0)).getBookingTime() && timeUtils.TimeAfter(bookDate, new Date())) {
            JDomUtils.addChild((Element)ntagcagcx1, (String)"EPTTIM", (String)DateTimeFormatter.ofPattern("HHmmss").format(bookDateTime));
        } else {
            JDomUtils.addChild((Element)ntagcagcx1, (String)"EPTTIM", (String)"");
        }
        String yurref = PaymentUtil.getBankBatchSeqId((PaymentInfo)((PaymentInfo)paymentInfos.get(0)));
        JDomUtils.addChild((Element)ntagcagcx1, (String)"YURREF", (String)yurref);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankBatchSeqID((List)paymentInfos);
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(0.0);
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfo.setBankRefID(yurref);
            Element ntagcdtly1 = JDomUtils.addChild((Element)root, (String)"NTAGCDTLY1");
            JDomUtils.addChild((Element)ntagcdtly1, (String)"TRXSEQ", (String)String.format("%08d", Integer.parseInt(paymentInfo.getBankSerialNo())));
            JDomUtils.addChild((Element)ntagcdtly1, (String)"ACCNBR", (String)paymentInfo.getIncomeAccNo());
            BigDecimal amount = paymentInfo.getAmount();
            bigDecimal = bigDecimal.add(amount);
            JDomUtils.addChild((Element)ntagcdtly1, (String)"ACCNAM", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)ntagcdtly1, (String)"TRSAMT", (String)amount.toString());
            if (paymentInfo.getExplanation().indexOf("|") != -1) {
                JDomUtils.addChild((Element)ntagcdtly1, (String)"TRSDSP", (String)paymentInfo.getExplanation().substring(0, paymentInfo.getExplanation().lastIndexOf("|")));
            } else {
                JDomUtils.addChild((Element)ntagcdtly1, (String)"TRSDSP", (String)paymentInfo.getExplanation());
            }
            JDomUtils.addChild((Element)ntagcdtly1, (String)"BNKFLG", (String)(paymentInfo.is2SameBank() ? "Y" : "N"));
            if (!paymentInfo.is2SameBank()) {
                JDomUtils.addChild((Element)ntagcdtly1, (String)"EACBNK", (String)paymentInfo.getIncomeBankName());
                JDomUtils.addChild((Element)ntagcdtly1, (String)"EACCTY", (String)paymentInfo.getIncomeCity());
            }
            JDomUtils.addChild((Element)ntagcdtly1, (String)"FSTFLG");
            JDomUtils.addChild((Element)ntagcdtly1, (String)"CPRACT");
        }
        ttlamt.addContent(bigDecimal.toString());
        curamt.addContent(bigDecimal.toString());
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO((Element)root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

