/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest bankDetailRequest) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)EBUtils.buildPackerHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        String groupAccount = BankBusinessConfig.getGroupAccount((String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)groupAccount);
        JDomUtils.addChild((Element)Map2, (String)"QryAcNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(EBUtils.dateTimeFormatter));
        JDomUtils.addChild((Element)Map2, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(EBUtils.dateTimeFormatter));
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element ebenk = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse rsp = EBUtils.parserResponseInfo(ebenk);
        Element body = ebenk.getChild("Body");
        if ("000000".equals(rsp.getResponseCode())) {
            List list = body.getChild("List").getChildren("Map");
            if (list == null || list.isEmpty()) {
                return new EBBankDetailResponse(detailList);
            }
            for (Element row : list) {
                DetailInfo detail = new DetailInfo();
                String currency = row.getChildTextTrim("Currency");
                detail.setCurrency(EBUtils.convertCurrencyName2Code(currency));
                String payeeAcNo = row.getChildTextTrim("PartnerAcct");
                String payeeAcName = row.getChildTextTrim("PartnerAcName");
                String payeeBankName = row.getChildTextTrim("PartnerBankName");
                detail.setOppAccNo(payeeAcNo);
                detail.setOppAccName(payeeAcName);
                detail.setOppBankName(payeeBankName);
                detail.setAccName(acnt.getAccName());
                detail.setAccNo(acnt.getAccNo());
                String transferDate = row.getChildTextTrim("TransDate");
                String transferTime = row.getChildTextTrim("TransTime");
                LocalDateTime transTime = EBUtils.parseTransTime(transferDate + " " + transferTime);
                detail.setTransTime(transTime);
                detail.setTransDate(transTime.toLocalDate());
                String JnlNo = row.getChildTextTrim("JnlNo");
                String SubJnlNo = row.getChildTextTrim("SubJnlNo");
                String amountStr = row.getChildTextTrim("Amount");
                BigDecimal amount = new BigDecimal(amountStr);
                BigDecimal zero = new BigDecimal("0.00");
                String DCFlag = row.getChildTextTrim("DCFlag");
                if ("D".equalsIgnoreCase(DCFlag) || ResManager.loadKDString((String)"\u501f", (String)"DetailImpl_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]).equalsIgnoreCase(DCFlag)) {
                    detail.setDebitAmount(amount);
                    detail.setCreditAmount(zero);
                } else if ("C".equalsIgnoreCase(DCFlag) || ResManager.loadKDString((String)"\u8d37", (String)"DetailImpl_1", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]).equalsIgnoreCase(DCFlag)) {
                    detail.setDebitAmount(zero);
                    detail.setCreditAmount(amount);
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u7684\u501f\u8d37\u6807\u8bc6\uff1a%s", (String)"DetailImpl_2", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), DCFlag));
                }
                String AcctBal = row.getChildTextTrim("Balance");
                if (!StringUtils.isEmpty((String)AcctBal)) {
                    BigDecimal balance = new BigDecimal(AcctBal);
                    detail.setBalance(balance);
                }
                String remark = row.getChildTextTrim("Remark");
                String postscript = row.getChildTextTrim("Postscript");
                if (!StringUtils.isEmpty((String)postscript)) {
                    if (postscript.contains("_KD_")) {
                        String id = BizNoUtil.getId((String)postscript);
                        postscript = BizNoUtil.getMsg((String)postscript);
                        detail.setKdFlag(id);
                        detail.setPayBankDetailSeqID(id);
                    }
                    remark = String.format(ResManager.loadKDString((String)"%1$s\uff08\u7528\u9014\uff1a%2$s\uff09", (String)"DetailImpl_3", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), remark, postscript);
                }
                detail.setExplanation(remark);
                JSONObject detailJson = new JSONObject();
                detailJson.put("TransDate", (Object)transferDate);
                detailJson.put("JnlNo", (Object)JnlNo);
                detailJson.put("SubJnlNo", (Object)SubJnlNo);
                detailJson.put("Amount", (Object)amountStr);
                String jsonString = detailJson.toJSONString();
                detail.setJsonMap(jsonString);
                String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonString);
                detail.setReceiptNo(receiptNo);
                detailList.add(detail);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)(rsp.getResponseMessage() + "\uff0c" + rsp.getResponseCode()));
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EGroupActTrsQry";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EGroupActTrsQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"cif") + "&SIGDATA=1";
        factory.setUri(s);
    }
}

