/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.services.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class B2EGroupTrsStatusQry
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)EBUtils.buildPackerHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"TransERPJnlNo", (String)paymentInfo.getBankBatchSeqID());
        if (paymentInfo.getSubBizType().equalsIgnoreCase(PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION.getName())) {
            JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)(UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? paymentInfo.getIncomeAccNo() : paymentInfo.getAccNo()));
        } else {
            String groupAccount = BankBusinessConfig.getGroupAccount((String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)groupAccount);
        }
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = EBUtils.parserResponseInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (!"000000".equals(bankStatus)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25 :%s", (String)"B2EGroupTrsStatusQry_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element list = body.getChild("List");
        List lists = list.getChildren("Map");
        if (lists.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u67e5\u8be2\u7684\u4ed8\u6b3e\u72b6\u6001\u4fe1\u606f\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\uff01", (String)"B2EGroupTrsStatusQry_1", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)errorMsg, (String)"", (String)"");
        } else {
            Element element = (Element)lists.get(0);
            String returnCode = JDomUtils.getChildText((Element)element, (String)"TranStatus");
            if ("1".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)returnCode, (String)"");
            } else if ("3".equals(returnCode) || "6".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)"");
            } else if ("2".equals(returnCode) || "4".equals(returnCode) || "5".equals(returnCode) || "7".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)returnCode, (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)"");
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EGroupTrsStatusQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u96c6\u56e2\u8d26\u6237\u4ea4\u6613\u72b6\u6001\u67e5\u8be2", (String)"B2EGroupTrsStatusQry_2", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EGroupTrsStatusQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"cif") + "&SIGDATA=1";
        factory.setUri(s);
    }
}

