/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.area;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.area.Area;
import kd.ebg.aqap.banks.boc.net.area.AreaStore;
import kd.ebg.aqap.banks.boc.net.area.AreaStoreExt;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;

public class IncomeAreaMatchUtils {
    public static void matchArea(PaymentInfo paymentInfo) {
        if (paymentInfo.getSameBank().booleanValue() && StrUtil.isEmpty((String)paymentInfo.getIncomeAreaCode())) {
            boolean hasMatch = IncomeAreaMatchUtils.matchAreaExt(paymentInfo);
            if (hasMatch) {
                return;
            }
            AreaStore store = AreaStore.getInstance();
            Area area = store.matchArea(paymentInfo.getIncomeBankAddress());
            if (null == area) {
                area = store.matchArea(paymentInfo.getIncomeCity());
            }
            if (null == area) {
                area = store.matchArea(paymentInfo.getIncomeProvince());
            }
            if (null == area) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u6536\u6b3e\u5730\u533a%s(\u4e2d\u884c\u884c\u5185\u4ed8\u6b3e)", (String)"IncomeAreaMatchUtils_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getIncomeBankAddress()));
            }
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
        }
    }

    private static boolean matchAreaExt(PaymentInfo paymentInfo) {
        boolean hasMatch = false;
        AreaStoreExt areaStoreExt = AreaStoreExt.getInstance();
        Area area = areaStoreExt.matchArea(paymentInfo.getIncomeBankAddress());
        if (null == area) {
            area = areaStoreExt.matchArea(paymentInfo.getIncomeCity());
        }
        if (null == area) {
            area = areaStoreExt.matchArea(paymentInfo.getIncomeProvince());
        }
        if (area != null) {
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            paymentInfo.setIncomeProvince(area.getAreaName());
            paymentInfo.setIncomeCity(area.getAreaName());
            hasMatch = true;
        }
        return hasMatch;
    }
}

