/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.area.IncomeAreaMatchUtils;
import kd.ebg.aqap.banks.boc.net.service.payment.allocation.AllocationPay0019Impl;
import kd.ebg.aqap.banks.boc.net.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.company.fcurrency.FCurrencyPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.direct.company.DirectCompanyPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.linkpay.LinkPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.oversea.OverseaPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.salary.OtherBankSalaryPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.salary.OtherBankSingleSalaryPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.banks.boc.net.service.payment.salary.SingleSalaryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.MatchTypeEnum;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PretreatmentImpl.class);

    public void appendData(PaymentInfo paymentInfo) {
        this.pretreatPaymentInfo(paymentInfo);
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    private void pretreatPaymentInfo(PaymentInfo paymentInfo) throws EBServiceException {
        this.checkTrue(CheckUtil.checkIlleageWordsExt((String)paymentInfo.getAccName()), String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6237\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff1a%s\u3002", (String)"PretreatmentImpl_8", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getAccName()));
        this.checkTrue(CheckUtil.checkIlleageWordsExt((String)paymentInfo.getIncomeAccName()), String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u6237\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff1a%s\u3002", (String)"PretreatmentImpl_9", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getIncomeAccName()));
        this.checkTrue(CheckUtil.checkIlleageWordsExt((String)paymentInfo.getIncomeBankName()), String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u94f6\u884c\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff1a%s\u3002", (String)"PretreatmentImpl_10", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getIncomeBankName()));
        this.checkTrue(CheckUtil.checkIlleageWordsExt((String)paymentInfo.getExplanation()), String.format(ResManager.loadKDString((String)"\u6458\u8981\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff1a%s\u3002", (String)"PretreatmentImpl_11", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getExplanation()));
        this.checkTrue(StringUtils.isEmpty((String)paymentInfo.getIncomeBankAddress()) || CheckUtil.checkIlleageWordsExt((String)paymentInfo.getIncomeBankAddress()), String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u94f6\u884c\u5730\u5740\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff1a%s\u3002", (String)"PretreatmentImpl_12", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getIncomeBankAddress()));
    }

    private void checkTrue(boolean isTrue, String msg) throws EBServiceException {
        if (!isTrue) {
            throw EBExceiptionUtil.serviceException((String)msg);
        }
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        if (this.isPay_for_capital_allocation(paymentInfo)) {
            if (this.isAllocationToCompanyPay()) {
                paymentInfo.setReversed4("AllocationToCompany");
                this.setCompanyPay(paymentInfo, acnt);
            } else {
                paymentInfo.setIndividual(Boolean.valueOf(false));
                this.setImplClassName(paymentInfo, AllocationPay0019Impl.class.getName());
                IncomeAreaMatchUtils.matchArea(paymentInfo);
            }
        } else if (this.isPay_for_overseaPay(paymentInfo)) {
            if (this.isUseB2e0062(paymentInfo.getUseCN())) {
                this.setImplClassName(paymentInfo, FCurrencyPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, OverseaPayImpl.class.getName());
            }
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.setSalaryPay(paymentInfo);
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            if (this.isLinkpayToCompanyPay()) {
                paymentInfo.setReversed4("LinkPayToCompany");
                this.setCompanyPay(paymentInfo, acnt);
            } else if (this.isLinkpayToCommonPay()) {
                paymentInfo.setReversed4("LinkPayToCommonPay");
                this.setCommonPay(paymentInfo, acnt);
            } else {
                IncomeAreaMatchUtils.matchArea(paymentInfo);
                if (this.isLinkpayDoBySystem()) {
                    this.setImplClassName(paymentInfo, "");
                } else {
                    this.setImplClassName(paymentInfo, LinkPayImpl.class.getName());
                }
            }
        } else if (this.isPay(paymentInfo)) {
            if (this.isIndividual(paymentInfo)) {
                logger.info("\u5f53\u524d\u8d26\u6237\u7684\u5e01\u79cd\u662f====" + acnt.getCurrency());
                String isoCurrency = CurrencyUtils.convert2Iso((String)acnt.getCurrency());
                logger.info("\u8f6c\u5316\u4e4b\u540e\u7684\u5e01\u79cd\u662f====" + isoCurrency);
                if (this.isMerge(paymentInfo)) {
                    this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
                } else if (this.isSalaryUseCN(paymentInfo)) {
                    this.setSalaryPay(paymentInfo);
                } else if (this.isIndividual2Salary()) {
                    this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
                }
                IncomeAreaMatchUtils.matchArea(paymentInfo);
            } else {
                this.setCompanyPay(paymentInfo, acnt);
            }
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c\u672a\u5b9e\u73b0\u4ed8\u6b3e\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u4ed8\u6b3e\u5355\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_15", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getSubBizType());
            throw EBExceiptionUtil.serviceException((String)msg);
        }
        return busiImplInfo;
    }

    private void checkIncomeCondition(PaymentInfo paymentInfo) throws EBServiceException {
        String cntNum;
        if (!paymentInfo.is2SameBank() && null == (cntNum = BankBusinessConfig.getCntNumByAcnt((String)paymentInfo.getIncomeAccNo()))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e2d\u884c\u4ee3\u6263\u4e1a\u52a1\u4e2d,\u4ee3\u6536\u7c7b\u578b\u4e3a\u4ed6\u884c\u5361\u65f6,\u94f6\u884c\u9700\u8981\u586b\u4e0a\u9001'\u6263\u6b3e\u5408\u540c\u7f16\u53f7'\u503c\u3002\u8bf7\u5728\u94f6\u4f01\u4e91\u4e2d\u7ef4\u62a4\u8d26\u53f7%s)\u7684'\u6263\u6b3e\u5408\u540c\u7f16\u53f7'.", (String)"PretreatmentImpl_13", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), paymentInfo.getIncomeAccNo()));
        }
    }

    private void setSalaryPay(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isMerge(paymentInfo)) {
            if (this.isSameBank(paymentInfo)) {
                this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, OtherBankSalaryPayImpl.class.getName());
            }
        } else if (this.isSameBank(paymentInfo)) {
            this.setImplClassName(paymentInfo, SingleSalaryPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, OtherBankSingleSalaryPayImpl.class.getName());
        }
        paymentInfo.setIndividual(Boolean.valueOf(true));
    }

    private void setCompanyPay(PaymentInfo paymentInfo, BankAcnt acnt) throws EBServiceException {
        String isoCurrency = CurrencyUtils.convert2Iso((String)acnt.getCurrency());
        if (this.isDirectionAcntConfig(paymentInfo)) {
            this.setImplClassName(paymentInfo, DirectCompanyPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
        }
        IncomeAreaMatchUtils.matchArea(paymentInfo);
    }

    private void setCommonPay(PaymentInfo paymentInfo, BankAcnt acnt) throws EBServiceException {
        String isoCurrency = CurrencyUtils.convert2Iso((String)acnt.getCurrency());
        if (this.isIndividual(paymentInfo)) {
            this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
        } else if (this.isDirectionAcntConfig(paymentInfo)) {
            this.setImplClassName(paymentInfo, DirectCompanyPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
        }
        IncomeAreaMatchUtils.matchArea(paymentInfo);
    }

    private boolean isISOCurrencyCNY(String isoCurrency) {
        return this.assertISOCurrency(isoCurrency, "CNY");
    }

    private boolean isUseB2e0062(String useCn) {
        boolean result = useCn.equalsIgnoreCase(ResManager.loadKDString((String)"\u4e2d\u884c\u5883\u5185\u5916\u5e01\u4ed8\u6b3e", (String)"PretreatmentImpl_16", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        if (result) {
            this.addRoute(false, PayRouteEnum.USE_CN.getDesc(), useCn);
        }
        return result;
    }

    private boolean isLinkpayToCommonPay() {
        return this.assertBusinessConfig("BOC_NET_isLinkpayToCompany", "linkpayToCommonPay");
    }

    private boolean isAllocationToCompanyPay() {
        return this.assertBusinessConfig("BOC_NET_isAllocation2Company", "AllocationToCompany");
    }

    private boolean isLinkpayToCompanyPay() {
        return this.assertBusinessConfig("BOC_NET_isLinkpayToCompany", "linkpayToCompany");
    }

    private boolean isLinkpayDoBySystem() {
        return this.assertBusinessConfig("boc_net_linkpay_systemlorbank", "system");
    }

    private boolean isIndividual2Salary() {
        return this.assertBusinessConfig("BOC_NET_Individual2Salary", "true");
    }

    private boolean isDirectionAcntConfig(PaymentInfo paymentInfo) {
        boolean result = BankBusinessConfig.getDirectionAcntConfig((String)paymentInfo.getAccNo(), (String)paymentInfo.getIncomeAccNo()).isSuccess();
        if (result) {
            this.addRoute(true, "BOC_NET_DIRECTION_ACNT", " ", MatchTypeEnum.MATCH_RULE.getDesc());
        }
        return result;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u884c\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_7", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

