/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.company;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(CompanyPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getIndividual() == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader((String)token, (String)"b2e0009");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0009-rq");
            if (BankBusinessConfig.isPaymetByAuthorized()) {
                JDomUtils.addChild((Element)trn, (String)"transtype", (String)"1");
            } else {
                JDomUtils.addChild((Element)trn, (String)"transtype", (String)"");
            }
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0009-rq");
                info.setBankRefID(BocNetUtils.getBankDetailSeqId((PaymentInfo)info));
                JDomUtils.addChild((Element)rq, (String)"insid", (String)BocNetUtils.getInsid((PaymentInfo)info));
                if (BankBusinessConfig.isAddKDFlagToPay()) {
                    PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
                }
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)BocNetUtils.getSeqIdFromInsid((String)info.getBankDetailSeqID()));
                Element fractn = JDomUtils.addChild((Element)rq, (String)"fractn");
                JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)info.getAreaCode());
                JDomUtils.addChild((Element)fractn, (String)"actacn", (String)info.getAccNo());
                JDomUtils.addChild((Element)fractn, (String)"actnam", (String)info.getAccName());
                Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
                boolean flag = BankBusinessConfig.isInnerPoolTransfer((String)info.getAccNo(), (String)info.getIncomeAccNo());
                if (flag) {
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeCnaps());
                } else if (info.getSameBank().booleanValue()) {
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeAreaCode());
                } else {
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeCnaps());
                }
                JDomUtils.addChild((Element)toactn, (String)"actacn", (String)info.getIncomeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"toname", (String)info.getIncomeAccName());
                JDomUtils.addChild((Element)toactn, (String)"toaddr", (String)info.getIncomeBankAddress());
                JDomUtils.addChild((Element)toactn, (String)"tobknm", (String)info.getIncomeBankName());
                JDomUtils.addChild((Element)rq, (String)"trnamt", (String)info.getAmount().setScale(2, 4).toString());
                JDomUtils.addChild((Element)rq, (String)"trncur", (String)info.getCurrency());
                JDomUtils.addChild((Element)rq, (String)"priolv", (String)(info.getUrgent() != false ? "1" : "0"));
                JDomUtils.addChild((Element)rq, (String)"furinfo", (String)PaymentUtil.substringChinese((boolean)true, (String)info.getExplanation(), (int)200, (String)RequestContextUtils.getCharset()));
                LocalDateTime now = LocalDateTime.now();
                if (null != info.getBookingTime() && info.getBookingTime().isAfter(now)) {
                    JDomUtils.addChild((Element)rq, (String)"trfdate", (String)info.getBookingTime().toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                    PaymentUtil.setBookPayFlag((PaymentInfo)info);
                } else {
                    JDomUtils.addChild((Element)rq, (String)"trfdate", (String)now.toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                }
                JDomUtils.addChild((Element)rq, (String)"comacn", (String)"");
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError((Element)root, (PaymentInfo[])paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]));
        if (isError) {
            this.log.info("\u94f6\u884c\u8fd4\u56de\u2018trn-b2eerror-rs\u2019\u65f6,\u5e76\u8fd4\u56de1012\u9519\u8bef\u7801\u65f6,\u5904\u7406\u4e3a\u2018\u4ea4\u6613\u5931\u8d25\u2019");
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0009-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0009-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid((String)insid));
            if (null == info) continue;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod) || "B4988".equals(another_rspcod) || "B4887".equals(another_rspcod) || "B4987".equals(another_rspcod) || "B4986".equals(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

