/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salarynew;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.salarynew.SalaryQueryPayOffImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element rpayoffQtr = JDomUtils.addChild((Element)msgsv, (String)"QUERYACCEPTTRNRQ");
        JDomUtils.addChild((Element)rpayoffQtr, (String)"TRNUID", (String)Sequence.gen18Sequence());
        Element xferInQrq = JDomUtils.addChild((Element)rpayoffQtr, (String)"RQBODY");
        JDomUtils.addChild((Element)xferInQrq, (String)"CLIENTREF", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root((String)rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        this.logger.info("\u53d7\u7406\u7ed3\u679c\u67e5\u8be2");
        Element secmsg = root.getChild("SECURITIES_MSGSRSV1");
        Element rpayoffInQ = JDomUtils.getChildElement((Element)secmsg, (String)"QUERYACCEPTTRNRS");
        BankResponse bankResponse = new BankResponse();
        Element status = JDomUtils.getChildElement((Element)rpayoffInQ, (String)"STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(message);
        Element rsbody = JDomUtils.getChildElement((Element)rpayoffInQ, (String)"RSBODY");
        String resultcode = JDomUtils.getChildText((Element)rsbody, (String)"RESULTCODE");
        String errmessage = JDomUtils.getChildText((Element)rsbody, (String)"ERRMESSAGE");
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if ("1".equals(resultcode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4ee3\u53d1\u6587\u4ef6\u4e2d\u3002", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)resultcode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4ee3\u53d1\u6587\u4ef6\u4e2d\u3002", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        } else if ("2".equals(resultcode)) {
            this.setQueryPayImpl(paymentInfos, SalaryQueryPayOffImpl.class.getName());
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u6587\u4ef6\u5904\u7406\u6210\u529f\uff0c\u8bf7\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\u3002", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)resultcode, (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u6587\u4ef6\u5904\u7406\u6210\u529f\uff0c\u8bf7\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\u3002", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        } else if ("3".equals(resultcode)) {
            this.logger.info("\u6574\u6279\u4ea4\u6613\u5931\u8d25");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)resultcode, (String)errmessage);
            String fileid = JDomUtils.getChildText((Element)rsbody, (String)"FILEID");
            String filename = JDomUtils.getChildText((Element)rsbody, (String)"FILENAME");
            this.logger.info("fileid\uff1a" + fileid + ",filename" + filename);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u7801\u3002", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void setQueryPayImpl(List<PaymentInfo> paymentInfos, String className) {
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfo.setQueryImplClassName(className);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QUERYACCEPTTRNRQ";
    }

    public String getBizDesc() {
        return "QUERYACCEPTTRNRQ";
    }
}

