/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.icbc.api.request.MybankEnterprisePayPayentRequestV2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.BankBusinessConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.io.IOUtils;

public class PackerUtils {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String REF_PREFIX = "KD@";
    public static Map<String, String> staMap = new HashMap<String, String>(10);
    public static final String ZIP_FLAG = "zipFlag";
    public static final String ZIP = "zip";
    public static final String RD = "rd";

    public static String convertYuan2CentStr(BigDecimal yuan) {
        yuan = yuan.multiply(ONE_HUNDRED);
        yuan = yuan.setScale(0);
        return yuan.toString();
    }

    public static String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }

    public static boolean isBelowZero(BigDecimal amount) {
        boolean flag = true;
        if (null != amount && amount.compareTo(ZERO) > 0) {
            flag = false;
        }
        return flag;
    }

    public static Long getTotalAmountLong(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        bigDecimal = bigDecimal.multiply(ONE_HUNDRED);
        return bigDecimal.longValue();
    }

    public static Long getTotalAmountLong(List<PaymentInfo> paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        bigDecimal = bigDecimal.multiply(ONE_HUNDRED);
        return bigDecimal.longValue();
    }

    public static Long getAmountLong(PaymentInfo paymentInfos) {
        BigDecimal bigDecimal = paymentInfos.getAmount();
        bigDecimal = bigDecimal.multiply(ONE_HUNDRED);
        return bigDecimal.longValue();
    }

    public static BigDecimal getAmount(PaymentInfo paymentInfos) {
        BigDecimal bigDecimal = paymentInfos.getAmount();
        return bigDecimal.multiply(ONE_HUNDRED);
    }

    public static BigDecimal getAmount(FinancingInfo financingInfo) {
        BigDecimal bigDecimal = new BigDecimal(financingInfo.getAmount());
        return bigDecimal.multiply(ONE_HUNDRED);
    }

    public static void optimize(MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestRdV2 rd, String explanation) {
        String choice = BankBusinessConfig.popResult();
        if (StringUtils.isEmpty((String)explanation)) {
            explanation = "";
        }
        String summary = explanation.substring(0, Math.min(explanation.length(), 20));
        String postScript = explanation.substring(0, Math.min(explanation.length(), 100));
        switch (choice) {
            case "1": {
                rd.setPostscript(postScript);
                rd.setSummary(summary);
                break;
            }
            case "2": {
                rd.setPostscript(postScript);
                break;
            }
            default: {
                rd.setSummary(summary);
            }
        }
        rd.setPurpose(summary);
    }

    public static void zip(JSONObject json) throws IOException {
        if ("1".equals(json.getString(ZIP_FLAG))) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            zos.putNextEntry(new ZipEntry("~"));
            zos.write(json.getJSONArray(RD).toJSONString().getBytes());
            zos.close();
            json.put(ZIP, (Object)Base64.getEncoder().encodeToString(baos.toByteArray()));
            json.remove((Object)RD);
        }
    }

    public static void unzip(JSONObject json) throws IOException {
        if ("1".equals(json.getString(ZIP_FLAG))) {
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(json.getString(ZIP)));
            ZipInputStream zis = new ZipInputStream(bais);
            ZipEntry zipEntry = zis.getNextEntry();
            if (null == zipEntry) {
                throw new IOException();
            }
            json.put(RD, (Object)JSONArray.parseArray((String)IOUtils.toString((InputStream)zis)));
            zis.close();
            json.remove((Object)ZIP);
        }
    }

    static {
        staMap.put("0", ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u7b54\u590d\u3002", (String)"PackerUtils_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("1", ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f\u7b49\u5f85\u94f6\u884c\u7b54\u590d\u3002", (String)"PackerUtils_1", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("2", ResManager.loadKDString((String)"\u7b49\u5f85\u6388\u6743", (String)"PackerUtils_2", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("3", ResManager.loadKDString((String)"\u7b49\u5f85\u4e8c\u6b21\u6388\u6743", (String)"PackerUtils_3", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("4", ResManager.loadKDString((String)"\u7b49\u5f85\u94f6\u884c\u7b54\u590d", (String)"PackerUtils_4", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("5", ResManager.loadKDString((String)"\u8d85\u671f\u4f5c\u5e9f", (String)"PackerUtils_5", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("6", ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"PackerUtils_6", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("7", ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"PackerUtils_7", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("8", ResManager.loadKDString((String)"\u6307\u4ee4\u88ab\u6388\u6743\u62d2\u7edd\u3002", (String)"PackerUtils_8", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        staMap.put("9", ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"PackerUtils_9", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
    }
}

